// Package models contains the types for schema 'public'.
package models

// Code generated by xo. DO NOT EDIT.

// Databases
type Databases struct {
	Datname      Name   // datname
	PgSizePretty string // pg_size_pretty
}

// GetDatabases runs a custom query, returning results as Databases.
func GetDatabases(db XODB) ([]*Databases, error) {
	var err error

	// sql query
	var sqlstr = `SELECT datname, pg_size_pretty(pg_database_size(datname)) ` +
		`FROM pg_stat_database ` +
		`WHERE datid <> 0`

	// run query
	XOLog(sqlstr)
	q, err := db.Query(sqlstr)
	if err != nil {
		return nil, err
	}
	defer q.Close()

	// load results
	res := []*Databases{}
	for q.Next() {
		d := Databases{}

		// scan
		err = q.Scan(&d.Datname, &d.PgSizePretty)
		if err != nil {
			return nil, err
		}

		res = append(res, &d)
	}

	return res, nil
}
