/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel.address;

import com.jsql.util.I18nUtil;
import com.jsql.view.swing.manager.util.StateButton;
import com.jsql.view.swing.text.JToolTipI18n;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JToolTip;

public class ButtonStart
extends JButton {
    private static final String BUTTON_START_TOOLTIP = "BUTTON_START_TOOLTIP";
    private StateButton state = StateButton.STARTABLE;
    private final AtomicReference<JToolTipI18n> tooltip = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey("BUTTON_START_TOOLTIP")));

    @Override
    public JToolTip createToolTip() {
        if (this.state == StateButton.STARTABLE) {
            this.tooltip.get().setText(I18nUtil.valueByKey(BUTTON_START_TOOLTIP));
        } else if (this.state == StateButton.STOPPABLE) {
            this.tooltip.get().setText(I18nUtil.valueByKey("BUTTON_STOP_TOOLTIP"));
        } else if (this.state == StateButton.STOPPING) {
            this.tooltip.get().setText(I18nUtil.valueByKey("BUTTON_STOPPING_TOOLTIP"));
        }
        return this.tooltip.get();
    }

    public ButtonStart() {
        this.setName("buttonInUrl");
        this.setToolTipText(I18nUtil.valueByKey(BUTTON_START_TOOLTIP));
        I18nViewUtil.addComponentForKey(BUTTON_START_TOOLTIP, this.tooltip.get());
        this.setPreferredSize(new Dimension(18, 16));
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setRolloverEnabled(true);
        this.setIcons();
    }

    public void setIcons() {
        if (ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()).isLeftToRight()) {
            this.setIcon(UiUtil.ARROW.getIcon());
            this.setRolloverIcon(UiUtil.ARROW_HOVER.getIcon());
            this.setPressedIcon(UiUtil.ARROW_PRESSED.getIcon());
        } else {
            this.setIcon(UiUtil.ARROW_LEFT.getIcon());
            this.setRolloverIcon(UiUtil.ARROW_LEFT_HOVER.getIcon());
            this.setPressedIcon(UiUtil.ARROW_LEFT_PRESSED.getIcon());
        }
    }

    public void setInjectionReady() {
        this.state = StateButton.STARTABLE;
        this.setRolloverEnabled(true);
        this.setEnabled(true);
        this.setIcons();
    }

    public void setInjectionRunning() {
        this.state = StateButton.STOPPABLE;
        this.setRolloverEnabled(false);
        this.setEnabled(true);
        this.setIcon(UiUtil.CROSS_RED.getIcon());
    }

    public void setInjectionStopping() {
        this.state = StateButton.STOPPING;
        this.setRolloverEnabled(false);
        this.setEnabled(false);
        this.setIcon(UiUtil.HOURGLASS.getIcon());
    }

    public StateButton getState() {
        return this.state;
    }
}

