#ifndef CAPSTONE_MIPS_H
#define CAPSTONE_MIPS_H

/* Capstone Disassembly Engine */
/* By Nguyen Anh Quynh <aquynh@gmail.com>, 2013-2015 */

#ifdef __cplusplus
extern "C" {
#endif

#include "platform.h"
#include "cs_operand.h"

// GCC MIPS toolchain has a default macro called "mips" which breaks
// compilation
#undef mips

#ifdef _MSC_VER
#pragma warning(disable : 4201)
#endif

/// Operand type for instruction's operands
typedef enum mips_op_type {
	MIPS_OP_INVALID = CS_OP_INVALID, ///< = CS_OP_INVALID (Uninitialized).
	MIPS_OP_REG = CS_OP_REG, ///< = CS_OP_REG (Register operand).
	MIPS_OP_IMM = CS_OP_IMM, ///< = CS_OP_IMM (Immediate operand).
	MIPS_OP_MEM = CS_OP_MEM, ///< = CS_OP_MEM (Memory operand).
} mips_op_type;

/// MIPS registers
typedef enum mips_reg {
	// generated content <MipsGenCSRegEnum.inc> begin
	// clang-format off

	MIPS_REG_INVALID = 0,
	MIPS_REG_AT = 1,
	MIPS_REG_AT_NM = 2,
	MIPS_REG_DSPCCOND = 3,
	MIPS_REG_DSPCARRY = 4,
	MIPS_REG_DSPEFI = 5,
	MIPS_REG_DSPOUTFLAG = 6,
	MIPS_REG_DSPPOS = 7,
	MIPS_REG_DSPSCOUNT = 8,
	MIPS_REG_FP = 9,
	MIPS_REG_FP_NM = 10,
	MIPS_REG_GP = 11,
	MIPS_REG_GP_NM = 12,
	MIPS_REG_MSAACCESS = 13,
	MIPS_REG_MSACSR = 14,
	MIPS_REG_MSAIR = 15,
	MIPS_REG_MSAMAP = 16,
	MIPS_REG_MSAMODIFY = 17,
	MIPS_REG_MSAREQUEST = 18,
	MIPS_REG_MSASAVE = 19,
	MIPS_REG_MSAUNMAP = 20,
	MIPS_REG_PC = 21,
	MIPS_REG_RA = 22,
	MIPS_REG_RA_NM = 23,
	MIPS_REG_SP = 24,
	MIPS_REG_SP_NM = 25,
	MIPS_REG_ZERO = 26,
	MIPS_REG_ZERO_NM = 27,
	MIPS_REG_A0 = 28,
	MIPS_REG_A1 = 29,
	MIPS_REG_A2 = 30,
	MIPS_REG_A3 = 31,
	MIPS_REG_AC0 = 32,
	MIPS_REG_AC1 = 33,
	MIPS_REG_AC2 = 34,
	MIPS_REG_AC3 = 35,
	MIPS_REG_AT_64 = 36,
	MIPS_REG_COP00 = 37,
	MIPS_REG_COP01 = 38,
	MIPS_REG_COP02 = 39,
	MIPS_REG_COP03 = 40,
	MIPS_REG_COP04 = 41,
	MIPS_REG_COP05 = 42,
	MIPS_REG_COP06 = 43,
	MIPS_REG_COP07 = 44,
	MIPS_REG_COP08 = 45,
	MIPS_REG_COP09 = 46,
	MIPS_REG_COP20 = 47,
	MIPS_REG_COP21 = 48,
	MIPS_REG_COP22 = 49,
	MIPS_REG_COP23 = 50,
	MIPS_REG_COP24 = 51,
	MIPS_REG_COP25 = 52,
	MIPS_REG_COP26 = 53,
	MIPS_REG_COP27 = 54,
	MIPS_REG_COP28 = 55,
	MIPS_REG_COP29 = 56,
	MIPS_REG_COP30 = 57,
	MIPS_REG_COP31 = 58,
	MIPS_REG_COP32 = 59,
	MIPS_REG_COP33 = 60,
	MIPS_REG_COP34 = 61,
	MIPS_REG_COP35 = 62,
	MIPS_REG_COP36 = 63,
	MIPS_REG_COP37 = 64,
	MIPS_REG_COP38 = 65,
	MIPS_REG_COP39 = 66,
	MIPS_REG_COP010 = 67,
	MIPS_REG_COP011 = 68,
	MIPS_REG_COP012 = 69,
	MIPS_REG_COP013 = 70,
	MIPS_REG_COP014 = 71,
	MIPS_REG_COP015 = 72,
	MIPS_REG_COP016 = 73,
	MIPS_REG_COP017 = 74,
	MIPS_REG_COP018 = 75,
	MIPS_REG_COP019 = 76,
	MIPS_REG_COP020 = 77,
	MIPS_REG_COP021 = 78,
	MIPS_REG_COP022 = 79,
	MIPS_REG_COP023 = 80,
	MIPS_REG_COP024 = 81,
	MIPS_REG_COP025 = 82,
	MIPS_REG_COP026 = 83,
	MIPS_REG_COP027 = 84,
	MIPS_REG_COP028 = 85,
	MIPS_REG_COP029 = 86,
	MIPS_REG_COP030 = 87,
	MIPS_REG_COP031 = 88,
	MIPS_REG_COP210 = 89,
	MIPS_REG_COP211 = 90,
	MIPS_REG_COP212 = 91,
	MIPS_REG_COP213 = 92,
	MIPS_REG_COP214 = 93,
	MIPS_REG_COP215 = 94,
	MIPS_REG_COP216 = 95,
	MIPS_REG_COP217 = 96,
	MIPS_REG_COP218 = 97,
	MIPS_REG_COP219 = 98,
	MIPS_REG_COP220 = 99,
	MIPS_REG_COP221 = 100,
	MIPS_REG_COP222 = 101,
	MIPS_REG_COP223 = 102,
	MIPS_REG_COP224 = 103,
	MIPS_REG_COP225 = 104,
	MIPS_REG_COP226 = 105,
	MIPS_REG_COP227 = 106,
	MIPS_REG_COP228 = 107,
	MIPS_REG_COP229 = 108,
	MIPS_REG_COP230 = 109,
	MIPS_REG_COP231 = 110,
	MIPS_REG_COP310 = 111,
	MIPS_REG_COP311 = 112,
	MIPS_REG_COP312 = 113,
	MIPS_REG_COP313 = 114,
	MIPS_REG_COP314 = 115,
	MIPS_REG_COP315 = 116,
	MIPS_REG_COP316 = 117,
	MIPS_REG_COP317 = 118,
	MIPS_REG_COP318 = 119,
	MIPS_REG_COP319 = 120,
	MIPS_REG_COP320 = 121,
	MIPS_REG_COP321 = 122,
	MIPS_REG_COP322 = 123,
	MIPS_REG_COP323 = 124,
	MIPS_REG_COP324 = 125,
	MIPS_REG_COP325 = 126,
	MIPS_REG_COP326 = 127,
	MIPS_REG_COP327 = 128,
	MIPS_REG_COP328 = 129,
	MIPS_REG_COP329 = 130,
	MIPS_REG_COP330 = 131,
	MIPS_REG_COP331 = 132,
	MIPS_REG_D0 = 133,
	MIPS_REG_D1 = 134,
	MIPS_REG_D2 = 135,
	MIPS_REG_D3 = 136,
	MIPS_REG_D4 = 137,
	MIPS_REG_D5 = 138,
	MIPS_REG_D6 = 139,
	MIPS_REG_D7 = 140,
	MIPS_REG_D8 = 141,
	MIPS_REG_D9 = 142,
	MIPS_REG_D10 = 143,
	MIPS_REG_D11 = 144,
	MIPS_REG_D12 = 145,
	MIPS_REG_D13 = 146,
	MIPS_REG_D14 = 147,
	MIPS_REG_D15 = 148,
	MIPS_REG_DSPOUTFLAG20 = 149,
	MIPS_REG_DSPOUTFLAG21 = 150,
	MIPS_REG_DSPOUTFLAG22 = 151,
	MIPS_REG_DSPOUTFLAG23 = 152,
	MIPS_REG_F0 = 153,
	MIPS_REG_F1 = 154,
	MIPS_REG_F2 = 155,
	MIPS_REG_F3 = 156,
	MIPS_REG_F4 = 157,
	MIPS_REG_F5 = 158,
	MIPS_REG_F6 = 159,
	MIPS_REG_F7 = 160,
	MIPS_REG_F8 = 161,
	MIPS_REG_F9 = 162,
	MIPS_REG_F10 = 163,
	MIPS_REG_F11 = 164,
	MIPS_REG_F12 = 165,
	MIPS_REG_F13 = 166,
	MIPS_REG_F14 = 167,
	MIPS_REG_F15 = 168,
	MIPS_REG_F16 = 169,
	MIPS_REG_F17 = 170,
	MIPS_REG_F18 = 171,
	MIPS_REG_F19 = 172,
	MIPS_REG_F20 = 173,
	MIPS_REG_F21 = 174,
	MIPS_REG_F22 = 175,
	MIPS_REG_F23 = 176,
	MIPS_REG_F24 = 177,
	MIPS_REG_F25 = 178,
	MIPS_REG_F26 = 179,
	MIPS_REG_F27 = 180,
	MIPS_REG_F28 = 181,
	MIPS_REG_F29 = 182,
	MIPS_REG_F30 = 183,
	MIPS_REG_F31 = 184,
	MIPS_REG_FCC0 = 185,
	MIPS_REG_FCC1 = 186,
	MIPS_REG_FCC2 = 187,
	MIPS_REG_FCC3 = 188,
	MIPS_REG_FCC4 = 189,
	MIPS_REG_FCC5 = 190,
	MIPS_REG_FCC6 = 191,
	MIPS_REG_FCC7 = 192,
	MIPS_REG_FCR0 = 193,
	MIPS_REG_FCR1 = 194,
	MIPS_REG_FCR2 = 195,
	MIPS_REG_FCR3 = 196,
	MIPS_REG_FCR4 = 197,
	MIPS_REG_FCR5 = 198,
	MIPS_REG_FCR6 = 199,
	MIPS_REG_FCR7 = 200,
	MIPS_REG_FCR8 = 201,
	MIPS_REG_FCR9 = 202,
	MIPS_REG_FCR10 = 203,
	MIPS_REG_FCR11 = 204,
	MIPS_REG_FCR12 = 205,
	MIPS_REG_FCR13 = 206,
	MIPS_REG_FCR14 = 207,
	MIPS_REG_FCR15 = 208,
	MIPS_REG_FCR16 = 209,
	MIPS_REG_FCR17 = 210,
	MIPS_REG_FCR18 = 211,
	MIPS_REG_FCR19 = 212,
	MIPS_REG_FCR20 = 213,
	MIPS_REG_FCR21 = 214,
	MIPS_REG_FCR22 = 215,
	MIPS_REG_FCR23 = 216,
	MIPS_REG_FCR24 = 217,
	MIPS_REG_FCR25 = 218,
	MIPS_REG_FCR26 = 219,
	MIPS_REG_FCR27 = 220,
	MIPS_REG_FCR28 = 221,
	MIPS_REG_FCR29 = 222,
	MIPS_REG_FCR30 = 223,
	MIPS_REG_FCR31 = 224,
	MIPS_REG_FP_64 = 225,
	MIPS_REG_F_HI0 = 226,
	MIPS_REG_F_HI1 = 227,
	MIPS_REG_F_HI2 = 228,
	MIPS_REG_F_HI3 = 229,
	MIPS_REG_F_HI4 = 230,
	MIPS_REG_F_HI5 = 231,
	MIPS_REG_F_HI6 = 232,
	MIPS_REG_F_HI7 = 233,
	MIPS_REG_F_HI8 = 234,
	MIPS_REG_F_HI9 = 235,
	MIPS_REG_F_HI10 = 236,
	MIPS_REG_F_HI11 = 237,
	MIPS_REG_F_HI12 = 238,
	MIPS_REG_F_HI13 = 239,
	MIPS_REG_F_HI14 = 240,
	MIPS_REG_F_HI15 = 241,
	MIPS_REG_F_HI16 = 242,
	MIPS_REG_F_HI17 = 243,
	MIPS_REG_F_HI18 = 244,
	MIPS_REG_F_HI19 = 245,
	MIPS_REG_F_HI20 = 246,
	MIPS_REG_F_HI21 = 247,
	MIPS_REG_F_HI22 = 248,
	MIPS_REG_F_HI23 = 249,
	MIPS_REG_F_HI24 = 250,
	MIPS_REG_F_HI25 = 251,
	MIPS_REG_F_HI26 = 252,
	MIPS_REG_F_HI27 = 253,
	MIPS_REG_F_HI28 = 254,
	MIPS_REG_F_HI29 = 255,
	MIPS_REG_F_HI30 = 256,
	MIPS_REG_F_HI31 = 257,
	MIPS_REG_GP_64 = 258,
	MIPS_REG_HI0 = 259,
	MIPS_REG_HI1 = 260,
	MIPS_REG_HI2 = 261,
	MIPS_REG_HI3 = 262,
	MIPS_REG_HWR0 = 263,
	MIPS_REG_HWR1 = 264,
	MIPS_REG_HWR2 = 265,
	MIPS_REG_HWR3 = 266,
	MIPS_REG_HWR4 = 267,
	MIPS_REG_HWR5 = 268,
	MIPS_REG_HWR6 = 269,
	MIPS_REG_HWR7 = 270,
	MIPS_REG_HWR8 = 271,
	MIPS_REG_HWR9 = 272,
	MIPS_REG_HWR10 = 273,
	MIPS_REG_HWR11 = 274,
	MIPS_REG_HWR12 = 275,
	MIPS_REG_HWR13 = 276,
	MIPS_REG_HWR14 = 277,
	MIPS_REG_HWR15 = 278,
	MIPS_REG_HWR16 = 279,
	MIPS_REG_HWR17 = 280,
	MIPS_REG_HWR18 = 281,
	MIPS_REG_HWR19 = 282,
	MIPS_REG_HWR20 = 283,
	MIPS_REG_HWR21 = 284,
	MIPS_REG_HWR22 = 285,
	MIPS_REG_HWR23 = 286,
	MIPS_REG_HWR24 = 287,
	MIPS_REG_HWR25 = 288,
	MIPS_REG_HWR26 = 289,
	MIPS_REG_HWR27 = 290,
	MIPS_REG_HWR28 = 291,
	MIPS_REG_HWR29 = 292,
	MIPS_REG_HWR30 = 293,
	MIPS_REG_HWR31 = 294,
	MIPS_REG_K0 = 295,
	MIPS_REG_K1 = 296,
	MIPS_REG_LO0 = 297,
	MIPS_REG_LO1 = 298,
	MIPS_REG_LO2 = 299,
	MIPS_REG_LO3 = 300,
	MIPS_REG_MPL0 = 301,
	MIPS_REG_MPL1 = 302,
	MIPS_REG_MPL2 = 303,
	MIPS_REG_MSA8 = 304,
	MIPS_REG_MSA9 = 305,
	MIPS_REG_MSA10 = 306,
	MIPS_REG_MSA11 = 307,
	MIPS_REG_MSA12 = 308,
	MIPS_REG_MSA13 = 309,
	MIPS_REG_MSA14 = 310,
	MIPS_REG_MSA15 = 311,
	MIPS_REG_MSA16 = 312,
	MIPS_REG_MSA17 = 313,
	MIPS_REG_MSA18 = 314,
	MIPS_REG_MSA19 = 315,
	MIPS_REG_MSA20 = 316,
	MIPS_REG_MSA21 = 317,
	MIPS_REG_MSA22 = 318,
	MIPS_REG_MSA23 = 319,
	MIPS_REG_MSA24 = 320,
	MIPS_REG_MSA25 = 321,
	MIPS_REG_MSA26 = 322,
	MIPS_REG_MSA27 = 323,
	MIPS_REG_MSA28 = 324,
	MIPS_REG_MSA29 = 325,
	MIPS_REG_MSA30 = 326,
	MIPS_REG_MSA31 = 327,
	MIPS_REG_P0 = 328,
	MIPS_REG_P1 = 329,
	MIPS_REG_P2 = 330,
	MIPS_REG_RA_64 = 331,
	MIPS_REG_S0 = 332,
	MIPS_REG_S1 = 333,
	MIPS_REG_S2 = 334,
	MIPS_REG_S3 = 335,
	MIPS_REG_S4 = 336,
	MIPS_REG_S5 = 337,
	MIPS_REG_S6 = 338,
	MIPS_REG_S7 = 339,
	MIPS_REG_SP_64 = 340,
	MIPS_REG_T0 = 341,
	MIPS_REG_T1 = 342,
	MIPS_REG_T2 = 343,
	MIPS_REG_T3 = 344,
	MIPS_REG_T4 = 345,
	MIPS_REG_T5 = 346,
	MIPS_REG_T6 = 347,
	MIPS_REG_T7 = 348,
	MIPS_REG_T8 = 349,
	MIPS_REG_T9 = 350,
	MIPS_REG_V0 = 351,
	MIPS_REG_V1 = 352,
	MIPS_REG_W0 = 353,
	MIPS_REG_W1 = 354,
	MIPS_REG_W2 = 355,
	MIPS_REG_W3 = 356,
	MIPS_REG_W4 = 357,
	MIPS_REG_W5 = 358,
	MIPS_REG_W6 = 359,
	MIPS_REG_W7 = 360,
	MIPS_REG_W8 = 361,
	MIPS_REG_W9 = 362,
	MIPS_REG_W10 = 363,
	MIPS_REG_W11 = 364,
	MIPS_REG_W12 = 365,
	MIPS_REG_W13 = 366,
	MIPS_REG_W14 = 367,
	MIPS_REG_W15 = 368,
	MIPS_REG_W16 = 369,
	MIPS_REG_W17 = 370,
	MIPS_REG_W18 = 371,
	MIPS_REG_W19 = 372,
	MIPS_REG_W20 = 373,
	MIPS_REG_W21 = 374,
	MIPS_REG_W22 = 375,
	MIPS_REG_W23 = 376,
	MIPS_REG_W24 = 377,
	MIPS_REG_W25 = 378,
	MIPS_REG_W26 = 379,
	MIPS_REG_W27 = 380,
	MIPS_REG_W28 = 381,
	MIPS_REG_W29 = 382,
	MIPS_REG_W30 = 383,
	MIPS_REG_W31 = 384,
	MIPS_REG_ZERO_64 = 385,
	MIPS_REG_A0_NM = 386,
	MIPS_REG_A1_NM = 387,
	MIPS_REG_A2_NM = 388,
	MIPS_REG_A3_NM = 389,
	MIPS_REG_A4_NM = 390,
	MIPS_REG_A5_NM = 391,
	MIPS_REG_A6_NM = 392,
	MIPS_REG_A7_NM = 393,
	MIPS_REG_COP0SEL_BADINST = 394,
	MIPS_REG_COP0SEL_BADINSTRP = 395,
	MIPS_REG_COP0SEL_BADINSTRX = 396,
	MIPS_REG_COP0SEL_BADVADDR = 397,
	MIPS_REG_COP0SEL_BEVVA = 398,
	MIPS_REG_COP0SEL_CACHEERR = 399,
	MIPS_REG_COP0SEL_CAUSE = 400,
	MIPS_REG_COP0SEL_CDMMBASE = 401,
	MIPS_REG_COP0SEL_CMGCRBASE = 402,
	MIPS_REG_COP0SEL_COMPARE = 403,
	MIPS_REG_COP0SEL_CONFIG = 404,
	MIPS_REG_COP0SEL_CONTEXT = 405,
	MIPS_REG_COP0SEL_CONTEXTCONFIG = 406,
	MIPS_REG_COP0SEL_COUNT = 407,
	MIPS_REG_COP0SEL_DDATAHI = 408,
	MIPS_REG_COP0SEL_DDATALO = 409,
	MIPS_REG_COP0SEL_DEBUG = 410,
	MIPS_REG_COP0SEL_DEBUGCONTEXTID = 411,
	MIPS_REG_COP0SEL_DEPC = 412,
	MIPS_REG_COP0SEL_DESAVE = 413,
	MIPS_REG_COP0SEL_DTAGHI = 414,
	MIPS_REG_COP0SEL_DTAGLO = 415,
	MIPS_REG_COP0SEL_EBASE = 416,
	MIPS_REG_COP0SEL_ENTRYHI = 417,
	MIPS_REG_COP0SEL_EPC = 418,
	MIPS_REG_COP0SEL_ERRCTL = 419,
	MIPS_REG_COP0SEL_ERROREPC = 420,
	MIPS_REG_COP0SEL_GLOBALNUMBER = 421,
	MIPS_REG_COP0SEL_GTOFFSET = 422,
	MIPS_REG_COP0SEL_HWRENA = 423,
	MIPS_REG_COP0SEL_IDATAHI = 424,
	MIPS_REG_COP0SEL_IDATALO = 425,
	MIPS_REG_COP0SEL_INDEX = 426,
	MIPS_REG_COP0SEL_INTCTL = 427,
	MIPS_REG_COP0SEL_ITAGHI = 428,
	MIPS_REG_COP0SEL_ITAGLO = 429,
	MIPS_REG_COP0SEL_LLADDR = 430,
	MIPS_REG_COP0SEL_MAAR = 431,
	MIPS_REG_COP0SEL_MAARI = 432,
	MIPS_REG_COP0SEL_MEMORYMAPID = 433,
	MIPS_REG_COP0SEL_MVPCONTROL = 434,
	MIPS_REG_COP0SEL_NESTEDEPC = 435,
	MIPS_REG_COP0SEL_NESTEDEXC = 436,
	MIPS_REG_COP0SEL_PAGEGRAIN = 437,
	MIPS_REG_COP0SEL_PAGEMASK = 438,
	MIPS_REG_COP0SEL_PRID = 439,
	MIPS_REG_COP0SEL_PWBASE = 440,
	MIPS_REG_COP0SEL_PWCTL = 441,
	MIPS_REG_COP0SEL_PWFIELD = 442,
	MIPS_REG_COP0SEL_PWSIZE = 443,
	MIPS_REG_COP0SEL_RANDOM = 444,
	MIPS_REG_COP0SEL_SRSCTL = 445,
	MIPS_REG_COP0SEL_SRSMAP = 446,
	MIPS_REG_COP0SEL_STATUS = 447,
	MIPS_REG_COP0SEL_TCBIND = 448,
	MIPS_REG_COP0SEL_TCCONTEXT = 449,
	MIPS_REG_COP0SEL_TCHALT = 450,
	MIPS_REG_COP0SEL_TCOPT = 451,
	MIPS_REG_COP0SEL_TCRESTART = 452,
	MIPS_REG_COP0SEL_TCSCHEDULE = 453,
	MIPS_REG_COP0SEL_TCSCHEFBACK = 454,
	MIPS_REG_COP0SEL_TCSTATUS = 455,
	MIPS_REG_COP0SEL_TRACECONTROL = 456,
	MIPS_REG_COP0SEL_TRACEDBPC = 457,
	MIPS_REG_COP0SEL_TRACEIBPC = 458,
	MIPS_REG_COP0SEL_USERLOCAL = 459,
	MIPS_REG_COP0SEL_VIEW_IPL = 460,
	MIPS_REG_COP0SEL_VIEW_RIPL = 461,
	MIPS_REG_COP0SEL_VPCONTROL = 462,
	MIPS_REG_COP0SEL_VPECONTROL = 463,
	MIPS_REG_COP0SEL_VPEOPT = 464,
	MIPS_REG_COP0SEL_VPESCHEDULE = 465,
	MIPS_REG_COP0SEL_VPESCHEFBACK = 466,
	MIPS_REG_COP0SEL_WIRED = 467,
	MIPS_REG_COP0SEL_XCONTEXT = 468,
	MIPS_REG_COP0SEL_XCONTEXTCONFIG = 469,
	MIPS_REG_COP0SEL_YQMASK = 470,
	MIPS_REG_K0_NM = 471,
	MIPS_REG_K1_NM = 472,
	MIPS_REG_S0_NM = 473,
	MIPS_REG_S1_NM = 474,
	MIPS_REG_S2_NM = 475,
	MIPS_REG_S3_NM = 476,
	MIPS_REG_S4_NM = 477,
	MIPS_REG_S5_NM = 478,
	MIPS_REG_S6_NM = 479,
	MIPS_REG_S7_NM = 480,
	MIPS_REG_T0_NM = 481,
	MIPS_REG_T1_NM = 482,
	MIPS_REG_T2_NM = 483,
	MIPS_REG_T3_NM = 484,
	MIPS_REG_T4_NM = 485,
	MIPS_REG_T5_NM = 486,
	MIPS_REG_T8_NM = 487,
	MIPS_REG_T9_NM = 488,
	MIPS_REG_A0_64 = 489,
	MIPS_REG_A1_64 = 490,
	MIPS_REG_A2_64 = 491,
	MIPS_REG_A3_64 = 492,
	MIPS_REG_AC0_64 = 493,
	MIPS_REG_COP0SEL_CONFIG1 = 494,
	MIPS_REG_COP0SEL_CONFIG2 = 495,
	MIPS_REG_COP0SEL_CONFIG3 = 496,
	MIPS_REG_COP0SEL_CONFIG4 = 497,
	MIPS_REG_COP0SEL_CONFIG5 = 498,
	MIPS_REG_COP0SEL_DEBUG2 = 499,
	MIPS_REG_COP0SEL_ENTRYLO0 = 500,
	MIPS_REG_COP0SEL_ENTRYLO1 = 501,
	MIPS_REG_COP0SEL_GUESTCTL0 = 502,
	MIPS_REG_COP0SEL_GUESTCTL1 = 503,
	MIPS_REG_COP0SEL_GUESTCTL2 = 504,
	MIPS_REG_COP0SEL_GUESTCTL3 = 505,
	MIPS_REG_COP0SEL_KSCRATCH1 = 506,
	MIPS_REG_COP0SEL_KSCRATCH2 = 507,
	MIPS_REG_COP0SEL_KSCRATCH3 = 508,
	MIPS_REG_COP0SEL_KSCRATCH4 = 509,
	MIPS_REG_COP0SEL_KSCRATCH5 = 510,
	MIPS_REG_COP0SEL_KSCRATCH6 = 511,
	MIPS_REG_COP0SEL_MVPCONF0 = 512,
	MIPS_REG_COP0SEL_MVPCONF1 = 513,
	MIPS_REG_COP0SEL_PERFCNT0 = 514,
	MIPS_REG_COP0SEL_PERFCNT1 = 515,
	MIPS_REG_COP0SEL_PERFCNT2 = 516,
	MIPS_REG_COP0SEL_PERFCNT3 = 517,
	MIPS_REG_COP0SEL_PERFCNT4 = 518,
	MIPS_REG_COP0SEL_PERFCNT5 = 519,
	MIPS_REG_COP0SEL_PERFCNT6 = 520,
	MIPS_REG_COP0SEL_PERFCNT7 = 521,
	MIPS_REG_COP0SEL_PERFCTL0 = 522,
	MIPS_REG_COP0SEL_PERFCTL1 = 523,
	MIPS_REG_COP0SEL_PERFCTL2 = 524,
	MIPS_REG_COP0SEL_PERFCTL3 = 525,
	MIPS_REG_COP0SEL_PERFCTL4 = 526,
	MIPS_REG_COP0SEL_PERFCTL5 = 527,
	MIPS_REG_COP0SEL_PERFCTL6 = 528,
	MIPS_REG_COP0SEL_PERFCTL7 = 529,
	MIPS_REG_COP0SEL_SEGCTL0 = 530,
	MIPS_REG_COP0SEL_SEGCTL1 = 531,
	MIPS_REG_COP0SEL_SEGCTL2 = 532,
	MIPS_REG_COP0SEL_SRSCONF0 = 533,
	MIPS_REG_COP0SEL_SRSCONF1 = 534,
	MIPS_REG_COP0SEL_SRSCONF2 = 535,
	MIPS_REG_COP0SEL_SRSCONF3 = 536,
	MIPS_REG_COP0SEL_SRSCONF4 = 537,
	MIPS_REG_COP0SEL_SRSMAP2 = 538,
	MIPS_REG_COP0SEL_TRACECONTROL2 = 539,
	MIPS_REG_COP0SEL_TRACECONTROL3 = 540,
	MIPS_REG_COP0SEL_USERTRACEDATA1 = 541,
	MIPS_REG_COP0SEL_USERTRACEDATA2 = 542,
	MIPS_REG_COP0SEL_VPECONF0 = 543,
	MIPS_REG_COP0SEL_VPECONF1 = 544,
	MIPS_REG_COP0SEL_WATCHHI0 = 545,
	MIPS_REG_COP0SEL_WATCHHI1 = 546,
	MIPS_REG_COP0SEL_WATCHHI2 = 547,
	MIPS_REG_COP0SEL_WATCHHI3 = 548,
	MIPS_REG_COP0SEL_WATCHHI4 = 549,
	MIPS_REG_COP0SEL_WATCHHI5 = 550,
	MIPS_REG_COP0SEL_WATCHHI6 = 551,
	MIPS_REG_COP0SEL_WATCHHI7 = 552,
	MIPS_REG_COP0SEL_WATCHHI8 = 553,
	MIPS_REG_COP0SEL_WATCHHI9 = 554,
	MIPS_REG_COP0SEL_WATCHHI10 = 555,
	MIPS_REG_COP0SEL_WATCHHI11 = 556,
	MIPS_REG_COP0SEL_WATCHHI12 = 557,
	MIPS_REG_COP0SEL_WATCHHI13 = 558,
	MIPS_REG_COP0SEL_WATCHHI14 = 559,
	MIPS_REG_COP0SEL_WATCHHI15 = 560,
	MIPS_REG_COP0SEL_WATCHLO0 = 561,
	MIPS_REG_COP0SEL_WATCHLO1 = 562,
	MIPS_REG_COP0SEL_WATCHLO2 = 563,
	MIPS_REG_COP0SEL_WATCHLO3 = 564,
	MIPS_REG_COP0SEL_WATCHLO4 = 565,
	MIPS_REG_COP0SEL_WATCHLO5 = 566,
	MIPS_REG_COP0SEL_WATCHLO6 = 567,
	MIPS_REG_COP0SEL_WATCHLO7 = 568,
	MIPS_REG_COP0SEL_WATCHLO8 = 569,
	MIPS_REG_COP0SEL_WATCHLO9 = 570,
	MIPS_REG_COP0SEL_WATCHLO10 = 571,
	MIPS_REG_COP0SEL_WATCHLO11 = 572,
	MIPS_REG_COP0SEL_WATCHLO12 = 573,
	MIPS_REG_COP0SEL_WATCHLO13 = 574,
	MIPS_REG_COP0SEL_WATCHLO14 = 575,
	MIPS_REG_COP0SEL_WATCHLO15 = 576,
	MIPS_REG_D0_64 = 577,
	MIPS_REG_D1_64 = 578,
	MIPS_REG_D2_64 = 579,
	MIPS_REG_D3_64 = 580,
	MIPS_REG_D4_64 = 581,
	MIPS_REG_D5_64 = 582,
	MIPS_REG_D6_64 = 583,
	MIPS_REG_D7_64 = 584,
	MIPS_REG_D8_64 = 585,
	MIPS_REG_D9_64 = 586,
	MIPS_REG_D10_64 = 587,
	MIPS_REG_D11_64 = 588,
	MIPS_REG_D12_64 = 589,
	MIPS_REG_D13_64 = 590,
	MIPS_REG_D14_64 = 591,
	MIPS_REG_D15_64 = 592,
	MIPS_REG_D16_64 = 593,
	MIPS_REG_D17_64 = 594,
	MIPS_REG_D18_64 = 595,
	MIPS_REG_D19_64 = 596,
	MIPS_REG_D20_64 = 597,
	MIPS_REG_D21_64 = 598,
	MIPS_REG_D22_64 = 599,
	MIPS_REG_D23_64 = 600,
	MIPS_REG_D24_64 = 601,
	MIPS_REG_D25_64 = 602,
	MIPS_REG_D26_64 = 603,
	MIPS_REG_D27_64 = 604,
	MIPS_REG_D28_64 = 605,
	MIPS_REG_D29_64 = 606,
	MIPS_REG_D30_64 = 607,
	MIPS_REG_D31_64 = 608,
	MIPS_REG_DSPOUTFLAG16_19 = 609,
	MIPS_REG_HI0_64 = 610,
	MIPS_REG_K0_64 = 611,
	MIPS_REG_K1_64 = 612,
	MIPS_REG_LO0_64 = 613,
	MIPS_REG_S0_64 = 614,
	MIPS_REG_S1_64 = 615,
	MIPS_REG_S2_64 = 616,
	MIPS_REG_S3_64 = 617,
	MIPS_REG_S4_64 = 618,
	MIPS_REG_S5_64 = 619,
	MIPS_REG_S6_64 = 620,
	MIPS_REG_S7_64 = 621,
	MIPS_REG_T0_64 = 622,
	MIPS_REG_T1_64 = 623,
	MIPS_REG_T2_64 = 624,
	MIPS_REG_T3_64 = 625,
	MIPS_REG_T4_64 = 626,
	MIPS_REG_T5_64 = 627,
	MIPS_REG_T6_64 = 628,
	MIPS_REG_T7_64 = 629,
	MIPS_REG_T8_64 = 630,
	MIPS_REG_T9_64 = 631,
	MIPS_REG_V0_64 = 632,
	MIPS_REG_V1_64 = 633,
	MIPS_REG_COP0SEL_GUESTCTL0EXT = 634,
	MIPS_REG_ENDING, // 635

	// clang-format on
	// generated content <MipsGenCSRegEnum.inc> end
} mips_reg;

/// Instruction's operand referring to memory
/// This is associated with MIPS_OP_MEM operand type above
typedef struct mips_op_mem {
	mips_reg base; ///< base register
	int64_t disp; ///< displacement/offset value
} mips_op_mem;

/// Instruction operand
typedef struct cs_mips_op {
	mips_op_type type; ///< operand type
	union {
		mips_reg reg; ///< register id for REG operand
		int64_t imm; ///< signed immediate value for IMM operand
		uint64_t uimm; ///< unsigned immediate value for IMM operand
		mips_op_mem mem; ///< base/index/scale/disp value for MEM operand
	};
	bool is_reglist; ///< defines if the register is part of a list
	bool is_unsigned; ///< when true, the immediate value is unsigned

	/// How is this operand accessed? (READ, WRITE or READ|WRITE)
	/// NOTE: this field is irrelevant if engine is compiled in DIET mode.
	cs_ac_type access;
} cs_mips_op;

#define NUM_MIPS_OPS 16

/// Instruction structure
typedef struct cs_mips {
	/// Number of operands of this instruction,
	/// or 0 when instruction has no operand.
	uint8_t op_count;
	cs_mips_op operands[NUM_MIPS_OPS]; ///< operands for this instruction.
} cs_mips;

/// MIPS instruction
typedef enum mips_insn {
	// generated content <MipsGenCSInsnEnum.inc> begin
	// clang-format off

	MIPS_INS_INVALID,
	MIPS_INS_ABS,
	MIPS_INS_ALIGN,
	MIPS_INS_BEQL,
	MIPS_INS_BGE,
	MIPS_INS_BGEL,
	MIPS_INS_BGEU,
	MIPS_INS_BGEUL,
	MIPS_INS_BGT,
	MIPS_INS_BGTL,
	MIPS_INS_BGTU,
	MIPS_INS_BGTUL,
	MIPS_INS_BLE,
	MIPS_INS_BLEL,
	MIPS_INS_BLEU,
	MIPS_INS_BLEUL,
	MIPS_INS_BLT,
	MIPS_INS_BLTL,
	MIPS_INS_BLTU,
	MIPS_INS_BLTUL,
	MIPS_INS_BNEL,
	MIPS_INS_B,
	MIPS_INS_BEQ,
	MIPS_INS_BNE,
	MIPS_INS_CFTC1,
	MIPS_INS_CTTC1,
	MIPS_INS_DMUL,
	MIPS_INS_DMULO,
	MIPS_INS_DMULOU,
	MIPS_INS_DROL,
	MIPS_INS_DROR,
	MIPS_INS_DDIV,
	MIPS_INS_DREM,
	MIPS_INS_DDIVU,
	MIPS_INS_DREMU,
	MIPS_INS_JAL,
	MIPS_INS_LD,
	MIPS_INS_LWM,
	MIPS_INS_LA,
	MIPS_INS_DLA,
	MIPS_INS_LI,
	MIPS_INS_DLI,
	MIPS_INS_LI_D,
	MIPS_INS_LI_S,
	MIPS_INS_MFTACX,
	MIPS_INS_MFTC0,
	MIPS_INS_MFTC1,
	MIPS_INS_MFTDSP,
	MIPS_INS_MFTGPR,
	MIPS_INS_MFTHC1,
	MIPS_INS_MFTHI,
	MIPS_INS_MFTLO,
	MIPS_INS_MTTACX,
	MIPS_INS_MTTC0,
	MIPS_INS_MTTC1,
	MIPS_INS_MTTDSP,
	MIPS_INS_MTTGPR,
	MIPS_INS_MTTHC1,
	MIPS_INS_MTTHI,
	MIPS_INS_MTTLO,
	MIPS_INS_MUL,
	MIPS_INS_MULO,
	MIPS_INS_MULOU,
	MIPS_INS_NOR,
	MIPS_INS_ADDIU,
	MIPS_INS_ANDI,
	MIPS_INS_SUBU,
	MIPS_INS_TRUNC_W_D,
	MIPS_INS_TRUNC_W_S,
	MIPS_INS_ROL,
	MIPS_INS_ROR,
	MIPS_INS_S_D,
	MIPS_INS_SD,
	MIPS_INS_DIV,
	MIPS_INS_SEQ,
	MIPS_INS_SGE,
	MIPS_INS_SGEU,
	MIPS_INS_SGT,
	MIPS_INS_SGTU,
	MIPS_INS_SLE,
	MIPS_INS_SLEU,
	MIPS_INS_SLT,
	MIPS_INS_SLTU,
	MIPS_INS_SNE,
	MIPS_INS_REM,
	MIPS_INS_SWM,
	MIPS_INS_SAA,
	MIPS_INS_SAAD,
	MIPS_INS_DIVU,
	MIPS_INS_REMU,
	MIPS_INS_ULH,
	MIPS_INS_ULHU,
	MIPS_INS_ULW,
	MIPS_INS_USH,
	MIPS_INS_USW,
	MIPS_INS_ABSQ_S_PH,
	MIPS_INS_ABSQ_S_QB,
	MIPS_INS_ABSQ_S_W,
	MIPS_INS_ADD,
	MIPS_INS_ADDIUPC,
	MIPS_INS_ADDIUR1SP,
	MIPS_INS_ADDIUR2,
	MIPS_INS_ADDIUS5,
	MIPS_INS_ADDIUSP,
	MIPS_INS_ADDQH_PH,
	MIPS_INS_ADDQH_R_PH,
	MIPS_INS_ADDQH_R_W,
	MIPS_INS_ADDQH_W,
	MIPS_INS_ADDQ_PH,
	MIPS_INS_ADDQ_S_PH,
	MIPS_INS_ADDQ_S_W,
	MIPS_INS_ADDR_PS,
	MIPS_INS_ADDSC,
	MIPS_INS_ADDS_A_B,
	MIPS_INS_ADDS_A_D,
	MIPS_INS_ADDS_A_H,
	MIPS_INS_ADDS_A_W,
	MIPS_INS_ADDS_S_B,
	MIPS_INS_ADDS_S_D,
	MIPS_INS_ADDS_S_H,
	MIPS_INS_ADDS_S_W,
	MIPS_INS_ADDS_U_B,
	MIPS_INS_ADDS_U_D,
	MIPS_INS_ADDS_U_H,
	MIPS_INS_ADDS_U_W,
	MIPS_INS_ADDU16,
	MIPS_INS_ADDUH_QB,
	MIPS_INS_ADDUH_R_QB,
	MIPS_INS_ADDU,
	MIPS_INS_ADDU_PH,
	MIPS_INS_ADDU_QB,
	MIPS_INS_ADDU_S_PH,
	MIPS_INS_ADDU_S_QB,
	MIPS_INS_ADDVI_B,
	MIPS_INS_ADDVI_D,
	MIPS_INS_ADDVI_H,
	MIPS_INS_ADDVI_W,
	MIPS_INS_ADDV_B,
	MIPS_INS_ADDV_D,
	MIPS_INS_ADDV_H,
	MIPS_INS_ADDV_W,
	MIPS_INS_ADDWC,
	MIPS_INS_ADD_A_B,
	MIPS_INS_ADD_A_D,
	MIPS_INS_ADD_A_H,
	MIPS_INS_ADD_A_W,
	MIPS_INS_ADDI,
	MIPS_INS_ALUIPC,
	MIPS_INS_AND,
	MIPS_INS_AND16,
	MIPS_INS_ANDI16,
	MIPS_INS_ANDI_B,
	MIPS_INS_AND_V,
	MIPS_INS_APPEND,
	MIPS_INS_ASUB_S_B,
	MIPS_INS_ASUB_S_D,
	MIPS_INS_ASUB_S_H,
	MIPS_INS_ASUB_S_W,
	MIPS_INS_ASUB_U_B,
	MIPS_INS_ASUB_U_D,
	MIPS_INS_ASUB_U_H,
	MIPS_INS_ASUB_U_W,
	MIPS_INS_AUI,
	MIPS_INS_AUIPC,
	MIPS_INS_AVER_S_B,
	MIPS_INS_AVER_S_D,
	MIPS_INS_AVER_S_H,
	MIPS_INS_AVER_S_W,
	MIPS_INS_AVER_U_B,
	MIPS_INS_AVER_U_D,
	MIPS_INS_AVER_U_H,
	MIPS_INS_AVER_U_W,
	MIPS_INS_AVE_S_B,
	MIPS_INS_AVE_S_D,
	MIPS_INS_AVE_S_H,
	MIPS_INS_AVE_S_W,
	MIPS_INS_AVE_U_B,
	MIPS_INS_AVE_U_D,
	MIPS_INS_AVE_U_H,
	MIPS_INS_AVE_U_W,
	MIPS_INS_B16,
	MIPS_INS_BADDU,
	MIPS_INS_BAL,
	MIPS_INS_BALC,
	MIPS_INS_BALIGN,
	MIPS_INS_BALRSC,
	MIPS_INS_BBEQZC,
	MIPS_INS_BBIT0,
	MIPS_INS_BBIT032,
	MIPS_INS_BBIT1,
	MIPS_INS_BBIT132,
	MIPS_INS_BBNEZC,
	MIPS_INS_BC,
	MIPS_INS_BC16,
	MIPS_INS_BC1EQZ,
	MIPS_INS_BC1EQZC,
	MIPS_INS_BC1F,
	MIPS_INS_BC1FL,
	MIPS_INS_BC1NEZ,
	MIPS_INS_BC1NEZC,
	MIPS_INS_BC1T,
	MIPS_INS_BC1TL,
	MIPS_INS_BC2EQZ,
	MIPS_INS_BC2EQZC,
	MIPS_INS_BC2NEZ,
	MIPS_INS_BC2NEZC,
	MIPS_INS_BCLRI_B,
	MIPS_INS_BCLRI_D,
	MIPS_INS_BCLRI_H,
	MIPS_INS_BCLRI_W,
	MIPS_INS_BCLR_B,
	MIPS_INS_BCLR_D,
	MIPS_INS_BCLR_H,
	MIPS_INS_BCLR_W,
	MIPS_INS_BEQC,
	MIPS_INS_BEQIC,
	MIPS_INS_BEQZ16,
	MIPS_INS_BEQZALC,
	MIPS_INS_BEQZC,
	MIPS_INS_BEQZC16,
	MIPS_INS_BGEC,
	MIPS_INS_BGEIC,
	MIPS_INS_BGEIUC,
	MIPS_INS_BGEUC,
	MIPS_INS_BGEZ,
	MIPS_INS_BGEZAL,
	MIPS_INS_BGEZALC,
	MIPS_INS_BGEZALL,
	MIPS_INS_BGEZALS,
	MIPS_INS_BGEZC,
	MIPS_INS_BGEZL,
	MIPS_INS_BGTZ,
	MIPS_INS_BGTZALC,
	MIPS_INS_BGTZC,
	MIPS_INS_BGTZL,
	MIPS_INS_BINSLI_B,
	MIPS_INS_BINSLI_D,
	MIPS_INS_BINSLI_H,
	MIPS_INS_BINSLI_W,
	MIPS_INS_BINSL_B,
	MIPS_INS_BINSL_D,
	MIPS_INS_BINSL_H,
	MIPS_INS_BINSL_W,
	MIPS_INS_BINSRI_B,
	MIPS_INS_BINSRI_D,
	MIPS_INS_BINSRI_H,
	MIPS_INS_BINSRI_W,
	MIPS_INS_BINSR_B,
	MIPS_INS_BINSR_D,
	MIPS_INS_BINSR_H,
	MIPS_INS_BINSR_W,
	MIPS_INS_BITREV,
	MIPS_INS_BITREVW,
	MIPS_INS_BITSWAP,
	MIPS_INS_BLEZ,
	MIPS_INS_BLEZALC,
	MIPS_INS_BLEZC,
	MIPS_INS_BLEZL,
	MIPS_INS_BLTC,
	MIPS_INS_BLTIC,
	MIPS_INS_BLTIUC,
	MIPS_INS_BLTUC,
	MIPS_INS_BLTZ,
	MIPS_INS_BLTZAL,
	MIPS_INS_BLTZALC,
	MIPS_INS_BLTZALL,
	MIPS_INS_BLTZALS,
	MIPS_INS_BLTZC,
	MIPS_INS_BLTZL,
	MIPS_INS_BMNZI_B,
	MIPS_INS_BMNZ_V,
	MIPS_INS_BMZI_B,
	MIPS_INS_BMZ_V,
	MIPS_INS_BNEC,
	MIPS_INS_BNEGI_B,
	MIPS_INS_BNEGI_D,
	MIPS_INS_BNEGI_H,
	MIPS_INS_BNEGI_W,
	MIPS_INS_BNEG_B,
	MIPS_INS_BNEG_D,
	MIPS_INS_BNEG_H,
	MIPS_INS_BNEG_W,
	MIPS_INS_BNEIC,
	MIPS_INS_BNEZ16,
	MIPS_INS_BNEZALC,
	MIPS_INS_BNEZC,
	MIPS_INS_BNEZC16,
	MIPS_INS_BNVC,
	MIPS_INS_BNZ_B,
	MIPS_INS_BNZ_D,
	MIPS_INS_BNZ_H,
	MIPS_INS_BNZ_V,
	MIPS_INS_BNZ_W,
	MIPS_INS_BOVC,
	MIPS_INS_BPOSGE32,
	MIPS_INS_BPOSGE32C,
	MIPS_INS_BREAK,
	MIPS_INS_BREAK16,
	MIPS_INS_BRSC,
	MIPS_INS_BSELI_B,
	MIPS_INS_BSEL_V,
	MIPS_INS_BSETI_B,
	MIPS_INS_BSETI_D,
	MIPS_INS_BSETI_H,
	MIPS_INS_BSETI_W,
	MIPS_INS_BSET_B,
	MIPS_INS_BSET_D,
	MIPS_INS_BSET_H,
	MIPS_INS_BSET_W,
	MIPS_INS_BYTEREVW,
	MIPS_INS_BZ_B,
	MIPS_INS_BZ_D,
	MIPS_INS_BZ_H,
	MIPS_INS_BZ_V,
	MIPS_INS_BZ_W,
	MIPS_INS_BEQZ,
	MIPS_INS_BNEZ,
	MIPS_INS_BTEQZ,
	MIPS_INS_BTNEZ,
	MIPS_INS_CACHE,
	MIPS_INS_CACHEE,
	MIPS_INS_CEIL_L_D,
	MIPS_INS_CEIL_L_S,
	MIPS_INS_CEIL_W_D,
	MIPS_INS_CEIL_W_S,
	MIPS_INS_CEQI_B,
	MIPS_INS_CEQI_D,
	MIPS_INS_CEQI_H,
	MIPS_INS_CEQI_W,
	MIPS_INS_CEQ_B,
	MIPS_INS_CEQ_D,
	MIPS_INS_CEQ_H,
	MIPS_INS_CEQ_W,
	MIPS_INS_CFC1,
	MIPS_INS_CFC2,
	MIPS_INS_CFCMSA,
	MIPS_INS_CINS,
	MIPS_INS_CINS32,
	MIPS_INS_CLASS_D,
	MIPS_INS_CLASS_S,
	MIPS_INS_CLEI_S_B,
	MIPS_INS_CLEI_S_D,
	MIPS_INS_CLEI_S_H,
	MIPS_INS_CLEI_S_W,
	MIPS_INS_CLEI_U_B,
	MIPS_INS_CLEI_U_D,
	MIPS_INS_CLEI_U_H,
	MIPS_INS_CLEI_U_W,
	MIPS_INS_CLE_S_B,
	MIPS_INS_CLE_S_D,
	MIPS_INS_CLE_S_H,
	MIPS_INS_CLE_S_W,
	MIPS_INS_CLE_U_B,
	MIPS_INS_CLE_U_D,
	MIPS_INS_CLE_U_H,
	MIPS_INS_CLE_U_W,
	MIPS_INS_CLO,
	MIPS_INS_CLTI_S_B,
	MIPS_INS_CLTI_S_D,
	MIPS_INS_CLTI_S_H,
	MIPS_INS_CLTI_S_W,
	MIPS_INS_CLTI_U_B,
	MIPS_INS_CLTI_U_D,
	MIPS_INS_CLTI_U_H,
	MIPS_INS_CLTI_U_W,
	MIPS_INS_CLT_S_B,
	MIPS_INS_CLT_S_D,
	MIPS_INS_CLT_S_H,
	MIPS_INS_CLT_S_W,
	MIPS_INS_CLT_U_B,
	MIPS_INS_CLT_U_D,
	MIPS_INS_CLT_U_H,
	MIPS_INS_CLT_U_W,
	MIPS_INS_CLZ,
	MIPS_INS_CMPGDU_EQ_QB,
	MIPS_INS_CMPGDU_LE_QB,
	MIPS_INS_CMPGDU_LT_QB,
	MIPS_INS_CMPGU_EQ_QB,
	MIPS_INS_CMPGU_LE_QB,
	MIPS_INS_CMPGU_LT_QB,
	MIPS_INS_CMPU_EQ_QB,
	MIPS_INS_CMPU_LE_QB,
	MIPS_INS_CMPU_LT_QB,
	MIPS_INS_CMP_AF_D,
	MIPS_INS_CMP_AF_S,
	MIPS_INS_CMP_EQ_D,
	MIPS_INS_CMP_EQ_PH,
	MIPS_INS_CMP_EQ_S,
	MIPS_INS_CMP_LE_D,
	MIPS_INS_CMP_LE_PH,
	MIPS_INS_CMP_LE_S,
	MIPS_INS_CMP_LT_D,
	MIPS_INS_CMP_LT_PH,
	MIPS_INS_CMP_LT_S,
	MIPS_INS_CMP_SAF_D,
	MIPS_INS_CMP_SAF_S,
	MIPS_INS_CMP_SEQ_D,
	MIPS_INS_CMP_SEQ_S,
	MIPS_INS_CMP_SLE_D,
	MIPS_INS_CMP_SLE_S,
	MIPS_INS_CMP_SLT_D,
	MIPS_INS_CMP_SLT_S,
	MIPS_INS_CMP_SUEQ_D,
	MIPS_INS_CMP_SUEQ_S,
	MIPS_INS_CMP_SULE_D,
	MIPS_INS_CMP_SULE_S,
	MIPS_INS_CMP_SULT_D,
	MIPS_INS_CMP_SULT_S,
	MIPS_INS_CMP_SUN_D,
	MIPS_INS_CMP_SUN_S,
	MIPS_INS_CMP_UEQ_D,
	MIPS_INS_CMP_UEQ_S,
	MIPS_INS_CMP_ULE_D,
	MIPS_INS_CMP_ULE_S,
	MIPS_INS_CMP_ULT_D,
	MIPS_INS_CMP_ULT_S,
	MIPS_INS_CMP_UN_D,
	MIPS_INS_CMP_UN_S,
	MIPS_INS_COPY_S_B,
	MIPS_INS_COPY_S_D,
	MIPS_INS_COPY_S_H,
	MIPS_INS_COPY_S_W,
	MIPS_INS_COPY_U_B,
	MIPS_INS_COPY_U_H,
	MIPS_INS_COPY_U_W,
	MIPS_INS_CRC32B,
	MIPS_INS_CRC32CB,
	MIPS_INS_CRC32CD,
	MIPS_INS_CRC32CH,
	MIPS_INS_CRC32CW,
	MIPS_INS_CRC32D,
	MIPS_INS_CRC32H,
	MIPS_INS_CRC32W,
	MIPS_INS_CTC1,
	MIPS_INS_CTC2,
	MIPS_INS_CTCMSA,
	MIPS_INS_CVT_D_S,
	MIPS_INS_CVT_D_W,
	MIPS_INS_CVT_D_L,
	MIPS_INS_CVT_L_D,
	MIPS_INS_CVT_L_S,
	MIPS_INS_CVT_PS_PW,
	MIPS_INS_CVT_PS_S,
	MIPS_INS_CVT_PW_PS,
	MIPS_INS_CVT_S_D,
	MIPS_INS_CVT_S_L,
	MIPS_INS_CVT_S_PL,
	MIPS_INS_CVT_S_PU,
	MIPS_INS_CVT_S_W,
	MIPS_INS_CVT_W_D,
	MIPS_INS_CVT_W_S,
	MIPS_INS_C_EQ_D,
	MIPS_INS_C_EQ_S,
	MIPS_INS_C_F_D,
	MIPS_INS_C_F_S,
	MIPS_INS_C_LE_D,
	MIPS_INS_C_LE_S,
	MIPS_INS_C_LT_D,
	MIPS_INS_C_LT_S,
	MIPS_INS_C_NGE_D,
	MIPS_INS_C_NGE_S,
	MIPS_INS_C_NGLE_D,
	MIPS_INS_C_NGLE_S,
	MIPS_INS_C_NGL_D,
	MIPS_INS_C_NGL_S,
	MIPS_INS_C_NGT_D,
	MIPS_INS_C_NGT_S,
	MIPS_INS_C_OLE_D,
	MIPS_INS_C_OLE_S,
	MIPS_INS_C_OLT_D,
	MIPS_INS_C_OLT_S,
	MIPS_INS_C_SEQ_D,
	MIPS_INS_C_SEQ_S,
	MIPS_INS_C_SF_D,
	MIPS_INS_C_SF_S,
	MIPS_INS_C_UEQ_D,
	MIPS_INS_C_UEQ_S,
	MIPS_INS_C_ULE_D,
	MIPS_INS_C_ULE_S,
	MIPS_INS_C_ULT_D,
	MIPS_INS_C_ULT_S,
	MIPS_INS_C_UN_D,
	MIPS_INS_C_UN_S,
	MIPS_INS_CMP,
	MIPS_INS_CMPI,
	MIPS_INS_DADD,
	MIPS_INS_DADDI,
	MIPS_INS_DADDIU,
	MIPS_INS_DADDU,
	MIPS_INS_DAHI,
	MIPS_INS_DALIGN,
	MIPS_INS_DATI,
	MIPS_INS_DAUI,
	MIPS_INS_DBITSWAP,
	MIPS_INS_DCLO,
	MIPS_INS_DCLZ,
	MIPS_INS_DERET,
	MIPS_INS_DEXT,
	MIPS_INS_DEXTM,
	MIPS_INS_DEXTU,
	MIPS_INS_DI,
	MIPS_INS_DINS,
	MIPS_INS_DINSM,
	MIPS_INS_DINSU,
	MIPS_INS_DIV_S_B,
	MIPS_INS_DIV_S_D,
	MIPS_INS_DIV_S_H,
	MIPS_INS_DIV_S_W,
	MIPS_INS_DIV_U_B,
	MIPS_INS_DIV_U_D,
	MIPS_INS_DIV_U_H,
	MIPS_INS_DIV_U_W,
	MIPS_INS_DLSA,
	MIPS_INS_DMFC0,
	MIPS_INS_DMFC1,
	MIPS_INS_DMFC2,
	MIPS_INS_DMFGC0,
	MIPS_INS_DMOD,
	MIPS_INS_DMODU,
	MIPS_INS_DMT,
	MIPS_INS_DMTC0,
	MIPS_INS_DMTC1,
	MIPS_INS_DMTC2,
	MIPS_INS_DMTGC0,
	MIPS_INS_DMUH,
	MIPS_INS_DMUHU,
	MIPS_INS_DMULT,
	MIPS_INS_DMULTU,
	MIPS_INS_DMULU,
	MIPS_INS_DOTP_S_D,
	MIPS_INS_DOTP_S_H,
	MIPS_INS_DOTP_S_W,
	MIPS_INS_DOTP_U_D,
	MIPS_INS_DOTP_U_H,
	MIPS_INS_DOTP_U_W,
	MIPS_INS_DPADD_S_D,
	MIPS_INS_DPADD_S_H,
	MIPS_INS_DPADD_S_W,
	MIPS_INS_DPADD_U_D,
	MIPS_INS_DPADD_U_H,
	MIPS_INS_DPADD_U_W,
	MIPS_INS_DPAQX_SA_W_PH,
	MIPS_INS_DPAQX_S_W_PH,
	MIPS_INS_DPAQ_SA_L_W,
	MIPS_INS_DPAQ_S_W_PH,
	MIPS_INS_DPAU_H_QBL,
	MIPS_INS_DPAU_H_QBR,
	MIPS_INS_DPAX_W_PH,
	MIPS_INS_DPA_W_PH,
	MIPS_INS_DPOP,
	MIPS_INS_DPSQX_SA_W_PH,
	MIPS_INS_DPSQX_S_W_PH,
	MIPS_INS_DPSQ_SA_L_W,
	MIPS_INS_DPSQ_S_W_PH,
	MIPS_INS_DPSUB_S_D,
	MIPS_INS_DPSUB_S_H,
	MIPS_INS_DPSUB_S_W,
	MIPS_INS_DPSUB_U_D,
	MIPS_INS_DPSUB_U_H,
	MIPS_INS_DPSUB_U_W,
	MIPS_INS_DPSU_H_QBL,
	MIPS_INS_DPSU_H_QBR,
	MIPS_INS_DPSX_W_PH,
	MIPS_INS_DPS_W_PH,
	MIPS_INS_DROTR,
	MIPS_INS_DROTR32,
	MIPS_INS_DROTRV,
	MIPS_INS_DSBH,
	MIPS_INS_DSHD,
	MIPS_INS_DSLL,
	MIPS_INS_DSLL32,
	MIPS_INS_DSLLV,
	MIPS_INS_DSRA,
	MIPS_INS_DSRA32,
	MIPS_INS_DSRAV,
	MIPS_INS_DSRL,
	MIPS_INS_DSRL32,
	MIPS_INS_DSRLV,
	MIPS_INS_DSUB,
	MIPS_INS_DSUBU,
	MIPS_INS_DVP,
	MIPS_INS_DVPE,
	MIPS_INS_EHB,
	MIPS_INS_EI,
	MIPS_INS_EMT,
	MIPS_INS_ERET,
	MIPS_INS_ERETNC,
	MIPS_INS_EVP,
	MIPS_INS_EVPE,
	MIPS_INS_EXT,
	MIPS_INS_EXTP,
	MIPS_INS_EXTPDP,
	MIPS_INS_EXTPDPV,
	MIPS_INS_EXTPV,
	MIPS_INS_EXTRV_RS_W,
	MIPS_INS_EXTRV_R_W,
	MIPS_INS_EXTRV_S_H,
	MIPS_INS_EXTRV_W,
	MIPS_INS_EXTR_RS_W,
	MIPS_INS_EXTR_R_W,
	MIPS_INS_EXTR_S_H,
	MIPS_INS_EXTR_W,
	MIPS_INS_EXTS,
	MIPS_INS_EXTS32,
	MIPS_INS_EXTW,
	MIPS_INS_ABS_D,
	MIPS_INS_ABS_S,
	MIPS_INS_FADD_D,
	MIPS_INS_ADD_D,
	MIPS_INS_ADD_PS,
	MIPS_INS_ADD_S,
	MIPS_INS_FADD_W,
	MIPS_INS_FCAF_D,
	MIPS_INS_FCAF_W,
	MIPS_INS_FCEQ_D,
	MIPS_INS_FCEQ_W,
	MIPS_INS_FCLASS_D,
	MIPS_INS_FCLASS_W,
	MIPS_INS_FCLE_D,
	MIPS_INS_FCLE_W,
	MIPS_INS_FCLT_D,
	MIPS_INS_FCLT_W,
	MIPS_INS_FCNE_D,
	MIPS_INS_FCNE_W,
	MIPS_INS_FCOR_D,
	MIPS_INS_FCOR_W,
	MIPS_INS_FCUEQ_D,
	MIPS_INS_FCUEQ_W,
	MIPS_INS_FCULE_D,
	MIPS_INS_FCULE_W,
	MIPS_INS_FCULT_D,
	MIPS_INS_FCULT_W,
	MIPS_INS_FCUNE_D,
	MIPS_INS_FCUNE_W,
	MIPS_INS_FCUN_D,
	MIPS_INS_FCUN_W,
	MIPS_INS_FDIV_D,
	MIPS_INS_DIV_D,
	MIPS_INS_DIV_S,
	MIPS_INS_FDIV_W,
	MIPS_INS_FEXDO_H,
	MIPS_INS_FEXDO_W,
	MIPS_INS_FEXP2_D,
	MIPS_INS_FEXP2_W,
	MIPS_INS_FEXUPL_D,
	MIPS_INS_FEXUPL_W,
	MIPS_INS_FEXUPR_D,
	MIPS_INS_FEXUPR_W,
	MIPS_INS_FFINT_S_D,
	MIPS_INS_FFINT_S_W,
	MIPS_INS_FFINT_U_D,
	MIPS_INS_FFINT_U_W,
	MIPS_INS_FFQL_D,
	MIPS_INS_FFQL_W,
	MIPS_INS_FFQR_D,
	MIPS_INS_FFQR_W,
	MIPS_INS_FILL_B,
	MIPS_INS_FILL_D,
	MIPS_INS_FILL_H,
	MIPS_INS_FILL_W,
	MIPS_INS_FLOG2_D,
	MIPS_INS_FLOG2_W,
	MIPS_INS_FLOOR_L_D,
	MIPS_INS_FLOOR_L_S,
	MIPS_INS_FLOOR_W_D,
	MIPS_INS_FLOOR_W_S,
	MIPS_INS_FMADD_D,
	MIPS_INS_FMADD_W,
	MIPS_INS_FMAX_A_D,
	MIPS_INS_FMAX_A_W,
	MIPS_INS_FMAX_D,
	MIPS_INS_FMAX_W,
	MIPS_INS_FMIN_A_D,
	MIPS_INS_FMIN_A_W,
	MIPS_INS_FMIN_D,
	MIPS_INS_FMIN_W,
	MIPS_INS_MOV_D,
	MIPS_INS_MOV_S,
	MIPS_INS_FMSUB_D,
	MIPS_INS_FMSUB_W,
	MIPS_INS_FMUL_D,
	MIPS_INS_MUL_D,
	MIPS_INS_MUL_PS,
	MIPS_INS_MUL_S,
	MIPS_INS_FMUL_W,
	MIPS_INS_NEG_D,
	MIPS_INS_NEG_S,
	MIPS_INS_FORK,
	MIPS_INS_FRCP_D,
	MIPS_INS_FRCP_W,
	MIPS_INS_FRINT_D,
	MIPS_INS_FRINT_W,
	MIPS_INS_FRSQRT_D,
	MIPS_INS_FRSQRT_W,
	MIPS_INS_FSAF_D,
	MIPS_INS_FSAF_W,
	MIPS_INS_FSEQ_D,
	MIPS_INS_FSEQ_W,
	MIPS_INS_FSLE_D,
	MIPS_INS_FSLE_W,
	MIPS_INS_FSLT_D,
	MIPS_INS_FSLT_W,
	MIPS_INS_FSNE_D,
	MIPS_INS_FSNE_W,
	MIPS_INS_FSOR_D,
	MIPS_INS_FSOR_W,
	MIPS_INS_FSQRT_D,
	MIPS_INS_SQRT_D,
	MIPS_INS_SQRT_S,
	MIPS_INS_FSQRT_W,
	MIPS_INS_FSUB_D,
	MIPS_INS_SUB_D,
	MIPS_INS_SUB_PS,
	MIPS_INS_SUB_S,
	MIPS_INS_FSUB_W,
	MIPS_INS_FSUEQ_D,
	MIPS_INS_FSUEQ_W,
	MIPS_INS_FSULE_D,
	MIPS_INS_FSULE_W,
	MIPS_INS_FSULT_D,
	MIPS_INS_FSULT_W,
	MIPS_INS_FSUNE_D,
	MIPS_INS_FSUNE_W,
	MIPS_INS_FSUN_D,
	MIPS_INS_FSUN_W,
	MIPS_INS_FTINT_S_D,
	MIPS_INS_FTINT_S_W,
	MIPS_INS_FTINT_U_D,
	MIPS_INS_FTINT_U_W,
	MIPS_INS_FTQ_H,
	MIPS_INS_FTQ_W,
	MIPS_INS_FTRUNC_S_D,
	MIPS_INS_FTRUNC_S_W,
	MIPS_INS_FTRUNC_U_D,
	MIPS_INS_FTRUNC_U_W,
	MIPS_INS_GINVI,
	MIPS_INS_GINVT,
	MIPS_INS_HADD_S_D,
	MIPS_INS_HADD_S_H,
	MIPS_INS_HADD_S_W,
	MIPS_INS_HADD_U_D,
	MIPS_INS_HADD_U_H,
	MIPS_INS_HADD_U_W,
	MIPS_INS_HSUB_S_D,
	MIPS_INS_HSUB_S_H,
	MIPS_INS_HSUB_S_W,
	MIPS_INS_HSUB_U_D,
	MIPS_INS_HSUB_U_H,
	MIPS_INS_HSUB_U_W,
	MIPS_INS_HYPCALL,
	MIPS_INS_ILVEV_B,
	MIPS_INS_ILVEV_D,
	MIPS_INS_ILVEV_H,
	MIPS_INS_ILVEV_W,
	MIPS_INS_ILVL_B,
	MIPS_INS_ILVL_D,
	MIPS_INS_ILVL_H,
	MIPS_INS_ILVL_W,
	MIPS_INS_ILVOD_B,
	MIPS_INS_ILVOD_D,
	MIPS_INS_ILVOD_H,
	MIPS_INS_ILVOD_W,
	MIPS_INS_ILVR_B,
	MIPS_INS_ILVR_D,
	MIPS_INS_ILVR_H,
	MIPS_INS_ILVR_W,
	MIPS_INS_INS,
	MIPS_INS_INSERT_B,
	MIPS_INS_INSERT_D,
	MIPS_INS_INSERT_H,
	MIPS_INS_INSERT_W,
	MIPS_INS_INSV,
	MIPS_INS_INSVE_B,
	MIPS_INS_INSVE_D,
	MIPS_INS_INSVE_H,
	MIPS_INS_INSVE_W,
	MIPS_INS_J,
	MIPS_INS_JALR,
	MIPS_INS_JALRC,
	MIPS_INS_JALRC_HB,
	MIPS_INS_JALRS16,
	MIPS_INS_JALRS,
	MIPS_INS_JALR_HB,
	MIPS_INS_JALS,
	MIPS_INS_JALX,
	MIPS_INS_JIALC,
	MIPS_INS_JIC,
	MIPS_INS_JR,
	MIPS_INS_JR16,
	MIPS_INS_JRADDIUSP,
	MIPS_INS_JRC,
	MIPS_INS_JRC16,
	MIPS_INS_JRCADDIUSP,
	MIPS_INS_JR_HB,
	MIPS_INS_LAPC_H,
	MIPS_INS_LAPC_B,
	MIPS_INS_LB,
	MIPS_INS_LBE,
	MIPS_INS_LBU16,
	MIPS_INS_LBU,
	MIPS_INS_LBUX,
	MIPS_INS_LBX,
	MIPS_INS_LBUE,
	MIPS_INS_LDC1,
	MIPS_INS_LDC2,
	MIPS_INS_LDC3,
	MIPS_INS_LDI_B,
	MIPS_INS_LDI_D,
	MIPS_INS_LDI_H,
	MIPS_INS_LDI_W,
	MIPS_INS_LDL,
	MIPS_INS_LDPC,
	MIPS_INS_LDR,
	MIPS_INS_LDXC1,
	MIPS_INS_LD_B,
	MIPS_INS_LD_D,
	MIPS_INS_LD_H,
	MIPS_INS_LD_W,
	MIPS_INS_LH,
	MIPS_INS_LHE,
	MIPS_INS_LHU16,
	MIPS_INS_LHU,
	MIPS_INS_LHUXS,
	MIPS_INS_LHUX,
	MIPS_INS_LHX,
	MIPS_INS_LHXS,
	MIPS_INS_LHUE,
	MIPS_INS_LI16,
	MIPS_INS_LL,
	MIPS_INS_LLD,
	MIPS_INS_LLE,
	MIPS_INS_LLWP,
	MIPS_INS_LSA,
	MIPS_INS_LUI,
	MIPS_INS_LUXC1,
	MIPS_INS_LW,
	MIPS_INS_LW16,
	MIPS_INS_LWC1,
	MIPS_INS_LWC2,
	MIPS_INS_LWC3,
	MIPS_INS_LWE,
	MIPS_INS_LWL,
	MIPS_INS_LWLE,
	MIPS_INS_LWM16,
	MIPS_INS_LWM32,
	MIPS_INS_LWPC,
	MIPS_INS_LWP,
	MIPS_INS_LWR,
	MIPS_INS_LWRE,
	MIPS_INS_LWUPC,
	MIPS_INS_LWU,
	MIPS_INS_LWX,
	MIPS_INS_LWXC1,
	MIPS_INS_LWXS,
	MIPS_INS_MADD,
	MIPS_INS_MADDF_D,
	MIPS_INS_MADDF_S,
	MIPS_INS_MADDR_Q_H,
	MIPS_INS_MADDR_Q_W,
	MIPS_INS_MADDU,
	MIPS_INS_MADDV_B,
	MIPS_INS_MADDV_D,
	MIPS_INS_MADDV_H,
	MIPS_INS_MADDV_W,
	MIPS_INS_MADD_D,
	MIPS_INS_MADD_Q_H,
	MIPS_INS_MADD_Q_W,
	MIPS_INS_MADD_S,
	MIPS_INS_MAQ_SA_W_PHL,
	MIPS_INS_MAQ_SA_W_PHR,
	MIPS_INS_MAQ_S_W_PHL,
	MIPS_INS_MAQ_S_W_PHR,
	MIPS_INS_MAXA_D,
	MIPS_INS_MAXA_S,
	MIPS_INS_MAXI_S_B,
	MIPS_INS_MAXI_S_D,
	MIPS_INS_MAXI_S_H,
	MIPS_INS_MAXI_S_W,
	MIPS_INS_MAXI_U_B,
	MIPS_INS_MAXI_U_D,
	MIPS_INS_MAXI_U_H,
	MIPS_INS_MAXI_U_W,
	MIPS_INS_MAX_A_B,
	MIPS_INS_MAX_A_D,
	MIPS_INS_MAX_A_H,
	MIPS_INS_MAX_A_W,
	MIPS_INS_MAX_D,
	MIPS_INS_MAX_S,
	MIPS_INS_MAX_S_B,
	MIPS_INS_MAX_S_D,
	MIPS_INS_MAX_S_H,
	MIPS_INS_MAX_S_W,
	MIPS_INS_MAX_U_B,
	MIPS_INS_MAX_U_D,
	MIPS_INS_MAX_U_H,
	MIPS_INS_MAX_U_W,
	MIPS_INS_MFC0,
	MIPS_INS_MFC1,
	MIPS_INS_MFC2,
	MIPS_INS_MFGC0,
	MIPS_INS_MFHC0,
	MIPS_INS_MFHC1,
	MIPS_INS_MFHC2,
	MIPS_INS_MFHGC0,
	MIPS_INS_MFHI,
	MIPS_INS_MFHI16,
	MIPS_INS_MFLO,
	MIPS_INS_MFLO16,
	MIPS_INS_MFTR,
	MIPS_INS_MINA_D,
	MIPS_INS_MINA_S,
	MIPS_INS_MINI_S_B,
	MIPS_INS_MINI_S_D,
	MIPS_INS_MINI_S_H,
	MIPS_INS_MINI_S_W,
	MIPS_INS_MINI_U_B,
	MIPS_INS_MINI_U_D,
	MIPS_INS_MINI_U_H,
	MIPS_INS_MINI_U_W,
	MIPS_INS_MIN_A_B,
	MIPS_INS_MIN_A_D,
	MIPS_INS_MIN_A_H,
	MIPS_INS_MIN_A_W,
	MIPS_INS_MIN_D,
	MIPS_INS_MIN_S,
	MIPS_INS_MIN_S_B,
	MIPS_INS_MIN_S_D,
	MIPS_INS_MIN_S_H,
	MIPS_INS_MIN_S_W,
	MIPS_INS_MIN_U_B,
	MIPS_INS_MIN_U_D,
	MIPS_INS_MIN_U_H,
	MIPS_INS_MIN_U_W,
	MIPS_INS_MOD,
	MIPS_INS_MODSUB,
	MIPS_INS_MODU,
	MIPS_INS_MOD_S_B,
	MIPS_INS_MOD_S_D,
	MIPS_INS_MOD_S_H,
	MIPS_INS_MOD_S_W,
	MIPS_INS_MOD_U_B,
	MIPS_INS_MOD_U_D,
	MIPS_INS_MOD_U_H,
	MIPS_INS_MOD_U_W,
	MIPS_INS_MOVE,
	MIPS_INS_MOVE16,
	MIPS_INS_MOVE_BALC,
	MIPS_INS_MOVEP,
	MIPS_INS_MOVE_V,
	MIPS_INS_MOVF_D,
	MIPS_INS_MOVF,
	MIPS_INS_MOVF_S,
	MIPS_INS_MOVN_D,
	MIPS_INS_MOVN,
	MIPS_INS_MOVN_S,
	MIPS_INS_MOVT_D,
	MIPS_INS_MOVT,
	MIPS_INS_MOVT_S,
	MIPS_INS_MOVZ_D,
	MIPS_INS_MOVZ,
	MIPS_INS_MOVZ_S,
	MIPS_INS_MSUB,
	MIPS_INS_MSUBF_D,
	MIPS_INS_MSUBF_S,
	MIPS_INS_MSUBR_Q_H,
	MIPS_INS_MSUBR_Q_W,
	MIPS_INS_MSUBU,
	MIPS_INS_MSUBV_B,
	MIPS_INS_MSUBV_D,
	MIPS_INS_MSUBV_H,
	MIPS_INS_MSUBV_W,
	MIPS_INS_MSUB_D,
	MIPS_INS_MSUB_Q_H,
	MIPS_INS_MSUB_Q_W,
	MIPS_INS_MSUB_S,
	MIPS_INS_MTC0,
	MIPS_INS_MTC1,
	MIPS_INS_MTC2,
	MIPS_INS_MTGC0,
	MIPS_INS_MTHC0,
	MIPS_INS_MTHC1,
	MIPS_INS_MTHC2,
	MIPS_INS_MTHGC0,
	MIPS_INS_MTHI,
	MIPS_INS_MTHLIP,
	MIPS_INS_MTLO,
	MIPS_INS_MTM0,
	MIPS_INS_MTM1,
	MIPS_INS_MTM2,
	MIPS_INS_MTP0,
	MIPS_INS_MTP1,
	MIPS_INS_MTP2,
	MIPS_INS_MTTR,
	MIPS_INS_MUH,
	MIPS_INS_MUHU,
	MIPS_INS_MULEQ_S_W_PHL,
	MIPS_INS_MULEQ_S_W_PHR,
	MIPS_INS_MULEU_S_PH_QBL,
	MIPS_INS_MULEU_S_PH_QBR,
	MIPS_INS_MULQ_RS_PH,
	MIPS_INS_MULQ_RS_W,
	MIPS_INS_MULQ_S_PH,
	MIPS_INS_MULQ_S_W,
	MIPS_INS_MULR_PS,
	MIPS_INS_MULR_Q_H,
	MIPS_INS_MULR_Q_W,
	MIPS_INS_MULSAQ_S_W_PH,
	MIPS_INS_MULSA_W_PH,
	MIPS_INS_MULT,
	MIPS_INS_MULTU,
	MIPS_INS_MULU,
	MIPS_INS_MULV_B,
	MIPS_INS_MULV_D,
	MIPS_INS_MULV_H,
	MIPS_INS_MULV_W,
	MIPS_INS_MUL_PH,
	MIPS_INS_MUL_Q_H,
	MIPS_INS_MUL_Q_W,
	MIPS_INS_MUL_S_PH,
	MIPS_INS_NLOC_B,
	MIPS_INS_NLOC_D,
	MIPS_INS_NLOC_H,
	MIPS_INS_NLOC_W,
	MIPS_INS_NLZC_B,
	MIPS_INS_NLZC_D,
	MIPS_INS_NLZC_H,
	MIPS_INS_NLZC_W,
	MIPS_INS_NMADD_D,
	MIPS_INS_NMADD_S,
	MIPS_INS_NMSUB_D,
	MIPS_INS_NMSUB_S,
	MIPS_INS_NOP32,
	MIPS_INS_NOP,
	MIPS_INS_NORI_B,
	MIPS_INS_NOR_V,
	MIPS_INS_NOT16,
	MIPS_INS_NOT,
	MIPS_INS_NEG,
	MIPS_INS_OR,
	MIPS_INS_OR16,
	MIPS_INS_ORI_B,
	MIPS_INS_ORI,
	MIPS_INS_OR_V,
	MIPS_INS_PACKRL_PH,
	MIPS_INS_PAUSE,
	MIPS_INS_PCKEV_B,
	MIPS_INS_PCKEV_D,
	MIPS_INS_PCKEV_H,
	MIPS_INS_PCKEV_W,
	MIPS_INS_PCKOD_B,
	MIPS_INS_PCKOD_D,
	MIPS_INS_PCKOD_H,
	MIPS_INS_PCKOD_W,
	MIPS_INS_PCNT_B,
	MIPS_INS_PCNT_D,
	MIPS_INS_PCNT_H,
	MIPS_INS_PCNT_W,
	MIPS_INS_PICK_PH,
	MIPS_INS_PICK_QB,
	MIPS_INS_PLL_PS,
	MIPS_INS_PLU_PS,
	MIPS_INS_POP,
	MIPS_INS_PRECEQU_PH_QBL,
	MIPS_INS_PRECEQU_PH_QBLA,
	MIPS_INS_PRECEQU_PH_QBR,
	MIPS_INS_PRECEQU_PH_QBRA,
	MIPS_INS_PRECEQ_W_PHL,
	MIPS_INS_PRECEQ_W_PHR,
	MIPS_INS_PRECEU_PH_QBL,
	MIPS_INS_PRECEU_PH_QBLA,
	MIPS_INS_PRECEU_PH_QBR,
	MIPS_INS_PRECEU_PH_QBRA,
	MIPS_INS_PRECRQU_S_QB_PH,
	MIPS_INS_PRECRQ_PH_W,
	MIPS_INS_PRECRQ_QB_PH,
	MIPS_INS_PRECRQ_RS_PH_W,
	MIPS_INS_PRECR_QB_PH,
	MIPS_INS_PRECR_SRA_PH_W,
	MIPS_INS_PRECR_SRA_R_PH_W,
	MIPS_INS_PREF,
	MIPS_INS_PREFE,
	MIPS_INS_PREFX,
	MIPS_INS_PREPEND,
	MIPS_INS_PUL_PS,
	MIPS_INS_PUU_PS,
	MIPS_INS_RADDU_W_QB,
	MIPS_INS_RDDSP,
	MIPS_INS_RDHWR,
	MIPS_INS_RDPGPR,
	MIPS_INS_RECIP_D,
	MIPS_INS_RECIP_S,
	MIPS_INS_REPLV_PH,
	MIPS_INS_REPLV_QB,
	MIPS_INS_REPL_PH,
	MIPS_INS_REPL_QB,
	MIPS_INS_RESTORE_JRC,
	MIPS_INS_RESTORE,
	MIPS_INS_RINT_D,
	MIPS_INS_RINT_S,
	MIPS_INS_ROTR,
	MIPS_INS_ROTRV,
	MIPS_INS_ROTX,
	MIPS_INS_ROUND_L_D,
	MIPS_INS_ROUND_L_S,
	MIPS_INS_ROUND_W_D,
	MIPS_INS_ROUND_W_S,
	MIPS_INS_RSQRT_D,
	MIPS_INS_RSQRT_S,
	MIPS_INS_SAT_S_B,
	MIPS_INS_SAT_S_D,
	MIPS_INS_SAT_S_H,
	MIPS_INS_SAT_S_W,
	MIPS_INS_SAT_U_B,
	MIPS_INS_SAT_U_D,
	MIPS_INS_SAT_U_H,
	MIPS_INS_SAT_U_W,
	MIPS_INS_SAVE,
	MIPS_INS_SB,
	MIPS_INS_SB16,
	MIPS_INS_SBE,
	MIPS_INS_SBX,
	MIPS_INS_SC,
	MIPS_INS_SCD,
	MIPS_INS_SCE,
	MIPS_INS_SCWP,
	MIPS_INS_SDBBP,
	MIPS_INS_SDBBP16,
	MIPS_INS_SDC1,
	MIPS_INS_SDC2,
	MIPS_INS_SDC3,
	MIPS_INS_SDL,
	MIPS_INS_SDR,
	MIPS_INS_SDXC1,
	MIPS_INS_SEB,
	MIPS_INS_SEH,
	MIPS_INS_SELEQZ,
	MIPS_INS_SELEQZ_D,
	MIPS_INS_SELEQZ_S,
	MIPS_INS_SELNEZ,
	MIPS_INS_SELNEZ_D,
	MIPS_INS_SELNEZ_S,
	MIPS_INS_SEL_D,
	MIPS_INS_SEL_S,
	MIPS_INS_SEQI,
	MIPS_INS_SH,
	MIPS_INS_SH16,
	MIPS_INS_SHE,
	MIPS_INS_SHF_B,
	MIPS_INS_SHF_H,
	MIPS_INS_SHF_W,
	MIPS_INS_SHILO,
	MIPS_INS_SHILOV,
	MIPS_INS_SHLLV_PH,
	MIPS_INS_SHLLV_QB,
	MIPS_INS_SHLLV_S_PH,
	MIPS_INS_SHLLV_S_W,
	MIPS_INS_SHLL_PH,
	MIPS_INS_SHLL_QB,
	MIPS_INS_SHLL_S_PH,
	MIPS_INS_SHLL_S_W,
	MIPS_INS_SHRAV_PH,
	MIPS_INS_SHRAV_QB,
	MIPS_INS_SHRAV_R_PH,
	MIPS_INS_SHRAV_R_QB,
	MIPS_INS_SHRAV_R_W,
	MIPS_INS_SHRA_PH,
	MIPS_INS_SHRA_QB,
	MIPS_INS_SHRA_R_PH,
	MIPS_INS_SHRA_R_QB,
	MIPS_INS_SHRA_R_W,
	MIPS_INS_SHRLV_PH,
	MIPS_INS_SHRLV_QB,
	MIPS_INS_SHRL_PH,
	MIPS_INS_SHRL_QB,
	MIPS_INS_SHXS,
	MIPS_INS_SHX,
	MIPS_INS_SIGRIE,
	MIPS_INS_SLDI_B,
	MIPS_INS_SLDI_D,
	MIPS_INS_SLDI_H,
	MIPS_INS_SLDI_W,
	MIPS_INS_SLD_B,
	MIPS_INS_SLD_D,
	MIPS_INS_SLD_H,
	MIPS_INS_SLD_W,
	MIPS_INS_SLL,
	MIPS_INS_SLL16,
	MIPS_INS_SLLI_B,
	MIPS_INS_SLLI_D,
	MIPS_INS_SLLI_H,
	MIPS_INS_SLLI_W,
	MIPS_INS_SLLV,
	MIPS_INS_SLL_B,
	MIPS_INS_SLL_D,
	MIPS_INS_SLL_H,
	MIPS_INS_SLL_W,
	MIPS_INS_SLTIU,
	MIPS_INS_SLTI,
	MIPS_INS_SNEI,
	MIPS_INS_SOV,
	MIPS_INS_SPLATI_B,
	MIPS_INS_SPLATI_D,
	MIPS_INS_SPLATI_H,
	MIPS_INS_SPLATI_W,
	MIPS_INS_SPLAT_B,
	MIPS_INS_SPLAT_D,
	MIPS_INS_SPLAT_H,
	MIPS_INS_SPLAT_W,
	MIPS_INS_SRA,
	MIPS_INS_SRAI_B,
	MIPS_INS_SRAI_D,
	MIPS_INS_SRAI_H,
	MIPS_INS_SRAI_W,
	MIPS_INS_SRARI_B,
	MIPS_INS_SRARI_D,
	MIPS_INS_SRARI_H,
	MIPS_INS_SRARI_W,
	MIPS_INS_SRAR_B,
	MIPS_INS_SRAR_D,
	MIPS_INS_SRAR_H,
	MIPS_INS_SRAR_W,
	MIPS_INS_SRAV,
	MIPS_INS_SRA_B,
	MIPS_INS_SRA_D,
	MIPS_INS_SRA_H,
	MIPS_INS_SRA_W,
	MIPS_INS_SRL,
	MIPS_INS_SRL16,
	MIPS_INS_SRLI_B,
	MIPS_INS_SRLI_D,
	MIPS_INS_SRLI_H,
	MIPS_INS_SRLI_W,
	MIPS_INS_SRLRI_B,
	MIPS_INS_SRLRI_D,
	MIPS_INS_SRLRI_H,
	MIPS_INS_SRLRI_W,
	MIPS_INS_SRLR_B,
	MIPS_INS_SRLR_D,
	MIPS_INS_SRLR_H,
	MIPS_INS_SRLR_W,
	MIPS_INS_SRLV,
	MIPS_INS_SRL_B,
	MIPS_INS_SRL_D,
	MIPS_INS_SRL_H,
	MIPS_INS_SRL_W,
	MIPS_INS_SSNOP,
	MIPS_INS_ST_B,
	MIPS_INS_ST_D,
	MIPS_INS_ST_H,
	MIPS_INS_ST_W,
	MIPS_INS_SUB,
	MIPS_INS_SUBQH_PH,
	MIPS_INS_SUBQH_R_PH,
	MIPS_INS_SUBQH_R_W,
	MIPS_INS_SUBQH_W,
	MIPS_INS_SUBQ_PH,
	MIPS_INS_SUBQ_S_PH,
	MIPS_INS_SUBQ_S_W,
	MIPS_INS_SUBSUS_U_B,
	MIPS_INS_SUBSUS_U_D,
	MIPS_INS_SUBSUS_U_H,
	MIPS_INS_SUBSUS_U_W,
	MIPS_INS_SUBSUU_S_B,
	MIPS_INS_SUBSUU_S_D,
	MIPS_INS_SUBSUU_S_H,
	MIPS_INS_SUBSUU_S_W,
	MIPS_INS_SUBS_S_B,
	MIPS_INS_SUBS_S_D,
	MIPS_INS_SUBS_S_H,
	MIPS_INS_SUBS_S_W,
	MIPS_INS_SUBS_U_B,
	MIPS_INS_SUBS_U_D,
	MIPS_INS_SUBS_U_H,
	MIPS_INS_SUBS_U_W,
	MIPS_INS_SUBU16,
	MIPS_INS_SUBUH_QB,
	MIPS_INS_SUBUH_R_QB,
	MIPS_INS_SUBU_PH,
	MIPS_INS_SUBU_QB,
	MIPS_INS_SUBU_S_PH,
	MIPS_INS_SUBU_S_QB,
	MIPS_INS_SUBVI_B,
	MIPS_INS_SUBVI_D,
	MIPS_INS_SUBVI_H,
	MIPS_INS_SUBVI_W,
	MIPS_INS_SUBV_B,
	MIPS_INS_SUBV_D,
	MIPS_INS_SUBV_H,
	MIPS_INS_SUBV_W,
	MIPS_INS_SUXC1,
	MIPS_INS_SW,
	MIPS_INS_SW16,
	MIPS_INS_SWC1,
	MIPS_INS_SWC2,
	MIPS_INS_SWC3,
	MIPS_INS_SWE,
	MIPS_INS_SWL,
	MIPS_INS_SWLE,
	MIPS_INS_SWM16,
	MIPS_INS_SWM32,
	MIPS_INS_SWPC,
	MIPS_INS_SWP,
	MIPS_INS_SWR,
	MIPS_INS_SWRE,
	MIPS_INS_SWSP,
	MIPS_INS_SWXC1,
	MIPS_INS_SWXS,
	MIPS_INS_SWX,
	MIPS_INS_SYNC,
	MIPS_INS_SYNCI,
	MIPS_INS_SYSCALL,
	MIPS_INS_TEQ,
	MIPS_INS_TEQI,
	MIPS_INS_TGE,
	MIPS_INS_TGEI,
	MIPS_INS_TGEIU,
	MIPS_INS_TGEU,
	MIPS_INS_TLBGINV,
	MIPS_INS_TLBGINVF,
	MIPS_INS_TLBGP,
	MIPS_INS_TLBGR,
	MIPS_INS_TLBGWI,
	MIPS_INS_TLBGWR,
	MIPS_INS_TLBINV,
	MIPS_INS_TLBINVF,
	MIPS_INS_TLBP,
	MIPS_INS_TLBR,
	MIPS_INS_TLBWI,
	MIPS_INS_TLBWR,
	MIPS_INS_TLT,
	MIPS_INS_TLTI,
	MIPS_INS_TLTIU,
	MIPS_INS_TLTU,
	MIPS_INS_TNE,
	MIPS_INS_TNEI,
	MIPS_INS_TRUNC_L_D,
	MIPS_INS_TRUNC_L_S,
	MIPS_INS_UALH,
	MIPS_INS_UALWM,
	MIPS_INS_UALW,
	MIPS_INS_UASH,
	MIPS_INS_UASWM,
	MIPS_INS_UASW,
	MIPS_INS_V3MULU,
	MIPS_INS_VMM0,
	MIPS_INS_VMULU,
	MIPS_INS_VSHF_B,
	MIPS_INS_VSHF_D,
	MIPS_INS_VSHF_H,
	MIPS_INS_VSHF_W,
	MIPS_INS_WAIT,
	MIPS_INS_WRDSP,
	MIPS_INS_WRPGPR,
	MIPS_INS_WSBH,
	MIPS_INS_XOR,
	MIPS_INS_XOR16,
	MIPS_INS_XORI_B,
	MIPS_INS_XORI,
	MIPS_INS_XOR_V,
	MIPS_INS_YIELD,

	// clang-format on
	// generated content <MipsGenCSInsnEnum.inc> end
	MIPS_INS_ENDING,

	MIPS_INS_ALIAS_BEGIN,
	// generated content <MipsGenCSAliasEnum.inc> begin
	// clang-format off

	MIPS_INS_ALIAS_ADDIU_B32, // Real instr.: MIPS_ADDIUGP48_NM
	MIPS_INS_ALIAS_BITREVB, // Real instr.: MIPS_ROTX_NM
	MIPS_INS_ALIAS_BITREVH, // Real instr.: MIPS_ROTX_NM
	MIPS_INS_ALIAS_BYTEREVH, // Real instr.: MIPS_ROTX_NM
	MIPS_INS_ALIAS_NOT, // Real instr.: MIPS_NOR_NM
	MIPS_INS_ALIAS_RESTORE_JRC, // Real instr.: MIPS_RESTOREJRC16_NM
	MIPS_INS_ALIAS_RESTORE, // Real instr.: MIPS_RESTORE_NM
	MIPS_INS_ALIAS_SAVE, // Real instr.: MIPS_SAVE16_NM
	MIPS_INS_ALIAS_MOVE, // Real instr.: MIPS_OR
	MIPS_INS_ALIAS_BAL, // Real instr.: MIPS_BGEZAL
	MIPS_INS_ALIAS_JALR_HB, // Real instr.: MIPS_JALR_HB
	MIPS_INS_ALIAS_NEG, // Real instr.: MIPS_SUB
	MIPS_INS_ALIAS_NEGU, // Real instr.: MIPS_SUBu
	MIPS_INS_ALIAS_NOP, // Real instr.: MIPS_SLL
	MIPS_INS_ALIAS_BNEZL, // Real instr.: MIPS_BNEL
	MIPS_INS_ALIAS_BEQZL, // Real instr.: MIPS_BEQL
	MIPS_INS_ALIAS_SYSCALL, // Real instr.: MIPS_SYSCALL
	MIPS_INS_ALIAS_BREAK, // Real instr.: MIPS_BREAK
	MIPS_INS_ALIAS_EI, // Real instr.: MIPS_EI
	MIPS_INS_ALIAS_DI, // Real instr.: MIPS_DI
	MIPS_INS_ALIAS_TEQ, // Real instr.: MIPS_TEQ
	MIPS_INS_ALIAS_TGE, // Real instr.: MIPS_TGE
	MIPS_INS_ALIAS_TGEU, // Real instr.: MIPS_TGEU
	MIPS_INS_ALIAS_TLT, // Real instr.: MIPS_TLT
	MIPS_INS_ALIAS_TLTU, // Real instr.: MIPS_TLTU
	MIPS_INS_ALIAS_TNE, // Real instr.: MIPS_TNE
	MIPS_INS_ALIAS_RDHWR, // Real instr.: MIPS_RDHWR
	MIPS_INS_ALIAS_SDBBP, // Real instr.: MIPS_SDBBP
	MIPS_INS_ALIAS_SYNC, // Real instr.: MIPS_SYNC
	MIPS_INS_ALIAS_HYPCALL, // Real instr.: MIPS_HYPCALL
	MIPS_INS_ALIAS_NOR, // Real instr.: MIPS_NORImm
	MIPS_INS_ALIAS_C_F_S, // Real instr.: MIPS_C_F_S
	MIPS_INS_ALIAS_C_UN_S, // Real instr.: MIPS_C_UN_S
	MIPS_INS_ALIAS_C_EQ_S, // Real instr.: MIPS_C_EQ_S
	MIPS_INS_ALIAS_C_UEQ_S, // Real instr.: MIPS_C_UEQ_S
	MIPS_INS_ALIAS_C_OLT_S, // Real instr.: MIPS_C_OLT_S
	MIPS_INS_ALIAS_C_ULT_S, // Real instr.: MIPS_C_ULT_S
	MIPS_INS_ALIAS_C_OLE_S, // Real instr.: MIPS_C_OLE_S
	MIPS_INS_ALIAS_C_ULE_S, // Real instr.: MIPS_C_ULE_S
	MIPS_INS_ALIAS_C_SF_S, // Real instr.: MIPS_C_SF_S
	MIPS_INS_ALIAS_C_NGLE_S, // Real instr.: MIPS_C_NGLE_S
	MIPS_INS_ALIAS_C_SEQ_S, // Real instr.: MIPS_C_SEQ_S
	MIPS_INS_ALIAS_C_NGL_S, // Real instr.: MIPS_C_NGL_S
	MIPS_INS_ALIAS_C_LT_S, // Real instr.: MIPS_C_LT_S
	MIPS_INS_ALIAS_C_NGE_S, // Real instr.: MIPS_C_NGE_S
	MIPS_INS_ALIAS_C_LE_S, // Real instr.: MIPS_C_LE_S
	MIPS_INS_ALIAS_C_NGT_S, // Real instr.: MIPS_C_NGT_S
	MIPS_INS_ALIAS_BC1T, // Real instr.: MIPS_BC1T
	MIPS_INS_ALIAS_BC1F, // Real instr.: MIPS_BC1F
	MIPS_INS_ALIAS_C_F_D, // Real instr.: MIPS_C_F_D32
	MIPS_INS_ALIAS_C_UN_D, // Real instr.: MIPS_C_UN_D32
	MIPS_INS_ALIAS_C_EQ_D, // Real instr.: MIPS_C_EQ_D32
	MIPS_INS_ALIAS_C_UEQ_D, // Real instr.: MIPS_C_UEQ_D32
	MIPS_INS_ALIAS_C_OLT_D, // Real instr.: MIPS_C_OLT_D32
	MIPS_INS_ALIAS_C_ULT_D, // Real instr.: MIPS_C_ULT_D32
	MIPS_INS_ALIAS_C_OLE_D, // Real instr.: MIPS_C_OLE_D32
	MIPS_INS_ALIAS_C_ULE_D, // Real instr.: MIPS_C_ULE_D32
	MIPS_INS_ALIAS_C_SF_D, // Real instr.: MIPS_C_SF_D32
	MIPS_INS_ALIAS_C_NGLE_D, // Real instr.: MIPS_C_NGLE_D32
	MIPS_INS_ALIAS_C_SEQ_D, // Real instr.: MIPS_C_SEQ_D32
	MIPS_INS_ALIAS_C_NGL_D, // Real instr.: MIPS_C_NGL_D32
	MIPS_INS_ALIAS_C_LT_D, // Real instr.: MIPS_C_LT_D32
	MIPS_INS_ALIAS_C_NGE_D, // Real instr.: MIPS_C_NGE_D32
	MIPS_INS_ALIAS_C_LE_D, // Real instr.: MIPS_C_LE_D32
	MIPS_INS_ALIAS_C_NGT_D, // Real instr.: MIPS_C_NGT_D32
	MIPS_INS_ALIAS_BC1TL, // Real instr.: MIPS_BC1TL
	MIPS_INS_ALIAS_BC1FL, // Real instr.: MIPS_BC1FL
	MIPS_INS_ALIAS_DNEG, // Real instr.: MIPS_DSUB
	MIPS_INS_ALIAS_DNEGU, // Real instr.: MIPS_DSUBu
	MIPS_INS_ALIAS_SLT, // Real instr.: MIPS_SLTImm64
	MIPS_INS_ALIAS_SLTU, // Real instr.: MIPS_SLTUImm64
	MIPS_INS_ALIAS_SIGRIE, // Real instr.: MIPS_SIGRIE
	MIPS_INS_ALIAS_JR, // Real instr.: MIPS_JALR
	MIPS_INS_ALIAS_JRC, // Real instr.: MIPS_JIC
	MIPS_INS_ALIAS_JALRC, // Real instr.: MIPS_JIALC
	MIPS_INS_ALIAS_DIV, // Real instr.: MIPS_DIV
	MIPS_INS_ALIAS_DIVU, // Real instr.: MIPS_DIVU
	MIPS_INS_ALIAS_LAPC, // Real instr.: MIPS_ADDIUPC
	MIPS_INS_ALIAS_WRDSP, // Real instr.: MIPS_WRDSP
	MIPS_INS_ALIAS_WAIT, // Real instr.: MIPS_WAIT_MM
	MIPS_INS_ALIAS_SW, // Real instr.: MIPS_SWSP_MM
	MIPS_INS_ALIAS_JALRC_HB, // Real instr.: MIPS_JALRC_HB_MMR6
	MIPS_INS_ALIAS_ADDIU_B, // Real instr.: MIPS_ADDIUGPB_NM
	MIPS_INS_ALIAS_ADDIU_W, // Real instr.: MIPS_ADDIUGPW_NM
	MIPS_INS_ALIAS_JRC_HB, // Real instr.: MIPS_JALRCHB_NM
	MIPS_INS_ALIAS_BEQC, // Real instr.: MIPS_BEQC16_NM
	MIPS_INS_ALIAS_BNEC, // Real instr.: MIPS_BNEC16_NM
	MIPS_INS_ALIAS_BEQZC, // Real instr.: MIPS_BEQC_NM
	MIPS_INS_ALIAS_BNEZC, // Real instr.: MIPS_BNEC_NM
	MIPS_INS_ALIAS_MFC0, // Real instr.: MIPS_MFC0_NM
	MIPS_INS_ALIAS_MFHC0, // Real instr.: MIPS_MFHC0_NM
	MIPS_INS_ALIAS_MTC0, // Real instr.: MIPS_MTC0_NM
	MIPS_INS_ALIAS_MTHC0, // Real instr.: MIPS_MTHC0_NM
	MIPS_INS_ALIAS_DMT, // Real instr.: MIPS_DMT
	MIPS_INS_ALIAS_EMT, // Real instr.: MIPS_EMT
	MIPS_INS_ALIAS_DVPE, // Real instr.: MIPS_DVPE
	MIPS_INS_ALIAS_EVPE, // Real instr.: MIPS_EVPE
	MIPS_INS_ALIAS_YIELD, // Real instr.: MIPS_YIELD
	MIPS_INS_ALIAS_MFTC0, // Real instr.: MIPS_MFTC0
	MIPS_INS_ALIAS_MFTLO, // Real instr.: MIPS_MFTLO
	MIPS_INS_ALIAS_MFTHI, // Real instr.: MIPS_MFTHI
	MIPS_INS_ALIAS_MFTACX, // Real instr.: MIPS_MFTACX
	MIPS_INS_ALIAS_MTTC0, // Real instr.: MIPS_MTTC0
	MIPS_INS_ALIAS_MTTLO, // Real instr.: MIPS_MTTLO
	MIPS_INS_ALIAS_MTTHI, // Real instr.: MIPS_MTTHI
	MIPS_INS_ALIAS_MTTACX, // Real instr.: MIPS_MTTACX

	// clang-format on
	// generated content <MipsGenCSAliasEnum.inc> end

	// The followings aliases are not generated by LLVM table gen.
	MIPS_INS_ALIAS_B, // beq $zero, $zero, $L2 => b $L2
	MIPS_INS_ALIAS_BEQZ, // beq $r0, $zero, $L2 => beqz $r0, $L2
	MIPS_INS_ALIAS_BNEZ, // bne $r0, $zero, $L2 => bnez $r0, $L2
	MIPS_INS_ALIAS_LI, // addiu $rX, $r0, imm => li $r0, imm
	MIPS_INS_ALIAS_END,
} mips_insn;

/// Group of MIPS instructions
typedef enum mips_insn_group {
	MIPS_GRP_INVALID = 0, ///< = CS_GRP_INVALID

	// Generic groups
	// all jump instructions (conditional+direct+indirect jumps)
	MIPS_GRP_JUMP, ///< = CS_GRP_JUMP
	// all call instructions
	MIPS_GRP_CALL, ///< = CS_GRP_CALL
	// all return instructions
	MIPS_GRP_RET, ///< = CS_GRP_RET
	// all interrupt instructions (int+syscall)
	MIPS_GRP_INT, ///< = CS_GRP_INT
	// all interrupt return instructions
	MIPS_GRP_IRET, ///< = CS_GRP_IRET
	// all privileged instructions
	MIPS_GRP_PRIVILEGE, ///< = CS_GRP_PRIVILEGE
	// all relative branching instructions
	MIPS_GRP_BRANCH_RELATIVE, ///< = CS_GRP_BRANCH_RELATIVE

	// Architecture-specific groups
	// generated content <MipsGenCSFeatureEnum.inc> begin
	// clang-format off

	MIPS_FEATURE_HASMIPS2 = 128,
	MIPS_FEATURE_HASMIPS3_32,
	MIPS_FEATURE_HASMIPS3_32R2,
	MIPS_FEATURE_HASMIPS3,
	MIPS_FEATURE_NOTMIPS3,
	MIPS_FEATURE_HASMIPS4_32,
	MIPS_FEATURE_NOTMIPS4_32,
	MIPS_FEATURE_HASMIPS4_32R2,
	MIPS_FEATURE_HASMIPS5_32R2,
	MIPS_FEATURE_HASMIPS32,
	MIPS_FEATURE_HASMIPS32R2,
	MIPS_FEATURE_HASMIPS32R5,
	MIPS_FEATURE_HASMIPS32R6,
	MIPS_FEATURE_NOTMIPS32R6,
	MIPS_FEATURE_HASNANOMIPS,
	MIPS_FEATURE_NOTNANOMIPS,
	MIPS_FEATURE_ISGP64BIT,
	MIPS_FEATURE_ISGP32BIT,
	MIPS_FEATURE_ISPTR64BIT,
	MIPS_FEATURE_ISPTR32BIT,
	MIPS_FEATURE_HASMIPS64,
	MIPS_FEATURE_NOTMIPS64,
	MIPS_FEATURE_HASMIPS64R2,
	MIPS_FEATURE_HASMIPS64R5,
	MIPS_FEATURE_HASMIPS64R6,
	MIPS_FEATURE_NOTMIPS64R6,
	MIPS_FEATURE_INMIPS16MODE,
	MIPS_FEATURE_NOTINMIPS16MODE,
	MIPS_FEATURE_HASCNMIPS,
	MIPS_FEATURE_NOTCNMIPS,
	MIPS_FEATURE_HASCNMIPSP,
	MIPS_FEATURE_NOTCNMIPSP,
	MIPS_FEATURE_ISSYM32,
	MIPS_FEATURE_ISSYM64,
	MIPS_FEATURE_HASSTDENC,
	MIPS_FEATURE_INMICROMIPS,
	MIPS_FEATURE_NOTINMICROMIPS,
	MIPS_FEATURE_HASEVA,
	MIPS_FEATURE_HASMSA,
	MIPS_FEATURE_HASMADD4,
	MIPS_FEATURE_HASMT,
	MIPS_FEATURE_USEINDIRECTJUMPSHAZARD,
	MIPS_FEATURE_NOINDIRECTJUMPGUARDS,
	MIPS_FEATURE_HASCRC,
	MIPS_FEATURE_HASVIRT,
	MIPS_FEATURE_HASGINV,
	MIPS_FEATURE_HASTLB,
	MIPS_FEATURE_ISFP64BIT,
	MIPS_FEATURE_NOTFP64BIT,
	MIPS_FEATURE_ISSINGLEFLOAT,
	MIPS_FEATURE_ISNOTSINGLEFLOAT,
	MIPS_FEATURE_ISNOTSOFTFLOAT,
	MIPS_FEATURE_HASMIPS3D,
	MIPS_FEATURE_HASDSP,
	MIPS_FEATURE_HASDSPR2,
	MIPS_FEATURE_HASDSPR3,

	// clang-format on
	// generated content <MipsGenCSFeatureEnum.inc> end

	MIPS_GRP_ENDING,
} mips_insn_group;

#ifdef __cplusplus
}
#endif

#endif
