/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Updates properties of dimensions within the specified range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateDimensionPropertiesRequest extends com.google.api.client.json.GenericJson {

  /**
   * The columns on a data source sheet to update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSourceSheetDimensionRange dataSourceSheetRange;

  /**
   * The fields that should be updated. At least one field must be specified. The root `properties`
   * is implied and should not be specified. A single `"*"` can be used as short-hand for listing
   * every field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * Properties to update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionProperties properties;

  /**
   * The rows or columns to update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionRange range;

  /**
   * The columns on a data source sheet to update.
   * @return value or {@code null} for none
   */
  public DataSourceSheetDimensionRange getDataSourceSheetRange() {
    return dataSourceSheetRange;
  }

  /**
   * The columns on a data source sheet to update.
   * @param dataSourceSheetRange dataSourceSheetRange or {@code null} for none
   */
  public UpdateDimensionPropertiesRequest setDataSourceSheetRange(DataSourceSheetDimensionRange dataSourceSheetRange) {
    this.dataSourceSheetRange = dataSourceSheetRange;
    return this;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root `properties`
   * is implied and should not be specified. A single `"*"` can be used as short-hand for listing
   * every field.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root `properties`
   * is implied and should not be specified. A single `"*"` can be used as short-hand for listing
   * every field.
   * @param fields fields or {@code null} for none
   */
  public UpdateDimensionPropertiesRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * Properties to update.
   * @return value or {@code null} for none
   */
  public DimensionProperties getProperties() {
    return properties;
  }

  /**
   * Properties to update.
   * @param properties properties or {@code null} for none
   */
  public UpdateDimensionPropertiesRequest setProperties(DimensionProperties properties) {
    this.properties = properties;
    return this;
  }

  /**
   * The rows or columns to update.
   * @return value or {@code null} for none
   */
  public DimensionRange getRange() {
    return range;
  }

  /**
   * The rows or columns to update.
   * @param range range or {@code null} for none
   */
  public UpdateDimensionPropertiesRequest setRange(DimensionRange range) {
    this.range = range;
    return this;
  }

  @Override
  public UpdateDimensionPropertiesRequest set(String fieldName, Object value) {
    return (UpdateDimensionPropertiesRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateDimensionPropertiesRequest clone() {
    return (UpdateDimensionPropertiesRequest) super.clone();
  }

}
