//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurityinsights

import "encoding/json"

func unmarshalAlertRuleClassification(rawMsg json.RawMessage) (AlertRuleClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AlertRuleClassification
	switch m["kind"] {
	case string(AlertRuleKindFusion):
		b = &FusionAlertRule{}
	case string(AlertRuleKindMLBehaviorAnalytics):
		b = &MLBehaviorAnalyticsAlertRule{}
	case string(AlertRuleKindMicrosoftSecurityIncidentCreation):
		b = &MicrosoftSecurityIncidentCreationAlertRule{}
	case string(AlertRuleKindNRT):
		b = &NrtAlertRule{}
	case string(AlertRuleKindScheduled):
		b = &ScheduledAlertRule{}
	case string(AlertRuleKindThreatIntelligence):
		b = &ThreatIntelligenceAlertRule{}
	default:
		b = &AlertRule{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalAlertRuleClassificationArray(rawMsg json.RawMessage) ([]AlertRuleClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AlertRuleClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAlertRuleClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalAlertRuleTemplateClassification(rawMsg json.RawMessage) (AlertRuleTemplateClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AlertRuleTemplateClassification
	switch m["kind"] {
	case string(AlertRuleKindFusion):
		b = &FusionAlertRuleTemplate{}
	case string(AlertRuleKindMLBehaviorAnalytics):
		b = &MLBehaviorAnalyticsAlertRuleTemplate{}
	case string(AlertRuleKindMicrosoftSecurityIncidentCreation):
		b = &MicrosoftSecurityIncidentCreationAlertRuleTemplate{}
	case string(AlertRuleKindNRT):
		b = &NrtAlertRuleTemplate{}
	case string(AlertRuleKindScheduled):
		b = &ScheduledAlertRuleTemplate{}
	case string(AlertRuleKindThreatIntelligence):
		b = &ThreatIntelligenceAlertRuleTemplate{}
	default:
		b = &AlertRuleTemplate{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalAlertRuleTemplateClassificationArray(rawMsg json.RawMessage) ([]AlertRuleTemplateClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AlertRuleTemplateClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAlertRuleTemplateClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalAutomationRuleActionClassification(rawMsg json.RawMessage) (AutomationRuleActionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AutomationRuleActionClassification
	switch m["actionType"] {
	case string(ActionTypeModifyProperties):
		b = &AutomationRuleModifyPropertiesAction{}
	case string(ActionTypeRunPlaybook):
		b = &AutomationRuleRunPlaybookAction{}
	default:
		b = &AutomationRuleAction{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalAutomationRuleActionClassificationArray(rawMsg json.RawMessage) ([]AutomationRuleActionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AutomationRuleActionClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAutomationRuleActionClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalAutomationRuleConditionClassification(rawMsg json.RawMessage) (AutomationRuleConditionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AutomationRuleConditionClassification
	switch m["conditionType"] {
	case string(ConditionTypeBoolean):
		b = &BooleanConditionProperties{}
	case string(ConditionTypeProperty):
		b = &PropertyConditionProperties{}
	case string(ConditionTypePropertyArray):
		b = &PropertyArrayConditionProperties{}
	case string(ConditionTypePropertyArrayChanged):
		b = &PropertyArrayChangedConditionProperties{}
	case string(ConditionTypePropertyChanged):
		b = &PropertyChangedConditionProperties{}
	default:
		b = &AutomationRuleCondition{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalAutomationRuleConditionClassificationArray(rawMsg json.RawMessage) ([]AutomationRuleConditionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AutomationRuleConditionClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAutomationRuleConditionClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalDataConnectorClassification(rawMsg json.RawMessage) (DataConnectorClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DataConnectorClassification
	switch m["kind"] {
	case string(DataConnectorKindAPIPolling):
		b = &CodelessAPIPollingDataConnector{}
	case string(DataConnectorKindAmazonWebServicesCloudTrail):
		b = &AwsCloudTrailDataConnector{}
	case string(DataConnectorKindAmazonWebServicesS3):
		b = &AwsS3DataConnector{}
	case string(DataConnectorKindAzureActiveDirectory):
		b = &AADDataConnector{}
	case string(DataConnectorKindAzureAdvancedThreatProtection):
		b = &AATPDataConnector{}
	case string(DataConnectorKindAzureSecurityCenter):
		b = &ASCDataConnector{}
	case string(DataConnectorKindDynamics365):
		b = &Dynamics365DataConnector{}
	case string(DataConnectorKindGenericUI):
		b = &CodelessUIDataConnector{}
	case string(DataConnectorKindIOT):
		b = &IoTDataConnector{}
	case string(DataConnectorKindMicrosoftCloudAppSecurity):
		b = &MCASDataConnector{}
	case string(DataConnectorKindMicrosoftDefenderAdvancedThreatProtection):
		b = &MDATPDataConnector{}
	case string(DataConnectorKindMicrosoftThreatIntelligence):
		b = &MSTIDataConnector{}
	case string(DataConnectorKindMicrosoftThreatProtection):
		b = &MTPDataConnector{}
	case string(DataConnectorKindOffice365):
		b = &OfficeDataConnector{}
	case string(DataConnectorKindOffice365Project):
		b = &Office365ProjectDataConnector{}
	case string(DataConnectorKindOfficeATP):
		b = &OfficeATPDataConnector{}
	case string(DataConnectorKindOfficeIRM):
		b = &OfficeIRMDataConnector{}
	case string(DataConnectorKindOfficePowerBI):
		b = &OfficePowerBIDataConnector{}
	case string(DataConnectorKindThreatIntelligence):
		b = &TIDataConnector{}
	case string(DataConnectorKindThreatIntelligenceTaxii):
		b = &TiTaxiiDataConnector{}
	default:
		b = &DataConnector{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalDataConnectorClassificationArray(rawMsg json.RawMessage) ([]DataConnectorClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]DataConnectorClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalDataConnectorClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalEntityClassification(rawMsg json.RawMessage) (EntityClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b EntityClassification
	switch m["kind"] {
	case string(EntityKindAccount):
		b = &AccountEntity{}
	case string(EntityKindAzureResource):
		b = &AzureResourceEntity{}
	case string(EntityKindBookmark):
		b = &HuntingBookmark{}
	case string(EntityKindCloudApplication):
		b = &CloudApplicationEntity{}
	case string(EntityKindDNSResolution):
		b = &DNSEntity{}
	case string(EntityKindFile):
		b = &FileEntity{}
	case string(EntityKindFileHash):
		b = &FileHashEntity{}
	case string(EntityKindHost):
		b = &HostEntity{}
	case string(EntityKindIoTDevice):
		b = &IoTDeviceEntity{}
	case string(EntityKindIP):
		b = &IPEntity{}
	case string(EntityKindMailCluster):
		b = &MailClusterEntity{}
	case string(EntityKindMailMessage):
		b = &MailMessageEntity{}
	case string(EntityKindMailbox):
		b = &MailboxEntity{}
	case string(EntityKindMalware):
		b = &MalwareEntity{}
	case string(EntityKindNic):
		b = &NicEntity{}
	case string(EntityKindProcess):
		b = &ProcessEntity{}
	case string(EntityKindRegistryKey):
		b = &RegistryKeyEntity{}
	case string(EntityKindRegistryValue):
		b = &RegistryValueEntity{}
	case string(EntityKindSecurityAlert):
		b = &SecurityAlert{}
	case string(EntityKindSecurityGroup):
		b = &SecurityGroupEntity{}
	case string(EntityKindSubmissionMail):
		b = &SubmissionMailEntity{}
	case string(EntityKindURL):
		b = &URLEntity{}
	default:
		b = &Entity{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalEntityClassificationArray(rawMsg json.RawMessage) ([]EntityClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]EntityClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalEntityClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalEntityQueryClassification(rawMsg json.RawMessage) (EntityQueryClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b EntityQueryClassification
	switch m["kind"] {
	case string(EntityQueryKindActivity):
		b = &ActivityEntityQuery{}
	case string(EntityQueryKindExpansion):
		b = &ExpansionEntityQuery{}
	default:
		b = &EntityQuery{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalEntityQueryClassificationArray(rawMsg json.RawMessage) ([]EntityQueryClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]EntityQueryClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalEntityQueryClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalEntityQueryItemClassification(rawMsg json.RawMessage) (EntityQueryItemClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b EntityQueryItemClassification
	switch m["kind"] {
	case string(EntityQueryKindInsight):
		b = &InsightQueryItem{}
	default:
		b = &EntityQueryItem{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalEntityQueryItemClassificationArray(rawMsg json.RawMessage) ([]EntityQueryItemClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]EntityQueryItemClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalEntityQueryItemClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalEntityQueryTemplateClassification(rawMsg json.RawMessage) (EntityQueryTemplateClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b EntityQueryTemplateClassification
	switch m["kind"] {
	case string(EntityQueryTemplateKindActivity):
		b = &ActivityEntityQueryTemplate{}
	default:
		b = &EntityQueryTemplate{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalEntityQueryTemplateClassificationArray(rawMsg json.RawMessage) ([]EntityQueryTemplateClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]EntityQueryTemplateClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalEntityQueryTemplateClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalEntityTimelineItemClassification(rawMsg json.RawMessage) (EntityTimelineItemClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b EntityTimelineItemClassification
	switch m["kind"] {
	case string(EntityTimelineKindActivity):
		b = &ActivityTimelineItem{}
	case string(EntityTimelineKindAnomaly):
		b = &AnomalyTimelineItem{}
	case string(EntityTimelineKindBookmark):
		b = &BookmarkTimelineItem{}
	case string(EntityTimelineKindSecurityAlert):
		b = &SecurityAlertTimelineItem{}
	default:
		b = &EntityTimelineItem{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalEntityTimelineItemClassificationArray(rawMsg json.RawMessage) ([]EntityTimelineItemClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]EntityTimelineItemClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalEntityTimelineItemClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalSecurityMLAnalyticsSettingClassification(rawMsg json.RawMessage) (SecurityMLAnalyticsSettingClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b SecurityMLAnalyticsSettingClassification
	switch m["kind"] {
	case string(SecurityMLAnalyticsSettingsKindAnomaly):
		b = &AnomalySecurityMLAnalyticsSettings{}
	default:
		b = &SecurityMLAnalyticsSetting{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalSecurityMLAnalyticsSettingClassificationArray(rawMsg json.RawMessage) ([]SecurityMLAnalyticsSettingClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]SecurityMLAnalyticsSettingClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalSecurityMLAnalyticsSettingClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalSettingsClassification(rawMsg json.RawMessage) (SettingsClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b SettingsClassification
	switch m["kind"] {
	case string(SettingKindAnomalies):
		b = &Anomalies{}
	case string(SettingKindEntityAnalytics):
		b = &EntityAnalytics{}
	case string(SettingKindEyesOn):
		b = &EyesOn{}
	case string(SettingKindUeba):
		b = &Ueba{}
	default:
		b = &Settings{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalSettingsClassificationArray(rawMsg json.RawMessage) ([]SettingsClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]SettingsClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalSettingsClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalThreatIntelligenceInformationClassification(rawMsg json.RawMessage) (ThreatIntelligenceInformationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ThreatIntelligenceInformationClassification
	switch m["kind"] {
	case string(ThreatIntelligenceResourceKindEnumIndicator):
		b = &ThreatIntelligenceIndicatorModel{}
	default:
		b = &ThreatIntelligenceInformation{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalThreatIntelligenceInformationClassificationArray(rawMsg json.RawMessage) ([]ThreatIntelligenceInformationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]ThreatIntelligenceInformationClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalThreatIntelligenceInformationClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}
