//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SQLVulnerabilityAssessmentBaselineRulesClient contains the methods for the SQLVulnerabilityAssessmentBaselineRules group.
// Don't use this type directly, use NewSQLVulnerabilityAssessmentBaselineRulesClient() instead.
type SQLVulnerabilityAssessmentBaselineRulesClient struct {
	host string
	pl   runtime.Pipeline
}

// NewSQLVulnerabilityAssessmentBaselineRulesClient creates a new instance of SQLVulnerabilityAssessmentBaselineRulesClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewSQLVulnerabilityAssessmentBaselineRulesClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*SQLVulnerabilityAssessmentBaselineRulesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &SQLVulnerabilityAssessmentBaselineRulesClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// Add - Add a list of baseline rules. Will overwrite any previously existing results (for all rules).
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-07-01-preview
// workspaceID - The workspace Id.
// resourceID - The identifier of the resource.
// options - SQLVulnerabilityAssessmentBaselineRulesClientAddOptions contains the optional parameters for the SQLVulnerabilityAssessmentBaselineRulesClient.Add
// method.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) Add(ctx context.Context, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentBaselineRulesClientAddOptions) (SQLVulnerabilityAssessmentBaselineRulesClientAddResponse, error) {
	req, err := client.addCreateRequest(ctx, workspaceID, resourceID, options)
	if err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientAddResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientAddResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLVulnerabilityAssessmentBaselineRulesClientAddResponse{}, runtime.NewResponseError(resp)
	}
	return client.addHandleResponse(resp)
}

// addCreateRequest creates the Add request.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) addCreateRequest(ctx context.Context, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentBaselineRulesClientAddOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("workspaceId", workspaceID)
	reqQP.Set("api-version", "2020-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// addHandleResponse handles the Add response.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) addHandleResponse(resp *http.Response) (SQLVulnerabilityAssessmentBaselineRulesClientAddResponse, error) {
	result := SQLVulnerabilityAssessmentBaselineRulesClientAddResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RulesResults); err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientAddResponse{}, err
	}
	return result, nil
}

// CreateOrUpdate - Creates a Baseline for a rule in a database. Will overwrite any previously existing results.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-07-01-preview
// ruleID - The rule Id.
// workspaceID - The workspace Id.
// resourceID - The identifier of the resource.
// options - SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateOptions contains the optional parameters for the SQLVulnerabilityAssessmentBaselineRulesClient.CreateOrUpdate
// method.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) CreateOrUpdate(ctx context.Context, ruleID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateOptions) (SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, ruleID, workspaceID, resourceID, options)
	if err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) createOrUpdateCreateRequest(ctx context.Context, ruleID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}"
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("workspaceId", workspaceID)
	reqQP.Set("api-version", "2020-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		return req, runtime.MarshalAsJSON(req, *options.Body)
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) createOrUpdateHandleResponse(resp *http.Response) (SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateResponse, error) {
	result := SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RuleResults); err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes a rule from the Baseline of a given database.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-07-01-preview
// ruleID - The rule Id.
// workspaceID - The workspace Id.
// resourceID - The identifier of the resource.
// options - SQLVulnerabilityAssessmentBaselineRulesClientDeleteOptions contains the optional parameters for the SQLVulnerabilityAssessmentBaselineRulesClient.Delete
// method.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) Delete(ctx context.Context, ruleID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentBaselineRulesClientDeleteOptions) (SQLVulnerabilityAssessmentBaselineRulesClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, ruleID, workspaceID, resourceID, options)
	if err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return SQLVulnerabilityAssessmentBaselineRulesClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return SQLVulnerabilityAssessmentBaselineRulesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) deleteCreateRequest(ctx context.Context, ruleID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentBaselineRulesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}"
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("workspaceId", workspaceID)
	reqQP.Set("api-version", "2020-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets the results for a given rule in the Baseline.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-07-01-preview
// ruleID - The rule Id.
// workspaceID - The workspace Id.
// resourceID - The identifier of the resource.
// options - SQLVulnerabilityAssessmentBaselineRulesClientGetOptions contains the optional parameters for the SQLVulnerabilityAssessmentBaselineRulesClient.Get
// method.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) Get(ctx context.Context, ruleID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentBaselineRulesClientGetOptions) (SQLVulnerabilityAssessmentBaselineRulesClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, ruleID, workspaceID, resourceID, options)
	if err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLVulnerabilityAssessmentBaselineRulesClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) getCreateRequest(ctx context.Context, ruleID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentBaselineRulesClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}"
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("workspaceId", workspaceID)
	reqQP.Set("api-version", "2020-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) getHandleResponse(resp *http.Response) (SQLVulnerabilityAssessmentBaselineRulesClientGetResponse, error) {
	result := SQLVulnerabilityAssessmentBaselineRulesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RuleResults); err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientGetResponse{}, err
	}
	return result, nil
}

// List - Gets the results for all rules in the Baseline.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-07-01-preview
// workspaceID - The workspace Id.
// resourceID - The identifier of the resource.
// options - SQLVulnerabilityAssessmentBaselineRulesClientListOptions contains the optional parameters for the SQLVulnerabilityAssessmentBaselineRulesClient.List
// method.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) List(ctx context.Context, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentBaselineRulesClientListOptions) (SQLVulnerabilityAssessmentBaselineRulesClientListResponse, error) {
	req, err := client.listCreateRequest(ctx, workspaceID, resourceID, options)
	if err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientListResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientListResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLVulnerabilityAssessmentBaselineRulesClientListResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHandleResponse(resp)
}

// listCreateRequest creates the List request.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) listCreateRequest(ctx context.Context, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentBaselineRulesClientListOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("workspaceId", workspaceID)
	reqQP.Set("api-version", "2020-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SQLVulnerabilityAssessmentBaselineRulesClient) listHandleResponse(resp *http.Response) (SQLVulnerabilityAssessmentBaselineRulesClientListResponse, error) {
	result := SQLVulnerabilityAssessmentBaselineRulesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RulesResults); err != nil {
		return SQLVulnerabilityAssessmentBaselineRulesClientListResponse{}, err
	}
	return result, nil
}
