/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.impl;

import java.lang.invoke.CallSite;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AIPromptUtils {
    public static String[] describeDataSourceInfo(@Nullable DBSLogicalDataSource dataSource) {
        BasicSQLDialect dialect = dataSource == null ? BasicSQLDialect.INSTANCE : SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource.getDataSourceContainer().getDataSource());
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        if (dataSource != null) {
            String currentCatalog;
            String currentSchema;
            DBPDataSourceInfo dsInfo;
            DBPDataSource ds = dataSource.getDataSourceContainer().getDataSource();
            DBPDataSourceInfo dBPDataSourceInfo = dsInfo = ds == null ? null : ds.getInfo();
            if (dataSource.getDataSourceContainer() instanceof DataSourceDescriptor) {
                lines.add((CallSite)((Object)("DBeaver connection name: " + dataSource.getDataSourceContainer().getName())));
                DBPDriver driver = dataSource.getDataSourceContainer().getDriver();
                if (ds instanceof JDBCDataSource) {
                    lines.add((CallSite)((Object)("JDBC driver: " + dsInfo.getDriverName() + " (" + dsInfo.getDriverVersion() + ")")));
                } else {
                    lines.add((CallSite)((Object)("Java driver: " + driver.getFullName())));
                }
            }
            if (!CommonUtils.isEmpty((String)(currentSchema = dataSource.getCurrentSchema()))) {
                lines.add((CallSite)((Object)("Current " + (dsInfo == null ? "Schema" : dsInfo.getSchemaTerm()) + ": " + currentSchema)));
            }
            if (!CommonUtils.isEmpty((String)(currentCatalog = dataSource.getCurrentCatalog()))) {
                lines.add((CallSite)((Object)("Current " + (dsInfo == null ? "Catalog" : dsInfo.getCatalogTerm()) + ": " + currentCatalog)));
            }
        }
        lines.add((CallSite)((Object)("SQL dialect: " + dialect.getDialectName())));
        lines.add((CallSite)((Object)("Current date and time: " + DateTimeFormatter.ISO_DATE_TIME.format(ZonedDateTime.now()))));
        return (String[])lines.toArray(String[]::new);
    }

    public static String[] createDatabaseInstructions(@Nullable DBSLogicalDataSource dataSource) {
        String stringsQuoteRule;
        ArrayList<Object> instructions = new ArrayList<Object>();
        instructions.add("You are the DBeaver AI assistant.");
        instructions.add("Act as a database architect and SQL expert.");
        instructions.add("Rely only on the schema information provided below.");
        instructions.add("Stick strictly to SQL dialect syntax.");
        instructions.add("Do not invent columns, tables, or data that aren\u2019t explicitly defined.");
        String useLanguage = DBWorkbench.getPlatform().getPreferenceStore().getString("ai.language");
        if (!CommonUtils.isEmpty((String)useLanguage)) {
            instructions.add("Use " + useLanguage + " language in your responses.");
        } else {
            instructions.add("Use the same language as the user.");
        }
        BasicSQLDialect dialect = dataSource == null ? BasicSQLDialect.INSTANCE : SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource.getDataSourceContainer().getDataSource());
        String quoteRule = AIPromptUtils.identifiersQuoteRule((SQLDialect)dialect);
        if (quoteRule != null) {
            instructions.add(quoteRule);
        }
        if ((stringsQuoteRule = AIPromptUtils.stringsQuoteRule((SQLDialect)dialect)) != null) {
            instructions.add(stringsQuoteRule);
        }
        return instructions.toArray(new String[0]);
    }

    @Nullable
    private static String identifiersQuoteRule(SQLDialect dialect) {
        String[][] identifierQuoteStrings = dialect.getIdentifierQuoteStrings();
        if (identifierQuoteStrings == null || identifierQuoteStrings.length == 0) {
            return null;
        }
        return "Use " + identifierQuoteStrings[0][0] + identifierQuoteStrings[0][1] + " to quote identifiers if needed.";
    }

    private static String stringsQuoteRule(SQLDialect dialect) {
        String[][] stringQuoteStrings = dialect.getStringQuoteStrings();
        if (stringQuoteStrings.length == 0) {
            return null;
        }
        return "Use " + stringQuoteStrings[0][0] + stringQuoteStrings[0][1] + " to quote strings.";
    }
}

