/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLAttributeResolver;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContainerResolver;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLDataTypeResolver;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLEntityResolver;

public abstract class SQLContextTypeAbstract
extends TemplateContextType {
    protected SQLContextTypeAbstract(String id, String name) {
        super(id, name);
        this.addGlobalResolvers();
        this.addDatabaseProposals();
    }

    private void addGlobalResolvers() {
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
    }

    private void addDatabaseProposals() {
        this.addResolver(new SQLEntityResolver());
        this.addResolver(new SQLContainerResolver<DBSSchema>("schema", "Schema", DBSSchema.class));
        this.addResolver(new SQLContainerResolver<DBSCatalog>("catalog", "Catalog", DBSCatalog.class));
        this.addResolver(new SQLAttributeResolver());
        this.addResolver(new SQLDataTypeResolver());
    }

    public String toString() {
        return this.getId() + " [" + this.getName() + "]";
    }

    public int hashCode() {
        return this.getId().hashCode() + this.getName().hashCode();
    }
}

