/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class SQLServerDatabaseManager
extends SQLObjectEditor<SQLServerDatabase, SQLServerDataSource>
implements DBEObjectRenamer<SQLServerDatabase> {
    public boolean canCreateObject(@NotNull Object container) {
        return true;
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull SQLServerDatabase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected SQLServerDatabase createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return new SQLServerDatabase((SQLServerDataSource)((Object)container));
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create database", "CREATE DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + ";"));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        if (CommonUtils.getOption(options, (String)"closeExistingConnections")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop database connections", "ALTER DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " SET SINGLE_USER WITH ROLLBACK IMMEDIATE;"));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop database", "DROP DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + ";"));
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        SQLServerDataSource source = ((SQLServerDatabase)command.getObject()).getDataSource();
        String oldName = DBUtils.getQuotedIdentifier((DBPDataSource)source, (String)command.getOldName());
        String newName = DBUtils.getQuotedIdentifier((DBPDataSource)source, (String)command.getNewName());
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename database", "ALTER DATABASE " + oldName + " MODIFY NAME = " + newName + ";"));
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 33L;
    }

    public DBSObjectCache<? extends DBSObject, SQLServerDatabase> getObjectsCache(SQLServerDatabase object) {
        return object.getDataSource().getDatabaseCache();
    }
}

