/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DBNDatabaseItem
extends DBNDatabaseNode {
    private final DBXTreeNode meta;
    private DBSObject object;

    DBNDatabaseItem(@NotNull DBNNode parent, @NotNull DBXTreeNode meta, DBSObject object, boolean reflect) {
        super(parent);
        this.meta = meta;
        this.object = object;
        this.registerNode();
    }

    @Override
    public boolean isDisposed() {
        return this.object == null || super.isDisposed();
    }

    @Override
    protected void dispose(boolean reflect) {
        this.unregisterNode(reflect);
        this.object = null;
        super.dispose(reflect);
    }

    @Override
    public boolean isDynamicStructObject() {
        DBNDatabaseFolder folder;
        DBNNode dBNNode = this.parentNode;
        return dBNNode instanceof DBNDatabaseFolder && (folder = (DBNDatabaseFolder)dBNNode).isDynamicStructObject();
    }

    @Override
    @NotNull
    public DBXTreeNode getMeta() {
        return this.meta;
    }

    @Override
    protected boolean reloadObject(DBRProgressMonitor monitor, DBSObject newObject) {
        if (this.object == newObject) {
            return false;
        }
        this.unregisterNode(false);
        this.object = newObject;
        this.registerNode();
        return true;
    }

    @Override
    @Nullable
    public DBSObject getObject() {
        return this.object;
    }

    @Override
    public Object getValueObject() {
        return this.object;
    }

    @Override
    public boolean isPersisted() {
        return this.object != null && this.object.isPersisted();
    }

    @Override
    public final boolean isManageable() {
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return this.object == null ? super.toString() : this.object.toString();
    }
}

