from astropy.constants import Constant

# Rotational_period_ refers to the sidereal period, relative to the stars it's the time it takes for a planet to complete one orbit.
rotational_period_earth = Constant(
    "rotational_period_earth",
    "Earth rotational period",
    0.9972698,
    "d",
    0,
    "Vallado, D. and McClain, W. Fundamentals of astrodynamics and applications.",
    system="si",
)

rotational_period_sun = Constant(
    "rotational_period_sun",
    "Sun rotational period",
    25.38,
    "d",
    0,
    "Vallado, D. and McClain, W. Fundamentals of astrodynamics and applications.",
    system="si",
)

rotational_period_mercury = Constant(
    "rotational_period_mercury",
    "Mercury rotational period",
    58.6462,
    "d",
    0,
    "Vallado, D. and McClain, W. Fundamentals of astrodynamics and applications.",
    system="si",
)

rotational_period_venus = Constant(
    "rotational_period_venus",
    "Venus rotational period",
    -243.01,
    "d",
    0,
    "",
    system="si",
)

rotational_period_moon = Constant(
    "rotational_period_moon",
    "Moon rotational period",
    27.32166,
    "d",
    0,
    "Vallado, D. and McClain, W. Fundamentals of astrodynamics and applications.",
    system="si",
)

rotational_period_mars = Constant(
    "rotational_period_mars",
    "Mars rotational period",
    1.02595675,
    "d",
    0,
    "Vallado, D. and McClain, W. Fundamentals of astrodynamics and applications.",
    system="si",
)

rotational_period_jupiter = Constant(
    "rotational_period_jupiter",
    "Jupiter rotational period",
    0.41354,
    "d",
    0,
    "Vallado, D. and McClain, W. Fundamentals of astrodynamics and applications.",
    system="si",
)

rotational_period_saturn = Constant(
    "rotational_period_saturn",
    "Saturn rotational period",
    0.4375,
    "d",
    0,
    "Vallado, D. and McClain, W. Fundamentals of astrodynamics and applications.",
    system="si",
)

rotational_period_uranus = Constant(
    "rotational_period_uranus",
    "Uranus rotational period",
    -0.65,
    "d",
    0,
    "Vallado, D. and McClain, W. Fundamentals of astrodynamics and applications.",
    system="si",
)

rotational_period_neptune = Constant(
    "rotational_period_neptune",
    "Neptune rotational period",
    0.768,
    "d",
    0,
    "",
    system="si",
)

rotational_period_pluto = Constant(
    "rotational_period_pluto",
    "Pluto rotational period",
    -6.3867,
    "d",
    0,
    "Vallado, D. and McClain, W. Fundamentals of astrodynamics and applications.",
    system="si",
)
