"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _codemirror = require("@neo4j-cypher/codemirror");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class CypherEditor extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "setEditorRef", ref => {
      this.editorRef = ref;
    });
    (0, _defineProperty2.default)(this, "valueChanged", (value, changes) => {
      this.lastValue = value;
      const {
        onValueChanged
      } = this.props;
      onValueChanged && onValueChanged(value, changes);
    });
    (0, _defineProperty2.default)(this, "focusChanged", focused => {
      const {
        onFocusChanged
      } = this.props;
      this.setState({
        focused
      });
      onFocusChanged && onFocusChanged(focused);
    });
    (0, _defineProperty2.default)(this, "scrollChanged", scrollInfo => {
      const {
        onScrollChanged
      } = this.props;
      onScrollChanged && onScrollChanged(scrollInfo);
    });
    (0, _defineProperty2.default)(this, "positionChanged", positionObject => {
      this.lastPosition = (positionObject || {
        position: null
      }).position;
      const {
        onPositionChanged
      } = this.props;
      onPositionChanged && onPositionChanged(positionObject);
    });
    (0, _defineProperty2.default)(this, "selectionChanged", selection => {
      this.lastSelection = selection;
      const {
        onSelectionChanged
      } = this.props;
      onSelectionChanged && onSelectionChanged(selection);
    });
    (0, _defineProperty2.default)(this, "autocompleteChanged", (autocompleteOpen, options, option) => {
      const {
        onAutocompleteChanged
      } = this.props;
      onAutocompleteChanged && onAutocompleteChanged(autocompleteOpen, options, option);
    });
    (0, _defineProperty2.default)(this, "searchChanged", (searchOpen, text, matches) => {
      const {
        onSearchChanged
      } = this.props;
      onSearchChanged && onSearchChanged(searchOpen, text, matches);
    });
    (0, _defineProperty2.default)(this, "lineNumberClick", (line, event) => {
      const {
        onLineNumberClick
      } = this.props;
      onLineNumberClick && onLineNumberClick(line, event);
    });
    (0, _defineProperty2.default)(this, "keyDown", event => {
      const {
        onKeyDown
      } = this.props;
      onKeyDown && onKeyDown(event);
    });
    (0, _defineProperty2.default)(this, "keyUp", event => {
      const {
        onKeyUp
      } = this.props;
      onKeyUp && onKeyUp(event);
    });
    this.state = {
      focused: false
    };
    this.lastValue = null;
    this.lastPosition = null;
    this.lastSelection = null;
  }
  componentDidMount() {
    const {
      autocomplete,
      autocompleteCloseOnBlur,
      autocompleteOpen,
      autocompleteTriggerStrings,
      autofocus,
      bracketMatching,
      closeBrackets,
      cursorWide,
      cypherLanguage,
      history,
      indentUnit,
      lineNumberFormatter,
      lineNumbers,
      lineWrapping,
      lint,
      placeholder,
      position,
      readOnly,
      readOnlyCursor,
      schema,
      search,
      searchMatches,
      searchOpen,
      searchText,
      searchTop,
      selection,
      tabKey,
      theme,
      tooltipAbsolute,
      parseOnSetValue,
      value,
      onEditorCreated,
      preExtensions,
      postExtensions
    } = this.props;
    this.value = value;
    const {
      editor
    } = (0, _codemirror.createCypherEditor)(this.editorRef, {
      autocomplete,
      autocompleteCloseOnBlur,
      autocompleteOpen,
      autocompleteTriggerStrings,
      autofocus,
      bracketMatching,
      closeBrackets,
      cursorWide,
      cypherLanguage,
      history,
      indentUnit,
      lineNumberFormatter,
      lineNumbers,
      lineWrapping,
      lint,
      placeholder,
      position,
      readOnly,
      readOnlyCursor,
      schema,
      search,
      searchMatches,
      searchOpen,
      searchText,
      searchTop,
      selection,
      tabKey,
      theme,
      tooltipAbsolute,
      parseOnSetValue,
      value,
      preExtensions,
      postExtensions
    });
    this.cypherEditor = editor;
    this.cypherEditor.onValueChanged(this.valueChanged);
    this.cypherEditor.onFocusChanged(this.focusChanged);
    this.cypherEditor.onScrollChanged(this.scrollChanged);
    this.cypherEditor.onPositionChanged(this.positionChanged);
    this.cypherEditor.onSelectionChanged(this.selectionChanged);
    this.cypherEditor.onAutocompleteChanged(this.autocompleteChanged);
    this.cypherEditor.onSearchChanged(this.searchChanged);
    this.cypherEditor.onLineNumberClick(this.lineNumberClick);
    this.cypherEditor.onKeyDown(this.keyDown);
    this.cypherEditor.onKeyUp(this.keyUp);
    onEditorCreated && onEditorCreated(this.cypherEditor);
  }
  componentWillUnmount() {
    if (this.cypherEditor) {
      this.cypherEditor.offValueChanged(this.valueChanged);
      this.cypherEditor.offFocusChanged(this.focusChanged);
      this.cypherEditor.offScrollChanged(this.scrollChanged);
      this.cypherEditor.offPositionChanged(this.positionChanged);
      this.cypherEditor.offSelectionChanged(this.selectionChanged);
      this.cypherEditor.offAutocompleteChanged(this.autocompleteChanged);
      this.cypherEditor.offSearchChanged(this.searchChanged);
      this.cypherEditor.offLineNumberClick(this.lineNumberClick);
      this.cypherEditor.offKeyDown(this.keyDown);
      this.cypherEditor.offKeyUp(this.keyUp);
      this.cypherEditor.destroy();
    }
  }
  componentDidUpdate(prevProps) {
    if (prevProps.value !== this.props.value) {
      this.value = this.props.value;
    }
    for (let key of _codemirror.reactiveOptionKeys) {
      if (prevProps[key] !== this.props[key]) {
        this.updateOption({
          [key]: this.props[key]
        });
      }
    }
  }
  updateOption(prop) {
    if (!this.cypherEditor) {
      return;
    }
    const key = Object.keys(prop).pop();
    if (key === "value") {
      if (prop[key] === this.lastValue) {
        return;
      } else {
        this.lastValue = prop[key];
      }
    }
    if (key === "position") {
      const {
        position
      } = this.cypherEditor.getPositionForValue(prop[key]) || {
        position: null
      };
      if (position === this.lastPosition) {
        return;
      } else {
        this.lastPosition = position;
      }
    }
    if (key === "selection") {
      if (prop[key] === this.lastSelection) {
        return;
      } else {
        this.lastSelection = prop[key];
      }
    }
    const methodName = "set" + key[0].toUpperCase() + key.slice(1);
    if (this.cypherEditor[methodName]) {
      this.cypherEditor[methodName](prop[key]);
    }
    const autofocusProps = this.props.autofocusProps !== undefined ? this.props.autofocusProps : _codemirror.defaultOptions.autofocusProps;
    if (autofocusProps.includes(key)) {
      this.cypherEditor.focus();
    }
    const clearHistoryProps = this.props.clearHistoryProps !== undefined ? this.props.clearHistoryProps : _codemirror.defaultOptions.clearHistoryProps;
    if (clearHistoryProps.includes(key)) {
      this.cypherEditor.clearHistory();
    }
  }
  render() {
    const {
      className,
      focusedClassName,
      style
    } = this.props;
    const {
      focused
    } = this.state;
    const editorClassName = (className ? className + " " : "") + (focused && focusedClassName ? focusedClassName : "");
    return /*#__PURE__*/(0, _jsxRuntime.jsx)("div", {
      className: editorClassName,
      style: style,
      ref: this.setEditorRef
    });
  }
}
var _default = CypherEditor;
exports.default = _default;