#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 BetaRays
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Life is Strange
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240911.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='life-is-strange'
GAME_NAME='Life is Strange'

ARCHIVE_BASE_0_NAME='setup_life_is_strange_complete_season_1.0.0.397609_(38128).exe'
ARCHIVE_BASE_0_MD5='11f65230b6545f95707824b6405da34f'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_life_is_strange_complete_season_1.0.0.397609_(38128)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='1ab68855e24ceebc9c138ad73ccccb6e'
ARCHIVE_BASE_0_PART2_NAME='setup_life_is_strange_complete_season_1.0.0.397609_(38128)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='e385f4858df5bcb30716ec1a8727480e'
ARCHIVE_BASE_0_PART3_NAME='setup_life_is_strange_complete_season_1.0.0.397609_(38128)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='c8613d8029c6a3b65d796fc09a9a5974'
ARCHIVE_BASE_0_PART4_NAME='setup_life_is_strange_complete_season_1.0.0.397609_(38128)-4.bin'
ARCHIVE_BASE_0_PART4_MD5='f7c905b4f21dc34e58ab8b68a8e96f48'
ARCHIVE_BASE_0_SIZE='15000000'
ARCHIVE_BASE_0_VERSION='1.0.0.397609-gog38128'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/life_is_strange_complete_season'

## Patched library, working around a crash on launch
## cf. https://www.gog.com/forum/life_is_strange_series/wont_launch_possible_fix/post32
ARCHIVE_REQUIRED_FIXED_DLL_NAME='common.dll'
ARCHIVE_REQUIRED_FIXED_DLL_MD5='4aea8c8d98053a925d9b41e604567889'
ARCHIVE_REQUIRED_FIXED_DLL_URL='https://downloads.dotslashplay.it/games/life-is-strange/'

UNREALENGINE4_NAME='lifeisstrangegame'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME0_BIN_PATH='app'
CONTENT_GAME0_BIN_PATH='
engine'
CONTENT_GAME_EPISODE2_FILES='
lifeisstrangegame/build/pcconsole/dlc/episode02'
CONTENT_GAME_EPISODE3_FILES='
lifeisstrangegame/build/pcconsole/dlc/episode03'
CONTENT_GAME_EPISODE4_FILES='
lifeisstrangegame/build/pcconsole/dlc/episode04'
CONTENT_GAME_EPISODE5_FILES='
lifeisstrangegame/build/pcconsole/dlc/episode05'
CONTENT_GAME_EXTRA_FILES='
lifeisstrangegame/build/pcconsole/dlc/extra01'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/My Games/Life is Strange'

APP_MAIN_EXE='binaries/win32/lifeisstrange.exe'

PACKAGES_LIST='
PKG_BIN
PKG_EPISODE2
PKG_EPISODE3
PKG_EPISODE4
PKG_EPISODE5
PKG_EXTRA
PKG_DATA'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_EPISODE2_ID="${GAME_ID}-episode-2"
PKG_EPISODE2_DESCRIPTION='Episode 2'
PKG_EPISODE2_DEPENDENCIES_SIBLINGS='
PKG_BIN'

PKG_EPISODE3_ID="${GAME_ID}-episode-3"
PKG_EPISODE3_DESCRIPTION='Episode 3'
PKG_EPISODE3_DEPENDENCIES_SIBLINGS='
PKG_BIN'

PKG_EPISODE4_ID="${GAME_ID}-episode-4"
PKG_EPISODE4_DESCRIPTION='Episode 4'
PKG_EPISODE4_DEPENDENCIES_SIBLINGS='
PKG_BIN'

PKG_EPISODE5_ID="${GAME_ID}-episode-5"
PKG_EPISODE5_DESCRIPTION='Episode 5'
PKG_EPISODE5_DEPENDENCIES_SIBLINGS='
PKG_BIN'

PKG_EXTRA_ID="${GAME_ID}-extra"
PKG_EXTRA_DESCRIPTION='Extra'
PKG_EXTRA_DEPENDENCIES_SIBLINGS='
PKG_BIN'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Check for the presence of extra required archives

archive_initialize_required \
	'ARCHIVE_FIXED_DLL' \
	'ARCHIVE_REQUIRED_FIXED_DLL'

# Extract game data

archive_extraction_default

# Include game icons

content_inclusion_icons 'PKG_DATA'
content_inclusion_default
install -D --mode=644 \
	"$(archive_path 'ARCHIVE_FIXED_DLL')" \
	"$(package_path 'PKG_BIN')$(path_game_data)/binaries/win32/common.dll"

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
