/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { TranslatedString } from "@gnu-taler/taler-util";
import * as tests from "../../tests/hook.js";
import { DefaultForm as TestedComponent } from "../forms-ui.js";
import { FormDesign, UIHandlerId } from "../forms-types.js";

export default {
  title: "Input Array",
};

export namespace Simplest {
  export interface Form {
    comment: string;
  }
}

type TargetObject = {
  people: {
    name: string;
    age: number;
  }[];
};
const initial: TargetObject = {
  people: [
    {
      name: "me",
      age: 17,
    },
  ],
};

const design: FormDesign = {
  type: "double-column",
  sections: [
    {
      title: "this is a simple form" as TranslatedString,
      description: "to test how arrays are used" as TranslatedString,
      fields: [
        {
          type: "array",
          label: "People" as TranslatedString,
          fields: [
            {
              id: "name",
              type: "text",
              required: true,
              label: "Name" as TranslatedString,
            },
            {
              id: "age",
              type: "integer",
              required: true,
              label: "Age" as TranslatedString,
            },
          ],
          id: "people",
          labelFieldId: "name",
        },
      ],
    },
  ],
};

export const FormWithArray = tests.createExample(TestedComponent, {
  initial,
  design,
});

const initial2: any = {};

const design2: FormDesign = {
  type: "double-column",
  sections: [
    {
      title: "Personal information" as TranslatedString,
      fields: [
        {
          type: "text",
          id: "AGE",
          label: "Full name",
          required: true,
        },
      ],
    },
    {
      title: "Representatives" as TranslatedString,
      fields: [
        {
          type: "array",
          id: "BUSINESS_LEGAL_REPRESENTATIVES",
          labelFieldId: "PERSON_FULL_NAME",
          label:
            "List of natural persons that are legal representatives or shareholders",
          fields: [
            {
              type: "text",
              id: "PERSON_FULL_NAME",
              label: "Name",
              required: true,
            },
            {
              type: "text",
              id: "PERSON_DATE_OF_BIRTH",
              label: "Date of birth",
              required: true,
            },
          ],
        },
      ],
    },
  ],
};

export const NonMixingProperties = tests.createExample(TestedComponent, {
  initial: initial2,
  design: design2,
});

const initial3: any = {
  list: [{ steps: ["asd"] }],
};

const design3: FormDesign = {
  type: "single-column",
  fields: [
    {
      type: "array",
      id: "list",
      label: `Paths`,
      help: `For every entry the customer will have a different path to satisfy checks.`,
      labelFieldId: "steps",
      fields: [
        {
          type: "selectMultiple",
          choices: ["asd", "qwe", "zxc"].map((m) => {
            return {
              value: m,
              label: m,
            };
          }),
          id: "steps",
          label: `Steps`,
          help: `The checks that the customer will need to satisfy for this path.`,
        },
      ],
    },
  ],
};

export const ArrayOfSelect = tests.createExample(TestedComponent, {
  initial: initial3,
  design: design3,
});
