;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2012-2023 Ludovic Courtès <ludo@gnu.org>
;;; Copyright © 2013,2014 Mark H Weaver <mhw@netris.org>
;;; Copyright © 2014 Taylan Ulrich Bayırlı/Kammer <taylanbayirli@gmail.com>
;;; Copyright © 2015 David Thompson <davet@gnu.org>
;;; Copyright © 2016 Hartmut Goebel <h.goebel@crazy-compilers.com>
;;; Copyright © 2017 Alex Kost <alezost@gmail.com>
;;; Copyright © 2018-2020 Caleb Ristvedt <caleb.ristvedt@cune.org>
;;; Copyright © 2020-2023, 2025 Maxim Cournoyer <maxim@guixotic.coop>
;;; Copyright © 2020 Miguel Ángel Arruga Vivas <rosen644835@gmail.com>
;;; Copyright © 2020 Christine Lemmer-Webber <cwebber@dustycloud.org>
;;; Copyright © 2022 Liliana Marie Prikler <liliana.prikler@gmail.com>
;;; Copyright © 2022 Andrew Tropin <andrew@trop.in>
;;; Copyright © 2022 Brian Cully <bjc@kublai.com>
;;; Copyright © 2023 (unmatched-parenthesis <paren@disroot.org>
;;; Copyright © 2024 Christopher Baines <mail@cbaines.net>
;;; Copyright © 2024 Tomas Volf <~@wolfsden.cz>
;;; Copyright © 2024 Nicolas Graves <ngraves@ngraves.fr>
;;; Copyright © 2025 David Elsing <david.elsing@posteo.net>
;;; Copyright © 2025 Hilton Chain <hako@ultrarare.space>
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

;; Per-directory local variables for GNU Emacs 23 and later.
((nil
  . ((fill-column . 78)
     (tab-width   .  8)
     (sentence-end-double-space . t)

     ;; For use with 'bug-reference-prog-mode'.  Extra bug-reference
     ;; configuration should be done in your Emacs user configuration file;
     ;; refer to (info (guix) The Perfect Setup).
     (bug-reference-bug-regexp
      . "\\(<https?://\\bugs\\.gnu\\.org/\\([0-9]+\\)>\\)")
     (bug-reference-url-format . "https://issues.guix.gnu.org/%s")

     (eval . (add-to-list 'completion-ignored-extensions ".go"))

     ;; Emacs-Guix
     (eval . (setq-local guix-directory
                         (locate-dominating-file default-directory
                                                 ".dir-locals.el")))
     ;; Magit
     (eval . (with-eval-after-load 'git-commit
               (add-to-list 'git-commit-trailers "Change-Id")))

     ;; TempEl
     (eval . (with-eval-after-load
                 'tempel
               (if (stringp tempel-path)
                   (setq tempel-path (list tempel-path)))
               (let ((guix-tempel-snippets
                      (concat
                       (expand-file-name
                        "etc/snippets/tempel"
                        (locate-dominating-file default-directory
                                                ".dir-locals.el"))
                       "/*.eld")))
                 (unless (member guix-tempel-snippets tempel-path)
                   (add-to-list 'tempel-path guix-tempel-snippets)))))

     ;; YASnippet
     (eval . (with-eval-after-load
                 'yasnippet
               (let ((guix-yasnippets
                      (expand-file-name
                       "etc/snippets/yas"
                       (locate-dominating-file default-directory
                                               ".dir-locals.el"))))
                 (unless (member guix-yasnippets yas-snippet-dirs)
                   (add-to-list 'yas-snippet-dirs guix-yasnippets)
                   (yas-reload-all)))))

     ;; Geiser
     ;; This allows automatically setting the `geiser-guile-load-path'
     ;; variable when using various Guix checkouts (e.g., via git worktrees).
     (geiser-repl-per-project-p . t)
     (geiser-insert-actual-lambda . nil)))

 (c-mode          . ((c-file-style . "gnu")))
 (emacs-lisp-mode . ((indent-tabs-mode . nil)))
 (texinfo-mode    . ((indent-tabs-mode . nil)
                     (fill-column . 72)))
 (scheme-mode
  .
  ((indent-tabs-mode . nil)

   ;; Emacs 28 changed the behavior of 'lisp-fill-paragraph', which causes the
   ;; first line of package descriptions to extrude past 'fill-column'. The
   ;; following variable reverts its behavior to the previous one.
   (lisp-fill-paragraphs-as-doc-string nil)

   ;; This notably allows '(' in Paredit to not insert a space when the
   ;; preceding symbol is one of these.
   (eval . (modify-syntax-entry ?~ "'"))
   (eval . (modify-syntax-entry ?$ "'"))
   (eval . (modify-syntax-entry ?+ "'"))

   (eval . (put 'eval-when 'scheme-indent-function 1))
   (eval . (put 'call-with-prompt 'scheme-indent-function 1))
   (eval . (put 'test-assert 'scheme-indent-function 1))
   (eval . (put 'test-assertm 'scheme-indent-function 1))
   (eval . (put 'test-equalm 'scheme-indent-function 1))
   (eval . (put 'test-equal 'scheme-indent-function 1))
   (eval . (put 'test-eq 'scheme-indent-function 1))
   (eval . (put 'call-with-input-string 'scheme-indent-function 1))
   (eval . (put 'call-with-port 'scheme-indent-function 1))
   (eval . (put 'guard 'scheme-indent-function 1))
   (eval . (put 'lambda* 'scheme-indent-function 1))
   (eval . (put 'peekable-lambda 'scheme-indent-function 1))
   (eval . (put 'substitute* 'scheme-indent-function 1))
   (eval . (put 'match-record 'scheme-indent-function 3))
   (eval . (put 'match-record-lambda 'scheme-indent-function 2))

   ;; TODO: Contribute these to Emacs' scheme-mode.
   (eval . (put 'let-keywords 'scheme-indent-function 3))

   ;; 'modify-inputs' and its keywords.
   (eval . (put 'modify-inputs 'scheme-indent-function 1))
   (eval . (put 'replace 'scheme-indent-function 1))

   ;; 'modify-phases' and its keywords.
   (eval . (put 'modify-phases 'scheme-indent-function 1))
   (eval . (put 'replace 'scheme-indent-function 1))
   (eval . (put 'add-before 'scheme-indent-function 2))
   (eval . (put 'add-after 'scheme-indent-function 2))

   (eval . (put 'modify-services 'scheme-indent-function 1))
   (eval . (put 'with-directory-excursion 'scheme-indent-function 1))
   (eval . (put 'with-file-lock 'scheme-indent-function 1))
   (eval . (put 'with-file-lock/no-wait 'scheme-indent-function 1))
   (eval . (put 'with-profile-lock 'scheme-indent-function 1))
   (eval . (put 'with-writable-file 'scheme-indent-function 2))

   (eval . (put 'package/inherit 'scheme-indent-function 1))
   (eval . (put 'substitute-keyword-arguments 'scheme-indent-function 1))
   (eval . (put 'with-store 'scheme-indent-function 1))
   (eval . (put 'with-store/non-blocking 'scheme-indent-function 1))
   (eval . (put 'with-external-store 'scheme-indent-function 1))
   (eval . (put 'with-error-handling 'scheme-indent-function 0))
   (eval . (put 'with-mutex 'scheme-indent-function 1))
   (eval . (put 'with-atomic-file-output 'scheme-indent-function 1))
   (eval . (put 'call-with-compressed-output-port 'scheme-indent-function 2))
   (eval . (put 'call-with-decompressed-port 'scheme-indent-function 2))
   (eval . (put 'call-with-gzip-input-port 'scheme-indent-function 1))
   (eval . (put 'call-with-gzip-output-port 'scheme-indent-function 1))
   (eval . (put 'call-with-lzip-input-port 'scheme-indent-function 1))
   (eval . (put 'call-with-lzip-output-port 'scheme-indent-function 1))
   (eval . (put 'signature-case 'scheme-indent-function 1))
   (eval . (put 'emacs-batch-eval 'scheme-indent-function 0))
   (eval . (put 'emacs-batch-edit-file 'scheme-indent-function 1))
   (eval . (put 'emacs-substitute-sexps 'scheme-indent-function 1))
   (eval . (put 'emacs-substitute-variables 'scheme-indent-function 1))
   (eval . (put 'with-derivation-narinfo 'scheme-indent-function 1))
   (eval . (put 'with-derivation-substitute 'scheme-indent-function 2))
   (eval . (put 'with-status-report 'scheme-indent-function 1))
   (eval . (put 'with-status-verbosity 'scheme-indent-function 1))
   (eval . (put 'with-build-handler 'scheme-indent-function 1))

   (eval . (put 'mlambda 'scheme-indent-function 1))
   (eval . (put 'mlambdaq 'scheme-indent-function 1))
   (eval . (put 'syntax-parameterize 'scheme-indent-function 1))
   (eval . (put 'with-monad 'scheme-indent-function 1))
   (eval . (put 'mbegin 'scheme-indent-function 1))
   (eval . (put 'mwhen 'scheme-indent-function 1))
   (eval . (put 'munless 'scheme-indent-function 1))
   (eval . (put 'mlet* 'scheme-indent-function 2))
   (eval . (put 'mlet 'scheme-indent-function 2))
   (eval . (put 'state-parameterize 'scheme-indent-function 2))
   (eval . (put 'store-parameterize 'scheme-indent-function 2))
   (eval . (put 'run-with-store 'scheme-indent-function 1))
   (eval . (put 'run-with-state 'scheme-indent-function 1))
   (eval . (put 'wrap-program 'scheme-indent-function 1))
   (eval . (put 'wrap-script 'scheme-indent-function 1))
   (eval . (put 'with-imported-modules 'scheme-indent-function 1))
   (eval . (put 'with-extensions 'scheme-indent-function 1))
   (eval . (put 'with-parameters 'scheme-indent-function 1))
   (eval . (put 'let-system 'scheme-indent-function 1))
   (eval . (put 'with-build-variables 'scheme-indent-function 2))

   (eval . (put 'with-database 'scheme-indent-function 2))
   (eval . (put 'call-with-database 'scheme-indent-function 1))
   (eval . (put 'call-with-transaction 'scheme-indent-function 1))
   (eval . (put 'call-with-retrying-transaction 'scheme-indent-function 1))

   (eval . (put 'call-with-container 'scheme-indent-function 1))
   (eval . (put 'container-excursion 'scheme-indent-function 1))
   (eval . (put 'eventually 'scheme-indent-function 1))

   (eval . (put 'call-with-progress-reporter 'scheme-indent-function 1))
   (eval . (put 'with-repository 'scheme-indent-function 2))
   (eval . (put 'with-temporary-git-repository 'scheme-indent-function 2))
   (eval . (put 'with-served-git-repository 'scheme-indent-function 2))
   (eval . (put 'with-environment-variables 'scheme-indent-function 1))
   (eval . (put 'with-fresh-gnupg-setup 'scheme-indent-function 1))

   (eval . (put 'with-paginated-output-port 'scheme-indent-function 1))

   (eval . (put 'with-shepherd-action 'scheme-indent-function 3))

   (eval . (put 'with-http-server 'scheme-indent-function 1))

   ;; Record constructors.
   ;; URIs for origin methods.
   (eval . (put 'android-repo-reference 'scheme-indent-function 0))
   (eval . (put 'bzr-reference 'scheme-indent-function 0))
   (eval . (put 'cvs-reference 'scheme-indent-function 0))
   (eval . (put 'git-checkout 'scheme-indent-function 0))
   (eval . (put 'git-reference 'scheme-indent-function 0))
   (eval . (put 'hg-reference 'scheme-indent-function 0))
   (eval . (put 'svn-multi-reference 'scheme-indent-function 0))
   (eval . (put 'svn-reference 'scheme-indent-function 0))

   ;; guix/
   (eval . (put 'avahi-service 'scheme-indent-function 0))
   (eval . (put 'bag 'scheme-indent-function 0))
   (eval . (put 'build-status 'scheme-indent-function 0))
   (eval . (put 'build-system 'scheme-indent-function 0))
   (eval . (put 'channel 'scheme-indent-function 0))
   (eval . (put 'gnu-package-descriptor 'scheme-indent-function 0))
   (eval . (put 'graft 'scheme-indent-function 0))
   (eval . (put 'lint-checker 'scheme-indent-function 0))
   (eval . (put 'lint-warning 'scheme-indent-function 0))
   (eval . (put 'manifest-entry 'scheme-indent-function 0))
   (eval . (put 'manifest-pattern 'scheme-indent-function 0))
   (eval . (put 'manifest-transaction 'scheme-indent-function 0))
   (eval . (put 'node-type 'scheme-indent-function 0))
   (eval . (put 'origin 'scheme-indent-function 0))
   (eval . (put 'package 'scheme-indent-function 0))
   (eval . (put 'platform 'scheme-indent-function 0))
   (eval . (put 'profile 'scheme-indent-function 0))
   (eval . (put 'progress-reporter 'scheme-indent-function 0))
   (eval . (put 'search-path-specification 'scheme-indent-function 0))
   (eval . (put 'upstream-input 'scheme-indent-function 0))
   (eval . (put 'upstream-source 'scheme-indent-function 0))
   (eval . (put 'upstream-updater 'scheme-indent-function 0))

   ;; gnu/
   (eval . (put 'bootloader 'scheme-indent-function 0))
   (eval . (put 'bootloader-configuration 'scheme-indent-function 0))
   (eval . (put 'image 'scheme-indent-function 0))
   (eval . (put 'image-type 'scheme-indent-function 0))
   (eval . (put 'menu-entry 'scheme-indent-function 0))
   (eval . (put 'partition 'scheme-indent-function 0))

   ;; gnu/machine
   (eval . (put 'digital-ocean-configuration 'scheme-indent-function 0))
   (eval . (put 'environment-type 'scheme-indent-function 0))
   (eval . (put 'hetzner-configuration 'scheme-indent-function 0))
   (eval . (put 'machine 'scheme-indent-function 0))
   (eval . (put 'machine-ssh-configuration 'scheme-indent-function 0))

   ;; gnu/system
   (eval . (put 'boot-parameters 'scheme-indent-function 0))
   (eval . (put 'file-system 'scheme-indent-function 0))
   (eval . (put 'file-system-mapping 'scheme-indent-function 0))
   (eval . (put 'locale-definition 'scheme-indent-function 0))
   (eval . (put 'mapped-device 'scheme-indent-function 0))
   (eval . (put 'mapped-device-kind 'scheme-indent-function 0))
   (eval . (put 'name-service 'scheme-indent-function 0))
   (eval . (put 'name-service-switch 'scheme-indent-function 0))
   (eval . (put 'operating-system 'scheme-indent-function 0))
   (eval . (put 'pam-configuration 'scheme-indent-function 0))
   (eval . (put 'pam-entry 'scheme-indent-function 0))
   (eval . (put 'pam-extension 'scheme-indent-function 0))
   (eval . (put 'pam-service 'scheme-indent-function 0))
   (eval . (put 'privileged-program 'scheme-indent-function 0))
   (eval . (put 'subid-range 'scheme-indent-function 0))
   (eval . (put 'subids-configuration 'scheme-indent-function 0))
   (eval . (put 'subids-extension 'scheme-indent-function 0))
   (eval . (put 'swap-space 'scheme-indent-function 0))
   (eval . (put 'user-account 'scheme-indent-function 0))
   (eval . (put 'user-group 'scheme-indent-function 0))
   (eval . (put 'virtual-machine 'scheme-indent-function 0))

   ;; gnu/home
   (eval . (put 'home-bash-configuration 'scheme-indent-function 0))
   (eval . (put 'home-bash-extension 'scheme-indent-function 0))
   (eval . (put 'home-batsignal-configuration 'scheme-indent-function 0))
   (eval . (put 'home-beets-configuration 'scheme-indent-function 0))
   (eval . (put 'home-dbus-configuration 'scheme-indent-function 0))
   (eval . (put 'home-dotfiles-configuration 'scheme-indent-function 0))
   (eval . (put 'home-environment 'scheme-indent-function 0))
   (eval . (put 'home-fish-configuration 'scheme-indent-function 0))
   (eval . (put 'home-fish-extension 'scheme-indent-function 0))
   (eval . (put 'home-gpg-agent-configuration 'scheme-indent-function 0))
   (eval . (put 'home-inputrc-configuration 'scheme-indent-function 0))
   (eval . (put 'home-kodi-configuration 'scheme-indent-function 0))
   (eval . (put 'home-mcron-configuration 'scheme-indent-function 0))
   (eval . (put 'home-msmtp-configuration 'scheme-indent-function 0))
   (eval . (put 'home-openssh-configuration 'scheme-indent-function 0))
   (eval . (put 'home-parcimonie-configuration 'scheme-indent-function 0))
   (eval . (put 'home-pipewire-configuration 'scheme-indent-function 0))
   (eval . (put 'home-redshift-configuration 'scheme-indent-function 0))
   (eval . (put 'home-shell-profile-configuration 'scheme-indent-function 0))
   (eval . (put 'home-shepherd-configuration 'scheme-indent-function 0))
   (eval . (put 'home-ssh-agent-configuration 'scheme-indent-function 0))
   (eval . (put 'home-unclutter-configuration 'scheme-indent-function 0))
   (eval . (put 'home-xdg-base-directories-configuration 'scheme-indent-function 0))
   (eval . (put 'home-xdg-mime-applications-configuration 'scheme-indent-function 0))
   (eval . (put 'home-xdg-user-directories-configuration 'scheme-indent-function 0))
   (eval . (put 'home-xmodmap-configuration 'scheme-indent-function 0))
   (eval . (put 'home-znc-configuration 'scheme-indent-function 0))
   (eval . (put 'home-zsh-configuration 'scheme-indent-function 0))
   (eval . (put 'home-zsh-extension 'scheme-indent-function 0))
   (eval . (put 'msmtp-account 'scheme-indent-function 0))
   (eval . (put 'msmtp-configuration 'scheme-indent-function 0))
   (eval . (put 'openssh-host 'scheme-indent-function 0))
   (eval . (put 'point 'scheme-indent-function 0))
   (eval . (put 'proxy-jump 'scheme-indent-function 0))
   (eval . (put 'sway-bar 'scheme-indent-function 0))
   (eval . (put 'sway-border-color 'scheme-indent-function 0))
   (eval . (put 'sway-color 'scheme-indent-function 0))
   (eval . (put 'sway-configuration 'scheme-indent-function 0))
   (eval . (put 'sway-input 'scheme-indent-function 0))
   (eval . (put 'sway-mode 'scheme-indent-function 0))
   (eval . (put 'sway-output 'scheme-indent-function 0))
   (eval . (put 'xdg-desktop-action 'scheme-indent-function 0))
   (eval . (put 'xdg-desktop-entry 'scheme-indent-function 0))

   ;; gnu/services
   (eval . (put 'agate-configuration 'scheme-indent-function 0))
   (eval . (put 'agetty-configuration 'scheme-indent-function 0))
   (eval . (put 'alsa-configuration 'scheme-indent-function 0))
   (eval . (put 'anonip-configuration 'scheme-indent-function 0))
   (eval . (put 'apcupsd-configuration 'scheme-indent-function 0))
   (eval . (put 'apcupsd-event-handlers 'scheme-indent-function 0))
   (eval . (put 'auditd-configuration 'scheme-indent-function 0))
   (eval . (put 'autossh-configuration 'scheme-indent-function 0))
   (eval . (put 'avahi-configuration 'scheme-indent-function 0))
   (eval . (put 'backend-userroot-configuration 'scheme-indent-function 0))
   (eval . (put 'bffe-configuration 'scheme-indent-function 0))
   (eval . (put 'bitlbee-configuration 'scheme-indent-function 0))
   (eval . (put 'bluetooth-configuration 'scheme-indent-function 0))
   (eval . (put 'cachefilesd-configuration 'scheme-indent-function 0))
   (eval . (put 'certbot-configuration 'scheme-indent-function 0))
   (eval . (put 'cgit-configuration 'scheme-indent-function 0))
   (eval . (put 'configuration-field 'scheme-indent-function 0))
   (eval . (put 'connman-configuration 'scheme-indent-function 0))
   (eval . (put 'connman-general-configuration 'scheme-indent-function 0))
   (eval . (put 'containerd-configuration 'scheme-indent-function 0))
   (eval . (put 'cuirass-configuration 'scheme-indent-function 0))
   (eval . (put 'cuirass-remote-server-configuration 'scheme-indent-function 0))
   (eval . (put 'cuirass-remote-worker-configuration 'scheme-indent-function 0))
   (eval . (put 'cups-configuration 'scheme-indent-function 0))
   (eval . (put 'darkstat-configuration 'scheme-indent-function 0))
   (eval . (put 'dbus-configuration 'scheme-indent-function 0))
   (eval . (put 'dconf-keyfile 'scheme-indent-function 0))
   (eval . (put 'dconf-profile 'scheme-indent-function 0))
   (eval . (put 'debootstrap-configuration 'scheme-indent-function 0))
   (eval . (put 'dhcp-client-configuration 'scheme-indent-function 0))
   (eval . (put 'dhcpcd-configuration 'scheme-indent-function 0))
   (eval . (put 'dhcpd-configuration 'scheme-indent-function 0))
   (eval . (put 'dicod-configuration 'scheme-indent-function 0))
   (eval . (put 'dict-configuration 'scheme-indent-function 0))
   (eval . (put 'directory-server-instance-configuration 'scheme-indent-function 0))
   (eval . (put 'dnsmasq-configuration 'scheme-indent-function 0))
   (eval . (put 'docker-configuration 'scheme-indent-function 0))
   (eval . (put 'dovecot-configuration 'scheme-indent-function 0))
   (eval . (put 'dropbear-configuration 'scheme-indent-function 0))
   (eval . (put 'earlyoom-configuration 'scheme-indent-function 0))
   (eval . (put 'elogind-configuration 'scheme-indent-function 0))
   (eval . (put 'enlightenment-desktop-configuration 'scheme-indent-function 0))
   (eval . (put 'exim-configuration 'scheme-indent-function 0))
   (eval . (put 'ext-component-configuration 'scheme-indent-function 0))
   (eval . (put 'fail2ban-configuration 'scheme-indent-function 0))
   (eval . (put 'fail2ban-ignore-cache-configuration 'scheme-indent-function 0))
   (eval . (put 'fail2ban-jail-action-configuration 'scheme-indent-function 0))
   (eval . (put 'fail2ban-jail-configuration 'scheme-indent-function 0))
   (eval . (put 'fail2ban-jail-filter-configuration 'scheme-indent-function 0))
   (eval . (put 'fcgiwrap-configuration 'scheme-indent-function 0))
   (eval . (put 'fifo-listener-configuration 'scheme-indent-function 0))
   (eval . (put 'file-database-configuration 'scheme-indent-function 0))
   (eval . (put 'files-configuration 'scheme-indent-function 0))
   (eval . (put 'fprintd-configuration 'scheme-indent-function 0))
   (eval . (put 'fstrim-configuration 'scheme-indent-function 0))
   (eval . (put 'ganeti-cleaner-configuration 'scheme-indent-function 0))
   (eval . (put 'ganeti-confd-configuration 'scheme-indent-function 0))
   (eval . (put 'ganeti-configuration 'scheme-indent-function 0))
   (eval . (put 'ganeti-kvmd-configuration 'scheme-indent-function 0))
   (eval . (put 'ganeti-luxid-configuration 'scheme-indent-function 0))
   (eval . (put 'ganeti-metad-configuration 'scheme-indent-function 0))
   (eval . (put 'ganeti-mond-configuration 'scheme-indent-function 0))
   (eval . (put 'ganeti-noded-configuration 'scheme-indent-function 0))
   (eval . (put 'ganeti-os 'scheme-indent-function 0))
   (eval . (put 'ganeti-os-variant 'scheme-indent-function 0))
   (eval . (put 'ganeti-rapi-configuration 'scheme-indent-function 0))
   (eval . (put 'ganeti-watcher-configuration 'scheme-indent-function 0))
   (eval . (put 'ganeti-wconfd-configuration 'scheme-indent-function 0))
   (eval . (put 'gdm-configuration 'scheme-indent-function 0))
   (eval . (put 'geoclue-configuration 'scheme-indent-function 0))
   (eval . (put 'getmail-configuration 'scheme-indent-function 0))
   (eval . (put 'getmail-configuration-file 'scheme-indent-function 0))
   (eval . (put 'getmail-destination-configuration 'scheme-indent-function 0))
   (eval . (put 'getmail-options-configuration 'scheme-indent-function 0))
   (eval . (put 'getmail-retriever-configuration 'scheme-indent-function 0))
   (eval . (put 'git-daemon-configuration 'scheme-indent-function 0))
   (eval . (put 'git-http-configuration 'scheme-indent-function 0))
   (eval . (put 'gitile-configuration 'scheme-indent-function 0))
   (eval . (put 'gitolite-configuration 'scheme-indent-function 0))
   (eval . (put 'gitolite-git-configuration 'scheme-indent-function 0))
   (eval . (put 'gitolite-rc-file 'scheme-indent-function 0))
   (eval . (put 'gmnisrv-configuration 'scheme-indent-function 0))
   (eval . (put 'gnome-desktop-configuration 'scheme-indent-function 0))
   (eval . (put 'gnome-keyring-configuration 'scheme-indent-function 0))
   (eval . (put 'gpm-configuration 'scheme-indent-function 0))
   (eval . (put 'greetd-agreety-session 'scheme-indent-function 0))
   (eval . (put 'greetd-configuration 'scheme-indent-function 0))
   (eval . (put 'greetd-gtkgreet-sway-session 'scheme-indent-function 0))
   (eval . (put 'greetd-terminal-configuration 'scheme-indent-function 0))
   (eval . (put 'greetd-user-session 'scheme-indent-function 0))
   (eval . (put 'greetd-wlgreet-configuration 'scheme-indent-function 0))
   (eval . (put 'greetd-wlgreet-session 'scheme-indent-function 0))
   (eval . (put 'greetd-wlgreet-sway-session 'scheme-indent-function 0))
   (eval . (put 'gss-configuration 'scheme-indent-function 0))
   (eval . (put 'guix-build-coordinator-agent-configuration 'scheme-indent-function 0))
   (eval . (put 'guix-build-coordinator-agent-dynamic-auth 'scheme-indent-function 0))
   (eval . (put 'guix-build-coordinator-agent-dynamic-auth-with-file 'scheme-indent-function 0))
   (eval . (put 'guix-build-coordinator-agent-password-auth 'scheme-indent-function 0))
   (eval . (put 'guix-build-coordinator-agent-password-file-auth 'scheme-indent-function 0))
   (eval . (put 'guix-build-coordinator-configuration 'scheme-indent-function 0))
   (eval . (put 'guix-configuration 'scheme-indent-function 0))
   (eval . (put 'guix-data-service-configuration 'scheme-indent-function 0))
   (eval . (put 'guix-extension 'scheme-indent-function 0))
   (eval . (put 'guix-publish-configuration 'scheme-indent-function 0))
   (eval . (put 'gvfs-configuration 'scheme-indent-function 0))
   (eval . (put 'host 'scheme-indent-function 0))
   (eval . (put 'hostapd-configuration 'scheme-indent-function 0))
   (eval . (put 'hpcguix-web-configuration 'scheme-indent-function 0))
   (eval . (put 'httpd-config-file 'scheme-indent-function 0))
   (eval . (put 'httpd-configuration 'scheme-indent-function 0))
   (eval . (put 'httpd-module 'scheme-indent-function 0))
   (eval . (put 'httpd-virtualhost 'scheme-indent-function 0))
   (eval . (put 'hurd-console-configuration 'scheme-indent-function 0))
   (eval . (put 'hurd-getty-configuration 'scheme-indent-function 0))
   (eval . (put 'hurd-vm-configuration 'scheme-indent-function 0))
   (eval . (put 'idmap-configuration 'scheme-indent-function 0))
   (eval . (put 'imap4d-configuration 'scheme-indent-function 0))
   (eval . (put 'inet-listener-configuration 'scheme-indent-function 0))
   (eval . (put 'inetd-configuration 'scheme-indent-function 0))
   (eval . (put 'inetd-entry 'scheme-indent-function 0))
   (eval . (put 'inputattach-configuration 'scheme-indent-function 0))
   (eval . (put 'int-component-configuration 'scheme-indent-function 0))
   (eval . (put 'ipfs-configuration 'scheme-indent-function 0))
   (eval . (put 'iptables-configuration 'scheme-indent-function 0))
   (eval . (put 'iwd-configuration 'scheme-indent-function 0))
   (eval . (put 'iwd-general-settings 'scheme-indent-function 0))
   (eval . (put 'iwd-network-settings 'scheme-indent-function 0))
   (eval . (put 'iwd-scan-settings 'scheme-indent-function 0))
   (eval . (put 'iwd-settings 'scheme-indent-function 0))
   (eval . (put 'jami-account 'scheme-indent-function 0))
   (eval . (put 'jami-configuration 'scheme-indent-function 0))
   (eval . (put 'joycond-configuration 'scheme-indent-function 0))
   (eval . (put 'keepalived-configuration 'scheme-indent-function 0))
   (eval . (put 'kmscon-configuration 'scheme-indent-function 0))
   (eval . (put 'knot-acl-configuration 'scheme-indent-function 0))
   (eval . (put 'knot-configuration 'scheme-indent-function 0))
   (eval . (put 'knot-key-configuration 'scheme-indent-function 0))
   (eval . (put 'knot-keystore-configuration 'scheme-indent-function 0))
   (eval . (put 'knot-policy-configuration 'scheme-indent-function 0))
   (eval . (put 'knot-remote-configuration 'scheme-indent-function 0))
   (eval . (put 'knot-resolver-configuration 'scheme-indent-function 0))
   (eval . (put 'knot-zone-configuration 'scheme-indent-function 0))
   (eval . (put 'krb5-configuration 'scheme-indent-function 0))
   (eval . (put 'krb5-realm 'scheme-indent-function 0))
   (eval . (put 'kwallet-configuration 'scheme-indent-function 0))
   (eval . (put 'ladspa-configuration 'scheme-indent-function 0))
   (eval . (put 'laminar-configuration 'scheme-indent-function 0))
   (eval . (put 'libvirt-configuration 'scheme-indent-function 0))
   (eval . (put 'lightdm-configuration 'scheme-indent-function 0))
   (eval . (put 'lightdm-gtk-greeter-configuration 'scheme-indent-function 0))
   (eval . (put 'lightdm-seat-configuration 'scheme-indent-function 0))
   (eval . (put 'linux-builder-configuration 'scheme-indent-function 0))
   (eval . (put 'lirc-configuration 'scheme-indent-function 0))
   (eval . (put 'live-service 'scheme-indent-function 0))
   (eval . (put 'localed-configuration 'scheme-indent-function 0))
   (eval . (put 'location-access-control 'scheme-indent-function 0))
   (eval . (put 'log-cleanup-configuration 'scheme-indent-function 0))
   (eval . (put 'log-rotation 'scheme-indent-function 0))
   (eval . (put 'log-rotation-configuration 'scheme-indent-function 0))
   (eval . (put 'login-configuration 'scheme-indent-function 0))
   (eval . (put 'lsh-configuration 'scheme-indent-function 0))
   (eval . (put 'lxqt-desktop-configuration 'scheme-indent-function 0))
   (eval . (put 'mailbox-configuration 'scheme-indent-function 0))
   (eval . (put 'mate-desktop-configuration 'scheme-indent-function 0))
   (eval . (put 'mcron-configuration 'scheme-indent-function 0))
   (eval . (put 'memcached-configuration 'scheme-indent-function 0))
   (eval . (put 'method-access-control 'scheme-indent-function 0))
   (eval . (put 'mingetty-configuration 'scheme-indent-function 0))
   (eval . (put 'mod-muc-configuration 'scheme-indent-function 0))
   (eval . (put 'modem-manager-configuration 'scheme-indent-function 0))
   (eval . (put 'mosquitto-configuration 'scheme-indent-function 0))
   (eval . (put 'mpd-configuration 'scheme-indent-function 0))
   (eval . (put 'mpd-output 'scheme-indent-function 0))
   (eval . (put 'mpd-partition 'scheme-indent-function 0))
   (eval . (put 'mpd-plugin 'scheme-indent-function 0))
   (eval . (put 'mumble-server-configuration 'scheme-indent-function 0))
   (eval . (put 'mumble-server-public-registration-configuration 'scheme-indent-function 0))
   (eval . (put 'mumi-configuration 'scheme-indent-function 0))
   (eval . (put 'mumi-package-configuration 'scheme-indent-function 0))
   (eval . (put 'mympd-configuration 'scheme-indent-function 0))
   (eval . (put 'mympd-ip-acl 'scheme-indent-function 0))
   (eval . (put 'mysql-configuration 'scheme-indent-function 0))
   (eval . (put 'namespace-configuration 'scheme-indent-function 0))
   (eval . (put 'nar-herder-cached-compression-configuration 'scheme-indent-function 0))
   (eval . (put 'nar-herder-configuration 'scheme-indent-function 0))
   (eval . (put 'network-address 'scheme-indent-function 0))
   (eval . (put 'network-link 'scheme-indent-function 0))
   (eval . (put 'network-manager-configuration 'scheme-indent-function 0))
   (eval . (put 'network-route 'scheme-indent-function 0))
   (eval . (put 'nfs-configuration 'scheme-indent-function 0))
   (eval . (put 'nftables-configuration 'scheme-indent-function 0))
   (eval . (put 'nginx-configuration 'scheme-indent-function 0))
   (eval . (put 'nginx-location-configuration 'scheme-indent-function 0))
   (eval . (put 'nginx-log-format-configuration 'scheme-indent-function 0))
   (eval . (put 'nginx-named-location-configuration 'scheme-indent-function 0))
   (eval . (put 'nginx-server-configuration 'scheme-indent-function 0))
   (eval . (put 'nginx-upstream-configuration 'scheme-indent-function 0))
   (eval . (put 'ngircd-channel 'scheme-indent-function 0))
   (eval . (put 'ngircd-configuration 'scheme-indent-function 0))
   (eval . (put 'ngircd-global 'scheme-indent-function 0))
   (eval . (put 'ngircd-limits 'scheme-indent-function 0))
   (eval . (put 'ngircd-operator 'scheme-indent-function 0))
   (eval . (put 'ngircd-options 'scheme-indent-function 0))
   (eval . (put 'ngircd-server 'scheme-indent-function 0))
   (eval . (put 'ngircd-ssl 'scheme-indent-function 0))
   (eval . (put 'nix-configuration 'scheme-indent-function 0))
   (eval . (put 'nscd-cache 'scheme-indent-function 0))
   (eval . (put 'nscd-configuration 'scheme-indent-function 0))
   (eval . (put 'nslcd-configuration 'scheme-indent-function 0))
   (eval . (put 'ntp-configuration 'scheme-indent-function 0))
   (eval . (put 'ntp-server 'scheme-indent-function 0))
   (eval . (put 'oci-container-configuration 'scheme-indent-function 0))
   (eval . (put 'oci-image 'scheme-indent-function 0))
   (eval . (put 'opaque-cgit-configuration 'scheme-indent-function 0))
   (eval . (put 'opaque-cups-configuration 'scheme-indent-function 0))
   (eval . (put 'opaque-dovecot-configuration 'scheme-indent-function 0))
   (eval . (put 'opaque-prosody-configuration 'scheme-indent-function 0))
   (eval . (put 'opendht-configuration 'scheme-indent-function 0))
   (eval . (put 'openntpd-configuration 'scheme-indent-function 0))
   (eval . (put 'opensmtpd-configuration 'scheme-indent-function 0))
   (eval . (put 'openssh-configuration 'scheme-indent-function 0))
   (eval . (put 'openvpn-ccd-configuration 'scheme-indent-function 0))
   (eval . (put 'openvpn-client-configuration 'scheme-indent-function 0))
   (eval . (put 'openvpn-remote-configuration 'scheme-indent-function 0))
   (eval . (put 'openvpn-server-configuration 'scheme-indent-function 0))
   (eval . (put 'openvswitch-configuration 'scheme-indent-function 0))
   (eval . (put 'operation-access-control 'scheme-indent-function 0))
   (eval . (put 'package-database-configuration 'scheme-indent-function 0))
   (eval . (put 'pagekite-configuration 'scheme-indent-function 0))
   (eval . (put 'pam-krb5-configuration 'scheme-indent-function 0))
   (eval . (put 'pam-mount-configuration 'scheme-indent-function 0))
   (eval . (put 'pam-mount-volume 'scheme-indent-function 0))
   (eval . (put 'passdb-configuration 'scheme-indent-function 0))
   (eval . (put 'patchwork-configuration 'scheme-indent-function 0))
   (eval . (put 'patchwork-database-configuration 'scheme-indent-function 0))
   (eval . (put 'patchwork-settings-module 'scheme-indent-function 0))
   (eval . (put 'pcscd-configuration 'scheme-indent-function 0))
   (eval . (put 'php-fpm-configuration 'scheme-indent-function 0))
   (eval . (put 'php-fpm-dynamic-process-manager-configuration 'scheme-indent-function 0))
   (eval . (put 'php-fpm-on-demand-process-manager-configuration 'scheme-indent-function 0))
   (eval . (put 'php-fpm-static-process-manager-configuration 'scheme-indent-function 0))
   (eval . (put 'pipefs-configuration 'scheme-indent-function 0))
   (eval . (put 'plasma-desktop-configuration 'scheme-indent-function 0))
   (eval . (put 'plugin-configuration 'scheme-indent-function 0))
   (eval . (put 'policy-configuration 'scheme-indent-function 0))
   (eval . (put 'polkit-configuration 'scheme-indent-function 0))
   (eval . (put 'postgresql-config-file 'scheme-indent-function 0))
   (eval . (put 'postgresql-configuration 'scheme-indent-function 0))
   (eval . (put 'postgresql-role 'scheme-indent-function 0))
   (eval . (put 'pounce-configuration 'scheme-indent-function 0))
   (eval . (put 'power-profiles-daemon-configuration 'scheme-indent-function 0))
   (eval . (put 'powertop-configuration 'scheme-indent-function 0))
   (eval . (put 'prometheus-node-exporter-configuration 'scheme-indent-function 0))
   (eval . (put 'prosody-configuration 'scheme-indent-function 0))
   (eval . (put 'protocol-configuration 'scheme-indent-function 0))
   (eval . (put 'pulseaudio-configuration 'scheme-indent-function 0))
   (eval . (put 'qemu-binfmt-configuration 'scheme-indent-function 0))
   (eval . (put 'qemu-guest-agent-configuration 'scheme-indent-function 0))
   (eval . (put 'quassel-configuration 'scheme-indent-function 0))
   (eval . (put 'radicale-auth-configuration 'scheme-indent-function 0))
   (eval . (put 'radicale-configuration 'scheme-indent-function 0))
   (eval . (put 'radicale-encoding-configuration 'scheme-indent-function 0))
   (eval . (put 'radicale-logging-configuration 'scheme-indent-function 0))
   (eval . (put 'radicale-rights-configuration 'scheme-indent-function 0))
   (eval . (put 'radicale-server-configuration 'scheme-indent-function 0))
   (eval . (put 'radicale-storage-configuration 'scheme-indent-function 0))
   (eval . (put 'rasdaemon-configuration 'scheme-indent-function 0))
   (eval . (put 'readymedia-configuration 'scheme-indent-function 0))
   (eval . (put 'readymedia-media-directory 'scheme-indent-function 0))
   (eval . (put 'redis-configuration 'scheme-indent-function 0))
   (eval . (put 'repository-cgit-configuration 'scheme-indent-function 0))
   (eval . (put 'resize-file-system-configuration 'scheme-indent-function 0))
   (eval . (put 'restic-backup-configuration 'scheme-indent-function 0))
   (eval . (put 'restic-backup-job 'scheme-indent-function 0))
   (eval . (put 'rngd-configuration 'scheme-indent-function 0))
   (eval . (put 'rootless-podman-configuration 'scheme-indent-function 0))
   (eval . (put 'rpcbind-configuration 'scheme-indent-function 0))
   (eval . (put 'rshiny-configuration 'scheme-indent-function 0))
   (eval . (put 'rspamd-configuration 'scheme-indent-function 0))
   (eval . (put 'rsync-configuration 'scheme-indent-function 0))
   (eval . (put 'rsync-module 'scheme-indent-function 0))
   (eval . (put 'samba-configuration 'scheme-indent-function 0))
   (eval . (put 'screen-locker-configuration 'scheme-indent-function 0))
   (eval . (put 'sddm-configuration 'scheme-indent-function 0))
   (eval . (put 'seatd-configuration 'scheme-indent-function 0))
   (eval . (put 'service-configuration 'scheme-indent-function 0))
   (eval . (put 'service-type 'scheme-indent-function 0))
   (eval . (put 'shepherd-action 'scheme-indent-function 0))
   (eval . (put 'shepherd-configuration 'scheme-indent-function 0))
   (eval . (put 'shepherd-service 'scheme-indent-function 0))
   (eval . (put 'slim-configuration 'scheme-indent-function 0))
   (eval . (put 'snuik-configuration 'scheme-indent-function 0))
   (eval . (put 'speakersafetyd-configuration 'scheme-indent-function 0))
   (eval . (put 'spice-vdagent-configuration 'scheme-indent-function 0))
   (eval . (put 'ssl-configuration 'scheme-indent-function 0))
   (eval . (put 'static-networking 'scheme-indent-function 0))
   (eval . (put 'strongswan-configuration 'scheme-indent-function 0))
   (eval . (put 'sugar-desktop-configuration 'scheme-indent-function 0))
   (eval . (put 'syncthing-config-file 'scheme-indent-function 0))
   (eval . (put 'syncthing-configuration 'scheme-indent-function 0))
   (eval . (put 'syncthing-device 'scheme-indent-function 0))
   (eval . (put 'syncthing-folder 'scheme-indent-function 0))
   (eval . (put 'syncthing-folder-device 'scheme-indent-function 0))
   (eval . (put 'sysctl-configuration 'scheme-indent-function 0))
   (eval . (put 'syslog-configuration 'scheme-indent-function 0))
   (eval . (put 'system-log-configuration 'scheme-indent-function 0))
   (eval . (put 'tailon-configuration 'scheme-indent-function 0))
   (eval . (put 'tailon-configuration-file 'scheme-indent-function 0))
   (eval . (put 'thermald-configuration 'scheme-indent-function 0))
   (eval . (put 'tlp-configuration 'scheme-indent-function 0))
   (eval . (put 'tor-configuration 'scheme-indent-function 0))
   (eval . (put 'tor-onion-service-configuration 'scheme-indent-function 0))
   (eval . (put 'tor-transport-plugin 'scheme-indent-function 0))
   (eval . (put 'transmission-daemon-configuration 'scheme-indent-function 0))
   (eval . (put 'udev-configuration 'scheme-indent-function 0))
   (eval . (put 'udisks-configuration 'scheme-indent-function 0))
   (eval . (put 'unattended-upgrade-configuration 'scheme-indent-function 0))
   (eval . (put 'unbound-configuration 'scheme-indent-function 0))
   (eval . (put 'unbound-remote 'scheme-indent-function 0))
   (eval . (put 'unbound-server 'scheme-indent-function 0))
   (eval . (put 'unbound-zone 'scheme-indent-function 0))
   (eval . (put 'unix-listener-configuration 'scheme-indent-function 0))
   (eval . (put 'upower-configuration 'scheme-indent-function 0))
   (eval . (put 'usb-modeswitch-configuration 'scheme-indent-function 0))
   (eval . (put 'userdb-configuration 'scheme-indent-function 0))
   (eval . (put 'varnish-configuration 'scheme-indent-function 0))
   (eval . (put 'virtlog-configuration 'scheme-indent-function 0))
   (eval . (put 'virtual-build-machine 'scheme-indent-function 0))
   (eval . (put 'virtualhost-configuration 'scheme-indent-function 0))
   (eval . (put 'vnstat-configuration 'scheme-indent-function 0))
   (eval . (put 'webssh-configuration 'scheme-indent-function 0))
   (eval . (put 'wesnothd-configuration 'scheme-indent-function 0))
   (eval . (put 'whoogle-configuration 'scheme-indent-function 0))
   (eval . (put 'wireguard-configuration 'scheme-indent-function 0))
   (eval . (put 'wireguard-peer 'scheme-indent-function 0))
   (eval . (put 'wpa-supplicant-configuration 'scheme-indent-function 0))
   (eval . (put 'wsdd-configuration 'scheme-indent-function 0))
   (eval . (put 'xe-guest-utilities-configuration 'scheme-indent-function 0))
   (eval . (put 'xen-guest-agent-configuration 'scheme-indent-function 0))
   (eval . (put 'xfce-desktop-configuration 'scheme-indent-function 0))
   (eval . (put 'xorg-configuration 'scheme-indent-function 0))
   (eval . (put 'xvnc-configuration 'scheme-indent-function 0))
   (eval . (put 'yggdrasil-configuration 'scheme-indent-function 0))
   (eval . (put 'zabbix-agent-configuration 'scheme-indent-function 0))
   (eval . (put 'zabbix-front-end-configuration 'scheme-indent-function 0))
   (eval . (put 'zabbix-server-configuration 'scheme-indent-function 0))
   (eval . (put 'zone-entry 'scheme-indent-function 0))
   (eval . (put 'zone-file 'scheme-indent-function 0))
   (eval . (put 'zram-device-configuration 'scheme-indent-function 0)))))
