/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.ByteBlockPool;
import org.apache.lucene.index.CharBlockPool;
import org.apache.lucene.index.DocInverterPerField;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IntBlockPool;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.InvertedDocConsumerPerThread;
import org.apache.lucene.index.RawPostingList;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TermsHashConsumerPerThread;
import org.apache.lucene.index.TermsHashPerField;

final class TermsHashPerThread
extends InvertedDocConsumerPerThread {
    final TermsHash termsHash;
    final TermsHashConsumerPerThread consumer;
    final TermsHashPerThread nextPerThread;
    final CharBlockPool charPool;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    final boolean primary;
    final DocumentsWriter.DocState docState;
    final RawPostingList[] freePostings = new RawPostingList[256];
    int freePostingsCount;

    public TermsHashPerThread(DocInverterPerThread docInverterPerThread, TermsHash termsHash, TermsHash nextTermsHash, TermsHashPerThread primaryPerThread) {
        this.docState = docInverterPerThread.docState;
        this.termsHash = termsHash;
        this.consumer = termsHash.consumer.addThread(this);
        if (nextTermsHash != null) {
            this.charPool = new CharBlockPool(termsHash.docWriter);
            this.primary = true;
        } else {
            this.charPool = primaryPerThread.charPool;
            this.primary = false;
        }
        this.intPool = new IntBlockPool(termsHash.docWriter, termsHash.trackAllocations);
        this.bytePool = new ByteBlockPool(termsHash.docWriter.byteBlockAllocator, termsHash.trackAllocations);
        this.nextPerThread = nextTermsHash != null ? nextTermsHash.addThread(docInverterPerThread, this) : null;
    }

    InvertedDocConsumerPerField addField(DocInverterPerField docInverterPerField, FieldInfo fieldInfo) {
        return new TermsHashPerField(docInverterPerField, this, this.nextPerThread, fieldInfo);
    }

    public synchronized void abort() {
        this.reset(true);
        this.consumer.abort();
        if (this.nextPerThread != null) {
            this.nextPerThread.abort();
        }
    }

    void morePostings() throws IOException {
        assert (this.freePostingsCount == 0);
        this.termsHash.getPostings(this.freePostings);
        this.freePostingsCount = this.freePostings.length;
        assert (TermsHashPerThread.noNullPostings(this.freePostings, this.freePostingsCount, "consumer=" + this.consumer));
    }

    private static boolean noNullPostings(RawPostingList[] postings, int count, String details) {
        for (int i = 0; i < count; ++i) {
            assert (postings[i] != null) : "postings[" + i + "] of " + count + " is null: " + details;
        }
        return true;
    }

    public void startDocument() throws IOException {
        this.consumer.startDocument();
        if (this.nextPerThread != null) {
            this.nextPerThread.consumer.startDocument();
        }
    }

    public DocumentsWriter.DocWriter finishDocument() throws IOException {
        DocumentsWriter.DocWriter doc = this.consumer.finishDocument();
        DocumentsWriter.DocWriter doc2 = this.nextPerThread != null ? this.nextPerThread.consumer.finishDocument() : null;
        if (doc == null) {
            return doc2;
        }
        doc.setNext(doc2);
        return doc;
    }

    void reset(boolean recyclePostings) {
        this.intPool.reset();
        this.bytePool.reset();
        if (this.primary) {
            this.charPool.reset();
        }
        if (recyclePostings) {
            this.termsHash.recyclePostings(this.freePostings, this.freePostingsCount);
            this.freePostingsCount = 0;
        }
    }
}

