/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.ComparisonKey;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;

public class GroupAdjacentIterator
implements GroupIterator,
LookaheadIterator {
    private SequenceIterator population;
    private Expression keyExpression;
    private StringCollator collator;
    private AtomicComparer comparer;
    private ComparisonKey currentComparisonKey;
    private XPathContext baseContext;
    private XPathContext runningContext;
    private AtomicValue currentKey = null;
    private List currentMembers;
    private AtomicValue nextKey = null;
    private Item next;
    private Item current = null;
    private int position = 0;

    public GroupAdjacentIterator(SequenceIterator population, Expression keyExpression, XPathContext baseContext, StringCollator collator) throws XPathException {
        this.population = population;
        this.keyExpression = keyExpression;
        this.baseContext = baseContext;
        this.runningContext = baseContext.newMinorContext();
        this.runningContext.setCurrentIterator(population);
        this.collator = collator;
        int type = keyExpression.getItemType(baseContext.getConfiguration().getTypeHierarchy()).getPrimitiveType();
        this.comparer = AtomicSortComparer.makeSortComparer(collator, type, baseContext);
        this.next = population.next();
        if (this.next != null) {
            this.nextKey = (AtomicValue)keyExpression.evaluateItem(this.runningContext);
        }
    }

    private void advance() throws XPathException {
        Item nextCandidate;
        this.currentMembers = new ArrayList(20);
        this.currentMembers.add(this.current);
        while ((nextCandidate = this.population.next()) != null) {
            AtomicValue candidateKey = (AtomicValue)this.keyExpression.evaluateItem(this.runningContext);
            try {
                if (this.currentComparisonKey.equals(this.comparer.getComparisonKey(candidateKey))) {
                    this.currentMembers.add(nextCandidate);
                    continue;
                }
                this.next = nextCandidate;
                this.nextKey = candidateKey;
                return;
            }
            catch (ClassCastException e) {
                XPathException err = new XPathException("Grouping key values are of non-comparable types (" + Type.displayTypeName(this.currentKey) + " and " + Type.displayTypeName(candidateKey) + ')');
                err.setIsTypeError(true);
                err.setXPathContext(this.runningContext);
                throw err;
            }
        }
        this.next = null;
        this.nextKey = null;
    }

    public AtomicValue getCurrentGroupingKey() {
        return this.currentKey;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator(this.currentMembers);
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() throws XPathException {
        if (this.next == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.next;
        this.currentKey = this.nextKey;
        this.currentComparisonKey = this.comparer.getComparisonKey(this.currentKey);
        ++this.position;
        this.advance();
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public void close() {
        this.population.close();
    }

    public SequenceIterator getAnother() throws XPathException {
        return new GroupAdjacentIterator(this.population.getAnother(), this.keyExpression, this.baseContext, this.collator);
    }

    public int getProperties() {
        return 4;
    }
}

