// SPDX-License-Identifier: MIT

#ifndef PKGCRAFT_H
#define PKGCRAFT_H

/* Generated with cbindgen:0.28.0 */


#define PKGCRAFT_MAJOR 0
#define PKGCRAFT_MINOR 0
#define PKGCRAFT_PATCH 16


#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

typedef enum Blocker {
  BLOCKER_STRONG = 1,
  BLOCKER_WEAK,
} Blocker;

enum DepField
#ifdef __cplusplus
  : uint32_t
#endif // __cplusplus
 {
  DEP_FIELD_CATEGORY = 1,
  DEP_FIELD_PACKAGE,
  DEP_FIELD_BLOCKER,
  DEP_FIELD_VERSION,
  DEP_FIELD_SLOT_DEP,
  DEP_FIELD_USE_DEPS,
  DEP_FIELD_REPO,
};
#ifndef __cplusplus
typedef uint32_t DepField;
#endif // __cplusplus

/**
 * Dependency variants.
 */
typedef enum DependencyKind {
  DEPENDENCY_KIND_ENABLED,
  DEPENDENCY_KIND_DISABLED,
  DEPENDENCY_KIND_ALL_OF,
  DEPENDENCY_KIND_ANY_OF,
  DEPENDENCY_KIND_EXACTLY_ONE_OF,
  DEPENDENCY_KIND_AT_MOST_ONE_OF,
  DEPENDENCY_KIND_CONDITIONAL,
} DependencyKind;

/**
 * DependencySet variants.
 */
typedef enum DependencySetKind {
  DEPENDENCY_SET_KIND_PACKAGE,
  DEPENDENCY_SET_KIND_SRC_URI,
  DEPENDENCY_SET_KIND_LICENSE,
  DEPENDENCY_SET_KIND_PROPERTIES,
  DEPENDENCY_SET_KIND_REQUIRED_USE,
  DEPENDENCY_SET_KIND_RESTRICT,
} DependencySetKind;

typedef enum ErrorKind {
  ERROR_KIND_GENERIC,
  ERROR_KIND_PKGCRAFT,
  ERROR_KIND_CONFIG,
  ERROR_KIND_REPO,
  ERROR_KIND_PKG,
} ErrorKind;

/**
 * Package keyword type.
 */
typedef enum KeywordStatus {
  KEYWORD_STATUS_DISABLED,
  KEYWORD_STATUS_UNSTABLE,
  KEYWORD_STATUS_STABLE,
} KeywordStatus;

typedef enum LogLevel {
  LOG_LEVEL_OFF,
  LOG_LEVEL_TRACE,
  LOG_LEVEL_DEBUG,
  LOG_LEVEL_INFO,
  LOG_LEVEL_WARN,
  LOG_LEVEL_ERROR,
} LogLevel;

typedef enum Operator {
  OPERATOR_LESS = 1,
  OPERATOR_LESS_OR_EQUAL,
  OPERATOR_EQUAL,
  OPERATOR_EQUAL_GLOB,
  OPERATOR_APPROXIMATE,
  OPERATOR_GREATER_OR_EQUAL,
  OPERATOR_GREATER,
} Operator;

typedef enum PkgFormat {
  PKG_FORMAT_CONFIGURED,
  PKG_FORMAT_EBUILD,
  PKG_FORMAT_FAKE,
} PkgFormat;

/**
 * Supported repo formats
 */
typedef enum RepoFormat {
  REPO_FORMAT_EBUILD,
  REPO_FORMAT_CONFIGURED,
  REPO_FORMAT_FAKE,
  REPO_FORMAT_EMPTY,
} RepoFormat;

/**
 * Generic set operations.
 */
typedef enum SetOp {
  SET_OP_AND,
  SET_OP_OR,
  SET_OP_XOR,
  SET_OP_SUB,
} SetOp;

typedef enum SlotOperator {
  SLOT_OPERATOR_EQUAL = 1,
  SLOT_OPERATOR_STAR,
} SlotOperator;

/**
 * Package USE dependency type.
 */
typedef enum UseDepKind {
  USE_DEP_KIND_ENABLED,
  USE_DEP_KIND_EQUAL,
  USE_DEP_KIND_CONDITIONAL,
} UseDepKind;

/**
 * System config
 */
typedef struct Config Config;

/**
 * Unversioned package.
 */
typedef struct Cpn Cpn;

/**
 * Versioned package.
 */
typedef struct Cpv Cpv;

/**
 * Package dependency.
 */
typedef struct Dep Dep;

/**
 * Opaque wrapper for pkgcraft::dep::IntoIter<T>.
 */
typedef struct DependencyIntoIter DependencyIntoIter;

/**
 * Opaque wrapper for pkgcraft::dep::IntoIterConditionals<T>.
 */
typedef struct DependencyIntoIterConditionals DependencyIntoIterConditionals;

/**
 * Opaque wrapper for pkgcraft::dep::IntoIterFlatten<T>.
 */
typedef struct DependencyIntoIterFlatten DependencyIntoIterFlatten;

/**
 * Opaque wrapper for pkgcraft::dep::IntoIterRecursive<T>.
 */
typedef struct DependencyIntoIterRecursive DependencyIntoIterRecursive;

/**
 * Opaque wrapper for pkgcraft::dep::DependencySet.
 */
typedef struct DependencySetWrapper DependencySetWrapper;

/**
 * Opaque wrapper for pkgcraft::dep::Dependency.
 */
typedef struct DependencyWrapper DependencyWrapper;

/**
 * EAPI object.
 */
typedef struct Eapi Eapi;

/**
 * Opaque wrapper for pkgcraft::repo::temp::Repo objects.
 */
typedef struct EbuildTempRepo EbuildTempRepo;

/**
 * Opaque wrapper for pkgcraft::pkg::ebuild::keyword::Keyword.
 */
typedef struct KeywordWrapper KeywordWrapper;

/**
 * Opaque wrapper for pkgcraft::pkg::Pkg objects.
 */
typedef struct Pkg Pkg;

/**
 * Opaque wrapper for pkgcraft::repo::Repo objects.
 */
typedef struct Repo Repo;

/**
 * Opaque wrapper for pkgcraft::repo::Iter objects.
 */
typedef struct RepoIter RepoIter;

/**
 * Opaque wrapper for pkgcraft::repo::IterCpv objects.
 */
typedef struct RepoIterCpv RepoIterCpv;

/**
 * Opaque wrapper for pkgcraft::repo::IterRestrict objects.
 */
typedef struct RepoIterRestrict RepoIterRestrict;

/**
 * Ordered set of repos.
 */
typedef struct RepoSet RepoSet;

/**
 * Opaque wrapper for pkgcraft::repo::set::Iter objects.
 */
typedef struct RepoSetIter RepoSetIter;

/**
 * Opaque wrapper for pkgcraft::restrict::Restrict objects.
 */
typedef struct Restrict Restrict;

typedef struct Revision Revision;

/**
 * Uri object.
 */
typedef struct Uri Uri;

/**
 * Opaque wrapper for pkgcraft::dep::UseDep.
 */
typedef struct UseDepWrapper UseDepWrapper;

typedef struct Version Version;

/**
 * C-compatible wrapper for pkgcraft::dep::UseDep.
 */
typedef struct UseDep {
  char *flag;
  enum UseDepKind kind;
  bool enabled;
  bool *default_;
  struct UseDepWrapper *dep;
} UseDep;

/**
 * C-compatible wrapper for pkgcraft::dep::Dependency.
 */
typedef struct Dependency {
  enum DependencySetKind set;
  enum DependencyKind kind;
  struct DependencyWrapper *dep;
} Dependency;

/**
 * C-compatible wrapper for pkgcraft::dep::DependencySet.
 */
typedef struct DependencySet {
  enum DependencySetKind set;
  struct DependencySetWrapper *dep;
} DependencySet;

typedef struct PkgcraftError {
  char *message;
  enum ErrorKind kind;
} PkgcraftError;

/**
 * C-compatible wrapper for pkgcraft::pkg::ebuild::keyword::Keyword.
 */
typedef struct Keyword {
  enum KeywordStatus status;
  char *arch;
  struct KeywordWrapper *keyword;
} Keyword;

typedef struct PkgcraftLog {
  char *message;
  enum LogLevel level;
} PkgcraftLog;

typedef void (*LogCallback)(struct PkgcraftLog*);

/**
 * Wrapper for package maintainers.
 */
typedef struct Maintainer {
  char *email;
  char *name;
  char *description;
  char *maint_type;
  char *proxied;
} Maintainer;

/**
 * Wrapper for package upstream remote-ids.
 */
typedef struct RemoteId {
  char *site;
  char *name;
} RemoteId;

/**
 * Wrapper for upstream package maintainers.
 */
typedef struct UpstreamMaintainer {
  char *name;
  char *email;
  char *status;
} UpstreamMaintainer;

/**
 * Wrapper for package upstream info.
 */
typedef struct Upstream {
  uintptr_t remote_ids_len;
  struct RemoteId **remote_ids;
  uintptr_t maintainers_len;
  struct UpstreamMaintainer **maintainers;
  char *bugs_to;
  char *changelog;
  char *doc;
} Upstream;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/**
 * Free an array without dropping the objects inside it.
 *
 * # Safety
 * The array objects should be explicitly dropped using other methods otherwise they will leak.
 */
void pkgcraft_array_free(void **array, uintptr_t len);

/**
 * Add an external Repo to the config.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The arguments must be valid Config and Repo pointers.
 */
struct Repo *pkgcraft_config_add_repo(struct Config *c, struct Repo *r, bool external);

/**
 * Add local repo from filesystem path.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The path argument should be a valid path on the system.
 */
struct Repo *pkgcraft_config_add_repo_path(struct Config *c,
                                           const char *id,
                                           int priority,
                                           const char *path,
                                           bool external);

/**
 * Free a config.
 *
 * # Safety
 * The argument must be a Config pointer or NULL.
 */
void pkgcraft_config_free(struct Config *c);

/**
 * Load the system config.
 *
 * Returns NULL on error.
 *
 * # Safety
 * A valid pkgcraft (or portage config) directory should be located on the system.
 */
struct Config *pkgcraft_config_load(struct Config *c);

/**
 * Load the portage config from a given path, use NULL for the default system paths.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The path argument should be a valid path on the system.
 */
struct Config *pkgcraft_config_load_portage_conf(struct Config *c, const char *path);

/**
 * Create an empty pkgcraft config.
 */
struct Config *pkgcraft_config_new(void);

/**
 * Return the repos for a config.
 *
 * # Safety
 * The config argument must be a non-null Config pointer.
 */
const struct Repo **pkgcraft_config_repos(struct Config *c, uintptr_t *len);

/**
 * Return the RepoSet for a given repo format.
 *
 * Use a null pointer format argument to return the set of all repos.
 *
 * # Safety
 * The config argument must be a non-null Config pointer.
 */
struct RepoSet *pkgcraft_config_repos_set(struct Config *c, const enum RepoFormat *format);

/**
 * Get the category of a Cpn object.
 *
 * # Safety
 * The argument must be a non-null Cpn pointer.
 */
char *pkgcraft_cpn_category(struct Cpn *c);

/**
 * Compare two Cpns returning -1, 0, or 1 if the first is less than, equal to, or
 * greater than the second, respectively.
 *
 * # Safety
 * The arguments must be non-null Cpn pointers.
 */
int pkgcraft_cpn_cmp(struct Cpn *c1, struct Cpn *c2);

/**
 * Free a Cpn.
 *
 * # Safety
 * The argument must be a Cpn pointer or NULL.
 */
void pkgcraft_cpn_free(struct Cpn *c);

/**
 * Return the hash value for a Cpn object.
 *
 * # Safety
 * The argument must be a non-null Cpn pointer.
 */
uint64_t pkgcraft_cpn_hash(struct Cpn *c);

/**
 * Parse a string into a Cpn object.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument should be a UTF-8 string.
 */
struct Cpn *pkgcraft_cpn_new(const char *s);

/**
 * Get the package name of a Cpn object.
 *
 * # Safety
 * The argument must be a non-null Cpn pointer.
 */
char *pkgcraft_cpn_package(struct Cpn *c);

/**
 * Determine if a string is a valid package Cpn.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument should point to a UTF-8 string.
 */
const char *pkgcraft_cpn_parse(const char *s);

/**
 * Return the restriction for a Cpn object.
 *
 * # Safety
 * The argument must be a non-null Cpn pointer.
 */
struct Restrict *pkgcraft_cpn_restrict(struct Cpn *c);

/**
 * Determine if a restriction matches a Cpn object.
 *
 * # Safety
 * The arguments must be valid Restrict and Cpn pointers.
 */
bool pkgcraft_cpn_restrict_matches(struct Cpn *c, struct Restrict *r);

/**
 * Return the string for a Cpn object.
 *
 * # Safety
 * The argument must be a non-null Cpn pointer.
 */
char *pkgcraft_cpn_str(struct Cpn *c);

/**
 * Get the category of a Cpv object.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
char *pkgcraft_cpv_category(struct Cpv *c);

/**
 * Compare two Cpvs returning -1, 0, or 1 if the first is less than, equal to, or
 * greater than the second, respectively.
 *
 * # Safety
 * The arguments must be non-null Cpv pointers.
 */
int pkgcraft_cpv_cmp(struct Cpv *c1, struct Cpv *c2);

/**
 * Get the Cpn of a Cpv object.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
struct Cpn *pkgcraft_cpv_cpn(struct Cpv *c);

/**
 * Free a Cpv.
 *
 * # Safety
 * The argument must be a Cpv pointer or NULL.
 */
void pkgcraft_cpv_free(struct Cpv *c);

/**
 * Return the hash value for a Cpv object.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
uint64_t pkgcraft_cpv_hash(struct Cpv *c);

/**
 * Determine if two Cpv objects intersect.
 *
 * # Safety
 * The arguments must be non-null Cpv pointers.
 */
bool pkgcraft_cpv_intersects(struct Cpv *c1, struct Cpv *c2);

/**
 * Determine if a Cpv intersects with a package dependency.
 *
 * # Safety
 * The arguments must be non-null Cpv and Dep pointers.
 */
bool pkgcraft_cpv_intersects_dep(struct Cpv *c, struct Dep *d);

/**
 * Parse a string into a Cpv object.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument should be a UTF-8 string.
 */
struct Cpv *pkgcraft_cpv_new(const char *s);

/**
 * Get the package and revision of a Cpv object.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
char *pkgcraft_cpv_p(struct Cpv *c);

/**
 * Get the package name of a Cpv object.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
char *pkgcraft_cpv_package(struct Cpv *c);

/**
 * Determine if a string is a valid package Cpv.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument should point to a UTF-8 string.
 */
const char *pkgcraft_cpv_parse(const char *s);

/**
 * Get the package, version, and revision of a Cpv object.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
char *pkgcraft_cpv_pf(struct Cpv *c);

/**
 * Get the revision of a Cpv object.
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
char *pkgcraft_cpv_pr(struct Cpv *c);

/**
 * Get the version of a Cpv object.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
char *pkgcraft_cpv_pv(struct Cpv *c);

/**
 * Get the version and revision of a Cpv object.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
char *pkgcraft_cpv_pvr(struct Cpv *c);

/**
 * Return the restriction for a Cpv object.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
struct Restrict *pkgcraft_cpv_restrict(struct Cpv *c);

/**
 * Determine if a restriction matches a Cpv object.
 *
 * # Safety
 * The arguments must be valid Restrict and Cpv pointers.
 */
bool pkgcraft_cpv_restrict_matches(struct Cpv *c, struct Restrict *r);

/**
 * Return the string for a Cpv object.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
char *pkgcraft_cpv_str(struct Cpv *c);

/**
 * Get the version of a Cpv object.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
struct Version *pkgcraft_cpv_version(struct Cpv *c);

/**
 * Create a Dep from a Cpv by applying a version operator.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null Cpv pointer.
 */
struct Dep *pkgcraft_cpv_with_op(struct Cpv *c, enum Operator op);

/**
 * Get a package dependency's raw blocker value.
 * For example, the package dependency "!cat/pkg" has a weak blocker.
 *
 * Returns a value of 0 for nonexistence.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
uint32_t pkgcraft_dep_blocker(struct Dep *d);

/**
 * Parse a string into a Blocker's raw value.
 *
 * Returns a value of 0 for nonexistence.
 *
 * # Safety
 * The argument must be a UTF-8 string.
 */
uint32_t pkgcraft_dep_blocker_from_str(const char *s);

/**
 * Return the string for a Blocker.
 */
char *pkgcraft_dep_blocker_str(enum Blocker b);

/**
 * Get the category of a package dependency.
 * For example, the package dependency "=cat/pkg-1-r2" returns "cat".
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
char *pkgcraft_dep_category(struct Dep *d);

/**
 * Compare two package dependencies returning -1, 0, or 1 if the first is less than, equal to, or
 * greater than the second, respectively.
 *
 * # Safety
 * The arguments must be non-null Dep pointers.
 */
int pkgcraft_dep_cmp(struct Dep *d1, struct Dep *d2);

/**
 * Get the Cpn of a package dependency.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
struct Cpn *pkgcraft_dep_cpn(struct Dep *d);

/**
 * Get the Cpv of a package dependency if one exists.
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
struct Cpv *pkgcraft_dep_cpv(struct Dep *d);

/**
 * Free a package dependency.
 *
 * # Safety
 * The argument must be a Dep pointer or NULL.
 */
void pkgcraft_dep_free(struct Dep *d);

/**
 * Return the hash value for a package dependency.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
uint64_t pkgcraft_dep_hash(struct Dep *d);

/**
 * Determine if two package dependencies intersect.
 *
 * # Safety
 * The arguments must be non-null Dep pointers.
 */
bool pkgcraft_dep_intersects(struct Dep *d1, struct Dep *d2);

/**
 * Determine if a package dependency intersects with a Cpv.
 *
 * # Safety
 * The arguments must be non-null Cpv and Dep pointers.
 */
bool pkgcraft_dep_intersects_cpv(struct Dep *d, struct Cpv *c);

/**
 * Return a package dependency modifying the specified fields with corresponding string values.
 * Use null pointers for string values to unset a given field.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The fields and values arguments must be equal length arrays of DepFields with
 * corresponding string values.
 */
struct Dep *pkgcraft_dep_modify(struct Dep *d, DepField *fields, char **values, uintptr_t len);

/**
 * Parse a string into a package dependency using a specific EAPI. Pass NULL for the eapi argument
 * in order to parse using the latest EAPI with extensions (e.g. support for repo deps).
 *
 * Returns NULL on error.
 *
 * # Safety
 * The eapi argument may be NULL to use the default EAPI.
 */
struct Dep *pkgcraft_dep_new(const char *s, const struct Eapi *eapi);

/**
 * Return a package dependency without USE dependencies.
 *
 * # Safety
 * The argument must a valid Dep pointer.
 */
struct Dep *pkgcraft_dep_no_use_deps(struct Dep *d);

/**
 * Get the package name of a package dependency.
 * For example, the package dependency "=cat/pkg-1-r2" returns "pkg".
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
char *pkgcraft_dep_package(struct Dep *d);

/**
 * Determine if a string is a valid package dependency.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The eapi argument may be NULL to use the default EAPI.
 */
const char *pkgcraft_dep_parse(const char *s, const struct Eapi *eapi);

/**
 * Get the repo of a package dependency.
 * For example, the package dependency "=cat/pkg-1-r2:3/4::repo" returns "repo".
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
char *pkgcraft_dep_repo(struct Dep *d);

/**
 * Return the restriction for a package dependency.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
struct Restrict *pkgcraft_dep_restrict(struct Dep *d);

/**
 * Determine if a restriction matches a package dependency.
 *
 * # Safety
 * The arguments must be valid Restrict and Dep pointers.
 */
bool pkgcraft_dep_restrict_matches(struct Dep *d, struct Restrict *r);

/**
 * Get the slot of a package dependency.
 * For example, the package dependency "=cat/pkg-1-r2:3" returns "3".
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
char *pkgcraft_dep_slot(struct Dep *d);

/**
 * Get a package dependency's raw slot operator value.
 * For example, the package dependency "=cat/pkg-1-r2:0=" has an equal slot operator.
 *
 * Returns a value of 0 for nonexistence.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
uint32_t pkgcraft_dep_slot_op(struct Dep *d);

/**
 * Parse a string into a SlotOperator's raw value.
 *
 * Returns a value of 0 for nonexistence.
 *
 * # Safety
 * The argument must be a UTF-8 string.
 */
uint32_t pkgcraft_dep_slot_op_from_str(const char *s);

/**
 * Return the string for a SlotOperator.
 */
char *pkgcraft_dep_slot_op_str(enum SlotOperator op);

/**
 * Return the string for a package dependency.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
char *pkgcraft_dep_str(struct Dep *d);

/**
 * Get the subslot of a package dependency.
 * For example, the package dependency "=cat/pkg-1-r2:3/4" returns "4".
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
char *pkgcraft_dep_subslot(struct Dep *d);

/**
 * Return a package dependency without optional fields.
 *
 * # Safety
 * The argument must a valid Dep pointer.
 */
struct Dep *pkgcraft_dep_unversioned(struct Dep *d);

/**
 * Get the USE dependencies of a package dependency.
 * For example, the package dependency "=cat/pkg-1-r2[a,b,c]" has USE dependencies of "a, b, c".
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
struct UseDep **pkgcraft_dep_use_deps(struct Dep *d, uintptr_t *len);

/**
 * Get the USE dependencies of a package dependency as raw strings.
 * For example, the package dependency "=cat/pkg-1-r2[a,b,c]" has USE dependencies of "a, b, c".
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
char **pkgcraft_dep_use_deps_str(struct Dep *d, uintptr_t *len);

/**
 * Get the version of a package dependency.
 * For example, the package dependency "=cat/pkg-1-r2" returns "1-r2".
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The argument must be a non-null Dep pointer.
 */
struct Version *pkgcraft_dep_version(struct Dep *d);

/**
 * Return a package dependency without optional fields except version.
 *
 * # Safety
 * The argument must a valid Dep pointer.
 */
struct Dep *pkgcraft_dep_versioned(struct Dep *d);

/**
 * Return a package dependency without the specified fields.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The arguments must a valid Dep pointer and DepField values.
 */
struct Dep *pkgcraft_dep_without(struct Dep *d, DepField *fields, uintptr_t len);

/**
 * Compare two Dependencys returning -1, 0, or 1 if the first is less than, equal to, or greater
 * than the second, respectively.
 *
 * # Safety
 * The arguments must be valid Dependency pointers.
 */
int pkgcraft_dependency_cmp(struct Dependency *d1, struct Dependency *d2);

/**
 * Return the conditional for a Dependency.
 *
 * Returns NULL if the Dependency variant isn't conditional.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
struct UseDep *pkgcraft_dependency_conditional(struct Dependency *d);

/**
 * Determine if a Dependency contains a given Dep.
 *
 * # Safety
 * The arguments must be valid pointers.
 */
bool pkgcraft_dependency_contains_dep(struct Dependency *d, struct Dep *dep);

/**
 * Determine if a Dependency contains a given Dependency.
 *
 * # Safety
 * The arguments must be valid Dependency pointers.
 */
bool pkgcraft_dependency_contains_dependency(struct Dependency *d1, struct Dependency *d2);

/**
 * Determine if a Dependency contains a given raw string.
 *
 * # Safety
 * The arguments must be valid pointers.
 */
bool pkgcraft_dependency_contains_str(struct Dependency *d, const char *s);

/**
 * Determine if a Dependency contains a given Uri.
 *
 * # Safety
 * The arguments must be valid pointers.
 */
bool pkgcraft_dependency_contains_uri(struct Dependency *d, struct Uri *uri);

/**
 * Determine if a Dependency contains a given UseDep.
 *
 * # Safety
 * The arguments must be valid pointers.
 */
bool pkgcraft_dependency_contains_use_dep(struct Dependency *d, struct UseDep *u);

/**
 * Evaluate a Dependency.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
struct Dependency **pkgcraft_dependency_evaluate(struct Dependency *d,
                                                 char **options,
                                                 uintptr_t len,
                                                 uintptr_t *deps_len);

/**
 * Forcibly evaluate a Dependency.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
struct Dependency **pkgcraft_dependency_evaluate_force(struct Dependency *d,
                                                       bool force,
                                                       uintptr_t *deps_len);

/**
 * Free a Dependency object.
 *
 * # Safety
 * The argument must be a Dependency pointer or NULL.
 */
void pkgcraft_dependency_free(struct Dependency *r);

/**
 * Create a Dependency from a Dep.
 *
 * # Safety
 * The argument must be valid Dep pointer.
 */
struct Dependency *pkgcraft_dependency_from_dep(struct Dep *d);

/**
 * Return the Dependency for a given index if it exists.
 *
 * Returns NULL on index nonexistence.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
struct Dependency *pkgcraft_dependency_get_index(struct Dependency *d, uintptr_t index);

/**
 * Return the hash value for a Dependency.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
uint64_t pkgcraft_dependency_hash(struct Dependency *d);

/**
 * Return an iterator for a Dependency.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
struct DependencyIntoIter *pkgcraft_dependency_into_iter(struct Dependency *d);

/**
 * Return a conditionals iterator for a Dependency.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
struct DependencyIntoIterConditionals *pkgcraft_dependency_into_iter_conditionals(struct Dependency *d);

/**
 * Return a flatten iterator for a Dependency.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
struct DependencyIntoIterFlatten *pkgcraft_dependency_into_iter_flatten(struct Dependency *d);

/**
 * Return a recursive iterator for a Dependency.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
struct DependencyIntoIterRecursive *pkgcraft_dependency_into_iter_recursive(struct Dependency *d);

/**
 * Return a Dependency's length.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
uintptr_t pkgcraft_dependency_len(struct Dependency *d);

/**
 * Parse a string into a specified Dependency type.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument should be a UTF-8 string.
 */
struct Dependency *pkgcraft_dependency_parse(const char *s,
                                             const struct Eapi *eapi,
                                             enum DependencySetKind kind);

/**
 * Perform a set operation on two DependencySets, assigning to the first.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The arguments must be valid DependencySet pointers.
 */
struct DependencySet *pkgcraft_dependency_set_assign_op_set(enum SetOp op,
                                                            struct DependencySet *d1,
                                                            struct DependencySet *d2);

/**
 * Clone a DependencySet.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
struct DependencySet *pkgcraft_dependency_set_clone(struct DependencySet *d);

/**
 * Determine if a DependencySet contains a given Dep.
 *
 * # Safety
 * The arguments must be valid pointers.
 */
bool pkgcraft_dependency_set_contains_dep(struct DependencySet *d, struct Dep *dep);

/**
 * Determine if a DependencySet contains a given Dependency.
 *
 * # Safety
 * The arguments must be valid DependencySet and Dependency pointers.
 */
bool pkgcraft_dependency_set_contains_dependency(struct DependencySet *s, struct Dependency *d);

/**
 * Determine if a DependencySet contains a given raw string.
 *
 * # Safety
 * The arguments must be valid pointers.
 */
bool pkgcraft_dependency_set_contains_str(struct DependencySet *d, const char *s);

/**
 * Determine if a DependencySet contains a given Uri.
 *
 * # Safety
 * The arguments must be valid pointers.
 */
bool pkgcraft_dependency_set_contains_uri(struct DependencySet *d, struct Uri *uri);

/**
 * Determine if a DependencySet contains a given UseDep.
 *
 * # Safety
 * The arguments must be valid pointers.
 */
bool pkgcraft_dependency_set_contains_use_dep(struct DependencySet *d, struct UseDep *u);

/**
 * Determine if two DependencySets are equal.
 *
 * # Safety
 * The arguments must be valid DependencySet pointers.
 */
bool pkgcraft_dependency_set_eq(struct DependencySet *d1, struct DependencySet *d2);

/**
 * Evaluate a DependencySet.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
struct DependencySet *pkgcraft_dependency_set_evaluate(struct DependencySet *d,
                                                       char **options,
                                                       uintptr_t len);

/**
 * Forcibly evaluate a DependencySet.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
struct DependencySet *pkgcraft_dependency_set_evaluate_force(struct DependencySet *d, bool force);

/**
 * Free a DependencySet.
 *
 * # Safety
 * The argument must be a DependencySet pointer or NULL.
 */
void pkgcraft_dependency_set_free(struct DependencySet *d);

/**
 * Create a DependencySet from an array of Dependency objects.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument should be an array of similarly-typed Dependency objects.
 */
struct DependencySet *pkgcraft_dependency_set_from_iter(struct Dependency **deps,
                                                        uintptr_t len,
                                                        enum DependencySetKind kind);

/**
 * Returns the Dependency element for a given index.
 *
 * Returns NULL on index nonexistence.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
struct Dependency *pkgcraft_dependency_set_get_index(struct DependencySet *d, uintptr_t index);

/**
 * Return the hash value for a DependencySet.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
uint64_t pkgcraft_dependency_set_hash(struct DependencySet *d);

/**
 * Insert a Dependency into a DependencySet.
 *
 * Returns false if an equivalent value already exists, otherwise true.
 *
 * # Safety
 * The arguments must be valid DependencySet and Dependency pointers.
 */
bool pkgcraft_dependency_set_insert(struct DependencySet *d, struct Dependency *value);

/**
 * Return an iterator for a DependencySet.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
struct DependencyIntoIter *pkgcraft_dependency_set_into_iter(struct DependencySet *d);

/**
 * Return a conditionals iterator for a DependencySet.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
struct DependencyIntoIterConditionals *pkgcraft_dependency_set_into_iter_conditionals(struct DependencySet *d);

/**
 * Free a conditionals iterator.
 *
 * # Safety
 * The argument must be a valid DependencyIntoIterConditionals pointer or NULL.
 */
void pkgcraft_dependency_set_into_iter_conditionals_free(struct DependencyIntoIterConditionals *i);

/**
 * Return the next object from a conditionals iterator.
 *
 * Returns NULL when the iterator is empty.
 *
 * # Safety
 * The argument must be a valid DependencyIntoIterConditionals pointer.
 */
struct UseDep *pkgcraft_dependency_set_into_iter_conditionals_next(struct DependencyIntoIterConditionals *i);

/**
 * Return a flatten iterator for a DependencySet.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
struct DependencyIntoIterFlatten *pkgcraft_dependency_set_into_iter_flatten(struct DependencySet *d);

/**
 * Free a flatten iterator.
 *
 * # Safety
 * The argument must be a valid DependencyIntoIterFlatten pointer or NULL.
 */
void pkgcraft_dependency_set_into_iter_flatten_free(struct DependencyIntoIterFlatten *i);

/**
 * Return the next object from a flatten iterator.
 *
 * Returns NULL when the iterator is empty.
 *
 * # Safety
 * The argument must be a valid DependencyIntoIterFlatten pointer.
 */
void *pkgcraft_dependency_set_into_iter_flatten_next(struct DependencyIntoIterFlatten *i);

/**
 * Free a DependencySet iterator.
 *
 * # Safety
 * The argument must be a valid DependencyIntoIter pointer or NULL.
 */
void pkgcraft_dependency_set_into_iter_free(struct DependencyIntoIter *i);

/**
 * Return the next object from a DependencySet iterator.
 *
 * Returns NULL when the iterator is empty.
 *
 * # Safety
 * The argument must be a valid DependencyIntoIter pointer.
 */
struct Dependency *pkgcraft_dependency_set_into_iter_next(struct DependencyIntoIter *i);

/**
 * Return the next object from the end of a DependencySet iterator.
 *
 * Returns NULL when the iterator is empty.
 *
 * # Safety
 * The argument must be a valid DependencyIntoIter pointer.
 */
struct Dependency *pkgcraft_dependency_set_into_iter_next_back(struct DependencyIntoIter *i);

/**
 * Return a recursive iterator for a DependencySet.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
struct DependencyIntoIterRecursive *pkgcraft_dependency_set_into_iter_recursive(struct DependencySet *d);

/**
 * Free a recursive iterator.
 *
 * # Safety
 * The argument must be a valid DependencyIntoIterRecursive pointer or NULL.
 */
void pkgcraft_dependency_set_into_iter_recursive_free(struct DependencyIntoIterRecursive *i);

/**
 * Return the next object from a recursive iterator.
 *
 * Returns NULL when the iterator is empty.
 *
 * # Safety
 * The argument must be a valid DependencyIntoIterRecursive pointer.
 */
struct Dependency *pkgcraft_dependency_set_into_iter_recursive_next(struct DependencyIntoIterRecursive *i);

/**
 * Returns true if two DependencySets have no elements in common.
 *
 * # Safety
 * The arguments must be a valid DependencySet pointers.
 */
bool pkgcraft_dependency_set_is_disjoint(struct DependencySet *d1, struct DependencySet *d2);

/**
 * Returns true if a DependencySet is empty.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
bool pkgcraft_dependency_set_is_empty(struct DependencySet *d);

/**
 * Returns true if all the elements of the first DependencySet are contained in the second.
 *
 * # Safety
 * The arguments must be a valid DependencySet pointers.
 */
bool pkgcraft_dependency_set_is_subset(struct DependencySet *d1, struct DependencySet *d2);

/**
 * Return a DependencySet's length.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
uintptr_t pkgcraft_dependency_set_len(struct DependencySet *d);

/**
 * Create a new, empty DependencySet.
 *
 * # Safety
 * The argument must be a valid DependencySetKind.
 */
struct DependencySet *pkgcraft_dependency_set_new(enum DependencySetKind kind);

/**
 * Perform a set operation on two DependencySets, creating a new set.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The arguments must be valid DependencySet pointers.
 */
struct DependencySet *pkgcraft_dependency_set_op_set(enum SetOp op,
                                                     struct DependencySet *d1,
                                                     struct DependencySet *d2);

/**
 * Parse a string into a specified DependencySet type.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument should be a UTF-8 string.
 */
struct DependencySet *pkgcraft_dependency_set_parse(const char *s,
                                                    const struct Eapi *eapi,
                                                    enum DependencySetKind kind);

/**
 * Remove the last value from a DependencySet.
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
struct Dependency *pkgcraft_dependency_set_pop(struct DependencySet *d);

/**
 * Replace a Dependency with another Dependency in a DependencySet, returning the replaced value.
 *
 * Returns NULL on nonexistence or if the DependencySet already contains the given Dependency.
 *
 * # Safety
 * The arguments must be valid DependencySet and Dependency pointers.
 */
struct Dependency *pkgcraft_dependency_set_replace(struct DependencySet *d,
                                                   const struct Dependency *key,
                                                   struct Dependency *value);

/**
 * Replace a Dependency for a given index in a DependencySet, returning the replaced value.
 *
 * Returns NULL on index nonexistence or if the DependencySet already contains the given Dependency.
 *
 * # Safety
 * The arguments must be valid DependencySet and Dependency pointers.
 */
struct Dependency *pkgcraft_dependency_set_replace_index(struct DependencySet *d,
                                                         uintptr_t index,
                                                         struct Dependency *value);

/**
 * Sort a DependencySet.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
void pkgcraft_dependency_set_sort(struct DependencySet *d);

/**
 * Recursively sort a DependencySet.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
void pkgcraft_dependency_set_sort_recursive(struct DependencySet *d);

/**
 * Return the formatted string for a DependencySet object.
 *
 * # Safety
 * The argument must be a valid DependencySet pointer.
 */
char *pkgcraft_dependency_set_str(struct DependencySet *d);

/**
 * Recursively sort a Dependency.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
void pkgcraft_dependency_sort(struct Dependency *d);

/**
 * Return the formatted string for a Dependency object.
 *
 * # Safety
 * The argument must be a valid Dependency pointer.
 */
char *pkgcraft_dependency_str(struct Dependency *d);

/**
 * Return an EAPI's identifier.
 *
 * # Safety
 * The arguments must be a non-null Eapi pointer.
 */
char *pkgcraft_eapi_as_str(const struct Eapi *eapi);

/**
 * Compare two Eapi objects chronologically returning -1, 0, or 1 if the first is less than, equal
 * to, or greater than the second, respectively.
 *
 * # Safety
 * The arguments must be non-null Eapi pointers.
 */
int pkgcraft_eapi_cmp(const struct Eapi *e1, const struct Eapi *e2);

/**
 * Return the array of dependency keys for an Eapi.
 *
 * # Safety
 * The argument must be a non-null Eapi pointer.
 */
char **pkgcraft_eapi_dep_keys(const struct Eapi *eapi, uintptr_t *len);

/**
 * Get an EAPI from its identifier.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null string.
 */
const struct Eapi *pkgcraft_eapi_from_str(const char *s);

/**
 * Check if an EAPI has a feature.
 *
 * # Safety
 * The arguments must be a non-null Eapi pointer and non-null string.
 */
bool pkgcraft_eapi_has(const struct Eapi *eapi, const char *s);

/**
 * Return the hash value for an Eapi.
 *
 * # Safety
 * The argument must be a non-null Eapi pointer.
 */
uint64_t pkgcraft_eapi_hash(const struct Eapi *eapi);

/**
 * Return the array of metadata keys for an Eapi.
 *
 * # Safety
 * The argument must be a non-null Eapi pointer.
 */
char **pkgcraft_eapi_metadata_keys(const struct Eapi *eapi, uintptr_t *len);

/**
 * Determine if a string is a valid EAPI.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument should point to a UTF-8 string.
 */
const char *pkgcraft_eapi_parse(const char *s);

/**
 * Get all known EAPIS.
 *
 * # Safety
 * The returned array must be freed via pkgcraft_eapis_free().
 */
const struct Eapi **pkgcraft_eapis(uintptr_t *len);

/**
 * Get all official EAPIS.
 *
 * # Safety
 * The returned array must be freed via pkgcraft_eapis_free().
 */
const struct Eapi **pkgcraft_eapis_official(uintptr_t *len);

/**
 * Convert EAPI range into an array of Eapi objects.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null string.
 */
const struct Eapi **pkgcraft_eapis_range(const char *s, uintptr_t *len);

/**
 * Free an error.
 *
 * # Safety
 * The argument must be a non-null PkgcraftError pointer or NULL.
 */
void pkgcraft_error_free(struct PkgcraftError *e);

/**
 * Get the most recent error, returns NULL if none exists.
 */
struct PkgcraftError *pkgcraft_error_last(void);

/**
 * Compare two package keywords returning -1, 0, or 1 if the first is less than, equal to,
 * or greater than the second, respectively.
 *
 * # Safety
 * The arguments must be non-null Keyword pointers.
 */
int pkgcraft_keyword_cmp(struct Keyword *k1, struct Keyword *k2);

/**
 * Free a package keyword.
 *
 * # Safety
 * The argument must be a Keyword pointer or NULL.
 */
void pkgcraft_keyword_free(struct Keyword *k);

/**
 * Return the hash value for a package keyword.
 *
 * # Safety
 * The argument must be a non-null Keyword pointer.
 */
uint64_t pkgcraft_keyword_hash(struct Keyword *k);

/**
 * Parse a string into a package keyword.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null string.
 */
struct Keyword *pkgcraft_keyword_new(const char *s);

/**
 * Return the string for a package keyword.
 *
 * # Safety
 * The argument must be a non-null Keyword pointer.
 */
char *pkgcraft_keyword_str(struct Keyword *k);

/**
 * Return the library version.
 */
char *pkgcraft_lib_version(void);

/**
 * Free a log.
 *
 * # Safety
 * The argument must be a non-null PkgcraftLog pointer or NULL.
 */
void pkgcraft_log_free(struct PkgcraftLog *l);

/**
 * Replay a given PkgcraftLog object for test purposes.
 *
 * # Safety
 * The argument must be a non-null PkgcraftLog pointer.
 */
void pkgcraft_log_test(const char *msg, enum LogLevel level);

/**
 * Enable pkgcraft logging support.
 */
void pkgcraft_logging_enable(LogCallback cb, enum LogLevel level);

/**
 * Verify a package category name is valid.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument be a valid UTF-8 string.
 */
const char *pkgcraft_parse_category(const char *s);

/**
 * Verify a package name is valid.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument be a valid UTF-8 string.
 */
const char *pkgcraft_parse_package(const char *s);

/**
 * Verify a repository name is valid.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument be a valid UTF-8 string.
 */
const char *pkgcraft_parse_repo(const char *s);

/**
 * Verify a package USE flag name is valid.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument be a valid UTF-8 string.
 */
const char *pkgcraft_parse_use_flag(const char *s);

/**
 * Compare two packages returning -1, 0, or 1 if the first package is less than, equal to, or
 * greater than the second package, respectively.
 *
 * # Safety
 * The arguments must be non-null Pkg pointers.
 */
int pkgcraft_pkg_cmp(struct Pkg *p1, struct Pkg *p2);

/**
 * Return a package's CPV.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct Cpv *pkgcraft_pkg_cpv(struct Pkg *p);

/**
 * Return a package's EAPI.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
const struct Eapi *pkgcraft_pkg_eapi(struct Pkg *p);

/**
 * Return a package's BDEPEND.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct DependencySet *pkgcraft_pkg_ebuild_bdepend(struct Pkg *p);

/**
 * Return a package's defined phases.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char **pkgcraft_pkg_ebuild_defined_phases(struct Pkg *p, uintptr_t *len);

/**
 * Return a package's DEPEND.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct DependencySet *pkgcraft_pkg_ebuild_depend(struct Pkg *p);

/**
 * Return a package's dependencies for a given set of descriptors.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct DependencySet *pkgcraft_pkg_ebuild_dependencies(struct Pkg *p, char **keys, uintptr_t len);

/**
 * Return a package's deprecated status.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
bool pkgcraft_pkg_ebuild_deprecated(struct Pkg *p);

/**
 * Return a package's description.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char *pkgcraft_pkg_ebuild_description(struct Pkg *p);

/**
 * Return a package's ebuild file content.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char *pkgcraft_pkg_ebuild_ebuild(struct Pkg *p);

/**
 * Return a package's homepage.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char **pkgcraft_pkg_ebuild_homepage(struct Pkg *p, uintptr_t *len);

/**
 * Return a package's IDEPEND.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct DependencySet *pkgcraft_pkg_ebuild_idepend(struct Pkg *p);

/**
 * Return a package's directly inherited eclasses.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char **pkgcraft_pkg_ebuild_inherit(struct Pkg *p, uintptr_t *len);

/**
 * Return a package's inherited eclasses.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char **pkgcraft_pkg_ebuild_inherited(struct Pkg *p, uintptr_t *len);

/**
 * Return a package's iuse.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char **pkgcraft_pkg_ebuild_iuse(struct Pkg *p, uintptr_t *len);

/**
 * Return a package's keywords.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct Keyword **pkgcraft_pkg_ebuild_keywords(struct Pkg *p, uintptr_t *len);

/**
 * Return a package's keywords as raw strings.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char **pkgcraft_pkg_ebuild_keywords_str(struct Pkg *p, uintptr_t *len);

/**
 * Return a package's LICENSE.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct DependencySet *pkgcraft_pkg_ebuild_license(struct Pkg *p);

/**
 * Return a package's live status.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
bool pkgcraft_pkg_ebuild_live(struct Pkg *p);

/**
 * Return a package's long description.
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char *pkgcraft_pkg_ebuild_long_description(struct Pkg *p);

/**
 * Return a package's maintainers.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct Maintainer **pkgcraft_pkg_ebuild_maintainers(struct Pkg *p, uintptr_t *len);

/**
 * Free an array of Maintainer pointers.
 *
 * # Safety
 * The argument must be the value received from pkgcraft_pkg_ebuild_maintainers() or NULL along
 * with the length of the array.
 */
void pkgcraft_pkg_ebuild_maintainers_free(struct Maintainer **maintainers, uintptr_t len);

/**
 * Return a package's masked status.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
bool pkgcraft_pkg_ebuild_masked(struct Pkg *p);

/**
 * Return a package's path.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char *pkgcraft_pkg_ebuild_path(struct Pkg *p);

/**
 * Return a package's PDEPEND.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct DependencySet *pkgcraft_pkg_ebuild_pdepend(struct Pkg *p);

/**
 * Return a package's PROPERTIES.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct DependencySet *pkgcraft_pkg_ebuild_properties(struct Pkg *p);

/**
 * Return a package's RDEPEND.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct DependencySet *pkgcraft_pkg_ebuild_rdepend(struct Pkg *p);

/**
 * Return a package's REQUIRED_USE.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct DependencySet *pkgcraft_pkg_ebuild_required_use(struct Pkg *p);

/**
 * Return a package's RESTRICT.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct DependencySet *pkgcraft_pkg_ebuild_restrict(struct Pkg *p);

/**
 * Return a package's slot.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char *pkgcraft_pkg_ebuild_slot(struct Pkg *p);

/**
 * Return a package's SRC_URI.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct DependencySet *pkgcraft_pkg_ebuild_src_uri(struct Pkg *p);

/**
 * Return a package's subslot.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char *pkgcraft_pkg_ebuild_subslot(struct Pkg *p);

/**
 * Return a package's upstream info.
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct Upstream *pkgcraft_pkg_ebuild_upstream(struct Pkg *p);

/**
 * Free an Upstream.
 *
 * # Safety
 * The argument must be a Upstream pointer or NULL.
 */
void pkgcraft_pkg_ebuild_upstream_free(struct Upstream *u);

/**
 * Return a package's format.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
enum PkgFormat pkgcraft_pkg_format(struct Pkg *p);

/**
 * Free an package.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer or NULL.
 */
void pkgcraft_pkg_free(struct Pkg *p);

/**
 * Return the hash value for a package.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
uint64_t pkgcraft_pkg_hash(struct Pkg *p);

/**
 * Determine if a package intersects with a Cpn.
 *
 * # Safety
 * The arguments should be non-null pointers.
 */
bool pkgcraft_pkg_intersects_cpn(struct Pkg *p, struct Cpn *c);

/**
 * Determine if a package intersects with a Cpv.
 *
 * # Safety
 * The arguments should be non-null pointers.
 */
bool pkgcraft_pkg_intersects_cpv(struct Pkg *p, struct Cpv *c);

/**
 * Determine if a package intersects with a package dependency.
 *
 * # Safety
 * The arguments should be non-null pointers.
 */
bool pkgcraft_pkg_intersects_dep(struct Pkg *p, struct Dep *d);

/**
 * Return a package's repo.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
const struct Repo *pkgcraft_pkg_repo(struct Pkg *p);

/**
 * Return the restriction for a package.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct Restrict *pkgcraft_pkg_restrict(struct Pkg *p);

/**
 * Determine if a restriction matches a package.
 *
 * # Safety
 * The arguments must be valid Restrict and Pkg pointers.
 */
bool pkgcraft_pkg_restrict_matches(struct Pkg *p, struct Restrict *r);

/**
 * Return the string for a package.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
char *pkgcraft_pkg_str(struct Pkg *p);

/**
 * Return a package's version.
 *
 * # Safety
 * The argument must be a non-null Pkg pointer.
 */
struct Version *pkgcraft_pkg_version(struct Pkg *p);

/**
 * Return a repo's categories.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
char **pkgcraft_repo_categories(struct Repo *r, uintptr_t *len);

/**
 * Compare two repos returning -1, 0, or 1 if the first repo is less than, equal to, or greater
 * than the second repo, respectively.
 *
 * # Safety
 * The arguments must be non-null Repo pointers.
 */
int pkgcraft_repo_cmp(struct Repo *r1, struct Repo *r2);

/**
 * Determine if a path is in a repo.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
bool pkgcraft_repo_contains_path(struct Repo *r, const char *path);

/**
 * Return a configured repo using the given config.
 *
 * # Safety
 * The arguments must be valid Repo and Config pointers.
 */
struct Repo *pkgcraft_repo_ebuild_configure(struct Repo *r, struct Config *c);

/**
 * Return an ebuild repo's EAPI.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
const struct Eapi *pkgcraft_repo_ebuild_eapi(struct Repo *r);

/**
 * Return an ebuild repo's inherited licenses.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
char **pkgcraft_repo_ebuild_licenses(struct Repo *r, uintptr_t *len);

/**
 * Return an ebuild repo's masters.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
struct Repo **pkgcraft_repo_ebuild_masters(struct Repo *r, uintptr_t *len);

/**
 * Return an ebuild repo's metadata arches.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
char **pkgcraft_repo_ebuild_metadata_arches(struct Repo *r, uintptr_t *len);

/**
 * Return an ebuild repo's metadata categories.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
char **pkgcraft_repo_ebuild_metadata_categories(struct Repo *r, uintptr_t *len);

/**
 * Return an ebuild repo's metadata licenses.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
char **pkgcraft_repo_ebuild_metadata_licenses(struct Repo *r, uintptr_t *len);

/**
 * Regenerate an ebuild repo's package metadata cache.
 *
 * Returns false on error, otherwise true.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
bool pkgcraft_repo_ebuild_metadata_regen(struct Repo *r, uintptr_t jobs, bool force, char *path);

/**
 * Create an ebuild file in the repo.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null EbuildTempRepo pointer.
 */
char *pkgcraft_repo_ebuild_temp_create_ebuild(EbuildTempRepo *r,
                                              const char *cpv,
                                              char **key_vals,
                                              uintptr_t len);

/**
 * Create an ebuild file in the repo from raw data.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null EbuildTempRepo pointer.
 */
char *pkgcraft_repo_ebuild_temp_create_ebuild_raw(EbuildTempRepo *r,
                                                  const char *cpv,
                                                  const char *data);

/**
 * Free a temporary repo.
 *
 * Freeing a temporary repo removes the related directory from the filesystem.
 *
 * # Safety
 * The argument must be a EbuildTempRepo pointer or NULL.
 */
void pkgcraft_repo_ebuild_temp_free(EbuildTempRepo *r);

/**
 * Create a temporary ebuild repository.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The id argument should be a valid, unicode string and the eapi parameter can optionally be
 * NULL.
 */
EbuildTempRepo *pkgcraft_repo_ebuild_temp_new(const char *id, const struct Eapi *eapi);

/**
 * Return a temporary repo's path.
 *
 * # Safety
 * The argument must be a non-null EbuildTempRepo pointer.
 */
char *pkgcraft_repo_ebuild_temp_path(EbuildTempRepo *r);

/**
 * Persist a temporary repo to disk, returning its path.
 *
 * # Safety
 * The related EbuildTempRepo pointer is invalid on function completion and should not be used.
 */
char *pkgcraft_repo_ebuild_temp_persist(EbuildTempRepo *r, const char *path);

/**
 * Add pkgs to an existing fake repo from an array of CPV strings.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The arguments must be a non-null Repo pointer and an array of CPV strings.
 */
struct Repo *pkgcraft_repo_fake_extend(struct Repo *r, char **cpvs, uintptr_t len);

/**
 * Create a fake repo from an array of CPV strings.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The cpvs argument should be valid CPV strings.
 */
struct Repo *pkgcraft_repo_fake_new(const char *id, int priority, char **cpvs, uintptr_t len);

/**
 * Return a repos's format.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
enum RepoFormat pkgcraft_repo_format(struct Repo *r);

/**
 * Free a repo.
 *
 * # Safety
 * The argument must be a Repo pointer or NULL.
 */
void pkgcraft_repo_free(struct Repo *r);

/**
 * Try to load a certain repo type from a given path.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The path argument should be a valid path on the system.
 */
struct Repo *pkgcraft_repo_from_format(enum RepoFormat format,
                                       const char *id,
                                       int priority,
                                       const char *path,
                                       bool finalize);

/**
 * Load a repo from a given path.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The path argument should be a valid path on the system.
 */
struct Repo *pkgcraft_repo_from_path(const char *id, int priority, const char *path, bool finalize);

/**
 * Return the hash value for a repo.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
uint64_t pkgcraft_repo_hash(struct Repo *r);

/**
 * Return a repo's id.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
char *pkgcraft_repo_id(struct Repo *r);

/**
 * Determine if a repo is empty.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
bool pkgcraft_repo_is_empty(struct Repo *r);

/**
 * Return a package iterator for a repo.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
RepoIter *pkgcraft_repo_iter(struct Repo *r);

/**
 * Return a Cpv iterator for a repo.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
RepoIterCpv *pkgcraft_repo_iter_cpv(struct Repo *r);

/**
 * Free a repo Cpv iterator.
 *
 * # Safety
 * The argument must be a non-null RepoIterCpv pointer or NULL.
 */
void pkgcraft_repo_iter_cpv_free(RepoIterCpv *i);

/**
 * Return the next Cpv from a repo Cpv iterator.
 *
 * Returns NULL when the iterator is empty.
 *
 * # Safety
 * The argument must be a non-null RepoIterCpv pointer.
 */
struct Cpv *pkgcraft_repo_iter_cpv_next(RepoIterCpv *i);

/**
 * Free a repo iterator.
 *
 * # Safety
 * The argument must be a non-null RepoIter pointer or NULL.
 */
void pkgcraft_repo_iter_free(RepoIter *i);

/**
 * Return the next package from a package iterator.
 *
 * Returns NULL when the iterator is empty.
 *
 * # Safety
 * The argument must be a non-null RepoIter pointer.
 */
struct Pkg *pkgcraft_repo_iter_next(RepoIter *i);

/**
 * Return a restriction package iterator for a repo.
 *
 * # Safety
 * The repo argument must be a non-null Repo pointer and the restrict argument must be a non-null
 * Restrict pointer.
 */
RepoIterRestrict *pkgcraft_repo_iter_restrict(struct Repo *repo, struct Restrict *restrict);

/**
 * Free a repo restriction iterator.
 *
 * # Safety
 * The argument must be a non-null RepoIterRestrict pointer or NULL.
 */
void pkgcraft_repo_iter_restrict_free(RepoIterRestrict *i);

/**
 * Return the next package from a restriction package iterator.
 *
 * Returns NULL when the iterator is empty.
 *
 * # Safety
 * The argument must be a non-null RepoIterRestrict pointer.
 */
struct Pkg *pkgcraft_repo_iter_restrict_next(RepoIterRestrict *i);

/**
 * Return a repo's length.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
uintptr_t pkgcraft_repo_len(struct Repo *r);

/**
 * Return a repo's packages for a category.
 *
 * # Safety
 * The arguments must be a non-null Repo pointer and category.
 */
char **pkgcraft_repo_packages(struct Repo *r, const char *cat, uintptr_t *len);

/**
 * Return a repo's path.
 *
 * # Safety
 * The argument must be a non-null Repo pointer.
 */
char *pkgcraft_repo_path(struct Repo *r);

/**
 * Perform a set operation on a repo set and repo, assigning to the set.
 *
 * # Safety
 * The arguments must be non-null RepoSet and Repo pointers.
 */
void pkgcraft_repo_set_assign_op_repo(enum SetOp op, struct RepoSet *s, struct Repo *r);

/**
 * Perform a set operation on two repo sets, assigning to the first set.
 *
 * # Safety
 * The arguments must be non-null RepoSet pointers.
 */
void pkgcraft_repo_set_assign_op_set(enum SetOp op, struct RepoSet *s1, struct RepoSet *s2);

/**
 * Return a repo set's categories.
 *
 * # Safety
 * The argument must be a non-null RepoSet pointer.
 */
char **pkgcraft_repo_set_categories(struct RepoSet *s, uintptr_t *len);

/**
 * Compare two repo sets returning -1, 0, or 1 if the first set is less than, equal to, or greater
 * than the second set, respectively.
 *
 * # Safety
 * The arguments must be non-null RepoSet pointers.
 */
int pkgcraft_repo_set_cmp(struct RepoSet *s1, struct RepoSet *s2);

/**
 * Free a repo set.
 *
 * # Safety
 * The argument must be a RepoSet pointer or NULL.
 */
void pkgcraft_repo_set_free(struct RepoSet *r);

/**
 * Return the hash value for a repo set.
 *
 * # Safety
 * The argument must be a non-null RepoSet pointer.
 */
uint64_t pkgcraft_repo_set_hash(struct RepoSet *s);

/**
 * Determine if a repo set is empty.
 *
 * # Safety
 * The argument must be a non-null RepoSet pointer.
 */
bool pkgcraft_repo_set_is_empty(struct RepoSet *s);

/**
 * Return a package iterator for a repo set.
 *
 * # Safety
 * The repo argument must be a non-null Repo pointer and the restrict argument can be a
 * Restrict pointer or NULL to iterate over all packages.
 */
RepoSetIter *pkgcraft_repo_set_iter(struct RepoSet *s, struct Restrict *restrict);

/**
 * Free a repo set iterator.
 *
 * # Safety
 * The argument must be a non-null RepoSetIter pointer or NULL.
 */
void pkgcraft_repo_set_iter_free(RepoSetIter *i);

/**
 * Return the next package from a repo set package iterator.
 *
 * Returns NULL when the iterator is empty.
 *
 * # Safety
 * The argument must be a non-null RepoSetIter pointer.
 */
struct Pkg *pkgcraft_repo_set_iter_next(RepoSetIter *i);

/**
 * Return a repo set's length.
 *
 * # Safety
 * The argument must be a non-null RepoSet pointer.
 */
uintptr_t pkgcraft_repo_set_len(struct RepoSet *s);

/**
 * Create a repo set.
 *
 * # Safety
 * The argument must be an array of Repo pointers.
 */
struct RepoSet *pkgcraft_repo_set_new(struct Repo **repos, uintptr_t len);

/**
 * Perform a set operation on a repo set and repo, creating a new set.
 *
 * # Safety
 * The arguments must be non-null RepoSet and Repo pointers.
 */
struct RepoSet *pkgcraft_repo_set_op_repo(enum SetOp op, struct RepoSet *s, struct Repo *r);

/**
 * Perform a set operation on two repo sets, creating a new set.
 *
 * # Safety
 * The arguments must be non-null RepoSet pointers.
 */
struct RepoSet *pkgcraft_repo_set_op_set(enum SetOp op, struct RepoSet *s1, struct RepoSet *s2);

/**
 * Return a repo set's packages for a category.
 *
 * # Safety
 * The arguments must be a non-null RepoSet pointer and category.
 */
char **pkgcraft_repo_set_packages(struct RepoSet *s, const char *cat, uintptr_t *len);

/**
 * Return the ordered array of repos for a repo set.
 *
 * # Safety
 * The argument must be a non-null RepoSet pointer.
 */
const struct Repo **pkgcraft_repo_set_repos(struct RepoSet *s, uintptr_t *len);

/**
 * Return a repo set's versions for a package.
 *
 * # Safety
 * The arguments must be a non-null RepoSet pointer, category, and package.
 */
struct Version **pkgcraft_repo_set_versions(struct RepoSet *s,
                                            const char *cat,
                                            const char *pkg,
                                            uintptr_t *len);

/**
 * Return a repo's versions for a package.
 *
 * # Safety
 * The arguments must be a non-null Repo pointer, category, and package.
 */
struct Version **pkgcraft_repo_versions(struct Repo *r,
                                        const char *cat,
                                        const char *pkg,
                                        uintptr_t *len);

/**
 * Create a new restriction combining two restrictions via logical AND.
 *
 * # Safety
 * The arguments must be Restrict pointers.
 */
struct Restrict *pkgcraft_restrict_and(struct Restrict *r1, struct Restrict *r2);

/**
 * Determine if two restrictions are equal.
 *
 * # Safety
 * The arguments must be non-null Restrict pointers.
 */
bool pkgcraft_restrict_eq(struct Restrict *r1, struct Restrict *r2);

/**
 * Free a restriction.
 *
 * # Safety
 * The argument must be a Restrict pointer or NULL.
 */
void pkgcraft_restrict_free(struct Restrict *r);

/**
 * Return the hash value for a restriction.
 *
 * # Safety
 * The argument must be a non-null Restrict pointer.
 */
uint64_t pkgcraft_restrict_hash(struct Restrict *r);

/**
 * Create a new restriction inverting a restriction via logical NOT.
 *
 * # Safety
 * The arguments must be a Restrict pointer.
 */
struct Restrict *pkgcraft_restrict_not(struct Restrict *r);

/**
 * Create a new restriction combining two restrictions via logical OR.
 *
 * # Safety
 * The arguments must be Restrict pointers.
 */
struct Restrict *pkgcraft_restrict_or(struct Restrict *r1, struct Restrict *r2);

/**
 * Parse a dependency restriction.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null string.
 */
struct Restrict *pkgcraft_restrict_parse_dep(const char *s);

/**
 * Parse a package query restriction.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null string.
 */
struct Restrict *pkgcraft_restrict_parse_pkg(const char *s);

/**
 * Create a new restriction combining two restrictions via logical XOR.
 *
 * # Safety
 * The arguments must be Restrict pointers.
 */
struct Restrict *pkgcraft_restrict_xor(struct Restrict *r1, struct Restrict *r2);

/**
 * Compare two revisions returning -1, 0, or 1 if the first is less than, equal to, or greater
 * than the second, respectively.
 *
 * # Safety
 * The revision arguments should be non-null Revision pointers.
 */
int pkgcraft_revision_cmp(struct Revision *r1, struct Revision *r2);

/**
 * Free a revision.
 *
 * # Safety
 * The revision argument should be a non-null Revision pointer.
 */
void pkgcraft_revision_free(struct Revision *r);

/**
 * Return the hash value for a revision.
 *
 * # Safety
 * The revision argument should be a non-null Revision pointer.
 */
uint64_t pkgcraft_revision_hash(struct Revision *r);

/**
 * Parse a string into a revision.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument should be a valid UTF-8 string.
 */
struct Revision *pkgcraft_revision_new(const char *s);

/**
 * Return a revision's string value.
 *
 * # Safety
 * The revision argument should be a non-null Revision pointer.
 */
char *pkgcraft_revision_str(struct Revision *r);

/**
 * Free an array of strings.
 *
 * # Safety
 * The argument must be a pointer to a string array or NULL along with the length of the array.
 */
void pkgcraft_str_array_free(char **strs, uintptr_t len);

/**
 * Free a string.
 *
 * # Safety
 * The argument must be a string pointer or NULL.
 */
void pkgcraft_str_free(char *s);

/**
 * Get the filename for a Uri.
 *
 * # Safety
 * The argument must be a Uri pointer.
 */
char *pkgcraft_uri_filename(struct Uri *u);

/**
 * Free a Uri object.
 *
 * # Safety
 * The argument must be a valid Uri pointer or NULL.
 */
void pkgcraft_uri_free(struct Uri *u);

/**
 * Return the formatted string for a Uri object.
 *
 * # Safety
 * The argument must be a Uri pointer.
 */
char *pkgcraft_uri_str(struct Uri *u);

/**
 * Get the main URI from a Uri object.
 *
 * # Safety
 * The argument must be a Uri pointer.
 */
char *pkgcraft_uri_uri(struct Uri *u);

/**
 * Compare two package USE dependencies returning -1, 0, or 1 if the first is less than, equal to,
 * or greater than the second, respectively.
 *
 * # Safety
 * The arguments must be non-null UseDep pointers.
 */
int pkgcraft_use_dep_cmp(struct UseDep *u1, struct UseDep *u2);

/**
 * Free a package USE dependency.
 *
 * # Safety
 * The argument must be a UseDep pointer or NULL.
 */
void pkgcraft_use_dep_free(struct UseDep *u);

/**
 * Return the hash value for a package USE dependency.
 *
 * # Safety
 * The argument must be a non-null UseDep pointer.
 */
uint64_t pkgcraft_use_dep_hash(struct UseDep *u);

/**
 * Parse a string into a package USE dependency.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null string.
 */
struct UseDep *pkgcraft_use_dep_new(const char *s);

/**
 * Return the string for a package USE dependency.
 *
 * # Safety
 * The argument must be a non-null UseDep pointer.
 */
char *pkgcraft_use_dep_str(struct UseDep *u);

/**
 * Return a version's base, e.g. the version "1-r2" has a base of "1".
 *
 * # Safety
 * The version argument should be a non-null Version pointer.
 */
char *pkgcraft_version_base(struct Version *v);

/**
 * Compare two versions returning -1, 0, or 1 if the first is less than, equal to, or greater than
 * the second, respectively.
 *
 * # Safety
 * The version arguments should be non-null Version pointers.
 */
int pkgcraft_version_cmp(struct Version *v1, struct Version *v2);

/**
 * Free a version.
 *
 * # Safety
 * The version argument should be a non-null Version pointer.
 */
void pkgcraft_version_free(struct Version *v);

/**
 * Return the hash value for a version.
 *
 * # Safety
 * The version argument should be a non-null Version pointer.
 */
uint64_t pkgcraft_version_hash(struct Version *v);

/**
 * Determine if two versions intersect.
 *
 * # Safety
 * The version arguments should be non-null Version pointers.
 */
bool pkgcraft_version_intersects(struct Version *v1, struct Version *v2);

/**
 * Parse a string into a version.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The version argument should point to a valid string.
 */
struct Version *pkgcraft_version_new(const char *s);

/**
 * Return a version operator's raw value.
 *
 * Returns a value of 0 for nonexistence.
 *
 * # Safety
 * The argument must be a non-null Version pointer.
 */
uint32_t pkgcraft_version_op(struct Version *v);

/**
 * Parse a string into an Operator's raw value.
 *
 * Returns a value of 0 for nonexistence.
 *
 * # Safety
 * The argument should be a UTF-8 string.
 */
uint32_t pkgcraft_version_op_from_str(const char *s);

/**
 * Return the string for an Operator.
 */
char *pkgcraft_version_op_str(enum Operator op);

/**
 * Determine if a string is a valid package version.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument should point to a UTF-8 string.
 */
const char *pkgcraft_version_parse(const char *s);

/**
 * Return a version's revision, e.g. the version "1-r2" has a revision of "2".
 *
 * Returns NULL on nonexistence.
 *
 * # Safety
 * The version argument should be a non-null Version pointer.
 */
struct Revision *pkgcraft_version_revision(struct Version *v);

/**
 * Return a version's string value without operator.
 *
 * # Safety
 * The version argument should be a non-null Version pointer.
 */
char *pkgcraft_version_str(struct Version *v);

/**
 * Potentially create a new Version by applying an operator.
 *
 * Returns NULL on error.
 *
 * # Safety
 * The argument must be a non-null Version pointer.
 */
struct Version *pkgcraft_version_with_op(struct Version *v, enum Operator op);

#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus

#endif  /* PKGCRAFT_H */
