/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import com.oracle.bmc.util.internal.ClientCompatibilityChecker;
import com.oracle.bmc.util.internal.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(ClientRuntime.class);
    public static final String SDK_VERSION_PROPERTY_NAME = "sdk.version";
    private static String clientUserAgent;
    private final String userAgent;
    private final String clientInfo;
    private final String sdkVersion;
    private final ClientCompatibilityChecker clientCompatibilityChecker;
    private static final String ENV_VAR_USER_AGENT = "OCI_SDK_APPEND_USER_AGENT";

    public static void setClientUserAgent(String clientUserAgent) {
        ClientRuntime.clientUserAgent = clientUserAgent;
    }

    ClientRuntime() {
        String os = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String javaVersion = System.getProperty("java.version");
        String javaVmName = System.getProperty("java.vm.name");
        String javaVmVersion = System.getProperty("java.vm.version");
        Properties sdkProperties = ClientRuntime.getSdkProperties();
        this.sdkVersion = ClientRuntime.extractSdkVersionFromProperties(sdkProperties);
        this.clientCompatibilityChecker = new ClientCompatibilityChecker(sdkProperties);
        String userAgentFromEnvVar = System.getenv(ENV_VAR_USER_AGENT);
        String ociSdkAppendUserAgent = StringUtils.isBlank(userAgentFromEnvVar) ? "" : " " + userAgentFromEnvVar.trim();
        String clientInfoFormat = "Oracle-JavaSDK/%s";
        this.clientInfo = String.format("Oracle-JavaSDK/%s", this.sdkVersion);
        String additionalUserAgentFromClient = clientUserAgent != null && !clientUserAgent.trim().isEmpty() ? " " + clientUserAgent.trim() : "";
        String agentFormat = "%s (%s/%s; Java/%s; %s/%s)%s%s";
        this.userAgent = String.format("%s (%s/%s; Java/%s; %s/%s)%s%s", this.clientInfo, os, osVersion, javaVersion, javaVmName, javaVmVersion, additionalUserAgentFromClient, ociSdkAppendUserAgent);
        LOG.info("Using SDK: {}", (Object)this.clientInfo);
        LOG.info("User agent set to: {}", (Object)this.userAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties getSdkProperties() {
        InputStream propertyStream = ClientRuntime.class.getClassLoader().getResourceAsStream("com/oracle/bmc/sdk.properties");
        Properties properties = new Properties();
        try {
            properties.load(propertyStream);
        }
        catch (Exception e) {
            LOG.error("Failed to load sdk.properties", (Throwable)e);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            try {
                propertyStream.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close property stream correctly", (Throwable)e);
            }
        }
        return properties;
    }

    public static String extractSdkVersionFromProperties(Properties sdkProperties) {
        return sdkProperties.getProperty(SDK_VERSION_PROPERTY_NAME, "Unknown");
    }

    public static ClientRuntime getRuntime() {
        return RuntimeInstance.INSTANCE;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public ClientCompatibilityChecker getClientCompatibilityChecker() {
        return this.clientCompatibilityChecker;
    }

    private static class RuntimeInstance {
        private static final ClientRuntime INSTANCE = new ClientRuntime();

        private RuntimeInstance() {
        }
    }
}

