/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/injection/CodeFenceHighlightInfoFilter;", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoFilter;", "<init>", "()V", "accept", "", "highlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "psiFile", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.markdown"})
public final class CodeFenceHighlightInfoFilter
implements HighlightInfoFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<HighlightSeverity> internalSeverities;

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)highlightInfo, (String)"highlightInfo");
        if (psiFile == null) {
            return true;
        }
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project2);
        PsiFile psiFile2 = manager.getTopLevelFile((PsiElement)psiFile);
        if (psiFile2 == null) {
            return true;
        }
        PsiFile topLevelFile = psiFile2;
        if (Intrinsics.areEqual((Object)topLevelFile.getFileType(), (Object)((Object)MarkdownFileType.INSTANCE)) && manager.getInjectionHost((PsiElement)psiFile) instanceof MarkdownCodeFence && !internalSeverities.contains(highlightInfo.getSeverity())) {
            return MarkdownSettings.Companion.getInstance(project2).getShowProblemsInCodeBlocks();
        }
        return true;
    }

    static {
        Object[] objectArray = new HighlightSeverity[]{HighlightInfoType.SYMBOL_TYPE_SEVERITY, HighlightInfoType.INJECTED_FRAGMENT_SYNTAX_SEVERITY, HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY, HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY, HighlightSeverity.TEXT_ATTRIBUTES};
        internalSeverities = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/injection/CodeFenceHighlightInfoFilter$Companion;", "", "<init>", "()V", "internalSeverities", "", "Lcom/intellij/lang/annotation/HighlightSeverity;", "kotlin.jvm.PlatformType", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

