// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The content filter for a guardrail.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailContentFilter {
    /// <p>The guardrail type.</p>
    pub r#type: crate::types::GuardrailContentFilterType,
    /// <p>The guardrail confidence.</p>
    pub confidence: crate::types::GuardrailContentFilterConfidence,
    /// <p>The filter strength setting for the guardrail content filter.</p>
    pub filter_strength: ::std::option::Option<crate::types::GuardrailContentFilterStrength>,
    /// <p>The guardrail action.</p>
    pub action: crate::types::GuardrailContentPolicyAction,
    /// <p>Indicates whether content that breaches the guardrail configuration is detected.</p>
    pub detected: ::std::option::Option<bool>,
}
impl GuardrailContentFilter {
    /// <p>The guardrail type.</p>
    pub fn r#type(&self) -> &crate::types::GuardrailContentFilterType {
        &self.r#type
    }
    /// <p>The guardrail confidence.</p>
    pub fn confidence(&self) -> &crate::types::GuardrailContentFilterConfidence {
        &self.confidence
    }
    /// <p>The filter strength setting for the guardrail content filter.</p>
    pub fn filter_strength(&self) -> ::std::option::Option<&crate::types::GuardrailContentFilterStrength> {
        self.filter_strength.as_ref()
    }
    /// <p>The guardrail action.</p>
    pub fn action(&self) -> &crate::types::GuardrailContentPolicyAction {
        &self.action
    }
    /// <p>Indicates whether content that breaches the guardrail configuration is detected.</p>
    pub fn detected(&self) -> ::std::option::Option<bool> {
        self.detected
    }
}
impl GuardrailContentFilter {
    /// Creates a new builder-style object to manufacture [`GuardrailContentFilter`](crate::types::GuardrailContentFilter).
    pub fn builder() -> crate::types::builders::GuardrailContentFilterBuilder {
        crate::types::builders::GuardrailContentFilterBuilder::default()
    }
}

/// A builder for [`GuardrailContentFilter`](crate::types::GuardrailContentFilter).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailContentFilterBuilder {
    pub(crate) r#type: ::std::option::Option<crate::types::GuardrailContentFilterType>,
    pub(crate) confidence: ::std::option::Option<crate::types::GuardrailContentFilterConfidence>,
    pub(crate) filter_strength: ::std::option::Option<crate::types::GuardrailContentFilterStrength>,
    pub(crate) action: ::std::option::Option<crate::types::GuardrailContentPolicyAction>,
    pub(crate) detected: ::std::option::Option<bool>,
}
impl GuardrailContentFilterBuilder {
    /// <p>The guardrail type.</p>
    /// This field is required.
    pub fn r#type(mut self, input: crate::types::GuardrailContentFilterType) -> Self {
        self.r#type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The guardrail type.</p>
    pub fn set_type(mut self, input: ::std::option::Option<crate::types::GuardrailContentFilterType>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>The guardrail type.</p>
    pub fn get_type(&self) -> &::std::option::Option<crate::types::GuardrailContentFilterType> {
        &self.r#type
    }
    /// <p>The guardrail confidence.</p>
    /// This field is required.
    pub fn confidence(mut self, input: crate::types::GuardrailContentFilterConfidence) -> Self {
        self.confidence = ::std::option::Option::Some(input);
        self
    }
    /// <p>The guardrail confidence.</p>
    pub fn set_confidence(mut self, input: ::std::option::Option<crate::types::GuardrailContentFilterConfidence>) -> Self {
        self.confidence = input;
        self
    }
    /// <p>The guardrail confidence.</p>
    pub fn get_confidence(&self) -> &::std::option::Option<crate::types::GuardrailContentFilterConfidence> {
        &self.confidence
    }
    /// <p>The filter strength setting for the guardrail content filter.</p>
    pub fn filter_strength(mut self, input: crate::types::GuardrailContentFilterStrength) -> Self {
        self.filter_strength = ::std::option::Option::Some(input);
        self
    }
    /// <p>The filter strength setting for the guardrail content filter.</p>
    pub fn set_filter_strength(mut self, input: ::std::option::Option<crate::types::GuardrailContentFilterStrength>) -> Self {
        self.filter_strength = input;
        self
    }
    /// <p>The filter strength setting for the guardrail content filter.</p>
    pub fn get_filter_strength(&self) -> &::std::option::Option<crate::types::GuardrailContentFilterStrength> {
        &self.filter_strength
    }
    /// <p>The guardrail action.</p>
    /// This field is required.
    pub fn action(mut self, input: crate::types::GuardrailContentPolicyAction) -> Self {
        self.action = ::std::option::Option::Some(input);
        self
    }
    /// <p>The guardrail action.</p>
    pub fn set_action(mut self, input: ::std::option::Option<crate::types::GuardrailContentPolicyAction>) -> Self {
        self.action = input;
        self
    }
    /// <p>The guardrail action.</p>
    pub fn get_action(&self) -> &::std::option::Option<crate::types::GuardrailContentPolicyAction> {
        &self.action
    }
    /// <p>Indicates whether content that breaches the guardrail configuration is detected.</p>
    pub fn detected(mut self, input: bool) -> Self {
        self.detected = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether content that breaches the guardrail configuration is detected.</p>
    pub fn set_detected(mut self, input: ::std::option::Option<bool>) -> Self {
        self.detected = input;
        self
    }
    /// <p>Indicates whether content that breaches the guardrail configuration is detected.</p>
    pub fn get_detected(&self) -> &::std::option::Option<bool> {
        &self.detected
    }
    /// Consumes the builder and constructs a [`GuardrailContentFilter`](crate::types::GuardrailContentFilter).
    /// This method will fail if any of the following fields are not set:
    /// - [`r#type`](crate::types::builders::GuardrailContentFilterBuilder::type)
    /// - [`confidence`](crate::types::builders::GuardrailContentFilterBuilder::confidence)
    /// - [`action`](crate::types::builders::GuardrailContentFilterBuilder::action)
    pub fn build(self) -> ::std::result::Result<crate::types::GuardrailContentFilter, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::GuardrailContentFilter {
            r#type: self.r#type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "r#type",
                    "r#type was not specified but it is required when building GuardrailContentFilter",
                )
            })?,
            confidence: self.confidence.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "confidence",
                    "confidence was not specified but it is required when building GuardrailContentFilter",
                )
            })?,
            filter_strength: self.filter_strength,
            action: self.action.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "action",
                    "action was not specified but it is required when building GuardrailContentFilter",
                )
            })?,
            detected: self.detected,
        })
    }
}
