# Environment variables

uv defines and respects the following environment variables:

### `UV_BREAK_SYSTEM_PACKAGES`

Equivalent to the `--break-system-packages` command-line argument. If set to `true`,
uv will allow the installation of packages that conflict with system-installed packages.

WARNING: `UV_BREAK_SYSTEM_PACKAGES=true` is intended for use in continuous integration
(CI) or containerized environments and should be used with caution, as modifying the system
Python can lead to unexpected behavior.

### `UV_BUILD_CONSTRAINT`

Equivalent to the `--build-constraint` command-line argument. If set, uv will use this file
as constraints for any source distribution builds. Uses space-separated list of files.

### `UV_CACHE_DIR`

Equivalent to the `--cache-dir` command-line argument. If set, uv will use this
directory for caching instead of the default cache directory.

### `UV_COMPILE_BYTECODE`

Equivalent to the `--compile-bytecode` command-line argument. If set, uv
will compile Python source files to bytecode after installation.

### `UV_COMPILE_BYTECODE_TIMEOUT`

Timeout (in seconds) for bytecode compilation.

### `UV_CONCURRENT_BUILDS`

Sets the maximum number of source distributions that uv will build
concurrently at any given time.

### `UV_CONCURRENT_DOWNLOADS`

Sets the maximum number of in-flight concurrent downloads that uv will
perform at any given time.

### `UV_CONCURRENT_INSTALLS`

Controls the number of threads used when installing and unzipping
packages.

### `UV_CONFIG_FILE`

Equivalent to the `--config-file` command-line argument. Expects a path to a
local `uv.toml` file to use as the configuration file.

### `UV_CONSTRAINT`

Equivalent to the `--constraint` command-line argument. If set, uv will use this
file as the constraints file. Uses space-separated list of files.

### `UV_CREDENTIALS_DIR`

The directory for storage of credentials when using a plain text backend.

### `UV_CUSTOM_COMPILE_COMMAND`

Equivalent to the `--custom-compile-command` command-line argument.

Used to override uv in the output header of the `requirements.txt` files generated by
`uv pip compile`. Intended for use-cases in which `uv pip compile` is called from within a wrapper
script, to include the name of the wrapper script in the output file.

### `UV_DEFAULT_INDEX`

Equivalent to the `--default-index` command-line argument. If set, uv will use
this URL as the default index when searching for packages.

### `UV_DEV`

Equivalent to the `--dev` command-line argument. If set, uv will include
development dependencies.

### `UV_DOWNLOAD_URL`

The URL from which to download uv using the standalone installer. By default, installs from
uv's GitHub Releases. `INSTALLER_DOWNLOAD_URL` is also supported as an alias, for backwards
compatibility.

### `UV_ENV_FILE`

`.env` files from which to load environment variables when executing `uv run` commands.

### `UV_EXCLUDE_NEWER`

Equivalent to the `--exclude-newer` command-line argument. If set, uv will
exclude distributions published after the specified date.

### `UV_EXTRA_INDEX_URL`

Equivalent to the `--extra-index-url` command-line argument. If set, uv will
use this space-separated list of URLs as additional indexes when searching for packages.
(Deprecated: use `UV_INDEX` instead.)

### `UV_FIND_LINKS`

Equivalent to the `--find-links` command-line argument. If set, uv will use this
comma-separated list of additional locations to search for packages.

### `UV_FORK_STRATEGY`

Equivalent to the `--fork-strategy` argument. Controls version selection during universal
resolution.

### `UV_FROZEN`

Equivalent to the `--frozen` command-line argument. If set, uv will run without
updating the `uv.lock` file.

### `UV_GITHUB_TOKEN`

Equivalent to the `--token` argument for self update. A GitHub token for authentication.

### `UV_GIT_LFS`

Enables fetching files stored in Git LFS when installing a package from a Git repository.

### `UV_HTTP_RETRIES`

The number of retries for HTTP requests. (default: 3)

### `UV_HTTP_TIMEOUT`

Timeout (in seconds) for HTTP requests. (default: 30 s)

### `UV_INDEX`

Equivalent to the `--index` command-line argument. If set, uv will use this
space-separated list of URLs as additional indexes when searching for packages.

### `UV_INDEX_STRATEGY`

Equivalent to the `--index-strategy` command-line argument.

For example, if set to `unsafe-best-match`, uv will consider versions of a given package
available across all index URLs, rather than limiting its search to the first index URL
that contains the package.

### `UV_INDEX_URL`

Equivalent to the `--index-url` command-line argument. If set, uv will use this
URL as the default index when searching for packages.
(Deprecated: use `UV_DEFAULT_INDEX` instead.)

### `UV_INDEX_{name}_PASSWORD`

Provides the HTTP Basic authentication password for a named index.

The `name` parameter is the name of the index. For example, given an index named `foo`,
the environment variable key would be `UV_INDEX_FOO_PASSWORD`.

### `UV_INDEX_{name}_USERNAME`

Provides the HTTP Basic authentication username for a named index.

The `name` parameter is the name of the index. For example, given an index named `foo`,
the environment variable key would be `UV_INDEX_FOO_USERNAME`.

### `UV_INIT_BUILD_BACKEND`

Equivalent to the `--build-backend` argument for `uv init`. Determines the default backend
to use when creating a new project.

### `UV_INSECURE_HOST`

Equivalent to the `--allow-insecure-host` argument.

### `UV_INSECURE_NO_ZIP_VALIDATION`

Disable ZIP validation for streamed wheels and ZIP-based source distributions.

WARNING: Disabling ZIP validation can expose your system to security risks by bypassing
integrity checks and allowing uv to install potentially malicious ZIP files. If uv rejects
a ZIP file due to failing validation, it is likely that the file is malformed; consider
filing an issue with the package maintainer.

### `UV_INSTALLER_GHE_BASE_URL`

The URL from which to download uv using the standalone installer and `self update` feature,
in lieu of the default GitHub Enterprise URL.

### `UV_INSTALLER_GITHUB_BASE_URL`

The URL from which to download uv using the standalone installer and `self update` feature,
in lieu of the default GitHub URL.

### `UV_INSTALL_DIR`

The directory in which to install uv using the standalone installer and `self update` feature.
Defaults to `~/.local/bin`.

### `UV_ISOLATED`

Equivalent to the `--isolated` command-line argument. If set, uv will avoid discovering
a `pyproject.toml` or `uv.toml` file.

### `UV_KEYRING_PROVIDER`

Equivalent to the `--keyring-provider` command-line argument. If set, uv
will use this value as the keyring provider.

### `UV_LIBC`

Overrides the environment-determined libc on linux systems when filling in the current platform
within Python version requests. Options are: `gnu`, `gnueabi`, `gnueabihf`, `musl`, and `none`.

### `UV_LINK_MODE`

Equivalent to the `--link-mode` command-line argument. If set, uv will use this as
a link mode.

### `UV_LOCKED`

Equivalent to the `--locked` command-line argument. If set, uv will assert that the
`uv.lock` remains unchanged.

### `UV_LOG_CONTEXT`

Add additional context and structure to log messages.

If logging is not enabled, e.g., with `RUST_LOG` or `-v`, this has no effect.

### `UV_MANAGED_PYTHON`

Require use of uv-managed Python versions.

### `UV_NATIVE_TLS`

Equivalent to the `--native-tls` command-line argument. If set to `true`, uv will
use the system's trust store instead of the bundled `webpki-roots` crate.

### `UV_NO_BINARY`

Equivalent to the `--no-binary` command-line argument. If set, uv will install
all packages from source. The resolver will still use pre-built wheels to
extract package metadata, if available.

### `UV_NO_BINARY_PACKAGE`

Equivalent to the `--no-binary-package` command line argument. If set, uv will
not use pre-built wheels for the given space-delimited list of packages.

### `UV_NO_BUILD`

Equivalent to the `--no-build` command-line argument. If set, uv will not build
source distributions.

### `UV_NO_BUILD_ISOLATION`

Equivalent to the `--no-build-isolation` command-line argument. If set, uv will
skip isolation when building source distributions.

### `UV_NO_BUILD_PACKAGE`

Equivalent to the `--no-build-package` command line argument. If set, uv will
not build source distributions for the given space-delimited list of packages.

### `UV_NO_CACHE`

Equivalent to the `--no-cache` command-line argument. If set, uv will not use the
cache for any operations.

### `UV_NO_CONFIG`

Equivalent to the `--no-config` command-line argument. If set, uv will not read
any configuration files from the current directory, parent directories, or user configuration
directories.

### `UV_NO_DEV`

Equivalent to the `--no-dev` command-line argument. If set, uv will exclude
development dependencies.

### `UV_NO_EDITABLE`

Equivalent to the `--no-editable` command-line argument. If set, uv
installs or exports any editable dependencies, including the project and any workspace
members, as non-editable.

### `UV_NO_ENV_FILE`

Ignore `.env` files when executing `uv run` commands.

### `UV_NO_GITHUB_FAST_PATH`

Disable GitHub-specific requests that allow uv to skip `git fetch` in some circumstances.

### `UV_NO_HF_TOKEN`

Disable Hugging Face authentication, even if `HF_TOKEN` is set.

### `UV_NO_INSTALLER_METADATA`

Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories.

### `UV_NO_MANAGED_PYTHON`

Disable use of uv-managed Python versions.

### `UV_NO_MODIFY_PATH`

Avoid modifying the `PATH` environment variable when installing uv using the standalone
installer and `self update` feature. `INSTALLER_NO_MODIFY_PATH` is also supported as an
alias, for backwards compatibility.

### `UV_NO_PROGRESS`

Equivalent to the `--no-progress` command-line argument. Disables all progress output. For
example, spinners and progress bars.

### `UV_NO_SYNC`

Equivalent to the `--no-sync` command-line argument. If set, uv will skip updating
the environment.

### `UV_NO_VERIFY_HASHES`

Equivalent to the `--no-verify-hashes` argument. Disables hash verification for
`requirements.txt` files.

### `UV_NO_WRAP`

Use to disable line wrapping for diagnostics.

### `UV_OFFLINE`

Equivalent to the `--offline` command-line argument. If set, uv will disable network access.

### `UV_OVERRIDE`

Equivalent to the `--override` command-line argument. If set, uv will use this file
as the overrides file. Uses space-separated list of files.

### `UV_PRERELEASE`

Equivalent to the `--prerelease` command-line argument. For example, if set to
`allow`, uv will allow pre-release versions for all dependencies.

### `UV_PREVIEW`

Equivalent to the `--preview` argument. Enables preview mode.

### `UV_PREVIEW_FEATURES`

Equivalent to the `--preview-features` argument. Enables specific preview features.

### `UV_PROJECT`

Equivalent to the `--project` command-line argument.

### `UV_PROJECT_ENVIRONMENT`

Specifies the path to the directory to use for a project virtual environment.

See the [project documentation](../concepts/projects/config.md#project-environment-path)
for more details.

### `UV_PUBLISH_CHECK_URL`

Don't upload a file if it already exists on the index. The value is the URL of the index.

### `UV_PUBLISH_INDEX`

Equivalent to the `--index` command-line argument in `uv publish`. If
set, uv the index with this name in the configuration for publishing.

### `UV_PUBLISH_PASSWORD`

Equivalent to the `--password` command-line argument in `uv publish`. If
set, uv will use this password for publishing.

### `UV_PUBLISH_TOKEN`

Equivalent to the `--token` command-line argument in `uv publish`. If set, uv
will use this token (with the username `__token__`) for publishing.

### `UV_PUBLISH_URL`

Equivalent to the `--publish-url` command-line argument. The URL of the upload
endpoint of the index to use with `uv publish`.

### `UV_PUBLISH_USERNAME`

Equivalent to the `--username` command-line argument in `uv publish`. If
set, uv will use this username for publishing.

### `UV_PYPY_INSTALL_MIRROR`

Managed PyPy installations are downloaded from [python.org](https://downloads.python.org/).

This variable can be set to a mirror URL to use a
different source for PyPy installations. The provided URL will replace
`https://downloads.python.org/pypy` in, e.g.,
`https://downloads.python.org/pypy/pypy3.8-v7.3.7-osx64.tar.bz2`.
Distributions can be read from a local directory by using the `file://` URL scheme.

### `UV_PYTHON`

Equivalent to the `--python` command-line argument. If set to a path, uv will use
this Python interpreter for all operations.

### `UV_PYTHON_BIN_DIR`

Specifies the directory to place links to installed, managed Python executables.

### `UV_PYTHON_CACHE_DIR`

Specifies the directory for caching the archives of managed Python installations before
installation.

### `UV_PYTHON_CPYTHON_BUILD`

Pin managed CPython versions to a specific build version.

For CPython, this should be the build date (e.g., "20250814").

### `UV_PYTHON_DOWNLOADS`

Equivalent to the
[`python-downloads`](../reference/settings.md#python-downloads) setting and, when disabled, the
`--no-python-downloads` option. Whether uv should allow Python downloads.

### `UV_PYTHON_DOWNLOADS_JSON_URL`

Managed Python installations information is hardcoded in the `uv` binary.

This variable can be set to a URL pointing to JSON to use as a list for Python installations.
This will allow for setting each property of the Python installation, mostly the url part for offline mirror.

Note that currently, only local paths are supported.

### `UV_PYTHON_GRAALPY_BUILD`

Pin managed GraalPy versions to a specific build version.

For GraalPy, this should be the GraalPy version (e.g., "24.2.2").

### `UV_PYTHON_INSTALL_BIN`

Whether to install the Python executable into the `UV_PYTHON_BIN_DIR` directory.

### `UV_PYTHON_INSTALL_DIR`

Specifies the directory for storing managed Python installations.

### `UV_PYTHON_INSTALL_MIRROR`

Managed Python installations are downloaded from the Astral
[`python-build-standalone`](https://github.com/astral-sh/python-build-standalone) project.

This variable can be set to a mirror URL to use a different source for Python installations.
The provided URL will replace `https://github.com/astral-sh/python-build-standalone/releases/download` in, e.g.,
`https://github.com/astral-sh/python-build-standalone/releases/download/20240713/cpython-3.12.4%2B20240713-aarch64-apple-darwin-install_only.tar.gz`.
Distributions can be read from a local directory by using the `file://` URL scheme.

### `UV_PYTHON_INSTALL_REGISTRY`

Whether to install the Python executable into the Windows registry.

### `UV_PYTHON_PREFERENCE`

Whether uv should prefer system or managed Python versions.

### `UV_PYTHON_PYODIDE_BUILD`

Pin managed Pyodide versions to a specific build version.

For Pyodide, this should be the Pyodide version (e.g., "0.28.1").

### `UV_PYTHON_PYPY_BUILD`

Pin managed PyPy versions to a specific build version.

For PyPy, this should be the PyPy version (e.g., "7.3.20").

### `UV_REQUEST_TIMEOUT`

Timeout (in seconds) for HTTP requests. Equivalent to `UV_HTTP_TIMEOUT`.

### `UV_REQUIRE_HASHES`

Equivalent to the `--require-hashes` command-line argument. If set to `true`,
uv will require that all dependencies have a hash specified in the requirements file.

### `UV_RESOLUTION`

Equivalent to the `--resolution` command-line argument. For example, if set to
`lowest-direct`, uv will install the lowest compatible versions of all direct dependencies.

### `UV_STACK_SIZE`

Use to set the stack size used by uv.

The value is in bytes, and if both `UV_STACK_SIZE` are `RUST_MIN_STACK` unset, uv uses a 4MB
(4194304) stack. `UV_STACK_SIZE` takes precedence over `RUST_MIN_STACK`.

Unlike the normal `RUST_MIN_STACK` semantics, this can affect main thread
stack size, because we actually spawn our own main2 thread to work around
the fact that Windows' real main thread is only 1MB. That thread has size
`max(UV_STACK_SIZE, 1MB)`.

### `UV_SYSTEM_PYTHON`

Equivalent to the `--system` command-line argument. If set to `true`, uv will
use the first Python interpreter found in the system `PATH`.

WARNING: `UV_SYSTEM_PYTHON=true` is intended for use in continuous integration (CI)
or containerized environments and should be used with caution, as modifying the system
Python can lead to unexpected behavior.

### `UV_TEST_NO_HTTP_RETRY_DELAY`

Used to disable delay for HTTP retries in tests.

### `UV_TOOL_BIN_DIR`

Specifies the "bin" directory for installing tool executables.

### `UV_TOOL_DIR`

Specifies the directory where uv stores managed tools.

### `UV_TORCH_BACKEND`

Equivalent to the `--torch-backend` command-line argument (e.g., `cpu`, `cu126`, or `auto`).

### `UV_UNMANAGED_INSTALL`

Used ephemeral environments like CI to install uv to a specific path while preventing
the installer from modifying shell profiles or environment variables.

### `UV_VENV_CLEAR`

Equivalent to the `--clear` command-line argument. If set, uv will remove any
existing files or directories at the target path.

### `UV_VENV_SEED`

Install seed packages (one or more of: `pip`, `setuptools`, and `wheel`) into the virtual environment
created by `uv venv`.

Note that `setuptools` and `wheel` are not included in Python 3.12+ environments.



## Externally defined variables

uv also reads the following externally defined environment variables:

### `ACTIONS_ID_TOKEN_REQUEST_TOKEN`

Used for trusted publishing via `uv publish`. Contains the oidc request token.

### `ACTIONS_ID_TOKEN_REQUEST_URL`

Used for trusted publishing via `uv publish`. Contains the oidc token url.

### `ALL_PROXY`

General proxy for all network requests.

### `ANDROID_API_LEVEL`

Used with `--python-platform aarch64-linux-android` and related variants to set the
Android API level. (i.e., the minimum supported Android API level).

Defaults to `24`.

### `APPDATA`

Path to user-level configuration directory on Windows systems.

### `BASH_VERSION`

Used to detect Bash shell usage.

### `CLICOLOR_FORCE`

Use to control color via `anstyle`.

### `COLUMNS`

Overrides terminal width used for wrapping. This variable is not read by uv directly.

This is a quasi-standard variable, described, e.g., in `ncurses(3x)`.

### `CONDA_DEFAULT_ENV`

Used to determine if an active Conda environment is the base environment or not.

### `CONDA_PREFIX`

Used to detect an activated Conda environment.

### `FISH_VERSION`

Used to detect Fish shell usage.

### `FORCE_COLOR`

Forces colored output regardless of terminal support.

See [force-color.org](https://force-color.org).

### `GITHUB_ACTIONS`

Used for trusted publishing via `uv publish`.

### `HF_TOKEN`

Authentication token for Hugging Face requests. When set, uv will use this token
when making requests to `https://huggingface.co/` and any subdomains.

### `HOME`

The standard `HOME` env var.

### `HTTPS_PROXY`

Proxy for HTTPS requests.

### `HTTP_PROXY`

Proxy for HTTP requests.

### `HTTP_TIMEOUT`

Timeout (in seconds) for HTTP requests. Equivalent to `UV_HTTP_TIMEOUT`.

### `IPHONEOS_DEPLOYMENT_TARGET`

Used with `--python-platform arm64-apple-ios` and related variants to set the
deployment target (i.e., the minimum supported iOS version).

Defaults to `13.0`.

### `JPY_SESSION_NAME`

Used to detect when running inside a Jupyter notebook.

### `KSH_VERSION`

Used to detect Ksh shell usage.

### `LOCALAPPDATA`

Used to look for Microsoft Store Pythons installations.

### `MACOSX_DEPLOYMENT_TARGET`

Used with `--python-platform macos` and related variants to set the
deployment target (i.e., the minimum supported macOS version).

Defaults to `13.0`, the least-recent non-EOL macOS version at time of writing.

### `NETRC`

Use to set the .netrc file location.

### `NO_COLOR`

Disables colored output (takes precedence over `FORCE_COLOR`).

See [no-color.org](https://no-color.org).

### `NU_VERSION`

Used to detect `NuShell` usage.

### `PAGER`

The standard `PAGER` posix env var. Used by `uv` to configure the appropriate pager.

### `PATH`

The standard `PATH` env var.

### `PROMPT`

Used to detect the use of the Windows Command Prompt (as opposed to PowerShell).

### `PWD`

The standard `PWD` posix env var.

### `PYC_INVALIDATION_MODE`

The validation modes to use when run with `--compile`.

See [`PycInvalidationMode`](https://docs.python.org/3/library/py_compile.html#py_compile.PycInvalidationMode).

### `PYTHONPATH`

Adds directories to Python module search path (e.g., `PYTHONPATH=/path/to/modules`).

### `PYX_API_KEY`

The pyx API key (e.g., `sk-pyx-...`).

### `PYX_API_URL`

The URL of the pyx Simple API server.

### `PYX_AUTH_TOKEN`

The pyx authentication token (e.g., `eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9...`), as output by `uv auth token`.

### `PYX_CDN_DOMAIN`

The domain of the pyx CDN.

### `PYX_CREDENTIALS_DIR`

Specifies the directory where uv stores pyx credentials.

### `RUST_BACKTRACE`

If set, it can be used to display more stack trace details when a panic occurs.
This is used by uv particularly on windows to show more details during a platform exception.

For example:

* `RUST_BACKTRACE=1` will print a short backtrace.
* `RUST_BACKTRACE=full` will print a full backtrace.

See the [Rust backtrace documentation](https://doc.rust-lang.org/std/backtrace/index.html)
for more.

### `RUST_LOG`

If set, uv will use this value as the log level for its `--verbose` output. Accepts
any filter compatible with the `tracing_subscriber` crate.

For example:

* `RUST_LOG=uv=debug` is the equivalent of adding `--verbose` to the command line
* `RUST_LOG=trace` will enable trace-level logging.

See the [tracing documentation](https://docs.rs/tracing-subscriber/latest/tracing_subscriber/filter/struct.EnvFilter.html#example-syntax)
for more.

### `RUST_MIN_STACK`

Use to set the stack size used by uv.

The value is in bytes, and if both `UV_STACK_SIZE` are `RUST_MIN_STACK` unset, uv uses a 4MB
(4194304) stack. `UV_STACK_SIZE` takes precedence over `RUST_MIN_STACK`.

Prefer setting `UV_STACK_SIZE`, since `RUST_MIN_STACK` also affects subprocesses, such as
build backends that use Rust code.

Unlike the normal `RUST_MIN_STACK` semantics, this can affect main thread
stack size, because we actually spawn our own main2 thread to work around
the fact that Windows' real main thread is only 1MB. That thread has size
`max(RUST_MIN_STACK, 1MB)`.

### `SHELL`

The standard `SHELL` posix env var.

### `SSL_CERT_FILE`

Custom certificate bundle file path for SSL connections.

### `SSL_CLIENT_CERT`

If set, uv will use this file for mTLS authentication.
This should be a single file containing both the certificate and the private key in PEM format.

### `SYSTEMDRIVE`

Path to system-level configuration directory on Windows systems.

### `TRACING_DURATIONS_FILE`

Use to create the tracing durations file via the `tracing-durations-export` feature.

### `USERPROFILE`

Path to root directory of user's profile on Windows systems.

### `UV`

The path to the binary that was used to invoke uv.

This is propagated to all subprocesses spawned by uv.

If the executable was invoked through a symbolic link, some platforms will return the path
of the symbolic link and other platforms will return the path of the symbolic link’s target.

See <https://doc.rust-lang.org/std/env/fn.current_exe.html#security> for security
considerations.

### `VIRTUAL_ENV`

Used to detect an activated virtual environment.

### `VIRTUAL_ENV_DISABLE_PROMPT`

If set to `1` before a virtual environment is activated, then the
virtual environment name will not be prepended to the terminal prompt.

### `XDG_BIN_HOME`

Path to directory where executables are installed.

### `XDG_CACHE_HOME`

Path to cache directory on Unix systems.

### `XDG_CONFIG_DIRS`

Path to system-level configuration directory on Unix systems.

### `XDG_CONFIG_HOME`

Path to user-level configuration directory on Unix systems.

### `XDG_DATA_HOME`

Path to directory for storing managed Python installations and tools.

### `ZDOTDIR`

Used to determine which `.zshenv` to use when Zsh is being used.

### `ZSH_VERSION`

Used to detect Zsh shell usage.

