﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/b2bi/B2BI_EXPORTS.h>
#include <aws/b2bi/model/S3Location.h>
#include <aws/b2bi/model/TransformerJobStatus.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace B2BI {
namespace Model {
class GetTransformerJobResult {
 public:
  AWS_B2BI_API GetTransformerJobResult() = default;
  AWS_B2BI_API GetTransformerJobResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_B2BI_API GetTransformerJobResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Returns the current state of the transformer job, either
   * <code>running</code>, <code>succeeded</code>, or <code>failed</code>.</p>
   */
  inline TransformerJobStatus GetStatus() const { return m_status; }
  inline void SetStatus(TransformerJobStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline GetTransformerJobResult& WithStatus(TransformerJobStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Returns the location for the output files. If the caller specified a
   * directory for the output, then this contains the full path to the output file,
   * including the file name generated by the service.</p>
   */
  inline const Aws::Vector<S3Location>& GetOutputFiles() const { return m_outputFiles; }
  template <typename OutputFilesT = Aws::Vector<S3Location>>
  void SetOutputFiles(OutputFilesT&& value) {
    m_outputFilesHasBeenSet = true;
    m_outputFiles = std::forward<OutputFilesT>(value);
  }
  template <typename OutputFilesT = Aws::Vector<S3Location>>
  GetTransformerJobResult& WithOutputFiles(OutputFilesT&& value) {
    SetOutputFiles(std::forward<OutputFilesT>(value));
    return *this;
  }
  template <typename OutputFilesT = S3Location>
  GetTransformerJobResult& AddOutputFiles(OutputFilesT&& value) {
    m_outputFilesHasBeenSet = true;
    m_outputFiles.emplace_back(std::forward<OutputFilesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Returns an optional error message, which gets populated when the job is not
   * run successfully.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  GetTransformerJobResult& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetTransformerJobResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  TransformerJobStatus m_status{TransformerJobStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::Vector<S3Location> m_outputFiles;
  bool m_outputFilesHasBeenSet = false;

  Aws::String m_message;
  bool m_messageHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace B2BI
}  // namespace Aws
