'use strict';

const fixtures = require('../../common/fixtures');

function getKeyFileName(type, suffix) {
  return `${type.replaceAll('-', '_')}_${suffix}.pem`;
}

module.exports = function() {
  const pkcs8 = {
    'ML-KEM-512': fixtures.readKey(getKeyFileName('ml-kem-512', 'private_seed_only'), 'ascii'),
    'ML-KEM-768': fixtures.readKey(getKeyFileName('ml-kem-768', 'private_seed_only'), 'ascii'),
    'ML-KEM-1024': fixtures.readKey(getKeyFileName('ml-kem-1024', 'private_seed_only'), 'ascii'),
  }

  const spki = {
    'ML-KEM-512': fixtures.readKey(getKeyFileName('ml-kem-512', 'public'), 'ascii'),
    'ML-KEM-768': fixtures.readKey(getKeyFileName('ml-kem-768', 'public'), 'ascii'),
    'ML-KEM-1024': fixtures.readKey(getKeyFileName('ml-kem-1024', 'public'), 'ascii'),
  }

  /* eslint-disable @stylistic/js/max-len */
  const results = {
    'ML-KEM-512': {
      ciphertext: Buffer.from('3b7ac92f6140c9fa0348f112ee8211ee668ce657b8bb6352a076880dd7ff4ca7c0babf635f1d36cab5106b8287504d572fab1d0fa3e086310564bd853bdd96cff460eeaa49be316eb95e47c477eeeec7276422abb44ce349016d80eb28f3519a64f1e1f7df63730a1ae83f6cd88af463fae7552103f1eff1097d2b80fa7539b10355136753d725dafd9311fca3d3b5353e2af9ac7f514c420dd7cf8a7e95eec82a37b39f29806db0c6469e884787054c8e48d1416e28fc5c809e42e0abe4547ba9f183f4ab3ce27da63d858b0a2c0970dce72674b5f2c62d6016fc9557b788685cb0b1c7ed3dbe5263463618edb729823f6afb349c3efd229bd03d94393880e48e9d5c80905702fd8bbaf19050dd67029f77df4d37a053fce22a41bde0a464f3940acada39d96a7e20dfef6f02d8317e40cbbe584fde7eeccd02db0b6e1b16c42eb2895afaafebeba0f628907af2a7de9da22afecf77ae1e3abd9593ed545736c766aafe7b223e3b8ab96084a8e14b81bdeff5b5d6c34a107f5108d99d76940535b0a0d3ffcd7e1085ef3e1c1fb54667af235d12f1b8a153faa5fc033676c81a4f39835c29a5ccc1ebb170c8f1717a9f0660ad353e5c18277e3c5e1c999431e51601f3d0a30b027b529489c83ab8da3e00faefc83c5df551c32446280db37940e347f283ac504b2f6a4ca3de69598dd5b73cbf64a2efac948f4793576ba59aafebff69cbfa53a9833d8a2af9b43bbb31c5c18248ddd3c869f7c4d701bd8050345c33bf87ae52cd97246930d84736723b777ab25d08233501a116ded57c28007944c7f3bfb469f0e7d54e643deb543014b6ce9ca4dce6f56a11af37ec0846bf8023efc5127af080e2ecf1c568626cd19842386f3f722d11f153c0167951692dab5468e5f8bc978fc21cca1fdbb6e1d2b27440bb132014da61536ec9c0175d4a7f6ab07bb57004b929a9efb452c718fbf754afb5433df64ae6b95850a1cdbe1e9d743b216f9e1465e488c3fe813a342138134ff73323210eea5950019b35940f8ab340a42054e4143dad43ebc4e9a363e610b5bef73f2de70642e3aa4a631f07b4', 'hex'),
      sharedKey: Buffer.from('f6d03353f51c73a55611f307f15eaa2fc8527213667370df2ccab580a0b50da3', 'hex'),
    },
    'ML-KEM-768': {
      ciphertext: Buffer.from('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', 'hex'),
      sharedKey: Buffer.from('e9888adf3af812be74eb1b52a49d37ec1ca0e06c04d47d8ceb05f64f0c979b5f', 'hex'),
    },
    'ML-KEM-1024': {
      ciphertext: Buffer.from('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', 'hex'),
      sharedKey: Buffer.from('345cee699a756befaf05c60a35591c6df4f91a97a004356dd823fa4053276405', 'hex'),
    },
  };
  /* eslint-enable @stylistic/js/max-len */

  const algorithms = ['ML-KEM-512', 'ML-KEM-768', 'ML-KEM-1024'];

  const vectors = algorithms.map((algorithm) => ({
    publicKeyPem: spki[algorithm],
    privateKeyPem: pkcs8[algorithm],
    name: algorithm,
    results: results[algorithm],
  }));

  return vectors;
}
