//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
/// \file VoxelParameterisation.hh
/// \brief Definition of the VoxelParameterisation class

#ifndef VOXELPARAMETERISATION_HH
#define VOXELPARAMETERISATION_HH

#include "G4VPVParameterisation.hh"
#include "G4ThreeVector.hh"
#include "G4UnitsTable.hh"
#include "G4SystemOfUnits.hh"
#include "G4VPhysicalVolume.hh"
#include "G4LogicalVolume.hh"
#include "G4VSolid.hh"
#include "G4VisAttributes.hh"
#include "PhysGeoImport.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
class VoxelParameterisation : public G4VPVParameterisation
{
public:
    VoxelParameterisation(std::map<G4String, G4LogicalVolume*>& voxelMap, 
                            std::vector<Voxel>* voxels);
    ~VoxelParameterisation() override;

    void ComputeTransformation(const G4int copyNo, G4VPhysicalVolume* physVol) const override;

private:
    std::map<G4String, G4LogicalVolume*> fVoxelMap;
    std::vector<Voxel>* fVoxels{nullptr};

    G4LogicalVolume* LogicalVoxel(Voxel::VoxelType type) const;
    G4String VoxelName(Voxel::VoxelType type) const;
};

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#endif // VOXELPARAMETERISATION_HH
