/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;

public class AIFunctionRegistry {
    private static final Log log = Log.getLog(AIFunctionRegistry.class);
    private static AIFunctionRegistry instance = null;
    private final Map<String, AIFunctionDescriptor> descriptorMap = new LinkedHashMap<String, AIFunctionDescriptor>();

    public static synchronized AIFunctionRegistry getInstance() {
        if (instance == null) {
            instance = new AIFunctionRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public AIFunctionRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("com.dbeaver.ai.function");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("function".equals(ext.getName())) {
                AIFunctionDescriptor descriptor = new AIFunctionDescriptor(ext);
                this.descriptorMap.put(descriptor.getName(), descriptor);
            }
            ++n2;
        }
    }

    @Nullable
    public AIFunctionDescriptor getFunction(@NotNull String id) {
        return this.descriptorMap.get(id);
    }

    @NotNull
    public List<AIFunctionDescriptor> getAllFunctions() {
        return new ArrayList<AIFunctionDescriptor>(this.descriptorMap.values());
    }

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull AIFunctionDescriptor descriptor, @NotNull Map<String, Object> arguments) throws DBException {
        AIFunction function = descriptor.createInstance();
        return function.callFunction(context, arguments);
    }
}

