/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.merge.MergeDelete;
import net.sf.jsqlparser.statement.merge.MergeInsert;
import net.sf.jsqlparser.statement.merge.MergeOperationVisitor;
import net.sf.jsqlparser.statement.merge.MergeUpdate;
import net.sf.jsqlparser.statement.update.UpdateSet;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;

public class MergeValidator<Void>
extends AbstractValidator<Merge>
implements MergeOperationVisitor<Void> {
    @Override
    public void validate(Merge merge) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.merge);
        }
        this.validateOptionalExpression(merge.getOnCondition());
        if (merge.getOperations() != null) {
            merge.getOperations().forEach(operation -> operation.accept(this, null));
        }
        this.validateOptionalFromItems(merge.getFromItem());
    }

    @Override
    public <S> Void visit(MergeDelete mergeDelete, S context) {
        this.validateOptionalExpression(mergeDelete.getAndPredicate());
        return null;
    }

    public void visit(MergeDelete mergeDelete) {
        this.visit(mergeDelete, null);
    }

    @Override
    public <S> Void visit(MergeUpdate mergeUpdate, S context) {
        this.validateOptionalExpression(mergeUpdate.getAndPredicate());
        for (UpdateSet updateSet : mergeUpdate.getUpdateSets()) {
            this.validateOptionalExpressions(updateSet.getColumns());
            this.validateOptionalExpressions(updateSet.getValues());
        }
        this.validateOptionalExpression(mergeUpdate.getDeleteWhereCondition());
        this.validateOptionalExpression(mergeUpdate.getWhereCondition());
        return null;
    }

    public void visit(MergeUpdate mergeUpdate) {
        this.visit(mergeUpdate, null);
    }

    @Override
    public <S> Void visit(MergeInsert mergeInsert, S context) {
        this.validateOptionalExpression(mergeInsert.getAndPredicate());
        this.validateOptionalExpressions(mergeInsert.getColumns());
        this.validateOptionalExpressions(mergeInsert.getValues());
        return null;
    }

    public void visit(MergeInsert mergeInsert) {
        this.visit(mergeInsert, null);
    }
}

