// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpcollectormetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolExportMetricsServiceResponse = sync.Pool{
		New: func() any {
			return &otlpcollectormetrics.ExportMetricsServiceResponse{}
		},
	}
)

func NewOrigExportMetricsServiceResponse() *otlpcollectormetrics.ExportMetricsServiceResponse {
	if !UseProtoPooling.IsEnabled() {
		return &otlpcollectormetrics.ExportMetricsServiceResponse{}
	}
	return protoPoolExportMetricsServiceResponse.Get().(*otlpcollectormetrics.ExportMetricsServiceResponse)
}

func DeleteOrigExportMetricsServiceResponse(orig *otlpcollectormetrics.ExportMetricsServiceResponse, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteOrigExportMetricsPartialSuccess(&orig.PartialSuccess, false)

	orig.Reset()
	if nullable {
		protoPoolExportMetricsServiceResponse.Put(orig)
	}
}

func CopyOrigExportMetricsServiceResponse(dest, src *otlpcollectormetrics.ExportMetricsServiceResponse) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	CopyOrigExportMetricsPartialSuccess(&dest.PartialSuccess, &src.PartialSuccess)
}

func GenTestOrigExportMetricsServiceResponse() *otlpcollectormetrics.ExportMetricsServiceResponse {
	orig := NewOrigExportMetricsServiceResponse()
	orig.PartialSuccess = *GenTestOrigExportMetricsPartialSuccess()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportMetricsServiceResponse(orig *otlpcollectormetrics.ExportMetricsServiceResponse, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("partialSuccess")
	MarshalJSONOrigExportMetricsPartialSuccess(&orig.PartialSuccess, dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExportResponse unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportMetricsServiceResponse(orig *otlpcollectormetrics.ExportMetricsServiceResponse, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "partialSuccess", "partial_success":
			UnmarshalJSONOrigExportMetricsPartialSuccess(&orig.PartialSuccess, iter)
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigExportMetricsServiceResponse(orig *otlpcollectormetrics.ExportMetricsServiceResponse) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigExportMetricsPartialSuccess(&orig.PartialSuccess)
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func MarshalProtoOrigExportMetricsServiceResponse(orig *otlpcollectormetrics.ExportMetricsServiceResponse, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigExportMetricsPartialSuccess(&orig.PartialSuccess, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	return len(buf) - pos
}

func UnmarshalProtoOrigExportMetricsServiceResponse(orig *otlpcollectormetrics.ExportMetricsServiceResponse, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialSuccess", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigExportMetricsPartialSuccess(&orig.PartialSuccess, buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
