/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// StreamedListObjectsResponse The response for a StreamedListObjects RPC.
type StreamedListObjectsResponse struct {
	Object string `json:"object" yaml:"object"`
}

// NewStreamedListObjectsResponse instantiates a new StreamedListObjectsResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewStreamedListObjectsResponse(object string) *StreamedListObjectsResponse {
	this := StreamedListObjectsResponse{}
	this.Object = object
	return &this
}

// NewStreamedListObjectsResponseWithDefaults instantiates a new StreamedListObjectsResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewStreamedListObjectsResponseWithDefaults() *StreamedListObjectsResponse {
	this := StreamedListObjectsResponse{}
	return &this
}

// GetObject returns the Object field value
func (o *StreamedListObjectsResponse) GetObject() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Object
}

// GetObjectOk returns a tuple with the Object field value
// and a boolean to check if the value has been set.
func (o *StreamedListObjectsResponse) GetObjectOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Object, true
}

// SetObject sets field value
func (o *StreamedListObjectsResponse) SetObject(v string) {
	o.Object = v
}

func (o StreamedListObjectsResponse) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["object"] = o.Object
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableStreamedListObjectsResponse struct {
	value *StreamedListObjectsResponse
	isSet bool
}

func (v NullableStreamedListObjectsResponse) Get() *StreamedListObjectsResponse {
	return v.value
}

func (v *NullableStreamedListObjectsResponse) Set(val *StreamedListObjectsResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableStreamedListObjectsResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableStreamedListObjectsResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableStreamedListObjectsResponse(val *StreamedListObjectsResponse) *NullableStreamedListObjectsResponse {
	return &NullableStreamedListObjectsResponse{value: val, isSet: true}
}

func (v NullableStreamedListObjectsResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableStreamedListObjectsResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
