/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.GenericMetaModelRegistry;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModelDescriptor;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class GenericDataSourceProvider
extends JDBCDataSourceProvider {
    public long getFeatures() {
        return 3L;
    }

    @NotNull
    public String getConnectionURL(@NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        return DatabaseURL.generateUrlByTemplate((DBPDriver)driver, (DBPConnectionConfiguration)connectionInfo);
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        GenericMetaModel metaModelInstance = GenericMetaModelRegistry.getInstance().getMetaModel(container);
        return metaModelInstance.createDataSourceImpl(monitor, container);
    }

    protected GenericMetaModelDescriptor getStandardMetaModel() {
        return GenericMetaModelRegistry.getInstance().getStandardMetaModel();
    }

    @NotNull
    public DBPPropertyDescriptor[] getConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) throws DBException {
        String driverParametersString;
        DBPPropertyDescriptor[] connectionProperties = super.getConnectionProperties(monitor, driver, connectionInfo);
        if (!(connectionProperties != null && connectionProperties.length != 0 || (driverParametersString = CommonUtils.toString((Object)driver.getDriverParameter("driver-properties"))).isEmpty())) {
            String[] propList = driverParametersString.split(",");
            connectionProperties = new DBPPropertyDescriptor[propList.length];
            int i = 0;
            while (i < propList.length) {
                String propName = propList[i].trim();
                connectionProperties[i] = new PropertyDescriptor(ModelMessages.model_jdbc_driver_properties, propName, propName, null, String.class, false, null, null, true);
                ++i;
            }
        }
        return connectionProperties;
    }
}

