package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// IgnoreAggregateEvaluationResults invokes the config.IgnoreAggregateEvaluationResults API synchronously
func (client *Client) IgnoreAggregateEvaluationResults(request *IgnoreAggregateEvaluationResultsRequest) (response *IgnoreAggregateEvaluationResultsResponse, err error) {
	response = CreateIgnoreAggregateEvaluationResultsResponse()
	err = client.DoAction(request, response)
	return
}

// IgnoreAggregateEvaluationResultsWithChan invokes the config.IgnoreAggregateEvaluationResults API asynchronously
func (client *Client) IgnoreAggregateEvaluationResultsWithChan(request *IgnoreAggregateEvaluationResultsRequest) (<-chan *IgnoreAggregateEvaluationResultsResponse, <-chan error) {
	responseChan := make(chan *IgnoreAggregateEvaluationResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.IgnoreAggregateEvaluationResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// IgnoreAggregateEvaluationResultsWithCallback invokes the config.IgnoreAggregateEvaluationResults API asynchronously
func (client *Client) IgnoreAggregateEvaluationResultsWithCallback(request *IgnoreAggregateEvaluationResultsRequest, callback func(response *IgnoreAggregateEvaluationResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *IgnoreAggregateEvaluationResultsResponse
		var err error
		defer close(result)
		response, err = client.IgnoreAggregateEvaluationResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// IgnoreAggregateEvaluationResultsRequest is the request struct for api IgnoreAggregateEvaluationResults
type IgnoreAggregateEvaluationResultsRequest struct {
	*requests.RpcRequest
	ConfigRuleId string                                       `position:"Body" name:"ConfigRuleId"`
	Reason       string                                       `position:"Body" name:"Reason"`
	Resources    *[]IgnoreAggregateEvaluationResultsResources `position:"Body" name:"Resources"  type:"Json"`
	AggregatorId string                                       `position:"Body" name:"AggregatorId"`
}

// IgnoreAggregateEvaluationResultsResources is a repeated param struct in IgnoreAggregateEvaluationResultsRequest
type IgnoreAggregateEvaluationResultsResources struct {
	ResourceId        string `name:"ResourceId"`
	ResourceAccountId string `name:"ResourceAccountId"`
	Region            string `name:"Region"`
	ResourceType      string `name:"ResourceType"`
}

// IgnoreAggregateEvaluationResultsResponse is the response struct for api IgnoreAggregateEvaluationResults
type IgnoreAggregateEvaluationResultsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateIgnoreAggregateEvaluationResultsRequest creates a request to invoke IgnoreAggregateEvaluationResults API
func CreateIgnoreAggregateEvaluationResultsRequest() (request *IgnoreAggregateEvaluationResultsRequest) {
	request = &IgnoreAggregateEvaluationResultsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "IgnoreAggregateEvaluationResults", "", "")
	request.Method = requests.POST
	return
}

// CreateIgnoreAggregateEvaluationResultsResponse creates a response to parse from IgnoreAggregateEvaluationResults response
func CreateIgnoreAggregateEvaluationResultsResponse() (response *IgnoreAggregateEvaluationResultsResponse) {
	response = &IgnoreAggregateEvaluationResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
