package compute

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessLevel enumerates the values for access level.
type AccessLevel string

const (
	// None ...
	None AccessLevel = "None"
	// Read ...
	Read AccessLevel = "Read"
	// Write ...
	Write AccessLevel = "Write"
)

// PossibleAccessLevelValues returns an array of possible values for the AccessLevel const type.
func PossibleAccessLevelValues() []AccessLevel {
	return []AccessLevel{None, Read, Write}
}

// AggregatedReplicationState enumerates the values for aggregated replication state.
type AggregatedReplicationState string

const (
	// Completed ...
	Completed AggregatedReplicationState = "Completed"
	// Failed ...
	Failed AggregatedReplicationState = "Failed"
	// InProgress ...
	InProgress AggregatedReplicationState = "InProgress"
	// Unknown ...
	Unknown AggregatedReplicationState = "Unknown"
)

// PossibleAggregatedReplicationStateValues returns an array of possible values for the AggregatedReplicationState const type.
func PossibleAggregatedReplicationStateValues() []AggregatedReplicationState {
	return []AggregatedReplicationState{Completed, Failed, InProgress, Unknown}
}

// AvailabilitySetSkuTypes enumerates the values for availability set sku types.
type AvailabilitySetSkuTypes string

const (
	// Aligned ...
	Aligned AvailabilitySetSkuTypes = "Aligned"
	// Classic ...
	Classic AvailabilitySetSkuTypes = "Classic"
)

// PossibleAvailabilitySetSkuTypesValues returns an array of possible values for the AvailabilitySetSkuTypes const type.
func PossibleAvailabilitySetSkuTypesValues() []AvailabilitySetSkuTypes {
	return []AvailabilitySetSkuTypes{Aligned, Classic}
}

// CachingTypes enumerates the values for caching types.
type CachingTypes string

const (
	// CachingTypesNone ...
	CachingTypesNone CachingTypes = "None"
	// CachingTypesReadOnly ...
	CachingTypesReadOnly CachingTypes = "ReadOnly"
	// CachingTypesReadWrite ...
	CachingTypesReadWrite CachingTypes = "ReadWrite"
)

// PossibleCachingTypesValues returns an array of possible values for the CachingTypes const type.
func PossibleCachingTypesValues() []CachingTypes {
	return []CachingTypes{CachingTypesNone, CachingTypesReadOnly, CachingTypesReadWrite}
}

// ComponentNames enumerates the values for component names.
type ComponentNames string

const (
	// MicrosoftWindowsShellSetup ...
	MicrosoftWindowsShellSetup ComponentNames = "Microsoft-Windows-Shell-Setup"
)

// PossibleComponentNamesValues returns an array of possible values for the ComponentNames const type.
func PossibleComponentNamesValues() []ComponentNames {
	return []ComponentNames{MicrosoftWindowsShellSetup}
}

// ContainerServiceOrchestratorTypes enumerates the values for container service orchestrator types.
type ContainerServiceOrchestratorTypes string

const (
	// Custom ...
	Custom ContainerServiceOrchestratorTypes = "Custom"
	// DCOS ...
	DCOS ContainerServiceOrchestratorTypes = "DCOS"
	// Kubernetes ...
	Kubernetes ContainerServiceOrchestratorTypes = "Kubernetes"
	// Swarm ...
	Swarm ContainerServiceOrchestratorTypes = "Swarm"
)

// PossibleContainerServiceOrchestratorTypesValues returns an array of possible values for the ContainerServiceOrchestratorTypes const type.
func PossibleContainerServiceOrchestratorTypesValues() []ContainerServiceOrchestratorTypes {
	return []ContainerServiceOrchestratorTypes{Custom, DCOS, Kubernetes, Swarm}
}

// ContainerServiceVMSizeTypes enumerates the values for container service vm size types.
type ContainerServiceVMSizeTypes string

const (
	// StandardA0 ...
	StandardA0 ContainerServiceVMSizeTypes = "Standard_A0"
	// StandardA1 ...
	StandardA1 ContainerServiceVMSizeTypes = "Standard_A1"
	// StandardA10 ...
	StandardA10 ContainerServiceVMSizeTypes = "Standard_A10"
	// StandardA11 ...
	StandardA11 ContainerServiceVMSizeTypes = "Standard_A11"
	// StandardA2 ...
	StandardA2 ContainerServiceVMSizeTypes = "Standard_A2"
	// StandardA3 ...
	StandardA3 ContainerServiceVMSizeTypes = "Standard_A3"
	// StandardA4 ...
	StandardA4 ContainerServiceVMSizeTypes = "Standard_A4"
	// StandardA5 ...
	StandardA5 ContainerServiceVMSizeTypes = "Standard_A5"
	// StandardA6 ...
	StandardA6 ContainerServiceVMSizeTypes = "Standard_A6"
	// StandardA7 ...
	StandardA7 ContainerServiceVMSizeTypes = "Standard_A7"
	// StandardA8 ...
	StandardA8 ContainerServiceVMSizeTypes = "Standard_A8"
	// StandardA9 ...
	StandardA9 ContainerServiceVMSizeTypes = "Standard_A9"
	// StandardD1 ...
	StandardD1 ContainerServiceVMSizeTypes = "Standard_D1"
	// StandardD11 ...
	StandardD11 ContainerServiceVMSizeTypes = "Standard_D11"
	// StandardD11V2 ...
	StandardD11V2 ContainerServiceVMSizeTypes = "Standard_D11_v2"
	// StandardD12 ...
	StandardD12 ContainerServiceVMSizeTypes = "Standard_D12"
	// StandardD12V2 ...
	StandardD12V2 ContainerServiceVMSizeTypes = "Standard_D12_v2"
	// StandardD13 ...
	StandardD13 ContainerServiceVMSizeTypes = "Standard_D13"
	// StandardD13V2 ...
	StandardD13V2 ContainerServiceVMSizeTypes = "Standard_D13_v2"
	// StandardD14 ...
	StandardD14 ContainerServiceVMSizeTypes = "Standard_D14"
	// StandardD14V2 ...
	StandardD14V2 ContainerServiceVMSizeTypes = "Standard_D14_v2"
	// StandardD1V2 ...
	StandardD1V2 ContainerServiceVMSizeTypes = "Standard_D1_v2"
	// StandardD2 ...
	StandardD2 ContainerServiceVMSizeTypes = "Standard_D2"
	// StandardD2V2 ...
	StandardD2V2 ContainerServiceVMSizeTypes = "Standard_D2_v2"
	// StandardD3 ...
	StandardD3 ContainerServiceVMSizeTypes = "Standard_D3"
	// StandardD3V2 ...
	StandardD3V2 ContainerServiceVMSizeTypes = "Standard_D3_v2"
	// StandardD4 ...
	StandardD4 ContainerServiceVMSizeTypes = "Standard_D4"
	// StandardD4V2 ...
	StandardD4V2 ContainerServiceVMSizeTypes = "Standard_D4_v2"
	// StandardD5V2 ...
	StandardD5V2 ContainerServiceVMSizeTypes = "Standard_D5_v2"
	// StandardDS1 ...
	StandardDS1 ContainerServiceVMSizeTypes = "Standard_DS1"
	// StandardDS11 ...
	StandardDS11 ContainerServiceVMSizeTypes = "Standard_DS11"
	// StandardDS12 ...
	StandardDS12 ContainerServiceVMSizeTypes = "Standard_DS12"
	// StandardDS13 ...
	StandardDS13 ContainerServiceVMSizeTypes = "Standard_DS13"
	// StandardDS14 ...
	StandardDS14 ContainerServiceVMSizeTypes = "Standard_DS14"
	// StandardDS2 ...
	StandardDS2 ContainerServiceVMSizeTypes = "Standard_DS2"
	// StandardDS3 ...
	StandardDS3 ContainerServiceVMSizeTypes = "Standard_DS3"
	// StandardDS4 ...
	StandardDS4 ContainerServiceVMSizeTypes = "Standard_DS4"
	// StandardG1 ...
	StandardG1 ContainerServiceVMSizeTypes = "Standard_G1"
	// StandardG2 ...
	StandardG2 ContainerServiceVMSizeTypes = "Standard_G2"
	// StandardG3 ...
	StandardG3 ContainerServiceVMSizeTypes = "Standard_G3"
	// StandardG4 ...
	StandardG4 ContainerServiceVMSizeTypes = "Standard_G4"
	// StandardG5 ...
	StandardG5 ContainerServiceVMSizeTypes = "Standard_G5"
	// StandardGS1 ...
	StandardGS1 ContainerServiceVMSizeTypes = "Standard_GS1"
	// StandardGS2 ...
	StandardGS2 ContainerServiceVMSizeTypes = "Standard_GS2"
	// StandardGS3 ...
	StandardGS3 ContainerServiceVMSizeTypes = "Standard_GS3"
	// StandardGS4 ...
	StandardGS4 ContainerServiceVMSizeTypes = "Standard_GS4"
	// StandardGS5 ...
	StandardGS5 ContainerServiceVMSizeTypes = "Standard_GS5"
)

// PossibleContainerServiceVMSizeTypesValues returns an array of possible values for the ContainerServiceVMSizeTypes const type.
func PossibleContainerServiceVMSizeTypesValues() []ContainerServiceVMSizeTypes {
	return []ContainerServiceVMSizeTypes{StandardA0, StandardA1, StandardA10, StandardA11, StandardA2, StandardA3, StandardA4, StandardA5, StandardA6, StandardA7, StandardA8, StandardA9, StandardD1, StandardD11, StandardD11V2, StandardD12, StandardD12V2, StandardD13, StandardD13V2, StandardD14, StandardD14V2, StandardD1V2, StandardD2, StandardD2V2, StandardD3, StandardD3V2, StandardD4, StandardD4V2, StandardD5V2, StandardDS1, StandardDS11, StandardDS12, StandardDS13, StandardDS14, StandardDS2, StandardDS3, StandardDS4, StandardG1, StandardG2, StandardG3, StandardG4, StandardG5, StandardGS1, StandardGS2, StandardGS3, StandardGS4, StandardGS5}
}

// DedicatedHostLicenseTypes enumerates the values for dedicated host license types.
type DedicatedHostLicenseTypes string

const (
	// DedicatedHostLicenseTypesNone ...
	DedicatedHostLicenseTypesNone DedicatedHostLicenseTypes = "None"
	// DedicatedHostLicenseTypesWindowsServerHybrid ...
	DedicatedHostLicenseTypesWindowsServerHybrid DedicatedHostLicenseTypes = "Windows_Server_Hybrid"
	// DedicatedHostLicenseTypesWindowsServerPerpetual ...
	DedicatedHostLicenseTypesWindowsServerPerpetual DedicatedHostLicenseTypes = "Windows_Server_Perpetual"
)

// PossibleDedicatedHostLicenseTypesValues returns an array of possible values for the DedicatedHostLicenseTypes const type.
func PossibleDedicatedHostLicenseTypesValues() []DedicatedHostLicenseTypes {
	return []DedicatedHostLicenseTypes{DedicatedHostLicenseTypesNone, DedicatedHostLicenseTypesWindowsServerHybrid, DedicatedHostLicenseTypesWindowsServerPerpetual}
}

// DiffDiskOptions enumerates the values for diff disk options.
type DiffDiskOptions string

const (
	// Local ...
	Local DiffDiskOptions = "Local"
)

// PossibleDiffDiskOptionsValues returns an array of possible values for the DiffDiskOptions const type.
func PossibleDiffDiskOptionsValues() []DiffDiskOptions {
	return []DiffDiskOptions{Local}
}

// DiskCreateOption enumerates the values for disk create option.
type DiskCreateOption string

const (
	// Attach Disk will be attached to a VM.
	Attach DiskCreateOption = "Attach"
	// Copy Create a new disk or snapshot by copying from a disk or snapshot specified by the given
	// sourceResourceId.
	Copy DiskCreateOption = "Copy"
	// Empty Create an empty data disk of a size given by diskSizeGB.
	Empty DiskCreateOption = "Empty"
	// FromImage Create a new disk from a platform image specified by the given imageReference.
	FromImage DiskCreateOption = "FromImage"
	// Import Create a disk by importing from a blob specified by a sourceUri in a storage account specified by
	// storageAccountId.
	Import DiskCreateOption = "Import"
	// Restore Create a new disk by copying from a backup recovery point.
	Restore DiskCreateOption = "Restore"
	// Upload Create a new disk by obtaining a write token and using it to directly upload the contents of the
	// disk.
	Upload DiskCreateOption = "Upload"
)

// PossibleDiskCreateOptionValues returns an array of possible values for the DiskCreateOption const type.
func PossibleDiskCreateOptionValues() []DiskCreateOption {
	return []DiskCreateOption{Attach, Copy, Empty, FromImage, Import, Restore, Upload}
}

// DiskCreateOptionTypes enumerates the values for disk create option types.
type DiskCreateOptionTypes string

const (
	// DiskCreateOptionTypesAttach ...
	DiskCreateOptionTypesAttach DiskCreateOptionTypes = "Attach"
	// DiskCreateOptionTypesEmpty ...
	DiskCreateOptionTypesEmpty DiskCreateOptionTypes = "Empty"
	// DiskCreateOptionTypesFromImage ...
	DiskCreateOptionTypesFromImage DiskCreateOptionTypes = "FromImage"
)

// PossibleDiskCreateOptionTypesValues returns an array of possible values for the DiskCreateOptionTypes const type.
func PossibleDiskCreateOptionTypesValues() []DiskCreateOptionTypes {
	return []DiskCreateOptionTypes{DiskCreateOptionTypesAttach, DiskCreateOptionTypesEmpty, DiskCreateOptionTypesFromImage}
}

// DiskState enumerates the values for disk state.
type DiskState string

const (
	// ActiveSAS The disk currently has an Active SAS Uri associated with it.
	ActiveSAS DiskState = "ActiveSAS"
	// ActiveUpload A disk is created for upload and a write token has been issued for uploading to it.
	ActiveUpload DiskState = "ActiveUpload"
	// Attached The disk is currently mounted to a running VM.
	Attached DiskState = "Attached"
	// ReadyToUpload A disk is ready to be created by upload by requesting a write token.
	ReadyToUpload DiskState = "ReadyToUpload"
	// Reserved The disk is mounted to a stopped-deallocated VM
	Reserved DiskState = "Reserved"
	// Unattached The disk is not being used and can be attached to a VM.
	Unattached DiskState = "Unattached"
)

// PossibleDiskStateValues returns an array of possible values for the DiskState const type.
func PossibleDiskStateValues() []DiskState {
	return []DiskState{ActiveSAS, ActiveUpload, Attached, ReadyToUpload, Reserved, Unattached}
}

// DiskStorageAccountTypes enumerates the values for disk storage account types.
type DiskStorageAccountTypes string

const (
	// PremiumLRS Premium SSD locally redundant storage. Best for production and performance sensitive
	// workloads.
	PremiumLRS DiskStorageAccountTypes = "Premium_LRS"
	// StandardLRS Standard HDD locally redundant storage. Best for backup, non-critical, and infrequent
	// access.
	StandardLRS DiskStorageAccountTypes = "Standard_LRS"
	// StandardSSDLRS Standard SSD locally redundant storage. Best for web servers, lightly used enterprise
	// applications and dev/test.
	StandardSSDLRS DiskStorageAccountTypes = "StandardSSD_LRS"
	// UltraSSDLRS Ultra SSD locally redundant storage. Best for IO-intensive workloads such as SAP HANA, top
	// tier databases (for example, SQL, Oracle), and other transaction-heavy workloads.
	UltraSSDLRS DiskStorageAccountTypes = "UltraSSD_LRS"
)

// PossibleDiskStorageAccountTypesValues returns an array of possible values for the DiskStorageAccountTypes const type.
func PossibleDiskStorageAccountTypesValues() []DiskStorageAccountTypes {
	return []DiskStorageAccountTypes{PremiumLRS, StandardLRS, StandardSSDLRS, UltraSSDLRS}
}

// HostCaching enumerates the values for host caching.
type HostCaching string

const (
	// HostCachingNone ...
	HostCachingNone HostCaching = "None"
	// HostCachingReadOnly ...
	HostCachingReadOnly HostCaching = "ReadOnly"
	// HostCachingReadWrite ...
	HostCachingReadWrite HostCaching = "ReadWrite"
)

// PossibleHostCachingValues returns an array of possible values for the HostCaching const type.
func PossibleHostCachingValues() []HostCaching {
	return []HostCaching{HostCachingNone, HostCachingReadOnly, HostCachingReadWrite}
}

// HyperVGeneration enumerates the values for hyper v generation.
type HyperVGeneration string

const (
	// V1 ...
	V1 HyperVGeneration = "V1"
	// V2 ...
	V2 HyperVGeneration = "V2"
)

// PossibleHyperVGenerationValues returns an array of possible values for the HyperVGeneration const type.
func PossibleHyperVGenerationValues() []HyperVGeneration {
	return []HyperVGeneration{V1, V2}
}

// HyperVGenerationType enumerates the values for hyper v generation type.
type HyperVGenerationType string

const (
	// HyperVGenerationTypeV1 ...
	HyperVGenerationTypeV1 HyperVGenerationType = "V1"
	// HyperVGenerationTypeV2 ...
	HyperVGenerationTypeV2 HyperVGenerationType = "V2"
)

// PossibleHyperVGenerationTypeValues returns an array of possible values for the HyperVGenerationType const type.
func PossibleHyperVGenerationTypeValues() []HyperVGenerationType {
	return []HyperVGenerationType{HyperVGenerationTypeV1, HyperVGenerationTypeV2}
}

// HyperVGenerationTypes enumerates the values for hyper v generation types.
type HyperVGenerationTypes string

const (
	// HyperVGenerationTypesV1 ...
	HyperVGenerationTypesV1 HyperVGenerationTypes = "V1"
	// HyperVGenerationTypesV2 ...
	HyperVGenerationTypesV2 HyperVGenerationTypes = "V2"
)

// PossibleHyperVGenerationTypesValues returns an array of possible values for the HyperVGenerationTypes const type.
func PossibleHyperVGenerationTypesValues() []HyperVGenerationTypes {
	return []HyperVGenerationTypes{HyperVGenerationTypesV1, HyperVGenerationTypesV2}
}

// InstanceViewTypes enumerates the values for instance view types.
type InstanceViewTypes string

const (
	// InstanceView ...
	InstanceView InstanceViewTypes = "instanceView"
)

// PossibleInstanceViewTypesValues returns an array of possible values for the InstanceViewTypes const type.
func PossibleInstanceViewTypesValues() []InstanceViewTypes {
	return []InstanceViewTypes{InstanceView}
}

// IntervalInMins enumerates the values for interval in mins.
type IntervalInMins string

const (
	// FiveMins ...
	FiveMins IntervalInMins = "FiveMins"
	// SixtyMins ...
	SixtyMins IntervalInMins = "SixtyMins"
	// ThirtyMins ...
	ThirtyMins IntervalInMins = "ThirtyMins"
	// ThreeMins ...
	ThreeMins IntervalInMins = "ThreeMins"
)

// PossibleIntervalInMinsValues returns an array of possible values for the IntervalInMins const type.
func PossibleIntervalInMinsValues() []IntervalInMins {
	return []IntervalInMins{FiveMins, SixtyMins, ThirtyMins, ThreeMins}
}

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPv4 ...
	IPv4 IPVersion = "IPv4"
	// IPv6 ...
	IPv6 IPVersion = "IPv6"
)

// PossibleIPVersionValues returns an array of possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{IPv4, IPv6}
}

// MaintenanceOperationResultCodeTypes enumerates the values for maintenance operation result code types.
type MaintenanceOperationResultCodeTypes string

const (
	// MaintenanceOperationResultCodeTypesMaintenanceAborted ...
	MaintenanceOperationResultCodeTypesMaintenanceAborted MaintenanceOperationResultCodeTypes = "MaintenanceAborted"
	// MaintenanceOperationResultCodeTypesMaintenanceCompleted ...
	MaintenanceOperationResultCodeTypesMaintenanceCompleted MaintenanceOperationResultCodeTypes = "MaintenanceCompleted"
	// MaintenanceOperationResultCodeTypesNone ...
	MaintenanceOperationResultCodeTypesNone MaintenanceOperationResultCodeTypes = "None"
	// MaintenanceOperationResultCodeTypesRetryLater ...
	MaintenanceOperationResultCodeTypesRetryLater MaintenanceOperationResultCodeTypes = "RetryLater"
)

// PossibleMaintenanceOperationResultCodeTypesValues returns an array of possible values for the MaintenanceOperationResultCodeTypes const type.
func PossibleMaintenanceOperationResultCodeTypesValues() []MaintenanceOperationResultCodeTypes {
	return []MaintenanceOperationResultCodeTypes{MaintenanceOperationResultCodeTypesMaintenanceAborted, MaintenanceOperationResultCodeTypesMaintenanceCompleted, MaintenanceOperationResultCodeTypesNone, MaintenanceOperationResultCodeTypesRetryLater}
}

// OperatingSystemStateTypes enumerates the values for operating system state types.
type OperatingSystemStateTypes string

const (
	// Generalized Generalized image. Needs to be provisioned during deployment time.
	Generalized OperatingSystemStateTypes = "Generalized"
	// Specialized Specialized image. Contains already provisioned OS Disk.
	Specialized OperatingSystemStateTypes = "Specialized"
)

// PossibleOperatingSystemStateTypesValues returns an array of possible values for the OperatingSystemStateTypes const type.
func PossibleOperatingSystemStateTypesValues() []OperatingSystemStateTypes {
	return []OperatingSystemStateTypes{Generalized, Specialized}
}

// OperatingSystemTypes enumerates the values for operating system types.
type OperatingSystemTypes string

const (
	// Linux ...
	Linux OperatingSystemTypes = "Linux"
	// Windows ...
	Windows OperatingSystemTypes = "Windows"
)

// PossibleOperatingSystemTypesValues returns an array of possible values for the OperatingSystemTypes const type.
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return []OperatingSystemTypes{Linux, Windows}
}

// PassNames enumerates the values for pass names.
type PassNames string

const (
	// OobeSystem ...
	OobeSystem PassNames = "OobeSystem"
)

// PossiblePassNamesValues returns an array of possible values for the PassNames const type.
func PossiblePassNamesValues() []PassNames {
	return []PassNames{OobeSystem}
}

// ProtocolTypes enumerates the values for protocol types.
type ProtocolTypes string

const (
	// HTTP ...
	HTTP ProtocolTypes = "Http"
	// HTTPS ...
	HTTPS ProtocolTypes = "Https"
)

// PossibleProtocolTypesValues returns an array of possible values for the ProtocolTypes const type.
func PossibleProtocolTypesValues() []ProtocolTypes {
	return []ProtocolTypes{HTTP, HTTPS}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateMigrating ...
	ProvisioningStateMigrating ProvisioningState = "Migrating"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateMigrating, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// ProvisioningState1 enumerates the values for provisioning state 1.
type ProvisioningState1 string

const (
	// ProvisioningState1Creating ...
	ProvisioningState1Creating ProvisioningState1 = "Creating"
	// ProvisioningState1Deleting ...
	ProvisioningState1Deleting ProvisioningState1 = "Deleting"
	// ProvisioningState1Failed ...
	ProvisioningState1Failed ProvisioningState1 = "Failed"
	// ProvisioningState1Migrating ...
	ProvisioningState1Migrating ProvisioningState1 = "Migrating"
	// ProvisioningState1Succeeded ...
	ProvisioningState1Succeeded ProvisioningState1 = "Succeeded"
	// ProvisioningState1Updating ...
	ProvisioningState1Updating ProvisioningState1 = "Updating"
)

// PossibleProvisioningState1Values returns an array of possible values for the ProvisioningState1 const type.
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return []ProvisioningState1{ProvisioningState1Creating, ProvisioningState1Deleting, ProvisioningState1Failed, ProvisioningState1Migrating, ProvisioningState1Succeeded, ProvisioningState1Updating}
}

// ProvisioningState2 enumerates the values for provisioning state 2.
type ProvisioningState2 string

const (
	// ProvisioningState2Creating ...
	ProvisioningState2Creating ProvisioningState2 = "Creating"
	// ProvisioningState2Deleting ...
	ProvisioningState2Deleting ProvisioningState2 = "Deleting"
	// ProvisioningState2Failed ...
	ProvisioningState2Failed ProvisioningState2 = "Failed"
	// ProvisioningState2Migrating ...
	ProvisioningState2Migrating ProvisioningState2 = "Migrating"
	// ProvisioningState2Succeeded ...
	ProvisioningState2Succeeded ProvisioningState2 = "Succeeded"
	// ProvisioningState2Updating ...
	ProvisioningState2Updating ProvisioningState2 = "Updating"
)

// PossibleProvisioningState2Values returns an array of possible values for the ProvisioningState2 const type.
func PossibleProvisioningState2Values() []ProvisioningState2 {
	return []ProvisioningState2{ProvisioningState2Creating, ProvisioningState2Deleting, ProvisioningState2Failed, ProvisioningState2Migrating, ProvisioningState2Succeeded, ProvisioningState2Updating}
}

// ProvisioningState3 enumerates the values for provisioning state 3.
type ProvisioningState3 string

const (
	// ProvisioningState3Creating ...
	ProvisioningState3Creating ProvisioningState3 = "Creating"
	// ProvisioningState3Deleting ...
	ProvisioningState3Deleting ProvisioningState3 = "Deleting"
	// ProvisioningState3Failed ...
	ProvisioningState3Failed ProvisioningState3 = "Failed"
	// ProvisioningState3Migrating ...
	ProvisioningState3Migrating ProvisioningState3 = "Migrating"
	// ProvisioningState3Succeeded ...
	ProvisioningState3Succeeded ProvisioningState3 = "Succeeded"
	// ProvisioningState3Updating ...
	ProvisioningState3Updating ProvisioningState3 = "Updating"
)

// PossibleProvisioningState3Values returns an array of possible values for the ProvisioningState3 const type.
func PossibleProvisioningState3Values() []ProvisioningState3 {
	return []ProvisioningState3{ProvisioningState3Creating, ProvisioningState3Deleting, ProvisioningState3Failed, ProvisioningState3Migrating, ProvisioningState3Succeeded, ProvisioningState3Updating}
}

// ProximityPlacementGroupType enumerates the values for proximity placement group type.
type ProximityPlacementGroupType string

const (
	// Standard ...
	Standard ProximityPlacementGroupType = "Standard"
	// Ultra ...
	Ultra ProximityPlacementGroupType = "Ultra"
)

// PossibleProximityPlacementGroupTypeValues returns an array of possible values for the ProximityPlacementGroupType const type.
func PossibleProximityPlacementGroupTypeValues() []ProximityPlacementGroupType {
	return []ProximityPlacementGroupType{Standard, Ultra}
}

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// ReplicationStateCompleted ...
	ReplicationStateCompleted ReplicationState = "Completed"
	// ReplicationStateFailed ...
	ReplicationStateFailed ReplicationState = "Failed"
	// ReplicationStateReplicating ...
	ReplicationStateReplicating ReplicationState = "Replicating"
	// ReplicationStateUnknown ...
	ReplicationStateUnknown ReplicationState = "Unknown"
)

// PossibleReplicationStateValues returns an array of possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{ReplicationStateCompleted, ReplicationStateFailed, ReplicationStateReplicating, ReplicationStateUnknown}
}

// ReplicationStatusTypes enumerates the values for replication status types.
type ReplicationStatusTypes string

const (
	// ReplicationStatusTypesReplicationStatus ...
	ReplicationStatusTypesReplicationStatus ReplicationStatusTypes = "ReplicationStatus"
)

// PossibleReplicationStatusTypesValues returns an array of possible values for the ReplicationStatusTypes const type.
func PossibleReplicationStatusTypesValues() []ReplicationStatusTypes {
	return []ReplicationStatusTypes{ReplicationStatusTypesReplicationStatus}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// ResourceSkuCapacityScaleType enumerates the values for resource sku capacity scale type.
type ResourceSkuCapacityScaleType string

const (
	// ResourceSkuCapacityScaleTypeAutomatic ...
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = "Automatic"
	// ResourceSkuCapacityScaleTypeManual ...
	ResourceSkuCapacityScaleTypeManual ResourceSkuCapacityScaleType = "Manual"
	// ResourceSkuCapacityScaleTypeNone ...
	ResourceSkuCapacityScaleTypeNone ResourceSkuCapacityScaleType = "None"
)

// PossibleResourceSkuCapacityScaleTypeValues returns an array of possible values for the ResourceSkuCapacityScaleType const type.
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return []ResourceSkuCapacityScaleType{ResourceSkuCapacityScaleTypeAutomatic, ResourceSkuCapacityScaleTypeManual, ResourceSkuCapacityScaleTypeNone}
}

// ResourceSkuRestrictionsReasonCode enumerates the values for resource sku restrictions reason code.
type ResourceSkuRestrictionsReasonCode string

const (
	// NotAvailableForSubscription ...
	NotAvailableForSubscription ResourceSkuRestrictionsReasonCode = "NotAvailableForSubscription"
	// QuotaID ...
	QuotaID ResourceSkuRestrictionsReasonCode = "QuotaId"
)

// PossibleResourceSkuRestrictionsReasonCodeValues returns an array of possible values for the ResourceSkuRestrictionsReasonCode const type.
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return []ResourceSkuRestrictionsReasonCode{NotAvailableForSubscription, QuotaID}
}

// ResourceSkuRestrictionsType enumerates the values for resource sku restrictions type.
type ResourceSkuRestrictionsType string

const (
	// Location ...
	Location ResourceSkuRestrictionsType = "Location"
	// Zone ...
	Zone ResourceSkuRestrictionsType = "Zone"
)

// PossibleResourceSkuRestrictionsTypeValues returns an array of possible values for the ResourceSkuRestrictionsType const type.
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return []ResourceSkuRestrictionsType{Location, Zone}
}

// RollingUpgradeActionType enumerates the values for rolling upgrade action type.
type RollingUpgradeActionType string

const (
	// Cancel ...
	Cancel RollingUpgradeActionType = "Cancel"
	// Start ...
	Start RollingUpgradeActionType = "Start"
)

// PossibleRollingUpgradeActionTypeValues returns an array of possible values for the RollingUpgradeActionType const type.
func PossibleRollingUpgradeActionTypeValues() []RollingUpgradeActionType {
	return []RollingUpgradeActionType{Cancel, Start}
}

// RollingUpgradeStatusCode enumerates the values for rolling upgrade status code.
type RollingUpgradeStatusCode string

const (
	// RollingUpgradeStatusCodeCancelled ...
	RollingUpgradeStatusCodeCancelled RollingUpgradeStatusCode = "Cancelled"
	// RollingUpgradeStatusCodeCompleted ...
	RollingUpgradeStatusCodeCompleted RollingUpgradeStatusCode = "Completed"
	// RollingUpgradeStatusCodeFaulted ...
	RollingUpgradeStatusCodeFaulted RollingUpgradeStatusCode = "Faulted"
	// RollingUpgradeStatusCodeRollingForward ...
	RollingUpgradeStatusCodeRollingForward RollingUpgradeStatusCode = "RollingForward"
)

// PossibleRollingUpgradeStatusCodeValues returns an array of possible values for the RollingUpgradeStatusCode const type.
func PossibleRollingUpgradeStatusCodeValues() []RollingUpgradeStatusCode {
	return []RollingUpgradeStatusCode{RollingUpgradeStatusCodeCancelled, RollingUpgradeStatusCodeCompleted, RollingUpgradeStatusCodeFaulted, RollingUpgradeStatusCodeRollingForward}
}

// SettingNames enumerates the values for setting names.
type SettingNames string

const (
	// AutoLogon ...
	AutoLogon SettingNames = "AutoLogon"
	// FirstLogonCommands ...
	FirstLogonCommands SettingNames = "FirstLogonCommands"
)

// PossibleSettingNamesValues returns an array of possible values for the SettingNames const type.
func PossibleSettingNamesValues() []SettingNames {
	return []SettingNames{AutoLogon, FirstLogonCommands}
}

// SnapshotStorageAccountTypes enumerates the values for snapshot storage account types.
type SnapshotStorageAccountTypes string

const (
	// SnapshotStorageAccountTypesPremiumLRS Premium SSD locally redundant storage
	SnapshotStorageAccountTypesPremiumLRS SnapshotStorageAccountTypes = "Premium_LRS"
	// SnapshotStorageAccountTypesStandardLRS Standard HDD locally redundant storage
	SnapshotStorageAccountTypesStandardLRS SnapshotStorageAccountTypes = "Standard_LRS"
	// SnapshotStorageAccountTypesStandardZRS Standard zone redundant storage
	SnapshotStorageAccountTypesStandardZRS SnapshotStorageAccountTypes = "Standard_ZRS"
)

// PossibleSnapshotStorageAccountTypesValues returns an array of possible values for the SnapshotStorageAccountTypes const type.
func PossibleSnapshotStorageAccountTypesValues() []SnapshotStorageAccountTypes {
	return []SnapshotStorageAccountTypes{SnapshotStorageAccountTypesPremiumLRS, SnapshotStorageAccountTypesStandardLRS, SnapshotStorageAccountTypesStandardZRS}
}

// StatusLevelTypes enumerates the values for status level types.
type StatusLevelTypes string

const (
	// Error ...
	Error StatusLevelTypes = "Error"
	// Info ...
	Info StatusLevelTypes = "Info"
	// Warning ...
	Warning StatusLevelTypes = "Warning"
)

// PossibleStatusLevelTypesValues returns an array of possible values for the StatusLevelTypes const type.
func PossibleStatusLevelTypesValues() []StatusLevelTypes {
	return []StatusLevelTypes{Error, Info, Warning}
}

// StorageAccountType enumerates the values for storage account type.
type StorageAccountType string

const (
	// StorageAccountTypeStandardLRS ...
	StorageAccountTypeStandardLRS StorageAccountType = "Standard_LRS"
	// StorageAccountTypeStandardZRS ...
	StorageAccountTypeStandardZRS StorageAccountType = "Standard_ZRS"
)

// PossibleStorageAccountTypeValues returns an array of possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{StorageAccountTypeStandardLRS, StorageAccountTypeStandardZRS}
}

// StorageAccountTypes enumerates the values for storage account types.
type StorageAccountTypes string

const (
	// StorageAccountTypesPremiumLRS ...
	StorageAccountTypesPremiumLRS StorageAccountTypes = "Premium_LRS"
	// StorageAccountTypesStandardLRS ...
	StorageAccountTypesStandardLRS StorageAccountTypes = "Standard_LRS"
	// StorageAccountTypesStandardSSDLRS ...
	StorageAccountTypesStandardSSDLRS StorageAccountTypes = "StandardSSD_LRS"
	// StorageAccountTypesUltraSSDLRS ...
	StorageAccountTypesUltraSSDLRS StorageAccountTypes = "UltraSSD_LRS"
)

// PossibleStorageAccountTypesValues returns an array of possible values for the StorageAccountTypes const type.
func PossibleStorageAccountTypesValues() []StorageAccountTypes {
	return []StorageAccountTypes{StorageAccountTypesPremiumLRS, StorageAccountTypesStandardLRS, StorageAccountTypesStandardSSDLRS, StorageAccountTypesUltraSSDLRS}
}

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// Automatic ...
	Automatic UpgradeMode = "Automatic"
	// Manual ...
	Manual UpgradeMode = "Manual"
	// Rolling ...
	Rolling UpgradeMode = "Rolling"
)

// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{Automatic, Manual, Rolling}
}

// UpgradeOperationInvoker enumerates the values for upgrade operation invoker.
type UpgradeOperationInvoker string

const (
	// UpgradeOperationInvokerPlatform ...
	UpgradeOperationInvokerPlatform UpgradeOperationInvoker = "Platform"
	// UpgradeOperationInvokerUnknown ...
	UpgradeOperationInvokerUnknown UpgradeOperationInvoker = "Unknown"
	// UpgradeOperationInvokerUser ...
	UpgradeOperationInvokerUser UpgradeOperationInvoker = "User"
)

// PossibleUpgradeOperationInvokerValues returns an array of possible values for the UpgradeOperationInvoker const type.
func PossibleUpgradeOperationInvokerValues() []UpgradeOperationInvoker {
	return []UpgradeOperationInvoker{UpgradeOperationInvokerPlatform, UpgradeOperationInvokerUnknown, UpgradeOperationInvokerUser}
}

// UpgradeState enumerates the values for upgrade state.
type UpgradeState string

const (
	// UpgradeStateCancelled ...
	UpgradeStateCancelled UpgradeState = "Cancelled"
	// UpgradeStateCompleted ...
	UpgradeStateCompleted UpgradeState = "Completed"
	// UpgradeStateFaulted ...
	UpgradeStateFaulted UpgradeState = "Faulted"
	// UpgradeStateRollingForward ...
	UpgradeStateRollingForward UpgradeState = "RollingForward"
)

// PossibleUpgradeStateValues returns an array of possible values for the UpgradeState const type.
func PossibleUpgradeStateValues() []UpgradeState {
	return []UpgradeState{UpgradeStateCancelled, UpgradeStateCompleted, UpgradeStateFaulted, UpgradeStateRollingForward}
}

// VirtualMachineEvictionPolicyTypes enumerates the values for virtual machine eviction policy types.
type VirtualMachineEvictionPolicyTypes string

const (
	// Deallocate ...
	Deallocate VirtualMachineEvictionPolicyTypes = "Deallocate"
	// Delete ...
	Delete VirtualMachineEvictionPolicyTypes = "Delete"
)

// PossibleVirtualMachineEvictionPolicyTypesValues returns an array of possible values for the VirtualMachineEvictionPolicyTypes const type.
func PossibleVirtualMachineEvictionPolicyTypesValues() []VirtualMachineEvictionPolicyTypes {
	return []VirtualMachineEvictionPolicyTypes{Deallocate, Delete}
}

// VirtualMachinePriorityTypes enumerates the values for virtual machine priority types.
type VirtualMachinePriorityTypes string

const (
	// Low ...
	Low VirtualMachinePriorityTypes = "Low"
	// Regular ...
	Regular VirtualMachinePriorityTypes = "Regular"
	// Spot ...
	Spot VirtualMachinePriorityTypes = "Spot"
)

// PossibleVirtualMachinePriorityTypesValues returns an array of possible values for the VirtualMachinePriorityTypes const type.
func PossibleVirtualMachinePriorityTypesValues() []VirtualMachinePriorityTypes {
	return []VirtualMachinePriorityTypes{Low, Regular, Spot}
}

// VirtualMachineScaleSetScaleInRules enumerates the values for virtual machine scale set scale in rules.
type VirtualMachineScaleSetScaleInRules string

const (
	// Default ...
	Default VirtualMachineScaleSetScaleInRules = "Default"
	// NewestVM ...
	NewestVM VirtualMachineScaleSetScaleInRules = "NewestVM"
	// OldestVM ...
	OldestVM VirtualMachineScaleSetScaleInRules = "OldestVM"
)

// PossibleVirtualMachineScaleSetScaleInRulesValues returns an array of possible values for the VirtualMachineScaleSetScaleInRules const type.
func PossibleVirtualMachineScaleSetScaleInRulesValues() []VirtualMachineScaleSetScaleInRules {
	return []VirtualMachineScaleSetScaleInRules{Default, NewestVM, OldestVM}
}

// VirtualMachineScaleSetSkuScaleType enumerates the values for virtual machine scale set sku scale type.
type VirtualMachineScaleSetSkuScaleType string

const (
	// VirtualMachineScaleSetSkuScaleTypeAutomatic ...
	VirtualMachineScaleSetSkuScaleTypeAutomatic VirtualMachineScaleSetSkuScaleType = "Automatic"
	// VirtualMachineScaleSetSkuScaleTypeNone ...
	VirtualMachineScaleSetSkuScaleTypeNone VirtualMachineScaleSetSkuScaleType = "None"
)

// PossibleVirtualMachineScaleSetSkuScaleTypeValues returns an array of possible values for the VirtualMachineScaleSetSkuScaleType const type.
func PossibleVirtualMachineScaleSetSkuScaleTypeValues() []VirtualMachineScaleSetSkuScaleType {
	return []VirtualMachineScaleSetSkuScaleType{VirtualMachineScaleSetSkuScaleTypeAutomatic, VirtualMachineScaleSetSkuScaleTypeNone}
}

// VirtualMachineSizeTypes enumerates the values for virtual machine size types.
type VirtualMachineSizeTypes string

const (
	// VirtualMachineSizeTypesBasicA0 ...
	VirtualMachineSizeTypesBasicA0 VirtualMachineSizeTypes = "Basic_A0"
	// VirtualMachineSizeTypesBasicA1 ...
	VirtualMachineSizeTypesBasicA1 VirtualMachineSizeTypes = "Basic_A1"
	// VirtualMachineSizeTypesBasicA2 ...
	VirtualMachineSizeTypesBasicA2 VirtualMachineSizeTypes = "Basic_A2"
	// VirtualMachineSizeTypesBasicA3 ...
	VirtualMachineSizeTypesBasicA3 VirtualMachineSizeTypes = "Basic_A3"
	// VirtualMachineSizeTypesBasicA4 ...
	VirtualMachineSizeTypesBasicA4 VirtualMachineSizeTypes = "Basic_A4"
	// VirtualMachineSizeTypesStandardA0 ...
	VirtualMachineSizeTypesStandardA0 VirtualMachineSizeTypes = "Standard_A0"
	// VirtualMachineSizeTypesStandardA1 ...
	VirtualMachineSizeTypesStandardA1 VirtualMachineSizeTypes = "Standard_A1"
	// VirtualMachineSizeTypesStandardA10 ...
	VirtualMachineSizeTypesStandardA10 VirtualMachineSizeTypes = "Standard_A10"
	// VirtualMachineSizeTypesStandardA11 ...
	VirtualMachineSizeTypesStandardA11 VirtualMachineSizeTypes = "Standard_A11"
	// VirtualMachineSizeTypesStandardA1V2 ...
	VirtualMachineSizeTypesStandardA1V2 VirtualMachineSizeTypes = "Standard_A1_v2"
	// VirtualMachineSizeTypesStandardA2 ...
	VirtualMachineSizeTypesStandardA2 VirtualMachineSizeTypes = "Standard_A2"
	// VirtualMachineSizeTypesStandardA2mV2 ...
	VirtualMachineSizeTypesStandardA2mV2 VirtualMachineSizeTypes = "Standard_A2m_v2"
	// VirtualMachineSizeTypesStandardA2V2 ...
	VirtualMachineSizeTypesStandardA2V2 VirtualMachineSizeTypes = "Standard_A2_v2"
	// VirtualMachineSizeTypesStandardA3 ...
	VirtualMachineSizeTypesStandardA3 VirtualMachineSizeTypes = "Standard_A3"
	// VirtualMachineSizeTypesStandardA4 ...
	VirtualMachineSizeTypesStandardA4 VirtualMachineSizeTypes = "Standard_A4"
	// VirtualMachineSizeTypesStandardA4mV2 ...
	VirtualMachineSizeTypesStandardA4mV2 VirtualMachineSizeTypes = "Standard_A4m_v2"
	// VirtualMachineSizeTypesStandardA4V2 ...
	VirtualMachineSizeTypesStandardA4V2 VirtualMachineSizeTypes = "Standard_A4_v2"
	// VirtualMachineSizeTypesStandardA5 ...
	VirtualMachineSizeTypesStandardA5 VirtualMachineSizeTypes = "Standard_A5"
	// VirtualMachineSizeTypesStandardA6 ...
	VirtualMachineSizeTypesStandardA6 VirtualMachineSizeTypes = "Standard_A6"
	// VirtualMachineSizeTypesStandardA7 ...
	VirtualMachineSizeTypesStandardA7 VirtualMachineSizeTypes = "Standard_A7"
	// VirtualMachineSizeTypesStandardA8 ...
	VirtualMachineSizeTypesStandardA8 VirtualMachineSizeTypes = "Standard_A8"
	// VirtualMachineSizeTypesStandardA8mV2 ...
	VirtualMachineSizeTypesStandardA8mV2 VirtualMachineSizeTypes = "Standard_A8m_v2"
	// VirtualMachineSizeTypesStandardA8V2 ...
	VirtualMachineSizeTypesStandardA8V2 VirtualMachineSizeTypes = "Standard_A8_v2"
	// VirtualMachineSizeTypesStandardA9 ...
	VirtualMachineSizeTypesStandardA9 VirtualMachineSizeTypes = "Standard_A9"
	// VirtualMachineSizeTypesStandardB1ms ...
	VirtualMachineSizeTypesStandardB1ms VirtualMachineSizeTypes = "Standard_B1ms"
	// VirtualMachineSizeTypesStandardB1s ...
	VirtualMachineSizeTypesStandardB1s VirtualMachineSizeTypes = "Standard_B1s"
	// VirtualMachineSizeTypesStandardB2ms ...
	VirtualMachineSizeTypesStandardB2ms VirtualMachineSizeTypes = "Standard_B2ms"
	// VirtualMachineSizeTypesStandardB2s ...
	VirtualMachineSizeTypesStandardB2s VirtualMachineSizeTypes = "Standard_B2s"
	// VirtualMachineSizeTypesStandardB4ms ...
	VirtualMachineSizeTypesStandardB4ms VirtualMachineSizeTypes = "Standard_B4ms"
	// VirtualMachineSizeTypesStandardB8ms ...
	VirtualMachineSizeTypesStandardB8ms VirtualMachineSizeTypes = "Standard_B8ms"
	// VirtualMachineSizeTypesStandardD1 ...
	VirtualMachineSizeTypesStandardD1 VirtualMachineSizeTypes = "Standard_D1"
	// VirtualMachineSizeTypesStandardD11 ...
	VirtualMachineSizeTypesStandardD11 VirtualMachineSizeTypes = "Standard_D11"
	// VirtualMachineSizeTypesStandardD11V2 ...
	VirtualMachineSizeTypesStandardD11V2 VirtualMachineSizeTypes = "Standard_D11_v2"
	// VirtualMachineSizeTypesStandardD12 ...
	VirtualMachineSizeTypesStandardD12 VirtualMachineSizeTypes = "Standard_D12"
	// VirtualMachineSizeTypesStandardD12V2 ...
	VirtualMachineSizeTypesStandardD12V2 VirtualMachineSizeTypes = "Standard_D12_v2"
	// VirtualMachineSizeTypesStandardD13 ...
	VirtualMachineSizeTypesStandardD13 VirtualMachineSizeTypes = "Standard_D13"
	// VirtualMachineSizeTypesStandardD13V2 ...
	VirtualMachineSizeTypesStandardD13V2 VirtualMachineSizeTypes = "Standard_D13_v2"
	// VirtualMachineSizeTypesStandardD14 ...
	VirtualMachineSizeTypesStandardD14 VirtualMachineSizeTypes = "Standard_D14"
	// VirtualMachineSizeTypesStandardD14V2 ...
	VirtualMachineSizeTypesStandardD14V2 VirtualMachineSizeTypes = "Standard_D14_v2"
	// VirtualMachineSizeTypesStandardD15V2 ...
	VirtualMachineSizeTypesStandardD15V2 VirtualMachineSizeTypes = "Standard_D15_v2"
	// VirtualMachineSizeTypesStandardD16sV3 ...
	VirtualMachineSizeTypesStandardD16sV3 VirtualMachineSizeTypes = "Standard_D16s_v3"
	// VirtualMachineSizeTypesStandardD16V3 ...
	VirtualMachineSizeTypesStandardD16V3 VirtualMachineSizeTypes = "Standard_D16_v3"
	// VirtualMachineSizeTypesStandardD1V2 ...
	VirtualMachineSizeTypesStandardD1V2 VirtualMachineSizeTypes = "Standard_D1_v2"
	// VirtualMachineSizeTypesStandardD2 ...
	VirtualMachineSizeTypesStandardD2 VirtualMachineSizeTypes = "Standard_D2"
	// VirtualMachineSizeTypesStandardD2sV3 ...
	VirtualMachineSizeTypesStandardD2sV3 VirtualMachineSizeTypes = "Standard_D2s_v3"
	// VirtualMachineSizeTypesStandardD2V2 ...
	VirtualMachineSizeTypesStandardD2V2 VirtualMachineSizeTypes = "Standard_D2_v2"
	// VirtualMachineSizeTypesStandardD2V3 ...
	VirtualMachineSizeTypesStandardD2V3 VirtualMachineSizeTypes = "Standard_D2_v3"
	// VirtualMachineSizeTypesStandardD3 ...
	VirtualMachineSizeTypesStandardD3 VirtualMachineSizeTypes = "Standard_D3"
	// VirtualMachineSizeTypesStandardD32sV3 ...
	VirtualMachineSizeTypesStandardD32sV3 VirtualMachineSizeTypes = "Standard_D32s_v3"
	// VirtualMachineSizeTypesStandardD32V3 ...
	VirtualMachineSizeTypesStandardD32V3 VirtualMachineSizeTypes = "Standard_D32_v3"
	// VirtualMachineSizeTypesStandardD3V2 ...
	VirtualMachineSizeTypesStandardD3V2 VirtualMachineSizeTypes = "Standard_D3_v2"
	// VirtualMachineSizeTypesStandardD4 ...
	VirtualMachineSizeTypesStandardD4 VirtualMachineSizeTypes = "Standard_D4"
	// VirtualMachineSizeTypesStandardD4sV3 ...
	VirtualMachineSizeTypesStandardD4sV3 VirtualMachineSizeTypes = "Standard_D4s_v3"
	// VirtualMachineSizeTypesStandardD4V2 ...
	VirtualMachineSizeTypesStandardD4V2 VirtualMachineSizeTypes = "Standard_D4_v2"
	// VirtualMachineSizeTypesStandardD4V3 ...
	VirtualMachineSizeTypesStandardD4V3 VirtualMachineSizeTypes = "Standard_D4_v3"
	// VirtualMachineSizeTypesStandardD5V2 ...
	VirtualMachineSizeTypesStandardD5V2 VirtualMachineSizeTypes = "Standard_D5_v2"
	// VirtualMachineSizeTypesStandardD64sV3 ...
	VirtualMachineSizeTypesStandardD64sV3 VirtualMachineSizeTypes = "Standard_D64s_v3"
	// VirtualMachineSizeTypesStandardD64V3 ...
	VirtualMachineSizeTypesStandardD64V3 VirtualMachineSizeTypes = "Standard_D64_v3"
	// VirtualMachineSizeTypesStandardD8sV3 ...
	VirtualMachineSizeTypesStandardD8sV3 VirtualMachineSizeTypes = "Standard_D8s_v3"
	// VirtualMachineSizeTypesStandardD8V3 ...
	VirtualMachineSizeTypesStandardD8V3 VirtualMachineSizeTypes = "Standard_D8_v3"
	// VirtualMachineSizeTypesStandardDS1 ...
	VirtualMachineSizeTypesStandardDS1 VirtualMachineSizeTypes = "Standard_DS1"
	// VirtualMachineSizeTypesStandardDS11 ...
	VirtualMachineSizeTypesStandardDS11 VirtualMachineSizeTypes = "Standard_DS11"
	// VirtualMachineSizeTypesStandardDS11V2 ...
	VirtualMachineSizeTypesStandardDS11V2 VirtualMachineSizeTypes = "Standard_DS11_v2"
	// VirtualMachineSizeTypesStandardDS12 ...
	VirtualMachineSizeTypesStandardDS12 VirtualMachineSizeTypes = "Standard_DS12"
	// VirtualMachineSizeTypesStandardDS12V2 ...
	VirtualMachineSizeTypesStandardDS12V2 VirtualMachineSizeTypes = "Standard_DS12_v2"
	// VirtualMachineSizeTypesStandardDS13 ...
	VirtualMachineSizeTypesStandardDS13 VirtualMachineSizeTypes = "Standard_DS13"
	// VirtualMachineSizeTypesStandardDS132V2 ...
	VirtualMachineSizeTypesStandardDS132V2 VirtualMachineSizeTypes = "Standard_DS13-2_v2"
	// VirtualMachineSizeTypesStandardDS134V2 ...
	VirtualMachineSizeTypesStandardDS134V2 VirtualMachineSizeTypes = "Standard_DS13-4_v2"
	// VirtualMachineSizeTypesStandardDS13V2 ...
	VirtualMachineSizeTypesStandardDS13V2 VirtualMachineSizeTypes = "Standard_DS13_v2"
	// VirtualMachineSizeTypesStandardDS14 ...
	VirtualMachineSizeTypesStandardDS14 VirtualMachineSizeTypes = "Standard_DS14"
	// VirtualMachineSizeTypesStandardDS144V2 ...
	VirtualMachineSizeTypesStandardDS144V2 VirtualMachineSizeTypes = "Standard_DS14-4_v2"
	// VirtualMachineSizeTypesStandardDS148V2 ...
	VirtualMachineSizeTypesStandardDS148V2 VirtualMachineSizeTypes = "Standard_DS14-8_v2"
	// VirtualMachineSizeTypesStandardDS14V2 ...
	VirtualMachineSizeTypesStandardDS14V2 VirtualMachineSizeTypes = "Standard_DS14_v2"
	// VirtualMachineSizeTypesStandardDS15V2 ...
	VirtualMachineSizeTypesStandardDS15V2 VirtualMachineSizeTypes = "Standard_DS15_v2"
	// VirtualMachineSizeTypesStandardDS1V2 ...
	VirtualMachineSizeTypesStandardDS1V2 VirtualMachineSizeTypes = "Standard_DS1_v2"
	// VirtualMachineSizeTypesStandardDS2 ...
	VirtualMachineSizeTypesStandardDS2 VirtualMachineSizeTypes = "Standard_DS2"
	// VirtualMachineSizeTypesStandardDS2V2 ...
	VirtualMachineSizeTypesStandardDS2V2 VirtualMachineSizeTypes = "Standard_DS2_v2"
	// VirtualMachineSizeTypesStandardDS3 ...
	VirtualMachineSizeTypesStandardDS3 VirtualMachineSizeTypes = "Standard_DS3"
	// VirtualMachineSizeTypesStandardDS3V2 ...
	VirtualMachineSizeTypesStandardDS3V2 VirtualMachineSizeTypes = "Standard_DS3_v2"
	// VirtualMachineSizeTypesStandardDS4 ...
	VirtualMachineSizeTypesStandardDS4 VirtualMachineSizeTypes = "Standard_DS4"
	// VirtualMachineSizeTypesStandardDS4V2 ...
	VirtualMachineSizeTypesStandardDS4V2 VirtualMachineSizeTypes = "Standard_DS4_v2"
	// VirtualMachineSizeTypesStandardDS5V2 ...
	VirtualMachineSizeTypesStandardDS5V2 VirtualMachineSizeTypes = "Standard_DS5_v2"
	// VirtualMachineSizeTypesStandardE16sV3 ...
	VirtualMachineSizeTypesStandardE16sV3 VirtualMachineSizeTypes = "Standard_E16s_v3"
	// VirtualMachineSizeTypesStandardE16V3 ...
	VirtualMachineSizeTypesStandardE16V3 VirtualMachineSizeTypes = "Standard_E16_v3"
	// VirtualMachineSizeTypesStandardE2sV3 ...
	VirtualMachineSizeTypesStandardE2sV3 VirtualMachineSizeTypes = "Standard_E2s_v3"
	// VirtualMachineSizeTypesStandardE2V3 ...
	VirtualMachineSizeTypesStandardE2V3 VirtualMachineSizeTypes = "Standard_E2_v3"
	// VirtualMachineSizeTypesStandardE3216V3 ...
	VirtualMachineSizeTypesStandardE3216V3 VirtualMachineSizeTypes = "Standard_E32-16_v3"
	// VirtualMachineSizeTypesStandardE328sV3 ...
	VirtualMachineSizeTypesStandardE328sV3 VirtualMachineSizeTypes = "Standard_E32-8s_v3"
	// VirtualMachineSizeTypesStandardE32sV3 ...
	VirtualMachineSizeTypesStandardE32sV3 VirtualMachineSizeTypes = "Standard_E32s_v3"
	// VirtualMachineSizeTypesStandardE32V3 ...
	VirtualMachineSizeTypesStandardE32V3 VirtualMachineSizeTypes = "Standard_E32_v3"
	// VirtualMachineSizeTypesStandardE4sV3 ...
	VirtualMachineSizeTypesStandardE4sV3 VirtualMachineSizeTypes = "Standard_E4s_v3"
	// VirtualMachineSizeTypesStandardE4V3 ...
	VirtualMachineSizeTypesStandardE4V3 VirtualMachineSizeTypes = "Standard_E4_v3"
	// VirtualMachineSizeTypesStandardE6416sV3 ...
	VirtualMachineSizeTypesStandardE6416sV3 VirtualMachineSizeTypes = "Standard_E64-16s_v3"
	// VirtualMachineSizeTypesStandardE6432sV3 ...
	VirtualMachineSizeTypesStandardE6432sV3 VirtualMachineSizeTypes = "Standard_E64-32s_v3"
	// VirtualMachineSizeTypesStandardE64sV3 ...
	VirtualMachineSizeTypesStandardE64sV3 VirtualMachineSizeTypes = "Standard_E64s_v3"
	// VirtualMachineSizeTypesStandardE64V3 ...
	VirtualMachineSizeTypesStandardE64V3 VirtualMachineSizeTypes = "Standard_E64_v3"
	// VirtualMachineSizeTypesStandardE8sV3 ...
	VirtualMachineSizeTypesStandardE8sV3 VirtualMachineSizeTypes = "Standard_E8s_v3"
	// VirtualMachineSizeTypesStandardE8V3 ...
	VirtualMachineSizeTypesStandardE8V3 VirtualMachineSizeTypes = "Standard_E8_v3"
	// VirtualMachineSizeTypesStandardF1 ...
	VirtualMachineSizeTypesStandardF1 VirtualMachineSizeTypes = "Standard_F1"
	// VirtualMachineSizeTypesStandardF16 ...
	VirtualMachineSizeTypesStandardF16 VirtualMachineSizeTypes = "Standard_F16"
	// VirtualMachineSizeTypesStandardF16s ...
	VirtualMachineSizeTypesStandardF16s VirtualMachineSizeTypes = "Standard_F16s"
	// VirtualMachineSizeTypesStandardF16sV2 ...
	VirtualMachineSizeTypesStandardF16sV2 VirtualMachineSizeTypes = "Standard_F16s_v2"
	// VirtualMachineSizeTypesStandardF1s ...
	VirtualMachineSizeTypesStandardF1s VirtualMachineSizeTypes = "Standard_F1s"
	// VirtualMachineSizeTypesStandardF2 ...
	VirtualMachineSizeTypesStandardF2 VirtualMachineSizeTypes = "Standard_F2"
	// VirtualMachineSizeTypesStandardF2s ...
	VirtualMachineSizeTypesStandardF2s VirtualMachineSizeTypes = "Standard_F2s"
	// VirtualMachineSizeTypesStandardF2sV2 ...
	VirtualMachineSizeTypesStandardF2sV2 VirtualMachineSizeTypes = "Standard_F2s_v2"
	// VirtualMachineSizeTypesStandardF32sV2 ...
	VirtualMachineSizeTypesStandardF32sV2 VirtualMachineSizeTypes = "Standard_F32s_v2"
	// VirtualMachineSizeTypesStandardF4 ...
	VirtualMachineSizeTypesStandardF4 VirtualMachineSizeTypes = "Standard_F4"
	// VirtualMachineSizeTypesStandardF4s ...
	VirtualMachineSizeTypesStandardF4s VirtualMachineSizeTypes = "Standard_F4s"
	// VirtualMachineSizeTypesStandardF4sV2 ...
	VirtualMachineSizeTypesStandardF4sV2 VirtualMachineSizeTypes = "Standard_F4s_v2"
	// VirtualMachineSizeTypesStandardF64sV2 ...
	VirtualMachineSizeTypesStandardF64sV2 VirtualMachineSizeTypes = "Standard_F64s_v2"
	// VirtualMachineSizeTypesStandardF72sV2 ...
	VirtualMachineSizeTypesStandardF72sV2 VirtualMachineSizeTypes = "Standard_F72s_v2"
	// VirtualMachineSizeTypesStandardF8 ...
	VirtualMachineSizeTypesStandardF8 VirtualMachineSizeTypes = "Standard_F8"
	// VirtualMachineSizeTypesStandardF8s ...
	VirtualMachineSizeTypesStandardF8s VirtualMachineSizeTypes = "Standard_F8s"
	// VirtualMachineSizeTypesStandardF8sV2 ...
	VirtualMachineSizeTypesStandardF8sV2 VirtualMachineSizeTypes = "Standard_F8s_v2"
	// VirtualMachineSizeTypesStandardG1 ...
	VirtualMachineSizeTypesStandardG1 VirtualMachineSizeTypes = "Standard_G1"
	// VirtualMachineSizeTypesStandardG2 ...
	VirtualMachineSizeTypesStandardG2 VirtualMachineSizeTypes = "Standard_G2"
	// VirtualMachineSizeTypesStandardG3 ...
	VirtualMachineSizeTypesStandardG3 VirtualMachineSizeTypes = "Standard_G3"
	// VirtualMachineSizeTypesStandardG4 ...
	VirtualMachineSizeTypesStandardG4 VirtualMachineSizeTypes = "Standard_G4"
	// VirtualMachineSizeTypesStandardG5 ...
	VirtualMachineSizeTypesStandardG5 VirtualMachineSizeTypes = "Standard_G5"
	// VirtualMachineSizeTypesStandardGS1 ...
	VirtualMachineSizeTypesStandardGS1 VirtualMachineSizeTypes = "Standard_GS1"
	// VirtualMachineSizeTypesStandardGS2 ...
	VirtualMachineSizeTypesStandardGS2 VirtualMachineSizeTypes = "Standard_GS2"
	// VirtualMachineSizeTypesStandardGS3 ...
	VirtualMachineSizeTypesStandardGS3 VirtualMachineSizeTypes = "Standard_GS3"
	// VirtualMachineSizeTypesStandardGS4 ...
	VirtualMachineSizeTypesStandardGS4 VirtualMachineSizeTypes = "Standard_GS4"
	// VirtualMachineSizeTypesStandardGS44 ...
	VirtualMachineSizeTypesStandardGS44 VirtualMachineSizeTypes = "Standard_GS4-4"
	// VirtualMachineSizeTypesStandardGS48 ...
	VirtualMachineSizeTypesStandardGS48 VirtualMachineSizeTypes = "Standard_GS4-8"
	// VirtualMachineSizeTypesStandardGS5 ...
	VirtualMachineSizeTypesStandardGS5 VirtualMachineSizeTypes = "Standard_GS5"
	// VirtualMachineSizeTypesStandardGS516 ...
	VirtualMachineSizeTypesStandardGS516 VirtualMachineSizeTypes = "Standard_GS5-16"
	// VirtualMachineSizeTypesStandardGS58 ...
	VirtualMachineSizeTypesStandardGS58 VirtualMachineSizeTypes = "Standard_GS5-8"
	// VirtualMachineSizeTypesStandardH16 ...
	VirtualMachineSizeTypesStandardH16 VirtualMachineSizeTypes = "Standard_H16"
	// VirtualMachineSizeTypesStandardH16m ...
	VirtualMachineSizeTypesStandardH16m VirtualMachineSizeTypes = "Standard_H16m"
	// VirtualMachineSizeTypesStandardH16mr ...
	VirtualMachineSizeTypesStandardH16mr VirtualMachineSizeTypes = "Standard_H16mr"
	// VirtualMachineSizeTypesStandardH16r ...
	VirtualMachineSizeTypesStandardH16r VirtualMachineSizeTypes = "Standard_H16r"
	// VirtualMachineSizeTypesStandardH8 ...
	VirtualMachineSizeTypesStandardH8 VirtualMachineSizeTypes = "Standard_H8"
	// VirtualMachineSizeTypesStandardH8m ...
	VirtualMachineSizeTypesStandardH8m VirtualMachineSizeTypes = "Standard_H8m"
	// VirtualMachineSizeTypesStandardL16s ...
	VirtualMachineSizeTypesStandardL16s VirtualMachineSizeTypes = "Standard_L16s"
	// VirtualMachineSizeTypesStandardL32s ...
	VirtualMachineSizeTypesStandardL32s VirtualMachineSizeTypes = "Standard_L32s"
	// VirtualMachineSizeTypesStandardL4s ...
	VirtualMachineSizeTypesStandardL4s VirtualMachineSizeTypes = "Standard_L4s"
	// VirtualMachineSizeTypesStandardL8s ...
	VirtualMachineSizeTypesStandardL8s VirtualMachineSizeTypes = "Standard_L8s"
	// VirtualMachineSizeTypesStandardM12832ms ...
	VirtualMachineSizeTypesStandardM12832ms VirtualMachineSizeTypes = "Standard_M128-32ms"
	// VirtualMachineSizeTypesStandardM12864ms ...
	VirtualMachineSizeTypesStandardM12864ms VirtualMachineSizeTypes = "Standard_M128-64ms"
	// VirtualMachineSizeTypesStandardM128ms ...
	VirtualMachineSizeTypesStandardM128ms VirtualMachineSizeTypes = "Standard_M128ms"
	// VirtualMachineSizeTypesStandardM128s ...
	VirtualMachineSizeTypesStandardM128s VirtualMachineSizeTypes = "Standard_M128s"
	// VirtualMachineSizeTypesStandardM6416ms ...
	VirtualMachineSizeTypesStandardM6416ms VirtualMachineSizeTypes = "Standard_M64-16ms"
	// VirtualMachineSizeTypesStandardM6432ms ...
	VirtualMachineSizeTypesStandardM6432ms VirtualMachineSizeTypes = "Standard_M64-32ms"
	// VirtualMachineSizeTypesStandardM64ms ...
	VirtualMachineSizeTypesStandardM64ms VirtualMachineSizeTypes = "Standard_M64ms"
	// VirtualMachineSizeTypesStandardM64s ...
	VirtualMachineSizeTypesStandardM64s VirtualMachineSizeTypes = "Standard_M64s"
	// VirtualMachineSizeTypesStandardNC12 ...
	VirtualMachineSizeTypesStandardNC12 VirtualMachineSizeTypes = "Standard_NC12"
	// VirtualMachineSizeTypesStandardNC12sV2 ...
	VirtualMachineSizeTypesStandardNC12sV2 VirtualMachineSizeTypes = "Standard_NC12s_v2"
	// VirtualMachineSizeTypesStandardNC12sV3 ...
	VirtualMachineSizeTypesStandardNC12sV3 VirtualMachineSizeTypes = "Standard_NC12s_v3"
	// VirtualMachineSizeTypesStandardNC24 ...
	VirtualMachineSizeTypesStandardNC24 VirtualMachineSizeTypes = "Standard_NC24"
	// VirtualMachineSizeTypesStandardNC24r ...
	VirtualMachineSizeTypesStandardNC24r VirtualMachineSizeTypes = "Standard_NC24r"
	// VirtualMachineSizeTypesStandardNC24rsV2 ...
	VirtualMachineSizeTypesStandardNC24rsV2 VirtualMachineSizeTypes = "Standard_NC24rs_v2"
	// VirtualMachineSizeTypesStandardNC24rsV3 ...
	VirtualMachineSizeTypesStandardNC24rsV3 VirtualMachineSizeTypes = "Standard_NC24rs_v3"
	// VirtualMachineSizeTypesStandardNC24sV2 ...
	VirtualMachineSizeTypesStandardNC24sV2 VirtualMachineSizeTypes = "Standard_NC24s_v2"
	// VirtualMachineSizeTypesStandardNC24sV3 ...
	VirtualMachineSizeTypesStandardNC24sV3 VirtualMachineSizeTypes = "Standard_NC24s_v3"
	// VirtualMachineSizeTypesStandardNC6 ...
	VirtualMachineSizeTypesStandardNC6 VirtualMachineSizeTypes = "Standard_NC6"
	// VirtualMachineSizeTypesStandardNC6sV2 ...
	VirtualMachineSizeTypesStandardNC6sV2 VirtualMachineSizeTypes = "Standard_NC6s_v2"
	// VirtualMachineSizeTypesStandardNC6sV3 ...
	VirtualMachineSizeTypesStandardNC6sV3 VirtualMachineSizeTypes = "Standard_NC6s_v3"
	// VirtualMachineSizeTypesStandardND12s ...
	VirtualMachineSizeTypesStandardND12s VirtualMachineSizeTypes = "Standard_ND12s"
	// VirtualMachineSizeTypesStandardND24rs ...
	VirtualMachineSizeTypesStandardND24rs VirtualMachineSizeTypes = "Standard_ND24rs"
	// VirtualMachineSizeTypesStandardND24s ...
	VirtualMachineSizeTypesStandardND24s VirtualMachineSizeTypes = "Standard_ND24s"
	// VirtualMachineSizeTypesStandardND6s ...
	VirtualMachineSizeTypesStandardND6s VirtualMachineSizeTypes = "Standard_ND6s"
	// VirtualMachineSizeTypesStandardNV12 ...
	VirtualMachineSizeTypesStandardNV12 VirtualMachineSizeTypes = "Standard_NV12"
	// VirtualMachineSizeTypesStandardNV24 ...
	VirtualMachineSizeTypesStandardNV24 VirtualMachineSizeTypes = "Standard_NV24"
	// VirtualMachineSizeTypesStandardNV6 ...
	VirtualMachineSizeTypesStandardNV6 VirtualMachineSizeTypes = "Standard_NV6"
)

// PossibleVirtualMachineSizeTypesValues returns an array of possible values for the VirtualMachineSizeTypes const type.
func PossibleVirtualMachineSizeTypesValues() []VirtualMachineSizeTypes {
	return []VirtualMachineSizeTypes{VirtualMachineSizeTypesBasicA0, VirtualMachineSizeTypesBasicA1, VirtualMachineSizeTypesBasicA2, VirtualMachineSizeTypesBasicA3, VirtualMachineSizeTypesBasicA4, VirtualMachineSizeTypesStandardA0, VirtualMachineSizeTypesStandardA1, VirtualMachineSizeTypesStandardA10, VirtualMachineSizeTypesStandardA11, VirtualMachineSizeTypesStandardA1V2, VirtualMachineSizeTypesStandardA2, VirtualMachineSizeTypesStandardA2mV2, VirtualMachineSizeTypesStandardA2V2, VirtualMachineSizeTypesStandardA3, VirtualMachineSizeTypesStandardA4, VirtualMachineSizeTypesStandardA4mV2, VirtualMachineSizeTypesStandardA4V2, VirtualMachineSizeTypesStandardA5, VirtualMachineSizeTypesStandardA6, VirtualMachineSizeTypesStandardA7, VirtualMachineSizeTypesStandardA8, VirtualMachineSizeTypesStandardA8mV2, VirtualMachineSizeTypesStandardA8V2, VirtualMachineSizeTypesStandardA9, VirtualMachineSizeTypesStandardB1ms, VirtualMachineSizeTypesStandardB1s, VirtualMachineSizeTypesStandardB2ms, VirtualMachineSizeTypesStandardB2s, VirtualMachineSizeTypesStandardB4ms, VirtualMachineSizeTypesStandardB8ms, VirtualMachineSizeTypesStandardD1, VirtualMachineSizeTypesStandardD11, VirtualMachineSizeTypesStandardD11V2, VirtualMachineSizeTypesStandardD12, VirtualMachineSizeTypesStandardD12V2, VirtualMachineSizeTypesStandardD13, VirtualMachineSizeTypesStandardD13V2, VirtualMachineSizeTypesStandardD14, VirtualMachineSizeTypesStandardD14V2, VirtualMachineSizeTypesStandardD15V2, VirtualMachineSizeTypesStandardD16sV3, VirtualMachineSizeTypesStandardD16V3, VirtualMachineSizeTypesStandardD1V2, VirtualMachineSizeTypesStandardD2, VirtualMachineSizeTypesStandardD2sV3, VirtualMachineSizeTypesStandardD2V2, VirtualMachineSizeTypesStandardD2V3, VirtualMachineSizeTypesStandardD3, VirtualMachineSizeTypesStandardD32sV3, VirtualMachineSizeTypesStandardD32V3, VirtualMachineSizeTypesStandardD3V2, VirtualMachineSizeTypesStandardD4, VirtualMachineSizeTypesStandardD4sV3, VirtualMachineSizeTypesStandardD4V2, VirtualMachineSizeTypesStandardD4V3, VirtualMachineSizeTypesStandardD5V2, VirtualMachineSizeTypesStandardD64sV3, VirtualMachineSizeTypesStandardD64V3, VirtualMachineSizeTypesStandardD8sV3, VirtualMachineSizeTypesStandardD8V3, VirtualMachineSizeTypesStandardDS1, VirtualMachineSizeTypesStandardDS11, VirtualMachineSizeTypesStandardDS11V2, VirtualMachineSizeTypesStandardDS12, VirtualMachineSizeTypesStandardDS12V2, VirtualMachineSizeTypesStandardDS13, VirtualMachineSizeTypesStandardDS132V2, VirtualMachineSizeTypesStandardDS134V2, VirtualMachineSizeTypesStandardDS13V2, VirtualMachineSizeTypesStandardDS14, VirtualMachineSizeTypesStandardDS144V2, VirtualMachineSizeTypesStandardDS148V2, VirtualMachineSizeTypesStandardDS14V2, VirtualMachineSizeTypesStandardDS15V2, VirtualMachineSizeTypesStandardDS1V2, VirtualMachineSizeTypesStandardDS2, VirtualMachineSizeTypesStandardDS2V2, VirtualMachineSizeTypesStandardDS3, VirtualMachineSizeTypesStandardDS3V2, VirtualMachineSizeTypesStandardDS4, VirtualMachineSizeTypesStandardDS4V2, VirtualMachineSizeTypesStandardDS5V2, VirtualMachineSizeTypesStandardE16sV3, VirtualMachineSizeTypesStandardE16V3, VirtualMachineSizeTypesStandardE2sV3, VirtualMachineSizeTypesStandardE2V3, VirtualMachineSizeTypesStandardE3216V3, VirtualMachineSizeTypesStandardE328sV3, VirtualMachineSizeTypesStandardE32sV3, VirtualMachineSizeTypesStandardE32V3, VirtualMachineSizeTypesStandardE4sV3, VirtualMachineSizeTypesStandardE4V3, VirtualMachineSizeTypesStandardE6416sV3, VirtualMachineSizeTypesStandardE6432sV3, VirtualMachineSizeTypesStandardE64sV3, VirtualMachineSizeTypesStandardE64V3, VirtualMachineSizeTypesStandardE8sV3, VirtualMachineSizeTypesStandardE8V3, VirtualMachineSizeTypesStandardF1, VirtualMachineSizeTypesStandardF16, VirtualMachineSizeTypesStandardF16s, VirtualMachineSizeTypesStandardF16sV2, VirtualMachineSizeTypesStandardF1s, VirtualMachineSizeTypesStandardF2, VirtualMachineSizeTypesStandardF2s, VirtualMachineSizeTypesStandardF2sV2, VirtualMachineSizeTypesStandardF32sV2, VirtualMachineSizeTypesStandardF4, VirtualMachineSizeTypesStandardF4s, VirtualMachineSizeTypesStandardF4sV2, VirtualMachineSizeTypesStandardF64sV2, VirtualMachineSizeTypesStandardF72sV2, VirtualMachineSizeTypesStandardF8, VirtualMachineSizeTypesStandardF8s, VirtualMachineSizeTypesStandardF8sV2, VirtualMachineSizeTypesStandardG1, VirtualMachineSizeTypesStandardG2, VirtualMachineSizeTypesStandardG3, VirtualMachineSizeTypesStandardG4, VirtualMachineSizeTypesStandardG5, VirtualMachineSizeTypesStandardGS1, VirtualMachineSizeTypesStandardGS2, VirtualMachineSizeTypesStandardGS3, VirtualMachineSizeTypesStandardGS4, VirtualMachineSizeTypesStandardGS44, VirtualMachineSizeTypesStandardGS48, VirtualMachineSizeTypesStandardGS5, VirtualMachineSizeTypesStandardGS516, VirtualMachineSizeTypesStandardGS58, VirtualMachineSizeTypesStandardH16, VirtualMachineSizeTypesStandardH16m, VirtualMachineSizeTypesStandardH16mr, VirtualMachineSizeTypesStandardH16r, VirtualMachineSizeTypesStandardH8, VirtualMachineSizeTypesStandardH8m, VirtualMachineSizeTypesStandardL16s, VirtualMachineSizeTypesStandardL32s, VirtualMachineSizeTypesStandardL4s, VirtualMachineSizeTypesStandardL8s, VirtualMachineSizeTypesStandardM12832ms, VirtualMachineSizeTypesStandardM12864ms, VirtualMachineSizeTypesStandardM128ms, VirtualMachineSizeTypesStandardM128s, VirtualMachineSizeTypesStandardM6416ms, VirtualMachineSizeTypesStandardM6432ms, VirtualMachineSizeTypesStandardM64ms, VirtualMachineSizeTypesStandardM64s, VirtualMachineSizeTypesStandardNC12, VirtualMachineSizeTypesStandardNC12sV2, VirtualMachineSizeTypesStandardNC12sV3, VirtualMachineSizeTypesStandardNC24, VirtualMachineSizeTypesStandardNC24r, VirtualMachineSizeTypesStandardNC24rsV2, VirtualMachineSizeTypesStandardNC24rsV3, VirtualMachineSizeTypesStandardNC24sV2, VirtualMachineSizeTypesStandardNC24sV3, VirtualMachineSizeTypesStandardNC6, VirtualMachineSizeTypesStandardNC6sV2, VirtualMachineSizeTypesStandardNC6sV3, VirtualMachineSizeTypesStandardND12s, VirtualMachineSizeTypesStandardND24rs, VirtualMachineSizeTypesStandardND24s, VirtualMachineSizeTypesStandardND6s, VirtualMachineSizeTypesStandardNV12, VirtualMachineSizeTypesStandardNV24, VirtualMachineSizeTypesStandardNV6}
}
