package batchai

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AllocationState enumerates the values for allocation state.
type AllocationState string

const (
	// Resizing ...
	Resizing AllocationState = "resizing"
	// Steady ...
	Steady AllocationState = "steady"
)

// PossibleAllocationStateValues returns an array of possible values for the AllocationState const type.
func PossibleAllocationStateValues() []AllocationState {
	return []AllocationState{Resizing, Steady}
}

// CachingType enumerates the values for caching type.
type CachingType string

const (
	// None ...
	None CachingType = "none"
	// Readonly ...
	Readonly CachingType = "readonly"
	// Readwrite ...
	Readwrite CachingType = "readwrite"
)

// PossibleCachingTypeValues returns an array of possible values for the CachingType const type.
func PossibleCachingTypeValues() []CachingType {
	return []CachingType{None, Readonly, Readwrite}
}

// DeallocationOption enumerates the values for deallocation option.
type DeallocationOption string

const (
	// Requeue ...
	Requeue DeallocationOption = "requeue"
	// Terminate ...
	Terminate DeallocationOption = "terminate"
	// Waitforjobcompletion ...
	Waitforjobcompletion DeallocationOption = "waitforjobcompletion"
)

// PossibleDeallocationOptionValues returns an array of possible values for the DeallocationOption const type.
func PossibleDeallocationOptionValues() []DeallocationOption {
	return []DeallocationOption{Requeue, Terminate, Waitforjobcompletion}
}

// ExecutionState enumerates the values for execution state.
type ExecutionState string

const (
	// Failed ...
	Failed ExecutionState = "failed"
	// Queued ...
	Queued ExecutionState = "queued"
	// Running ...
	Running ExecutionState = "running"
	// Succeeded ...
	Succeeded ExecutionState = "succeeded"
	// Terminating ...
	Terminating ExecutionState = "terminating"
)

// PossibleExecutionStateValues returns an array of possible values for the ExecutionState const type.
func PossibleExecutionStateValues() []ExecutionState {
	return []ExecutionState{Failed, Queued, Running, Succeeded, Terminating}
}

// FileServerProvisioningState enumerates the values for file server provisioning state.
type FileServerProvisioningState string

const (
	// FileServerProvisioningStateCreating ...
	FileServerProvisioningStateCreating FileServerProvisioningState = "creating"
	// FileServerProvisioningStateDeleting ...
	FileServerProvisioningStateDeleting FileServerProvisioningState = "deleting"
	// FileServerProvisioningStateFailed ...
	FileServerProvisioningStateFailed FileServerProvisioningState = "failed"
	// FileServerProvisioningStateSucceeded ...
	FileServerProvisioningStateSucceeded FileServerProvisioningState = "succeeded"
	// FileServerProvisioningStateUpdating ...
	FileServerProvisioningStateUpdating FileServerProvisioningState = "updating"
)

// PossibleFileServerProvisioningStateValues returns an array of possible values for the FileServerProvisioningState const type.
func PossibleFileServerProvisioningStateValues() []FileServerProvisioningState {
	return []FileServerProvisioningState{FileServerProvisioningStateCreating, FileServerProvisioningStateDeleting, FileServerProvisioningStateFailed, FileServerProvisioningStateSucceeded, FileServerProvisioningStateUpdating}
}

// FileType enumerates the values for file type.
type FileType string

const (
	// FileTypeDirectory ...
	FileTypeDirectory FileType = "directory"
	// FileTypeFile ...
	FileTypeFile FileType = "file"
)

// PossibleFileTypeValues returns an array of possible values for the FileType const type.
func PossibleFileTypeValues() []FileType {
	return []FileType{FileTypeDirectory, FileTypeFile}
}

// JobPriority enumerates the values for job priority.
type JobPriority string

const (
	// High ...
	High JobPriority = "high"
	// Low ...
	Low JobPriority = "low"
	// Normal ...
	Normal JobPriority = "normal"
)

// PossibleJobPriorityValues returns an array of possible values for the JobPriority const type.
func PossibleJobPriorityValues() []JobPriority {
	return []JobPriority{High, Low, Normal}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded}
}

// StorageAccountType enumerates the values for storage account type.
type StorageAccountType string

const (
	// PremiumLRS ...
	PremiumLRS StorageAccountType = "Premium_LRS"
	// StandardLRS ...
	StandardLRS StorageAccountType = "Standard_LRS"
)

// PossibleStorageAccountTypeValues returns an array of possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{PremiumLRS, StandardLRS}
}

// ToolType enumerates the values for tool type.
type ToolType string

const (
	// Caffe ...
	Caffe ToolType = "caffe"
	// Caffe2 ...
	Caffe2 ToolType = "caffe2"
	// Chainer ...
	Chainer ToolType = "chainer"
	// Cntk ...
	Cntk ToolType = "cntk"
	// Custom ...
	Custom ToolType = "custom"
	// Custommpi ...
	Custommpi ToolType = "custommpi"
	// Horovod ...
	Horovod ToolType = "horovod"
	// Tensorflow ...
	Tensorflow ToolType = "tensorflow"
)

// PossibleToolTypeValues returns an array of possible values for the ToolType const type.
func PossibleToolTypeValues() []ToolType {
	return []ToolType{Caffe, Caffe2, Chainer, Cntk, Custom, Custommpi, Horovod, Tensorflow}
}

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// Count ...
	Count UsageUnit = "Count"
)

// PossibleUsageUnitValues returns an array of possible values for the UsageUnit const type.
func PossibleUsageUnitValues() []UsageUnit {
	return []UsageUnit{Count}
}

// VMPriority enumerates the values for vm priority.
type VMPriority string

const (
	// Dedicated ...
	Dedicated VMPriority = "dedicated"
	// Lowpriority ...
	Lowpriority VMPriority = "lowpriority"
)

// PossibleVMPriorityValues returns an array of possible values for the VMPriority const type.
func PossibleVMPriorityValues() []VMPriority {
	return []VMPriority{Dedicated, Lowpriority}
}
