// { dg-do compile { target c++26 } }
// { dg-additional-options "-freflection" }
// Test reflection type traits [meta.reflection.traits], type properties.

#include <meta>
using namespace std::meta;

class ClassType { };
class DerivedType : public ClassType { };
enum EnumType { e0 };
class AbstractClass { virtual void rotate (int) = 0; };
class PolymorphicClass { virtual void rotate (int); };
class DerivedPolymorphic : public PolymorphicClass { };
class VirtualDestructorClass { virtual ~VirtualDestructorClass (); };

static_assert (has_virtual_destructor (^^VirtualDestructorClass));
static_assert (!has_virtual_destructor (^^PolymorphicClass));
static_assert (!has_virtual_destructor (^^DerivedPolymorphic));
static_assert (!has_virtual_destructor (^^AbstractClass));
static_assert (!has_virtual_destructor (^^void));
static_assert (!has_virtual_destructor (^^int (int)));
static_assert (!has_virtual_destructor (^^int &));
static_assert (!has_virtual_destructor (^^EnumType));
static_assert (!has_virtual_destructor (^^ClassType));
static_assert (!has_virtual_destructor (^^DerivedType));

static_assert (has_unique_object_representations (^^char));
static_assert (has_unique_object_representations (^^unsigned char));
static_assert (has_unique_object_representations (^^signed char));
static_assert (has_unique_object_representations (^^unsigned));
static_assert (has_unique_object_representations (^^bool));
enum E3 : unsigned { };
static_assert (has_unique_object_representations (^^E3));
static_assert (has_unique_object_representations (^^unsigned [3]));
static_assert (has_unique_object_representations (^^unsigned [3][2]));
static_assert (has_unique_object_representations (^^unsigned []));
static_assert (has_unique_object_representations (^^unsigned [][2]));
static_assert (has_unique_object_representations (^^E3 [3]));
static_assert (has_unique_object_representations (^^E3 [3][2]));
static_assert (has_unique_object_representations (^^E3 []));
static_assert (has_unique_object_representations (^^E3 [][2]));
struct Padded { char c1; alignas(4) char c2; };
struct Bitfield { int i : 3; };
struct Aligned { alignas(4) char c; };
static_assert (!has_unique_object_representations (^^void));
static_assert (!has_unique_object_representations (^^float));
static_assert (!has_unique_object_representations (^^Padded));
static_assert (!has_unique_object_representations (^^Padded [2]));
static_assert (!has_unique_object_representations (^^Padded [2][1]));
static_assert (!has_unique_object_representations (^^Padded []));
static_assert (!has_unique_object_representations (^^Padded [][1]));
static_assert (!has_unique_object_representations (^^Bitfield));
static_assert (!has_unique_object_representations (^^Bitfield [2]));
static_assert (!has_unique_object_representations (^^Bitfield [2][1]));
static_assert (!has_unique_object_representations (^^Bitfield []));
static_assert (!has_unique_object_representations (^^Bitfield [][1]));
static_assert (!has_unique_object_representations (^^Aligned));
static_assert (!has_unique_object_representations (^^Aligned [2]));
static_assert (!has_unique_object_representations (^^Aligned [2][1]));
static_assert (!has_unique_object_representations (^^Aligned []));
static_assert (!has_unique_object_representations (^^Aligned [][1]));

struct A { A(); };
struct B { operator int (); explicit operator int && (); };
struct C { operator int (); explicit operator int & (); };

static_assert (!reference_constructs_from_temporary (^^int, ^^int));
static_assert (!reference_constructs_from_temporary (^^int &, ^^void));
static_assert (!reference_constructs_from_temporary (^^int &, ^^const volatile void));
static_assert (!reference_constructs_from_temporary (^^void, ^^void));
static_assert (!reference_constructs_from_temporary (^^int &, ^^int));
static_assert (!reference_constructs_from_temporary (^^int &, ^^int &));
static_assert (!reference_constructs_from_temporary (^^int &, ^^int &&));
static_assert (!reference_constructs_from_temporary (^^int &, ^^long));
static_assert (!reference_constructs_from_temporary (^^int &, ^^long &));
static_assert (!reference_constructs_from_temporary (^^int &, ^^long &&));
static_assert (reference_constructs_from_temporary (^^const int &, ^^int));
static_assert (!reference_constructs_from_temporary (^^const int &, ^^int &));
static_assert (!reference_constructs_from_temporary (^^const int &, ^^int &&));
static_assert (reference_constructs_from_temporary (^^const int &, ^^long));
static_assert (reference_constructs_from_temporary (^^const int &, ^^long &));
static_assert (reference_constructs_from_temporary (^^const int &, ^^long &&));
static_assert (reference_constructs_from_temporary (^^int &&, ^^int));
static_assert (!reference_constructs_from_temporary (^^int &&, ^^int &));
static_assert (!reference_constructs_from_temporary (^^int &&, ^^int &&));
static_assert (reference_constructs_from_temporary (^^int &&, ^^long));
static_assert (reference_constructs_from_temporary (^^int &&, ^^long &));
static_assert (reference_constructs_from_temporary (^^int &&, ^^long &&));
static_assert (reference_constructs_from_temporary (^^const A &, ^^A));
static_assert (!reference_constructs_from_temporary (^^const A &, ^^A &&));
static_assert (reference_constructs_from_temporary (^^A &&, ^^A));
static_assert (!reference_constructs_from_temporary (^^int &, ^^int []));
static_assert (!reference_constructs_from_temporary (^^const int &, ^^int []));
static_assert (!reference_constructs_from_temporary (^^int &&, ^^int []));
static_assert (!reference_constructs_from_temporary (^^int &&, ^^B));
static_assert (!reference_constructs_from_temporary (^^const int &, ^^C));
static_assert (reference_constructs_from_temporary (^^const std::string &, ^^const char *));

static_assert (!reference_converts_from_temporary (^^int, ^^int));
static_assert (!reference_converts_from_temporary (^^int &, ^^void));
static_assert (!reference_converts_from_temporary (^^int &, ^^const volatile void));
static_assert (!reference_converts_from_temporary (^^void, ^^void));
static_assert (!reference_converts_from_temporary (^^int &, ^^int));
static_assert (!reference_converts_from_temporary (^^int &, ^^int &));
static_assert (!reference_converts_from_temporary (^^int &, ^^int &&));
static_assert (!reference_converts_from_temporary (^^int &, ^^long));
static_assert (!reference_converts_from_temporary (^^int &, ^^long &));
static_assert (!reference_converts_from_temporary (^^int &, ^^long &&));
static_assert (reference_converts_from_temporary (^^const int &, ^^int));
static_assert (!reference_converts_from_temporary (^^const int &, ^^int &));
static_assert (!reference_converts_from_temporary (^^const int &, ^^int &&));
static_assert (reference_converts_from_temporary (^^const int &, ^^long));
static_assert (reference_converts_from_temporary (^^const int &, ^^long &));
static_assert (reference_converts_from_temporary (^^const int &, ^^long &&));
static_assert (reference_converts_from_temporary (^^int &&, ^^int));
static_assert (!reference_converts_from_temporary (^^int &&, ^^int &));
static_assert (!reference_converts_from_temporary (^^int &&, ^^int &&));
static_assert (reference_converts_from_temporary (^^int &&, ^^long));
static_assert (reference_converts_from_temporary (^^int &&, ^^long &));
static_assert (reference_converts_from_temporary (^^int &&, ^^long &&));
static_assert (reference_converts_from_temporary (^^const A &, ^^A));
static_assert (!reference_converts_from_temporary (^^const A &, ^^A &&));
static_assert (reference_converts_from_temporary (^^A &&, ^^A));
static_assert (!reference_converts_from_temporary (^^int &, ^^int []));
static_assert (!reference_converts_from_temporary (^^const int &, ^^int []));
static_assert (!reference_converts_from_temporary (^^int &&, ^^int []));
static_assert (reference_converts_from_temporary (^^int &&, ^^B));
static_assert (reference_converts_from_temporary (^^const int &, ^^C));
static_assert (reference_converts_from_temporary (^^const std::string &, ^^const char *));
