// REQUIRES: riscv-registered-target
// RUN: %clang --target=riscv64-linux-gnu --print-supported-extensions | FileCheck --strict-whitespace --implicit-check-not=FEAT_ %s

// CHECK: All available -march extensions for RISC-V
// CHECK-EMPTY:
// CHECK-NEXT:     Name                 Version   Description
// CHECK-NEXT:     i                    2.1       'I' (Base Integer Instruction Set)
// CHECK-NEXT:     e                    2.0       'E' (Embedded Instruction Set with 16 GPRs)
// CHECK-NEXT:     m                    2.0       'M' (Integer Multiplication and Division)
// CHECK-NEXT:     a                    2.1       'A' (Atomic Instructions)
// CHECK-NEXT:     f                    2.2       'F' (Single-Precision Floating-Point)
// CHECK-NEXT:     d                    2.2       'D' (Double-Precision Floating-Point)
// CHECK-NEXT:     q                    2.2       'Q' (Quad-Precision Floating-Point)
// CHECK-NEXT:     c                    2.0       'C' (Compressed Instructions)
// CHECK-NEXT:     b                    1.0       'B' (the collection of the Zba, Zbb, Zbs extensions)
// CHECK-NEXT:     v                    1.0       'V' (Vector Extension for Application Processors)
// CHECK-NEXT:     h                    1.0       'H' (Hypervisor)
// CHECK-NEXT:     zic64b               1.0       'Zic64b' (Cache Block Size Is 64 Bytes)
// CHECK-NEXT:     zicbom               1.0       'Zicbom' (Cache-Block Management Instructions)
// CHECK-NEXT:     zicbop               1.0       'Zicbop' (Cache-Block Prefetch Instructions)
// CHECK-NEXT:     zicboz               1.0       'Zicboz' (Cache-Block Zero Instructions)
// CHECK-NEXT:     ziccamoa             1.0       'Ziccamoa' (Main Memory Supports All Atomics in A)
// CHECK-NEXT:     ziccamoc             1.0       'Ziccamoc' (Main Memory Supports Atomics in Zacas)
// CHECK-NEXT:     ziccif               1.0       'Ziccif' (Main Memory Supports Instruction Fetch with Atomicity Requirement)
// CHECK-NEXT:     zicclsm              1.0       'Zicclsm' (Main Memory Supports Misaligned Loads/Stores)
// CHECK-NEXT:     ziccrse              1.0       'Ziccrse' (Main Memory Supports Forward Progress on LR/SC Sequences)
// CHECK-NEXT:     zicntr               2.0       'Zicntr' (Base Counters and Timers)
// CHECK-NEXT:     zicond               1.0       'Zicond' (Integer Conditional Operations)
// CHECK-NEXT:     zicsr                2.0       'Zicsr' (CSRs)
// CHECK-NEXT:     zifencei             2.0       'Zifencei' (fence.i)
// CHECK-NEXT:     zihintntl            1.0       'Zihintntl' (Non-Temporal Locality Hints)
// CHECK-NEXT:     zihintpause          2.0       'Zihintpause' (Pause Hint)
// CHECK-NEXT:     zihpm                2.0       'Zihpm' (Hardware Performance Counters)
// CHECK-NEXT:     zilsd                1.0       'Zilsd' (Load/Store Pair Instructions)
// CHECK-NEXT:     zimop                1.0       'Zimop' (May-Be-Operations)
// CHECK-NEXT:     zmmul                1.0       'Zmmul' (Integer Multiplication)
// CHECK-NEXT:     za128rs              1.0       'Za128rs' (Reservation Set Size of at Most 128 Bytes)
// CHECK-NEXT:     za64rs               1.0       'Za64rs' (Reservation Set Size of at Most 64 Bytes)
// CHECK-NEXT:     zaamo                1.0       'Zaamo' (Atomic Memory Operations)
// CHECK-NEXT:     zabha                1.0       'Zabha' (Byte and Halfword Atomic Memory Operations)
// CHECK-NEXT:     zacas                1.0       'Zacas' (Atomic Compare-And-Swap Instructions)
// CHECK-NEXT:     zalrsc               1.0       'Zalrsc' (Load-Reserved/Store-Conditional)
// CHECK-NEXT:     zama16b              1.0       'Zama16b' (Atomic 16-byte misaligned loads, stores and AMOs)
// CHECK-NEXT:     zawrs                1.0       'Zawrs' (Wait on Reservation Set)
// CHECK-NEXT:     zfa                  1.0       'Zfa' (Additional Floating-Point)
// CHECK-NEXT:     zfbfmin              1.0       'Zfbfmin' (Scalar BF16 Converts)
// CHECK-NEXT:     zfh                  1.0       'Zfh' (Half-Precision Floating-Point)
// CHECK-NEXT:     zfhmin               1.0       'Zfhmin' (Half-Precision Floating-Point Minimal)
// CHECK-NEXT:     zfinx                1.0       'Zfinx' (Float in Integer)
// CHECK-NEXT:     zdinx                1.0       'Zdinx' (Double in Integer)
// CHECK-NEXT:     zca                  1.0       'Zca' (part of the C extension, excluding compressed floating point loads/stores)
// CHECK-NEXT:     zcb                  1.0       'Zcb' (Compressed basic bit manipulation instructions)
// CHECK-NEXT:     zcd                  1.0       'Zcd' (Compressed Double-Precision Floating-Point Instructions)
// CHECK-NEXT:     zce                  1.0       'Zce' (Compressed extensions for microcontrollers)
// CHECK-NEXT:     zcf                  1.0       'Zcf' (Compressed Single-Precision Floating-Point Instructions)
// CHECK-NEXT:     zclsd                1.0       'Zclsd' (Compressed Load/Store Pair Instructions)
// CHECK-NEXT:     zcmop                1.0       'Zcmop' (Compressed May-Be-Operations)
// CHECK-NEXT:     zcmp                 1.0       'Zcmp' (sequenced instructions for code-size reduction)
// CHECK-NEXT:     zcmt                 1.0       'Zcmt' (table jump instructions for code-size reduction)
// CHECK-NEXT:     zba                  1.0       'Zba' (Address Generation Instructions)
// CHECK-NEXT:     zbb                  1.0       'Zbb' (Basic Bit-Manipulation)
// CHECK-NEXT:     zbc                  1.0       'Zbc' (Carry-Less Multiplication)
// CHECK-NEXT:     zbkb                 1.0       'Zbkb' (Bitmanip instructions for Cryptography)
// CHECK-NEXT:     zbkc                 1.0       'Zbkc' (Carry-less multiply instructions for Cryptography)
// CHECK-NEXT:     zbkx                 1.0       'Zbkx' (Crossbar permutation instructions)
// CHECK-NEXT:     zbs                  1.0       'Zbs' (Single-Bit Instructions)
// CHECK-NEXT:     zk                   1.0       'Zk' (Standard scalar cryptography extension)
// CHECK-NEXT:     zkn                  1.0       'Zkn' (NIST Algorithm Suite)
// CHECK-NEXT:     zknd                 1.0       'Zknd' (NIST Suite: AES Decryption)
// CHECK-NEXT:     zkne                 1.0       'Zkne' (NIST Suite: AES Encryption)
// CHECK-NEXT:     zknh                 1.0       'Zknh' (NIST Suite: Hash Function Instructions)
// CHECK-NEXT:     zkr                  1.0       'Zkr' (Entropy Source Extension)
// CHECK-NEXT:     zks                  1.0       'Zks' (ShangMi Algorithm Suite)
// CHECK-NEXT:     zksed                1.0       'Zksed' (ShangMi Suite: SM4 Block Cipher Instructions)
// CHECK-NEXT:     zksh                 1.0       'Zksh' (ShangMi Suite: SM3 Hash Function Instructions)
// CHECK-NEXT:     zkt                  1.0       'Zkt' (Data Independent Execution Latency)
// CHECK-NEXT:     ztso                 1.0       'Ztso' (Memory Model - Total Store Order)
// CHECK-NEXT:     zvbb                 1.0       'Zvbb' (Vector basic bit-manipulation instructions)
// CHECK-NEXT:     zvbc                 1.0       'Zvbc' (Vector Carryless Multiplication)
// CHECK-NEXT:     zve32f               1.0       'Zve32f' (Vector Extensions for Embedded Processors with maximal 32 EEW and F extension)
// CHECK-NEXT:     zve32x               1.0       'Zve32x' (Vector Extensions for Embedded Processors with maximal 32 EEW)
// CHECK-NEXT:     zve64d               1.0       'Zve64d' (Vector Extensions for Embedded Processors with maximal 64 EEW, F and D extension)
// CHECK-NEXT:     zve64f               1.0       'Zve64f' (Vector Extensions for Embedded Processors with maximal 64 EEW and F extension)
// CHECK-NEXT:     zve64x               1.0       'Zve64x' (Vector Extensions for Embedded Processors with maximal 64 EEW)
// CHECK-NEXT:     zvfbfmin             1.0       'Zvfbfmin' (Vector BF16 Converts)
// CHECK-NEXT:     zvfbfwma             1.0       'Zvfbfwma' (Vector BF16 widening mul-add)
// CHECK-NEXT:     zvfh                 1.0       'Zvfh' (Vector Half-Precision Floating-Point)
// CHECK-NEXT:     zvfhmin              1.0       'Zvfhmin' (Vector Half-Precision Floating-Point Minimal)
// CHECK-NEXT:     zvkb                 1.0       'Zvkb' (Vector Bit-manipulation used in Cryptography)
// CHECK-NEXT:     zvkg                 1.0       'Zvkg' (Vector GCM instructions for Cryptography)
// CHECK-NEXT:     zvkn                 1.0       'Zvkn' (shorthand for 'Zvkned', 'Zvknhb', 'Zvkb', and 'Zvkt')
// CHECK-NEXT:     zvknc                1.0       'Zvknc' (shorthand for 'Zvknc' and 'Zvbc')
// CHECK-NEXT:     zvkned               1.0       'Zvkned' (Vector AES Encryption & Decryption (Single Round))
// CHECK-NEXT:     zvkng                1.0       'Zvkng' (shorthand for 'Zvkn' and 'Zvkg')
// CHECK-NEXT:     zvknha               1.0       'Zvknha' (Vector SHA-2 (SHA-256 only))
// CHECK-NEXT:     zvknhb               1.0       'Zvknhb' (Vector SHA-2 (SHA-256 and SHA-512))
// CHECK-NEXT:     zvks                 1.0       'Zvks' (shorthand for 'Zvksed', 'Zvksh', 'Zvkb', and 'Zvkt')
// CHECK-NEXT:     zvksc                1.0       'Zvksc' (shorthand for 'Zvks' and 'Zvbc')
// CHECK-NEXT:     zvksed               1.0       'Zvksed' (SM4 Block Cipher Instructions)
// CHECK-NEXT:     zvksg                1.0       'Zvksg' (shorthand for 'Zvks' and 'Zvkg')
// CHECK-NEXT:     zvksh                1.0       'Zvksh' (SM3 Hash Function Instructions)
// CHECK-NEXT:     zvkt                 1.0       'Zvkt' (Vector Data-Independent Execution Latency)
// CHECK-NEXT:     zvl1024b             1.0       'Zvl1024b' (Minimum Vector Length 1024)
// CHECK-NEXT:     zvl128b              1.0       'Zvl128b' (Minimum Vector Length 128)
// CHECK-NEXT:     zvl16384b            1.0       'Zvl16384b' (Minimum Vector Length 16384)
// CHECK-NEXT:     zvl2048b             1.0       'Zvl2048b' (Minimum Vector Length 2048)
// CHECK-NEXT:     zvl256b              1.0       'Zvl256b' (Minimum Vector Length 256)
// CHECK-NEXT:     zvl32768b            1.0       'Zvl32768b' (Minimum Vector Length 32768)
// CHECK-NEXT:     zvl32b               1.0       'Zvl32b' (Minimum Vector Length 32)
// CHECK-NEXT:     zvl4096b             1.0       'Zvl4096b' (Minimum Vector Length 4096)
// CHECK-NEXT:     zvl512b              1.0       'Zvl512b' (Minimum Vector Length 512)
// CHECK-NEXT:     zvl64b               1.0       'Zvl64b' (Minimum Vector Length 64)
// CHECK-NEXT:     zvl65536b            1.0       'Zvl65536b' (Minimum Vector Length 65536)
// CHECK-NEXT:     zvl8192b             1.0       'Zvl8192b' (Minimum Vector Length 8192)
// CHECK-NEXT:     zhinx                1.0       'Zhinx' (Half Float in Integer)
// CHECK-NEXT:     zhinxmin             1.0       'Zhinxmin' (Half Float in Integer Minimal)
// CHECK-NEXT:     sdext                1.0       'Sdext' (External debugger)
// CHECK-NEXT:     sdtrig               1.0       'Sdtrig' (Debugger triggers)
// CHECK-NEXT:     sha                  1.0       'Sha' (Augmented Hypervisor)
// CHECK-NEXT:     shcounterenw         1.0       'Shcounterenw' (Support writeable hcounteren enable bit for any hpmcounter that is not read-only zero)
// CHECK-NEXT:     shgatpa              1.0       'Shgatpa' (SvNNx4 mode supported for all modes supported by satp, as well as Bare)
// CHECK-NEXT:     shlcofideleg         1.0       'Shlcofideleg' (Delegating LCOFI Interrupts to VS-mode)
// CHECK-NEXT:     shtvala              1.0       'Shtvala' (htval provides all needed values)
// CHECK-NEXT:     shvsatpa             1.0       'Shvsatpa' (vsatp supports all modes supported by satp)
// CHECK-NEXT:     shvstvala            1.0       'Shvstvala' (vstval provides all needed values)
// CHECK-NEXT:     shvstvecd            1.0       'Shvstvecd' (vstvec supports Direct mode)
// CHECK-NEXT:     smaia                1.0       'Smaia' (Advanced Interrupt Architecture Machine Level)
// CHECK-NEXT:     smcdeleg             1.0       'Smcdeleg' (Counter Delegation Machine Level)
// CHECK-NEXT:     smcntrpmf            1.0       'Smcntrpmf' (Cycle and Instret Privilege Mode Filtering)
// CHECK-NEXT:     smcsrind             1.0       'Smcsrind' (Indirect CSR Access Machine Level)
// CHECK-NEXT:     smctr                1.0       'Smctr' (Control Transfer Records Machine Level)
// CHECK-NEXT:     smdbltrp             1.0       'Smdbltrp' (Double Trap Machine Level)
// CHECK-NEXT:     smepmp               1.0       'Smepmp' (Enhanced Physical Memory Protection)
// CHECK-NEXT:     smmpm                1.0       'Smmpm' (Machine-level Pointer Masking for M-mode)
// CHECK-NEXT:     smnpm                1.0       'Smnpm' (Machine-level Pointer Masking for next lower privilege mode)
// CHECK-NEXT:     smrnmi               1.0       'Smrnmi' (Resumable Non-Maskable Interrupts)
// CHECK-NEXT:     smstateen            1.0       'Smstateen' (Machine-mode view of the state-enable extension)
// CHECK-NEXT:     ssaia                1.0       'Ssaia' (Advanced Interrupt Architecture Supervisor Level)
// CHECK-NEXT:     ssccfg               1.0       'Ssccfg' (Counter Configuration Supervisor Level)
// CHECK-NEXT:     ssccptr              1.0       'Ssccptr' (Main memory supports page table reads)
// CHECK-NEXT:     sscofpmf             1.0       'Sscofpmf' (Count Overflow and Mode-Based Filtering)
// CHECK-NEXT:     sscounterenw         1.0       'Sscounterenw' (Support writeable scounteren enable bit for any hpmcounter that is not read-only zero)
// CHECK-NEXT:     sscsrind             1.0       'Sscsrind' (Indirect CSR Access Supervisor Level)
// CHECK-NEXT:     ssctr                1.0       'Ssctr' (Control Transfer Records Supervisor Level)
// CHECK-NEXT:     ssdbltrp             1.0       'Ssdbltrp' (Double Trap Supervisor Level)
// CHECK-NEXT:     ssnpm                1.0       'Ssnpm' (Supervisor-level Pointer Masking for next lower privilege mode)
// CHECK-NEXT:     sspm                 1.0       'Sspm' (Indicates Supervisor-mode Pointer Masking)
// CHECK-NEXT:     ssqosid              1.0       'Ssqosid' (Quality-of-Service (QoS) Identifiers)
// CHECK-NEXT:     ssstateen            1.0       'Ssstateen' (Supervisor-mode view of the state-enable extension)
// CHECK-NEXT:     ssstrict             1.0       'Ssstrict' (No non-conforming extensions are present)
// CHECK-NEXT:     sstc                 1.0       'Sstc' (Supervisor-mode timer interrupts)
// CHECK-NEXT:     sstvala              1.0       'Sstvala' (stval provides all needed values)
// CHECK-NEXT:     sstvecd              1.0       'Sstvecd' (stvec supports Direct mode)
// CHECK-NEXT:     ssu64xl              1.0       'Ssu64xl' (UXLEN=64 supported)
// CHECK-NEXT:     supm                 1.0       'Supm' (Indicates User-mode Pointer Masking)
// CHECK-NEXT:     svade                1.0       'Svade' (Raise exceptions on improper A/D bits)
// CHECK-NEXT:     svadu                1.0       'Svadu' (Hardware A/D updates)
// CHECK-NEXT:     svbare               1.0       'Svbare' (satp mode Bare supported)
// CHECK-NEXT:     svinval              1.0       'Svinval' (Fine-Grained Address-Translation Cache Invalidation)
// CHECK-NEXT:     svnapot              1.0       'Svnapot' (NAPOT Translation Contiguity)
// CHECK-NEXT:     svpbmt               1.0       'Svpbmt' (Page-Based Memory Types)
// CHECK-NEXT:     svvptc               1.0       'Svvptc' (Obviating Memory-Management Instructions after Marking PTEs Valid)
// CHECK-NEXT:     xandesbfhcvt         5.0       'XAndesBFHCvt' (Andes Scalar BFLOAT16 Conversion Extension)
// CHECK-NEXT:     xandesperf           5.0       'XAndesPerf' (Andes Performance Extension)
// CHECK-NEXT:     xandesvbfhcvt        5.0       'XAndesVBFHCvt' (Andes Vector BFLOAT16 Conversion Extension)
// CHECK-NEXT:     xandesvdot           5.0       'XAndesVDot' (Andes Vector Dot Product Extension)
// CHECK-NEXT:     xandesvpackfph       5.0       'XAndesVPackFPH' (Andes Vector Packed FP16 Extension)
// CHECK-NEXT:     xandesvsintload      5.0       'XAndesVSIntLoad' (Andes Vector INT4 Load Extension)
// CHECK-NEXT:     xcvalu               1.0       'XCValu' (CORE-V ALU Operations)
// CHECK-NEXT:     xcvbi                1.0       'XCVbi' (CORE-V Immediate Branching)
// CHECK-NEXT:     xcvbitmanip          1.0       'XCVbitmanip' (CORE-V Bit Manipulation)
// CHECK-NEXT:     xcvelw               1.0       'XCVelw' (CORE-V Event Load Word)
// CHECK-NEXT:     xcvmac               1.0       'XCVmac' (CORE-V Multiply-Accumulate)
// CHECK-NEXT:     xcvmem               1.0       'XCVmem' (CORE-V Post-incrementing Load & Store)
// CHECK-NEXT:     xcvsimd              1.0       'XCVsimd' (CORE-V SIMD ALU)
// CHECK-NEXT:     xmipscbop            1.0       'XMIPSCBOP' (MIPS Software Prefetch)
// CHECK-NEXT:     xmipscmov            1.0       'XMIPSCMov' (MIPS conditional move instruction (mips.ccmov))
// CHECK-NEXT:     xmipsexectl          1.0       'XMIPSEXECTL' (MIPS execution control)
// CHECK-NEXT:     xmipslsp             1.0       'XMIPSLSP' (MIPS optimization for hardware load-store bonding)
// CHECK-NEXT:     xsfcease             1.0       'XSfcease' (SiFive sf.cease Instruction)
// CHECK-NEXT:     xsfmm128t            0.6       'XSfmm128t' (TE=128 configuration)
// CHECK-NEXT:     xsfmm16t             0.6       'XSfmm16t' (TE=16 configuration)
// CHECK-NEXT:     xsfmm32a16f          0.6       'XSfmm32a16f' (TEW=32-bit accumulation, operands - float: 16b, widen=2 (IEEE, BF))
// CHECK-NEXT:     xsfmm32a32f          0.6       'XSfmm32a32f' (TEW=32-bit accumulation, operands - float: 32b)
// CHECK-NEXT:     xsfmm32a8f           0.6       'XSfmm32a8f' (TEW=32-bit accumulation, operands - float: fp8)
// CHECK-NEXT:     xsfmm32a8i           0.6       'XSfmm32a8i' (TEW=32-bit accumulation, operands - int: 8b)
// CHECK-NEXT:     xsfmm32t             0.6       'XSfmm32t' (TE=32 configuration)
// CHECK-NEXT:     xsfmm64a64f          0.6       'XSfmm64a64f' (TEW=64-bit accumulation, operands - float: fp64)
// CHECK-NEXT:     xsfmm64t             0.6       'XSfmm64t' (TE=64 configuration)
// CHECK-NEXT:     xsfmmbase            0.6       'XSfmmbase' (All non arithmetic instructions for all TEWs and sf.vtzero)
// CHECK-NEXT:     xsfvcp               1.0       'XSfvcp' (SiFive Custom Vector Coprocessor Interface Instructions)
// CHECK-NEXT:     xsfvfnrclipxfqf      1.0       'XSfvfnrclipxfqf' (SiFive FP32-to-int8 Ranged Clip Instructions)
// CHECK-NEXT:     xsfvfwmaccqqq        1.0       'XSfvfwmaccqqq' (SiFive Matrix Multiply Accumulate Instruction (4-by-4))
// CHECK-NEXT:     xsfvqmaccdod         1.0       'XSfvqmaccdod' (SiFive Int8 Matrix Multiplication Instructions (2-by-8 and 8-by-2))
// CHECK-NEXT:     xsfvqmaccqoq         1.0       'XSfvqmaccqoq' (SiFive Int8 Matrix Multiplication Instructions (4-by-8 and 8-by-4))
// CHECK-NEXT:     xsifivecdiscarddlone 1.0       'XSiFivecdiscarddlone' (SiFive sf.cdiscard.d.l1 Instruction)
// CHECK-NEXT:     xsifivecflushdlone   1.0       'XSiFivecflushdlone' (SiFive sf.cflush.d.l1 Instruction)
// CHECK-NEXT:     xsmtvdot             1.0       'XSMTVDot' (SpacemiT Vector Dot Product Extension)
// CHECK-NEXT:     xtheadba             1.0       'XTHeadBa' (T-Head address calculation instructions)
// CHECK-NEXT:     xtheadbb             1.0       'XTHeadBb' (T-Head basic bit-manipulation instructions)
// CHECK-NEXT:     xtheadbs             1.0       'XTHeadBs' (T-Head single-bit instructions)
// CHECK-NEXT:     xtheadcmo            1.0       'XTHeadCmo' (T-Head cache management instructions)
// CHECK-NEXT:     xtheadcondmov        1.0       'XTHeadCondMov' (T-Head conditional move instructions)
// CHECK-NEXT:     xtheadfmemidx        1.0       'XTHeadFMemIdx' (T-Head FP Indexed Memory Operations)
// CHECK-NEXT:     xtheadmac            1.0       'XTHeadMac' (T-Head Multiply-Accumulate Instructions)
// CHECK-NEXT:     xtheadmemidx         1.0       'XTHeadMemIdx' (T-Head Indexed Memory Operations)
// CHECK-NEXT:     xtheadmempair        1.0       'XTHeadMemPair' (T-Head two-GPR Memory Operations)
// CHECK-NEXT:     xtheadsync           1.0       'XTHeadSync' (T-Head multicore synchronization instructions)
// CHECK-NEXT:     xtheadvdot           1.0       'XTHeadVdot' (T-Head Vector Extensions for Dot)
// CHECK-NEXT:     xventanacondops      1.0       'XVentanaCondOps' (Ventana Conditional Ops)
// CHECK-NEXT:     xwchc                2.2       'Xwchc' (WCH/QingKe additional compressed opcodes)
// CHECK-EMPTY:
// CHECK-NEXT: Experimental extensions
// CHECK-NEXT:     p                    0.15      'P' ('Base P' (Packed SIMD))
// CHECK-NEXT:     zicfilp              1.0       'Zicfilp' (Landing pad)
// CHECK-NEXT:     zicfiss              1.0       'Zicfiss' (Shadow stack)
// CHECK-NEXT:     zalasr               0.1       'Zalasr' (Load-Acquire and Store-Release Instructions)
// CHECK-NEXT:     zvbc32e              0.7       'Zvbc32e' (Vector Carryless Multiplication with 32-bits elements)
// CHECK-NEXT:     zvfbfa               0.1       'Zvfbfa' (Additional BF16 vector compute support)
// CHECK-NEXT:     zvkgs                0.7       'Zvkgs' (Vector-Scalar GCM instructions for Cryptography)
// CHECK-NEXT:     zvqdotq              0.0       'Zvqdotq' (Vector quad widening 4D Dot Product)
// CHECK-NEXT:     svukte               0.3       'Svukte' (Address-Independent Latency of User-Mode Faults to Supervisor Addresses)
// CHECK-NEXT:     xqccmp               0.3       'Xqccmp' (Qualcomm 16-bit Push/Pop and Double Moves)
// CHECK-NEXT:     xqcia                0.7       'Xqcia' (Qualcomm uC Arithmetic Extension)
// CHECK-NEXT:     xqciac               0.3       'Xqciac' (Qualcomm uC Load-Store Address Calculation Extension)
// CHECK-NEXT:     xqcibi               0.2       'Xqcibi' (Qualcomm uC Branch Immediate Extension)
// CHECK-NEXT:     xqcibm               0.8       'Xqcibm' (Qualcomm uC Bit Manipulation Extension)
// CHECK-NEXT:     xqcicli              0.3       'Xqcicli' (Qualcomm uC Conditional Load Immediate Extension)
// CHECK-NEXT:     xqcicm               0.2       'Xqcicm' (Qualcomm uC Conditional Move Extension)
// CHECK-NEXT:     xqcics               0.2       'Xqcics' (Qualcomm uC Conditional Select Extension)
// CHECK-NEXT:     xqcicsr              0.4       'Xqcicsr' (Qualcomm uC CSR Extension)
// CHECK-NEXT:     xqciint              0.10      'Xqciint' (Qualcomm uC Interrupts Extension)
// CHECK-NEXT:     xqciio               0.1       'Xqciio' (Qualcomm uC External Input Output Extension)
// CHECK-NEXT:     xqcilb               0.2       'Xqcilb' (Qualcomm uC Long Branch Extension)
// CHECK-NEXT:     xqcili               0.2       'Xqcili' (Qualcomm uC Load Large Immediate Extension)
// CHECK-NEXT:     xqcilia              0.2       'Xqcilia' (Qualcomm uC Large Immediate Arithmetic Extension)
// CHECK-NEXT:     xqcilo               0.3       'Xqcilo' (Qualcomm uC Large Offset Load Store Extension)
// CHECK-NEXT:     xqcilsm              0.6       'Xqcilsm' (Qualcomm uC Load Store Multiple Extension)
// CHECK-NEXT:     xqcisim              0.2       'Xqcisim' (Qualcomm uC Simulation Hint Extension)
// CHECK-NEXT:     xqcisls              0.2       'Xqcisls' (Qualcomm uC Scaled Load Store Extension)
// CHECK-NEXT:     xqcisync             0.3       'Xqcisync' (Qualcomm uC Sync Delay Extension)
// CHECK-NEXT:     xrivosvisni          0.1       'XRivosVisni' (Rivos Vector Integer Small New)
// CHECK-NEXT:     xrivosvizip          0.1       'XRivosVizip' (Rivos Vector Register Zips)
// CHECK-NEXT:     xsfmclic             0.1       'XSfmclic' (SiFive CLIC Machine-mode CSRs)
// CHECK-NEXT:     xsfsclic             0.1       'XSfsclic' (SiFive CLIC Supervisor-mode CSRs)
// CHECK-EMPTY:
// CHECK-NEXT: Supported Profiles
// CHECK-NEXT:     rva20s64
// CHECK-NEXT:     rva20u64
// CHECK-NEXT:     rva22s64
// CHECK-NEXT:     rva22u64
// CHECK-NEXT:     rva23s64
// CHECK-NEXT:     rva23u64
// CHECK-NEXT:     rvb23s64
// CHECK-NEXT:     rvb23u64
// CHECK-NEXT:     rvi20u32
// CHECK-NEXT:     rvi20u64
// CHECK-EMPTY:
// CHECK-NEXT: Experimental Profiles
// CHECK-NEXT:     rvm23u32
// CHECK-EMPTY:
// CHECK-NEXT: Use -march to specify the target's extension.
// CHECK-NEXT: For example, clang -march=rv32i_v1p0
