/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.ops4j.pax.web.service.jetty.internal.PaxWebSessionHandler;
import org.ops4j.pax.web.service.jetty.internal.PaxWebSessionIdManager;
import org.ops4j.pax.web.service.jetty.internal.web.RootBundleURLResource;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerKey;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.servlet.SCIWrapper;
import org.ops4j.pax.web.service.spi.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxWebServletContextHandler
extends ServletContextHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PaxWebServletContextHandler.class);
    private final Collection<SCIWrapper> servletContainerInitializers = new TreeSet<SCIWrapper>();
    private AccessControlContext accessControllerContext;
    private List<String> virtualHosts;
    private ServletContext osgiServletContext;
    private final Map<EventListenerKey, EventListener> rankedListeners = new TreeMap<EventListenerKey, EventListener>();
    private final List<EventListener> orderedListeners = new ArrayList<EventListener>();
    private final ThreadLocal<Boolean> isCallingSCI = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final Set<String> attributesToClearBeforeRestart = new HashSet<String>();

    public PaxWebServletContextHandler(HandlerContainer parent, String contextPath, Configuration configuration) {
        super(parent, contextPath, true, true);
        ScheduledExecutorScheduler executorScheduler = new ScheduledExecutorScheduler(this.getSessionHandler().toString() + "Timer", true, ((Object)((Object)this)).getClass().getClassLoader());
        this._scontext.setAttribute("org.eclipse.jetty.server.session.timer", (Object)executorScheduler);
        this.setLogger(Log.getLogger((String)(this.getDisplayName() == null ? this.getContextPath() : this.getDisplayName())));
        this.setProtectedTargets(new String[]{"/WEB-INF", "/META-INF", "/OSGI-INF", "/OSGI-OPT"});
    }

    public static Resource toJettyResource(URL url) throws MalformedURLException {
        if (url != null && ("bundle".equals(url.getProtocol()) || "bundleentry".equals(url.getProtocol()))) {
            if ("/".equals(url.getPath())) {
                return new RootBundleURLResource(Resource.newResource((URL)url));
            }
            if (!url.getPath().endsWith("/")) {
                try (Resource potentialDirectory = Resource.newResource((URL)url);){
                    URL fixedURL;
                    Resource properDirectory;
                    if (potentialDirectory.exists() && potentialDirectory.length() == 0L && (properDirectory = Resource.newResource((URL)(fixedURL = new URL(url.toExternalForm() + "/")))).exists()) {
                        Resource resource = properDirectory;
                        return resource;
                    }
                }
            }
        }
        return Resource.newResource((URL)url);
    }

    public void setServletContainerInitializers(Collection<SCIWrapper> wrappers) {
        this.servletContainerInitializers.clear();
        this.servletContainerInitializers.addAll(wrappers);
    }

    public void setOsgiServletContext(ServletContext osgiServletContext) {
        this.osgiServletContext = osgiServletContext;
    }

    public void callContextInitialized(ServletContextListener l, ServletContextEvent e) {
        super.callContextInitialized(l, new ServletContextEvent(this.osgiServletContext));
    }

    public void callContextDestroyed(ServletContextListener l, ServletContextEvent e) {
        super.callContextDestroyed(l, new ServletContextEvent(this.osgiServletContext));
    }

    public void addEventListener(EventListener listener) {
        this.addEventListener(null, listener);
    }

    public void addEventListener(EventListenerModel model, EventListener listener) {
        if (model == null || model.isDynamic()) {
            this.orderedListeners.add(listener);
        } else {
            this.rankedListeners.put(EventListenerKey.ofModel((EventListenerModel)model), listener);
        }
        if (!ServletContextListener.class.isAssignableFrom(listener.getClass()) && this.isStarted()) {
            super.addEventListener(listener);
        }
    }

    protected void addProgrammaticListener(EventListener listener) {
        this.orderedListeners.add(listener);
    }

    public void removeEventListener(EventListener listener) {
        this.removeEventListener(null, listener);
    }

    public void removeEventListener(EventListenerModel model, EventListener listener) {
        if (model == null || model.isDynamic()) {
            this.orderedListeners.remove(listener);
        } else {
            this.rankedListeners.remove(EventListenerKey.ofModel((EventListenerModel)model));
        }
    }

    protected void startContext() throws Exception {
        for (String name : this.attributesToClearBeforeRestart) {
            this.removeAttribute(name);
        }
        this.attributesToClearBeforeRestart.clear();
        this.servletContainerInitializers.forEach(wrapper -> {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                this.getServletContext().setExtendedListenerTypes(true);
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
                this.isCallingSCI.set(true);
                wrapper.onStartup();
            }
            catch (ServletException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.isCallingSCI.remove();
                Thread.currentThread().setContextClassLoader(tccl);
                this.getServletContext().setExtendedListenerTypes(false);
            }
        });
        for (int pos = 0; pos < this.orderedListeners.size(); ++pos) {
            EventListener el = this.orderedListeners.get(pos);
            this.rankedListeners.put(EventListenerKey.ofPosition((int)pos), el);
        }
        for (EventListener el : this.rankedListeners.values()) {
            super.addEventListener(el);
        }
        super.startContext();
    }

    public void setAttribute(String name, Object value) {
        if (this.isCallingSCI.get().booleanValue()) {
            this.attributesToClearBeforeRestart.add(name);
        }
        super.setAttribute(name, value);
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.setEventListeners(new EventListener[0]);
        this.getSessionHandler().clearEventListeners();
        this.rankedListeners.entrySet().removeIf(e -> ((EventListenerKey)e.getKey()).getRanklessPosition() >= 0);
        this.orderedListeners.clear();
    }

    protected void requestInitialized(Request baseRequest, HttpServletRequest request) {
        if (this.getSessionHandler() instanceof PaxWebSessionHandler) {
            PaxWebSessionHandler sessionHandler = (PaxWebSessionHandler)this.getSessionHandler();
            String sid = baseRequest.getRequestedSessionId();
            if (sid != null && baseRequest.getSession(false) == null) {
                String baseSid = sessionHandler.getSessionIdManager().getId(sid);
                baseSid = baseSid + PaxWebSessionIdManager.getSessionIdSuffix((HttpServletRequest)baseRequest);
                sid = sessionHandler.getSessionIdManager().getExtendedId(baseSid, request);
                HttpSession session = sessionHandler.getHttpSession(sid);
                if (session != null && sessionHandler.isValid(session)) {
                    baseRequest.enterSession(session);
                    baseRequest.setSession(session);
                }
            }
        }
        super.requestInitialized(baseRequest, request);
    }

    public Resource getResource(String path) throws MalformedURLException {
        URL url;
        Resource resource;
        String childPath = Path.securePath((String)path);
        if (childPath == null) {
            return null;
        }
        if (childPath.startsWith("/")) {
            childPath = childPath.substring(1);
        }
        if ((resource = PaxWebServletContextHandler.toJettyResource(url = this.osgiServletContext.getResource("/" + childPath))) == null) {
            return super.getResource(path);
        }
        return resource;
    }

    protected SessionHandler newSessionHandler() {
        return new PaxWebSessionHandler();
    }
}

