// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// Test target codegen - host bc file has to be created first.
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -fopenmp-cuda-mode -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=nvptx64-nvidia-cuda -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -fopenmp-cuda-mode -x c++ -triple nvptx64-unknown-unknown -fopenmp-targets=nvptx64-nvidia-cuda -emit-llvm %s -fopenmp-is-target-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --check-prefix=CHECK45-64
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -fopenmp-cuda-mode -x c++ -triple i386-unknown-unknown -fopenmp-targets=nvptx-nvidia-cuda -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -fopenmp-cuda-mode -x c++ -triple nvptx-unknown-unknown -fopenmp-targets=nvptx-nvidia-cuda -emit-llvm %s -fopenmp-is-target-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --check-prefix=CHECK45-32
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -fopenmp-cuda-mode -fexceptions -fcxx-exceptions -x c++ -triple nvptx-unknown-unknown -fopenmp-targets=nvptx-nvidia-cuda -emit-llvm %s -fopenmp-is-target-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --check-prefix=CHECK45-32-EX

// RUN: %clang_cc1 -verify -fopenmp -fopenmp-cuda-mode -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=nvptx64-nvidia-cuda -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-cuda-mode -x c++ -triple nvptx64-unknown-unknown -fopenmp-targets=nvptx64-nvidia-cuda -emit-llvm %s -fopenmp-is-target-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --check-prefix=CHECK-64
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-cuda-mode -x c++ -triple i386-unknown-unknown -fopenmp-targets=nvptx-nvidia-cuda -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-cuda-mode -x c++ -triple nvptx-unknown-unknown -fopenmp-targets=nvptx-nvidia-cuda -emit-llvm %s -fopenmp-is-target-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --check-prefix=CHECK-32
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-cuda-mode -fexceptions -fcxx-exceptions -x c++ -triple nvptx-unknown-unknown -fopenmp-targets=nvptx-nvidia-cuda -emit-llvm %s -fopenmp-is-target-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --check-prefix=CHECK-32-EX

// expected-no-diagnostics
#ifndef HEADER
#define HEADER

// Check that the execution mode of all 3 target regions on the gpu is set to SPMD Mode.

template<typename tx>
tx ftemplate(int n) {
  tx a = 0;
  short aa = 0;
  tx b[10];

  #pragma omp target parallel proc_bind(master)
  {
  }

  #pragma omp target parallel proc_bind(spread)
  {
    aa += 1;
  }

  #pragma omp target parallel proc_bind(close)
  {
    a += 1;
    aa += 1;
    b[2] += 1;
  }

  return a;
}

int bar(int n){
  int a = 0;

  a += ftemplate<int>(n);

  return a;
}

#endif
// CHECK45-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27
// CHECK45-64-SAME: (ptr noalias noundef [[DYN_PTR:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK45-64-NEXT:  entry:
// CHECK45-64-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK45-64-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [0 x ptr], align 8
// CHECK45-64-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 8
// CHECK45-64-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_kernel_environment, ptr [[DYN_PTR]])
// CHECK45-64-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK45-64-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK45-64:       user_code.entry:
// CHECK45-64-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK45-64-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i64 0, i32 0)
// CHECK45-64-NEXT:    call void @__kmpc_target_deinit()
// CHECK45-64-NEXT:    ret void
// CHECK45-64:       worker.exit:
// CHECK45-64-NEXT:    ret void
//
//
// CHECK45-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined
// CHECK45-64-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK45-64-NEXT:  entry:
// CHECK45-64-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK45-64-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK45-64-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK45-64-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK45-64-NEXT:    ret void
//
//
// CHECK45-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31
// CHECK45-64-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK45-64-NEXT:  entry:
// CHECK45-64-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK45-64-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK45-64-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK45-64-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [1 x ptr], align 8
// CHECK45-64-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 8
// CHECK45-64-NEXT:    store i64 [[AA]], ptr [[AA_ADDR]], align 8
// CHECK45-64-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_kernel_environment, ptr [[DYN_PTR]])
// CHECK45-64-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK45-64-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK45-64:       user_code.entry:
// CHECK45-64-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK45-64-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-64-NEXT:    store i16 [[TMP2]], ptr [[AA_CASTED]], align 2
// CHECK45-64-NEXT:    [[TMP3:%.*]] = load i64, ptr [[AA_CASTED]], align 8
// CHECK45-64-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i64 0, i64 0
// CHECK45-64-NEXT:    [[TMP5:%.*]] = inttoptr i64 [[TMP3]] to ptr
// CHECK45-64-NEXT:    store ptr [[TMP5]], ptr [[TMP4]], align 8
// CHECK45-64-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i64 1, i32 0)
// CHECK45-64-NEXT:    call void @__kmpc_target_deinit()
// CHECK45-64-NEXT:    ret void
// CHECK45-64:       worker.exit:
// CHECK45-64-NEXT:    ret void
//
//
// CHECK45-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined
// CHECK45-64-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK45-64-NEXT:  entry:
// CHECK45-64-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK45-64-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK45-64-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK45-64-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK45-64-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK45-64-NEXT:    store i64 [[AA]], ptr [[AA_ADDR]], align 8
// CHECK45-64-NEXT:    [[TMP0:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-64-NEXT:    [[CONV:%.*]] = sext i16 [[TMP0]] to i32
// CHECK45-64-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK45-64-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK45-64-NEXT:    store i16 [[CONV1]], ptr [[AA_ADDR]], align 2
// CHECK45-64-NEXT:    ret void
//
//
// CHECK45-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36
// CHECK45-64-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK45-64-NEXT:  entry:
// CHECK45-64-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK45-64-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK45-64-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK45-64-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// CHECK45-64-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK45-64-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK45-64-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [3 x ptr], align 8
// CHECK45-64-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 8
// CHECK45-64-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK45-64-NEXT:    store i64 [[AA]], ptr [[AA_ADDR]], align 8
// CHECK45-64-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// CHECK45-64-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// CHECK45-64-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_kernel_environment, ptr [[DYN_PTR]])
// CHECK45-64-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP1]], -1
// CHECK45-64-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK45-64:       user_code.entry:
// CHECK45-64-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK45-64-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK45-64-NEXT:    store i32 [[TMP3]], ptr [[A_CASTED]], align 4
// CHECK45-64-NEXT:    [[TMP4:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK45-64-NEXT:    [[TMP5:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-64-NEXT:    store i16 [[TMP5]], ptr [[AA_CASTED]], align 2
// CHECK45-64-NEXT:    [[TMP6:%.*]] = load i64, ptr [[AA_CASTED]], align 8
// CHECK45-64-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i64 0, i64 0
// CHECK45-64-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP4]] to ptr
// CHECK45-64-NEXT:    store ptr [[TMP8]], ptr [[TMP7]], align 8
// CHECK45-64-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i64 0, i64 1
// CHECK45-64-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP6]] to ptr
// CHECK45-64-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 8
// CHECK45-64-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i64 0, i64 2
// CHECK45-64-NEXT:    store ptr [[TMP0]], ptr [[TMP11]], align 8
// CHECK45-64-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP2]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i64 3, i32 0)
// CHECK45-64-NEXT:    call void @__kmpc_target_deinit()
// CHECK45-64-NEXT:    ret void
// CHECK45-64:       worker.exit:
// CHECK45-64-NEXT:    ret void
//
//
// CHECK45-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined
// CHECK45-64-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK45-64-NEXT:  entry:
// CHECK45-64-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK45-64-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK45-64-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK45-64-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK45-64-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// CHECK45-64-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK45-64-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK45-64-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK45-64-NEXT:    store i64 [[AA]], ptr [[AA_ADDR]], align 8
// CHECK45-64-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// CHECK45-64-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// CHECK45-64-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK45-64-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK45-64-NEXT:    store i32 [[ADD]], ptr [[A_ADDR]], align 4
// CHECK45-64-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-64-NEXT:    [[CONV:%.*]] = sext i16 [[TMP2]] to i32
// CHECK45-64-NEXT:    [[ADD1:%.*]] = add nsw i32 [[CONV]], 1
// CHECK45-64-NEXT:    [[CONV2:%.*]] = trunc i32 [[ADD1]] to i16
// CHECK45-64-NEXT:    store i16 [[CONV2]], ptr [[AA_ADDR]], align 2
// CHECK45-64-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], ptr [[TMP0]], i64 0, i64 2
// CHECK45-64-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK45-64-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP3]], 1
// CHECK45-64-NEXT:    store i32 [[ADD3]], ptr [[ARRAYIDX]], align 4
// CHECK45-64-NEXT:    ret void
//
//
// CHECK45-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27
// CHECK45-32-SAME: (ptr noalias noundef [[DYN_PTR:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK45-32-NEXT:  entry:
// CHECK45-32-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [0 x ptr], align 4
// CHECK45-32-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK45-32-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_kernel_environment, ptr [[DYN_PTR]])
// CHECK45-32-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK45-32-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK45-32:       user_code.entry:
// CHECK45-32-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK45-32-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0)
// CHECK45-32-NEXT:    call void @__kmpc_target_deinit()
// CHECK45-32-NEXT:    ret void
// CHECK45-32:       worker.exit:
// CHECK45-32-NEXT:    ret void
//
//
// CHECK45-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined
// CHECK45-32-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK45-32-NEXT:  entry:
// CHECK45-32-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK45-32-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK45-32-NEXT:    ret void
//
//
// CHECK45-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31
// CHECK45-32-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK45-32-NEXT:  entry:
// CHECK45-32-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK45-32-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [1 x ptr], align 4
// CHECK45-32-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK45-32-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK45-32-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_kernel_environment, ptr [[DYN_PTR]])
// CHECK45-32-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK45-32-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK45-32:       user_code.entry:
// CHECK45-32-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK45-32-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-32-NEXT:    store i16 [[TMP2]], ptr [[AA_CASTED]], align 2
// CHECK45-32-NEXT:    [[TMP3:%.*]] = load i32, ptr [[AA_CASTED]], align 4
// CHECK45-32-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK45-32-NEXT:    [[TMP5:%.*]] = inttoptr i32 [[TMP3]] to ptr
// CHECK45-32-NEXT:    store ptr [[TMP5]], ptr [[TMP4]], align 4
// CHECK45-32-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 1, i32 0)
// CHECK45-32-NEXT:    call void @__kmpc_target_deinit()
// CHECK45-32-NEXT:    ret void
// CHECK45-32:       worker.exit:
// CHECK45-32-NEXT:    ret void
//
//
// CHECK45-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined
// CHECK45-32-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK45-32-NEXT:  entry:
// CHECK45-32-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK45-32-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK45-32-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK45-32-NEXT:    [[TMP0:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-32-NEXT:    [[CONV:%.*]] = sext i16 [[TMP0]] to i32
// CHECK45-32-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK45-32-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK45-32-NEXT:    store i16 [[CONV1]], ptr [[AA_ADDR]], align 2
// CHECK45-32-NEXT:    ret void
//
//
// CHECK45-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36
// CHECK45-32-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK45-32-NEXT:  entry:
// CHECK45-32-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK45-32-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK45-32-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [3 x ptr], align 4
// CHECK45-32-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK45-32-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK45-32-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK45-32-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 4
// CHECK45-32-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 4
// CHECK45-32-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_kernel_environment, ptr [[DYN_PTR]])
// CHECK45-32-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP1]], -1
// CHECK45-32-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK45-32:       user_code.entry:
// CHECK45-32-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK45-32-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK45-32-NEXT:    store i32 [[TMP3]], ptr [[A_CASTED]], align 4
// CHECK45-32-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A_CASTED]], align 4
// CHECK45-32-NEXT:    [[TMP5:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-32-NEXT:    store i16 [[TMP5]], ptr [[AA_CASTED]], align 2
// CHECK45-32-NEXT:    [[TMP6:%.*]] = load i32, ptr [[AA_CASTED]], align 4
// CHECK45-32-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK45-32-NEXT:    [[TMP8:%.*]] = inttoptr i32 [[TMP4]] to ptr
// CHECK45-32-NEXT:    store ptr [[TMP8]], ptr [[TMP7]], align 4
// CHECK45-32-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 1
// CHECK45-32-NEXT:    [[TMP10:%.*]] = inttoptr i32 [[TMP6]] to ptr
// CHECK45-32-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 4
// CHECK45-32-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 2
// CHECK45-32-NEXT:    store ptr [[TMP0]], ptr [[TMP11]], align 4
// CHECK45-32-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP2]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 3, i32 0)
// CHECK45-32-NEXT:    call void @__kmpc_target_deinit()
// CHECK45-32-NEXT:    ret void
// CHECK45-32:       worker.exit:
// CHECK45-32-NEXT:    ret void
//
//
// CHECK45-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined
// CHECK45-32-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK45-32-NEXT:  entry:
// CHECK45-32-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK45-32-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK45-32-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK45-32-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK45-32-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 4
// CHECK45-32-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 4
// CHECK45-32-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK45-32-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK45-32-NEXT:    store i32 [[ADD]], ptr [[A_ADDR]], align 4
// CHECK45-32-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-32-NEXT:    [[CONV:%.*]] = sext i16 [[TMP2]] to i32
// CHECK45-32-NEXT:    [[ADD1:%.*]] = add nsw i32 [[CONV]], 1
// CHECK45-32-NEXT:    [[CONV2:%.*]] = trunc i32 [[ADD1]] to i16
// CHECK45-32-NEXT:    store i16 [[CONV2]], ptr [[AA_ADDR]], align 2
// CHECK45-32-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], ptr [[TMP0]], i32 0, i32 2
// CHECK45-32-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK45-32-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP3]], 1
// CHECK45-32-NEXT:    store i32 [[ADD3]], ptr [[ARRAYIDX]], align 4
// CHECK45-32-NEXT:    ret void
//
//
// CHECK45-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27
// CHECK45-32-EX-SAME: (ptr noalias noundef [[DYN_PTR:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK45-32-EX-NEXT:  entry:
// CHECK45-32-EX-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-EX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [0 x ptr], align 4
// CHECK45-32-EX-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK45-32-EX-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_kernel_environment, ptr [[DYN_PTR]])
// CHECK45-32-EX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK45-32-EX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK45-32-EX:       user_code.entry:
// CHECK45-32-EX-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK45-32-EX-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0)
// CHECK45-32-EX-NEXT:    call void @__kmpc_target_deinit()
// CHECK45-32-EX-NEXT:    ret void
// CHECK45-32-EX:       worker.exit:
// CHECK45-32-EX-NEXT:    ret void
//
//
// CHECK45-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined
// CHECK45-32-EX-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK45-32-EX-NEXT:  entry:
// CHECK45-32-EX-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-EX-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-EX-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK45-32-EX-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK45-32-EX-NEXT:    ret void
//
//
// CHECK45-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31
// CHECK45-32-EX-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK45-32-EX-NEXT:  entry:
// CHECK45-32-EX-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-EX-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-EX-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK45-32-EX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [1 x ptr], align 4
// CHECK45-32-EX-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK45-32-EX-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK45-32-EX-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_kernel_environment, ptr [[DYN_PTR]])
// CHECK45-32-EX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK45-32-EX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK45-32-EX:       user_code.entry:
// CHECK45-32-EX-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK45-32-EX-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-32-EX-NEXT:    store i16 [[TMP2]], ptr [[AA_CASTED]], align 2
// CHECK45-32-EX-NEXT:    [[TMP3:%.*]] = load i32, ptr [[AA_CASTED]], align 4
// CHECK45-32-EX-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK45-32-EX-NEXT:    [[TMP5:%.*]] = inttoptr i32 [[TMP3]] to ptr
// CHECK45-32-EX-NEXT:    store ptr [[TMP5]], ptr [[TMP4]], align 4
// CHECK45-32-EX-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 1, i32 0)
// CHECK45-32-EX-NEXT:    call void @__kmpc_target_deinit()
// CHECK45-32-EX-NEXT:    ret void
// CHECK45-32-EX:       worker.exit:
// CHECK45-32-EX-NEXT:    ret void
//
//
// CHECK45-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined
// CHECK45-32-EX-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK45-32-EX-NEXT:  entry:
// CHECK45-32-EX-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-EX-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-EX-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-EX-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK45-32-EX-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK45-32-EX-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK45-32-EX-NEXT:    [[TMP0:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-32-EX-NEXT:    [[CONV:%.*]] = sext i16 [[TMP0]] to i32
// CHECK45-32-EX-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK45-32-EX-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK45-32-EX-NEXT:    store i16 [[CONV1]], ptr [[AA_ADDR]], align 2
// CHECK45-32-EX-NEXT:    ret void
//
//
// CHECK45-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36
// CHECK45-32-EX-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK45-32-EX-NEXT:  entry:
// CHECK45-32-EX-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-EX-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-EX-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-EX-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-EX-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK45-32-EX-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK45-32-EX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [3 x ptr], align 4
// CHECK45-32-EX-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK45-32-EX-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK45-32-EX-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK45-32-EX-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 4
// CHECK45-32-EX-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 4
// CHECK45-32-EX-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_kernel_environment, ptr [[DYN_PTR]])
// CHECK45-32-EX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP1]], -1
// CHECK45-32-EX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK45-32-EX:       user_code.entry:
// CHECK45-32-EX-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK45-32-EX-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK45-32-EX-NEXT:    store i32 [[TMP3]], ptr [[A_CASTED]], align 4
// CHECK45-32-EX-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A_CASTED]], align 4
// CHECK45-32-EX-NEXT:    [[TMP5:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-32-EX-NEXT:    store i16 [[TMP5]], ptr [[AA_CASTED]], align 2
// CHECK45-32-EX-NEXT:    [[TMP6:%.*]] = load i32, ptr [[AA_CASTED]], align 4
// CHECK45-32-EX-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK45-32-EX-NEXT:    [[TMP8:%.*]] = inttoptr i32 [[TMP4]] to ptr
// CHECK45-32-EX-NEXT:    store ptr [[TMP8]], ptr [[TMP7]], align 4
// CHECK45-32-EX-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 1
// CHECK45-32-EX-NEXT:    [[TMP10:%.*]] = inttoptr i32 [[TMP6]] to ptr
// CHECK45-32-EX-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 4
// CHECK45-32-EX-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 2
// CHECK45-32-EX-NEXT:    store ptr [[TMP0]], ptr [[TMP11]], align 4
// CHECK45-32-EX-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP2]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 3, i32 0)
// CHECK45-32-EX-NEXT:    call void @__kmpc_target_deinit()
// CHECK45-32-EX-NEXT:    ret void
// CHECK45-32-EX:       worker.exit:
// CHECK45-32-EX-NEXT:    ret void
//
//
// CHECK45-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined
// CHECK45-32-EX-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK45-32-EX-NEXT:  entry:
// CHECK45-32-EX-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-EX-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-EX-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-EX-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK45-32-EX-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 4
// CHECK45-32-EX-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK45-32-EX-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK45-32-EX-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK45-32-EX-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK45-32-EX-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 4
// CHECK45-32-EX-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 4
// CHECK45-32-EX-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK45-32-EX-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK45-32-EX-NEXT:    store i32 [[ADD]], ptr [[A_ADDR]], align 4
// CHECK45-32-EX-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK45-32-EX-NEXT:    [[CONV:%.*]] = sext i16 [[TMP2]] to i32
// CHECK45-32-EX-NEXT:    [[ADD1:%.*]] = add nsw i32 [[CONV]], 1
// CHECK45-32-EX-NEXT:    [[CONV2:%.*]] = trunc i32 [[ADD1]] to i16
// CHECK45-32-EX-NEXT:    store i16 [[CONV2]], ptr [[AA_ADDR]], align 2
// CHECK45-32-EX-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], ptr [[TMP0]], i32 0, i32 2
// CHECK45-32-EX-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK45-32-EX-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP3]], 1
// CHECK45-32-EX-NEXT:    store i32 [[ADD3]], ptr [[ARRAYIDX]], align 4
// CHECK45-32-EX-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27
// CHECK-64-SAME: (ptr noalias noundef [[DYN_PTR:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-64-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [0 x ptr], align 8
// CHECK-64-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_kernel_environment, ptr [[DYN_PTR]])
// CHECK-64-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK-64-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-64:       user_code.entry:
// CHECK-64-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK-64-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i64 0, i32 0)
// CHECK-64-NEXT:    call void @__kmpc_target_deinit()
// CHECK-64-NEXT:    ret void
// CHECK-64:       worker.exit:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined
// CHECK-64-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-64-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-64-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-64-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31
// CHECK-64-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-64-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK-64-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK-64-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [1 x ptr], align 8
// CHECK-64-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 8
// CHECK-64-NEXT:    store i64 [[AA]], ptr [[AA_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_kernel_environment, ptr [[DYN_PTR]])
// CHECK-64-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK-64-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-64:       user_code.entry:
// CHECK-64-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK-64-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-64-NEXT:    store i16 [[TMP2]], ptr [[AA_CASTED]], align 2
// CHECK-64-NEXT:    [[TMP3:%.*]] = load i64, ptr [[AA_CASTED]], align 8
// CHECK-64-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP5:%.*]] = inttoptr i64 [[TMP3]] to ptr
// CHECK-64-NEXT:    store ptr [[TMP5]], ptr [[TMP4]], align 8
// CHECK-64-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i64 1, i32 0)
// CHECK-64-NEXT:    call void @__kmpc_target_deinit()
// CHECK-64-NEXT:    ret void
// CHECK-64:       worker.exit:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined
// CHECK-64-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-64-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-64-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK-64-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-64-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK-64-NEXT:    store i64 [[AA]], ptr [[AA_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP0:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-64-NEXT:    [[CONV:%.*]] = sext i16 [[TMP0]] to i32
// CHECK-64-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK-64-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK-64-NEXT:    store i16 [[CONV1]], ptr [[AA_ADDR]], align 2
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36
// CHECK-64-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-64-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK-64-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK-64-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// CHECK-64-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK-64-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK-64-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [3 x ptr], align 8
// CHECK-64-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 8
// CHECK-64-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK-64-NEXT:    store i64 [[AA]], ptr [[AA_ADDR]], align 8
// CHECK-64-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_kernel_environment, ptr [[DYN_PTR]])
// CHECK-64-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP1]], -1
// CHECK-64-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-64:       user_code.entry:
// CHECK-64-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK-64-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-64-NEXT:    store i32 [[TMP3]], ptr [[A_CASTED]], align 4
// CHECK-64-NEXT:    [[TMP4:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK-64-NEXT:    [[TMP5:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-64-NEXT:    store i16 [[TMP5]], ptr [[AA_CASTED]], align 2
// CHECK-64-NEXT:    [[TMP6:%.*]] = load i64, ptr [[AA_CASTED]], align 8
// CHECK-64-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i64 0, i64 0
// CHECK-64-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP4]] to ptr
// CHECK-64-NEXT:    store ptr [[TMP8]], ptr [[TMP7]], align 8
// CHECK-64-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i64 0, i64 1
// CHECK-64-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP6]] to ptr
// CHECK-64-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 8
// CHECK-64-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i64 0, i64 2
// CHECK-64-NEXT:    store ptr [[TMP0]], ptr [[TMP11]], align 8
// CHECK-64-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP2]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i64 3, i32 0)
// CHECK-64-NEXT:    call void @__kmpc_target_deinit()
// CHECK-64-NEXT:    ret void
// CHECK-64:       worker.exit:
// CHECK-64-NEXT:    ret void
//
//
// CHECK-64-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined
// CHECK-64-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK-64-NEXT:  entry:
// CHECK-64-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-64-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK-64-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK-64-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK-64-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// CHECK-64-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK-64-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK-64-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK-64-NEXT:    store i64 [[AA]], ptr [[AA_ADDR]], align 8
// CHECK-64-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// CHECK-64-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-64-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK-64-NEXT:    store i32 [[ADD]], ptr [[A_ADDR]], align 4
// CHECK-64-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-64-NEXT:    [[CONV:%.*]] = sext i16 [[TMP2]] to i32
// CHECK-64-NEXT:    [[ADD1:%.*]] = add nsw i32 [[CONV]], 1
// CHECK-64-NEXT:    [[CONV2:%.*]] = trunc i32 [[ADD1]] to i16
// CHECK-64-NEXT:    store i16 [[CONV2]], ptr [[AA_ADDR]], align 2
// CHECK-64-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], ptr [[TMP0]], i64 0, i64 2
// CHECK-64-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-64-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP3]], 1
// CHECK-64-NEXT:    store i32 [[ADD3]], ptr [[ARRAYIDX]], align 4
// CHECK-64-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27
// CHECK-32-SAME: (ptr noalias noundef [[DYN_PTR:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [0 x ptr], align 4
// CHECK-32-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_kernel_environment, ptr [[DYN_PTR]])
// CHECK-32-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK-32-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32:       user_code.entry:
// CHECK-32-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK-32-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0)
// CHECK-32-NEXT:    call void @__kmpc_target_deinit()
// CHECK-32-NEXT:    ret void
// CHECK-32:       worker.exit:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined
// CHECK-32-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31
// CHECK-32-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [1 x ptr], align 4
// CHECK-32-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK-32-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_kernel_environment, ptr [[DYN_PTR]])
// CHECK-32-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK-32-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32:       user_code.entry:
// CHECK-32-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK-32-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-32-NEXT:    store i16 [[TMP2]], ptr [[AA_CASTED]], align 2
// CHECK-32-NEXT:    [[TMP3:%.*]] = load i32, ptr [[AA_CASTED]], align 4
// CHECK-32-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP5:%.*]] = inttoptr i32 [[TMP3]] to ptr
// CHECK-32-NEXT:    store ptr [[TMP5]], ptr [[TMP4]], align 4
// CHECK-32-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 1, i32 0)
// CHECK-32-NEXT:    call void @__kmpc_target_deinit()
// CHECK-32-NEXT:    ret void
// CHECK-32:       worker.exit:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined
// CHECK-32-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP0:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-32-NEXT:    [[CONV:%.*]] = sext i16 [[TMP0]] to i32
// CHECK-32-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK-32-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK-32-NEXT:    store i16 [[CONV1]], ptr [[AA_ADDR]], align 2
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36
// CHECK-32-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [3 x ptr], align 4
// CHECK-32-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK-32-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-32-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK-32-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_kernel_environment, ptr [[DYN_PTR]])
// CHECK-32-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP1]], -1
// CHECK-32-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32:       user_code.entry:
// CHECK-32-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK-32-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-32-NEXT:    store i32 [[TMP3]], ptr [[A_CASTED]], align 4
// CHECK-32-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A_CASTED]], align 4
// CHECK-32-NEXT:    [[TMP5:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-32-NEXT:    store i16 [[TMP5]], ptr [[AA_CASTED]], align 2
// CHECK-32-NEXT:    [[TMP6:%.*]] = load i32, ptr [[AA_CASTED]], align 4
// CHECK-32-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK-32-NEXT:    [[TMP8:%.*]] = inttoptr i32 [[TMP4]] to ptr
// CHECK-32-NEXT:    store ptr [[TMP8]], ptr [[TMP7]], align 4
// CHECK-32-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 1
// CHECK-32-NEXT:    [[TMP10:%.*]] = inttoptr i32 [[TMP6]] to ptr
// CHECK-32-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 4
// CHECK-32-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 2
// CHECK-32-NEXT:    store ptr [[TMP0]], ptr [[TMP11]], align 4
// CHECK-32-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP2]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 3, i32 0)
// CHECK-32-NEXT:    call void @__kmpc_target_deinit()
// CHECK-32-NEXT:    ret void
// CHECK-32:       worker.exit:
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined
// CHECK-32-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK-32-NEXT:  entry:
// CHECK-32-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-32-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK-32-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-32-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK-32-NEXT:    store i32 [[ADD]], ptr [[A_ADDR]], align 4
// CHECK-32-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-32-NEXT:    [[CONV:%.*]] = sext i16 [[TMP2]] to i32
// CHECK-32-NEXT:    [[ADD1:%.*]] = add nsw i32 [[CONV]], 1
// CHECK-32-NEXT:    [[CONV2:%.*]] = trunc i32 [[ADD1]] to i16
// CHECK-32-NEXT:    store i16 [[CONV2]], ptr [[AA_ADDR]], align 2
// CHECK-32-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], ptr [[TMP0]], i32 0, i32 2
// CHECK-32-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-32-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP3]], 1
// CHECK-32-NEXT:    store i32 [[ADD3]], ptr [[ARRAYIDX]], align 4
// CHECK-32-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27
// CHECK-32-EX-SAME: (ptr noalias noundef [[DYN_PTR:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-EX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [0 x ptr], align 4
// CHECK-32-EX-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_kernel_environment, ptr [[DYN_PTR]])
// CHECK-32-EX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK-32-EX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32-EX:       user_code.entry:
// CHECK-32-EX-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK-32-EX-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0)
// CHECK-32-EX-NEXT:    call void @__kmpc_target_deinit()
// CHECK-32-EX-NEXT:    ret void
// CHECK-32-EX:       worker.exit:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l27_omp_outlined
// CHECK-32-EX-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-EX-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-EX-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31
// CHECK-32-EX-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-EX-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [1 x ptr], align 4
// CHECK-32-EX-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_kernel_environment, ptr [[DYN_PTR]])
// CHECK-32-EX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK-32-EX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32-EX:       user_code.entry:
// CHECK-32-EX-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-32-EX-NEXT:    store i16 [[TMP2]], ptr [[AA_CASTED]], align 2
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = load i32, ptr [[AA_CASTED]], align 4
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = inttoptr i32 [[TMP3]] to ptr
// CHECK-32-EX-NEXT:    store ptr [[TMP5]], ptr [[TMP4]], align 4
// CHECK-32-EX-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 1, i32 0)
// CHECK-32-EX-NEXT:    call void @__kmpc_target_deinit()
// CHECK-32-EX-NEXT:    ret void
// CHECK-32-EX:       worker.exit:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l31_omp_outlined
// CHECK-32-EX-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-EX-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-EX-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP0:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-32-EX-NEXT:    [[CONV:%.*]] = sext i16 [[TMP0]] to i32
// CHECK-32-EX-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK-32-EX-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK-32-EX-NEXT:    store i16 [[CONV1]], ptr [[AA_ADDR]], align 2
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36
// CHECK-32-EX-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-EX-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-EX-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [3 x ptr], align 4
// CHECK-32-EX-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK-32-EX-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_target_init(ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_kernel_environment, ptr [[DYN_PTR]])
// CHECK-32-EX-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP1]], -1
// CHECK-32-EX-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-32-EX:       user_code.entry:
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32 [[TMP3]], ptr [[A_CASTED]], align 4
// CHECK-32-EX-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A_CASTED]], align 4
// CHECK-32-EX-NEXT:    [[TMP5:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-32-EX-NEXT:    store i16 [[TMP5]], ptr [[AA_CASTED]], align 2
// CHECK-32-EX-NEXT:    [[TMP6:%.*]] = load i32, ptr [[AA_CASTED]], align 4
// CHECK-32-EX-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 0
// CHECK-32-EX-NEXT:    [[TMP8:%.*]] = inttoptr i32 [[TMP4]] to ptr
// CHECK-32-EX-NEXT:    store ptr [[TMP8]], ptr [[TMP7]], align 4
// CHECK-32-EX-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 1
// CHECK-32-EX-NEXT:    [[TMP10:%.*]] = inttoptr i32 [[TMP6]] to ptr
// CHECK-32-EX-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 4
// CHECK-32-EX-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[CAPTURED_VARS_ADDRS]], i32 0, i32 2
// CHECK-32-EX-NEXT:    store ptr [[TMP0]], ptr [[TMP11]], align 4
// CHECK-32-EX-NEXT:    call void @__kmpc_parallel_60(ptr @[[GLOB1]], i32 [[TMP2]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS]], i32 3, i32 0)
// CHECK-32-EX-NEXT:    call void @__kmpc_target_deinit()
// CHECK-32-EX-NEXT:    ret void
// CHECK-32-EX:       worker.exit:
// CHECK-32-EX-NEXT:    ret void
//
//
// CHECK-32-EX-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l36_omp_outlined
// CHECK-32-EX-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], ptr noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK-32-EX-NEXT:  entry:
// CHECK-32-EX-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-EX-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-EX-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK-32-EX-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 4
// CHECK-32-EX-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-32-EX-NEXT:    store i32 [[AA]], ptr [[AA_ADDR]], align 4
// CHECK-32-EX-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[B_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK-32-EX-NEXT:    store i32 [[ADD]], ptr [[A_ADDR]], align 4
// CHECK-32-EX-NEXT:    [[TMP2:%.*]] = load i16, ptr [[AA_ADDR]], align 2
// CHECK-32-EX-NEXT:    [[CONV:%.*]] = sext i16 [[TMP2]] to i32
// CHECK-32-EX-NEXT:    [[ADD1:%.*]] = add nsw i32 [[CONV]], 1
// CHECK-32-EX-NEXT:    [[CONV2:%.*]] = trunc i32 [[ADD1]] to i16
// CHECK-32-EX-NEXT:    store i16 [[CONV2]], ptr [[AA_ADDR]], align 2
// CHECK-32-EX-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], ptr [[TMP0]], i32 0, i32 2
// CHECK-32-EX-NEXT:    [[TMP3:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-32-EX-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP3]], 1
// CHECK-32-EX-NEXT:    store i32 [[ADD3]], ptr [[ARRAYIDX]], align 4
// CHECK-32-EX-NEXT:    ret void
//
