/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.addons;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.util.ArrayUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayJavaAddons {
    @JRubyMethod(name={"copy_data"})
    public static IRubyObject copy_data(ThreadContext context, IRubyObject fromRuby, IRubyObject toJava, IRubyObject fillValue) {
        int i2;
        ArrayJavaProxy javaArray = ArrayJavaAddons.assertJavaArrayProxy(context, toJava);
        int javaLength = javaArray.length();
        Class<?> targetType = javaArray.getComponentType();
        Object fillJavaObject = null;
        if (!fillValue.isNil()) {
            fillJavaObject = fillValue.toJava(targetType);
        }
        RubyArray rubyArray = null;
        if (fromRuby instanceof RubyArray) {
            rubyArray = (RubyArray)fromRuby;
        } else {
            fillJavaObject = fromRuby.toJava(targetType);
        }
        Ruby runtime2 = context.runtime;
        Object array2 = javaArray.getObject();
        if (rubyArray != null) {
            int rubyLength2 = rubyArray.getLength();
            for (i2 = 0; i2 < rubyLength2 && i2 < javaLength; ++i2) {
                Object javaObject = rubyArray.eltInternal(i2).toJava(targetType);
                ArrayUtils.setWithExceptionHandlingDirect(runtime2, array2, i2, javaObject);
            }
        }
        if (i2 < javaLength && fillJavaObject != null) {
            while (i2 < javaLength) {
                ArrayUtils.setWithExceptionHandlingDirect(runtime2, array2, i2, fillJavaObject);
                ++i2;
            }
        }
        return toJava;
    }

    @JRubyMethod(name={"copy_data", "copy_data_simple"})
    public static IRubyObject copy_data(ThreadContext context, IRubyObject fromRuby, IRubyObject toJava) {
        ArrayJavaProxy javaArray = ArrayJavaAddons.assertJavaArrayProxy(context, toJava);
        RubyArray rubyArray = (RubyArray)fromRuby;
        ArrayJavaAddons.copyDataToJavaArray(context, rubyArray, javaArray, 0);
        return toJava;
    }

    private static void copyDataToJavaArray(ThreadContext context, RubyArray rubyArray, ArrayJavaProxy javaArray, int offset2) {
        int length2 = javaArray.length();
        if (length2 > rubyArray.getLength()) {
            length2 = rubyArray.getLength();
        }
        Ruby runtime2 = context.runtime;
        Object array2 = javaArray.getObject();
        Class<?> targetType = javaArray.getComponentType();
        for (int i2 = offset2; i2 < length2; ++i2) {
            Object javaObject = rubyArray.eltInternal(i2).toJava(targetType);
            ArrayUtils.setWithExceptionHandlingDirect(runtime2, array2, i2, javaObject);
        }
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject rubyArray) {
        return ArrayJavaAddons.dimensions(context, rubyArray, context.runtime.newEmptyArray());
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject rubyArray, IRubyObject dims) {
        Ruby runtime2 = context.runtime;
        if (!(rubyArray instanceof RubyArray)) {
            return runtime2.newEmptyArray();
        }
        assert (dims instanceof RubyArray);
        return ArrayJavaAddons.calcDimensions(runtime2, (RubyArray)rubyArray, (RubyArray)dims, 0);
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject rubyArray, IRubyObject dims, IRubyObject index2) {
        Ruby runtime2 = context.runtime;
        if (!(rubyArray instanceof RubyArray)) {
            return runtime2.newEmptyArray();
        }
        assert (dims instanceof RubyArray);
        assert (index2 instanceof RubyFixnum);
        int i2 = (int)((RubyFixnum)index2).getLongValue();
        return ArrayJavaAddons.calcDimensions(runtime2, (RubyArray)rubyArray, (RubyArray)dims, i2);
    }

    private static RubyArray calcDimensions(Ruby runtime2, RubyArray array2, RubyArray dims, int index2) {
        while (dims.size() <= index2) {
            dims.append(RubyFixnum.zero(runtime2));
        }
        long dim = ((RubyFixnum)dims.eltInternal(index2)).getLongValue();
        if ((long)array2.size() > dim) {
            dims.eltInternalSet(index2, RubyFixnum.newFixnum(runtime2, array2.size()));
        }
        for (int i2 = 0; i2 < array2.size(); ++i2) {
            Object element = array2.eltInternal(i2);
            if (!(element instanceof RubyArray)) continue;
            ArrayJavaAddons.calcDimensions(runtime2, (RubyArray)element, dims, 1);
        }
        return dims;
    }

    private static ArrayJavaProxy assertJavaArrayProxy(ThreadContext context, IRubyObject java_array) {
        if (java_array instanceof ArrayJavaProxy) {
            return (ArrayJavaProxy)java_array;
        }
        throw context.runtime.newTypeError("expected a Java array, got " + java_array.inspect());
    }
}

