RabbitMQ `3.11.14` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Enhacements

 * It is now possible to limit the maximum number of virtual hosts that can be created
   in the cluster.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#7777](https://github.com/rabbitmq/rabbitmq-server/issues/7777)

 * It is now possible to limit how many shovels or federation links can run on a node
   using `rabbitmq.conf`:

   ``` ini
   runtime_parameters.limits.shovel = 10
   runtime_parameters.limits.federation = 10
   ```

   Contributed by @illotum (AWS).

   GitHub issue: [#7917](https://github.com/rabbitmq/rabbitmq-server/pull/7917)

 * Quorum queues will now log if they could not apply policy changes, for example,
   because there was no quorum of replicas online, or the queue was going through
   a leader election.

   GitHub issue: [#7853](https://github.com/rabbitmq/rabbitmq-server/pull/7853)

#### Bug Fixes

 * [Superstream](https://blog.rabbitmq.com/posts/2022/07/rabbitmq-3-11-feature-preview-super-streams/) could fail
   to elect a single active consumer (SAC) in certain consumer churn conditions.

   GitHub issue: [#7743](https://github.com/rabbitmq/rabbitmq-server/issues/7743)


### CLI Tools

#### Enhancements

 * `rabbitmqctl update_vhost_metadata` is a new command that can be used to update
   the description, default queue type, or tags of a virtual host:

   ``` shell
   rabbitmqctl update_vhost_metadata vh1 --tags qa,quorum,team3,project2

   rabbitmqctl update_vhost_metadata vh1 --description "QA env 1 for issue 37483"

   rabbitmqctl update_vhost_metadata vh1 --description "QQs all the way" --default-queue-type "quorum"

   rabbitmqctl update_vhost_metadata vh1 --description "streaming my brain out" --default-queue-type "stream"
   ```

   GitHub issue: [#7914](https://github.com/rabbitmq/rabbitmq-server/pull/7914)


### Management Plugin

#### Bug Fixes

 * It was impossible to return to a tab that had a filter expression
   that was not a valid regular expressions.

   Now such expressions will be used as regular text filters.

   GitHub issue: [#8008](https://github.com/rabbitmq/rabbitmq-server/issues/8008)


### OAuth 2 AuthN/AuthZ Backend Plugin

#### Enhancement

 * Several variables (`{username}`, `{vhost}` and JWT claims that are single string values)
   now can be used (expanded) in topic operation authorization.

   GitHub issue: [#7178](https://github.com/rabbitmq/rabbitmq-server/issues/7178)


### HTTPS AuthN/AuthZ Backend Plugin

#### Bug Fixes

 * The authorization backend could run into an exception when used in
   combination with other backends.

   GitHub issue: [#7864](https://github.com/rabbitmq/rabbitmq-server/issues/7864)


## Dependency Upgrades

 * [`cowlib`](https://github.com/ninenines/cowlib) was upgraded to `2.12.1`


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.14.tar.xz`
instead of the source tarball produced by GitHub.
