// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`SelectObjectContent`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_bucket):<br>required: **true**<br><p>The S3 bucket.</p><br>
    ///   - [`key(impl Into<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_key):<br>required: **true**<br><p>The object key.</p><br>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_sse_customer_algorithm):<br>required: **false**<br><p>The server-side encryption (SSE) algorithm used to encrypt the object. This parameter is needed only when the object was created using a checksum algorithm. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Protecting data using SSE-C keys</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_sse_customer_key):<br>required: **false**<br><p>The server-side encryption (SSE) customer managed key. This parameter is needed only when the object was created using a checksum algorithm. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Protecting data using SSE-C keys</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_sse_customer_key_md5):<br>required: **false**<br><p>The MD5 server-side encryption (SSE) customer managed key. This parameter is needed only when the object was created using a checksum algorithm. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Protecting data using SSE-C keys</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`expression(impl Into<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::expression) / [`set_expression(Option<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_expression):<br>required: **true**<br><p>The expression that is used to query the object.</p><br>
    ///   - [`expression_type(ExpressionType)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::expression_type) / [`set_expression_type(Option<ExpressionType>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_expression_type):<br>required: **true**<br><p>The type of the provided expression (for example, SQL).</p><br>
    ///   - [`request_progress(RequestProgress)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::request_progress) / [`set_request_progress(Option<RequestProgress>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_request_progress):<br>required: **false**<br><p>Specifies if periodic request progress information should be enabled.</p><br>
    ///   - [`input_serialization(InputSerialization)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::input_serialization) / [`set_input_serialization(Option<InputSerialization>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_input_serialization):<br>required: **true**<br><p>Describes the format of the data in the object that is being queried.</p><br>
    ///   - [`output_serialization(OutputSerialization)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::output_serialization) / [`set_output_serialization(Option<OutputSerialization>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_output_serialization):<br>required: **true**<br><p>Describes the format of the data that you want Amazon S3 to return in response.</p><br>
    ///   - [`scan_range(ScanRange)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::scan_range) / [`set_scan_range(Option<ScanRange>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_scan_range):<br>required: **false**<br><p>Specifies the byte range of the object to get the records from. A record is processed when its first byte is contained by the range. This parameter is optional, but when specified, it must not be empty. See RFC 2616, Section 14.35.1 about how to specify the start and end of the range.</p> <p><code>ScanRange</code>may be used in the following ways:</p> <ul>  <li>   <p><code><scanrange>      <start>       50      </start>      <end>       100      </end>     </scanrange></code> - process only the records starting between the bytes 50 and 100 (inclusive, counting from zero)</p></li>  <li>   <p><code><scanrange>      <start>       50      </start>     </scanrange></code> - process only the records starting after the byte 50</p></li>  <li>   <p><code><scanrange>      <end>       50      </end>     </scanrange></code> - process only the records within the last 50 bytes of the file.</p></li> </ul><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`SelectObjectContentOutput`](crate::operation::select_object_content::SelectObjectContentOutput) with field(s):
    ///   - [`payload(EventReceiver<SelectObjectContentEventStream, SelectObjectContentEventStreamError>)`](crate::operation::select_object_content::SelectObjectContentOutput::payload): <p>The array of results.</p>
    /// - On failure, responds with [`SdkError<SelectObjectContentError>`](crate::operation::select_object_content::SelectObjectContentError)
    pub fn select_object_content(&self) -> crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder {
        crate::operation::select_object_content::builders::SelectObjectContentFluentBuilder::new(self.handle.clone())
    }
}
