
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest C++ Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
#include <azure/core/base64.hpp>
#include <azure/core/context.hpp>
#include <azure/core/datetime.hpp>
#include <azure/core/etag.hpp>
#include <azure/core/http/http.hpp>
#include <azure/core/http/http_status_code.hpp>
#include <azure/core/internal/http/pipeline.hpp>
#include <azure/core/io/body_stream.hpp>
#include <azure/core/response.hpp>
#include <azure/core/url.hpp>
#include <azure/storage/blobs/rest_client.hpp>
#include <azure/storage/common/crypt.hpp>
#include <azure/storage/common/internal/xml_wrapper.hpp>
#include <azure/storage/common/storage_common.hpp>
#include <azure/storage/common/storage_exception.hpp>

#include <map>
#include <string>
#include <unordered_map>
#include <vector>

namespace {
std::string ListBlobContainersIncludeFlagsToString(
    const Azure::Storage::Blobs::Models::ListBlobContainersIncludeFlags& val)
{
  const Azure::Storage::Blobs::Models::ListBlobContainersIncludeFlags valueList[] = {
      Azure::Storage::Blobs::Models::ListBlobContainersIncludeFlags::Metadata,
      Azure::Storage::Blobs::Models::ListBlobContainersIncludeFlags::Deleted,
      Azure::Storage::Blobs::Models::ListBlobContainersIncludeFlags::System,
  };
  const char* stringList[] = {
      "metadata",
      "deleted",
      "system",
  };
  std::string ret;
  for (size_t i = 0; i < 3; ++i)
  {
    if ((val & valueList[i]) == valueList[i])
    {
      if (!ret.empty())
      {
        ret += ",";
      }
      ret += stringList[i];
    }
  }
  return ret;
}
std::string ListBlobsIncludeFlagsToString(
    const Azure::Storage::Blobs::Models::ListBlobsIncludeFlags& val)
{
  const Azure::Storage::Blobs::Models::ListBlobsIncludeFlags valueList[] = {
      Azure::Storage::Blobs::Models::ListBlobsIncludeFlags::Copy,
      Azure::Storage::Blobs::Models::ListBlobsIncludeFlags::Deleted,
      Azure::Storage::Blobs::Models::ListBlobsIncludeFlags::Metadata,
      Azure::Storage::Blobs::Models::ListBlobsIncludeFlags::Snapshots,
      Azure::Storage::Blobs::Models::ListBlobsIncludeFlags::UncomittedBlobs,
      Azure::Storage::Blobs::Models::ListBlobsIncludeFlags::Versions,
      Azure::Storage::Blobs::Models::ListBlobsIncludeFlags::Tags,
      Azure::Storage::Blobs::Models::ListBlobsIncludeFlags::ImmutabilityPolicy,
      Azure::Storage::Blobs::Models::ListBlobsIncludeFlags::LegalHold,
      Azure::Storage::Blobs::Models::ListBlobsIncludeFlags::DeletedWithVersions,
  };
  const char* stringList[] = {
      "copy",
      "deleted",
      "metadata",
      "snapshots",
      "uncommittedblobs",
      "versions",
      "tags",
      "immutabilitypolicy",
      "legalhold",
      "deletedwithversions",
  };
  std::string ret;
  for (size_t i = 0; i < 10; ++i)
  {
    if ((val & valueList[i]) == valueList[i])
    {
      if (!ret.empty())
      {
        ret += ",";
      }
      ret += stringList[i];
    }
  }
  return ret;
}
} // namespace
namespace Azure { namespace Storage { namespace Blobs {
  namespace Models {
    const EncryptionAlgorithmType EncryptionAlgorithmType::Aes256("AES256");
    const BlockType BlockType::Committed("Committed");
    const BlockType BlockType::Uncommitted("Uncommitted");
    const BlockType BlockType::Latest("Latest");
    const GeoReplicationStatus GeoReplicationStatus::Live("live");
    const GeoReplicationStatus GeoReplicationStatus::Bootstrap("bootstrap");
    const GeoReplicationStatus GeoReplicationStatus::Unavailable("unavailable");
    const LeaseStatus LeaseStatus::Locked("locked");
    const LeaseStatus LeaseStatus::Unlocked("unlocked");
    const LeaseState LeaseState::Available("available");
    const LeaseState LeaseState::Leased("leased");
    const LeaseState LeaseState::Expired("expired");
    const LeaseState LeaseState::Breaking("breaking");
    const LeaseState LeaseState::Broken("broken");
    const LeaseDurationType LeaseDurationType::Infinite("infinite");
    const LeaseDurationType LeaseDurationType::Fixed("fixed");
    const PublicAccessType PublicAccessType::BlobContainer("container");
    const PublicAccessType PublicAccessType::Blob("blob");
    const PublicAccessType PublicAccessType::None("");
    const SkuName SkuName::StandardLrs("Standard_LRS");
    const SkuName SkuName::StandardGrs("Standard_GRS");
    const SkuName SkuName::StandardRagrs("Standard_RAGRS");
    const SkuName SkuName::StandardZrs("Standard_ZRS");
    const SkuName SkuName::PremiumLrs("Premium_LRS");
    const SkuName SkuName::PremiumZrs("Premium_ZRS");
    const SkuName SkuName::StandardGzrs("Standard_GZRS");
    const SkuName SkuName::StandardRagzrs("Standard_RAGZRS");
    const AccountKind AccountKind::Storage("Storage");
    const AccountKind AccountKind::BlobStorage("BlobStorage");
    const AccountKind AccountKind::StorageV2("StorageV2");
    const AccountKind AccountKind::FileStorage("FileStorage");
    const AccountKind AccountKind::BlockBlobStorage("BlockBlobStorage");
    const CopyStatus CopyStatus::Pending("pending");
    const CopyStatus CopyStatus::Success("success");
    const CopyStatus CopyStatus::Aborted("aborted");
    const CopyStatus CopyStatus::Failed("failed");
    const AccessTier AccessTier::P1("p1");
    const AccessTier AccessTier::P2("p2");
    const AccessTier AccessTier::P3("p3");
    const AccessTier AccessTier::P4("p4");
    const AccessTier AccessTier::P6("p6");
    const AccessTier AccessTier::P10("p10");
    const AccessTier AccessTier::P15("p15");
    const AccessTier AccessTier::P20("p20");
    const AccessTier AccessTier::P30("p30");
    const AccessTier AccessTier::P40("p40");
    const AccessTier AccessTier::P50("p50");
    const AccessTier AccessTier::P60("p60");
    const AccessTier AccessTier::P70("p70");
    const AccessTier AccessTier::P80("p80");
    const AccessTier AccessTier::Hot("Hot");
    const AccessTier AccessTier::Cool("Cool");
    const AccessTier AccessTier::Archive("Archive");
    const AccessTier AccessTier::Premium("Premium");
    const AccessTier AccessTier::Cold("Cold");
    const ArchiveStatus ArchiveStatus::RehydratePendingToHot("rehydrate-pending-to-hot");
    const ArchiveStatus ArchiveStatus::RehydratePendingToCool("rehydrate-pending-to-cool");
    const ArchiveStatus ArchiveStatus::RehydratePendingToCold("rehydrate-pending-to-cold");
    const RehydratePriority RehydratePriority::High("High");
    const RehydratePriority RehydratePriority::Standard("Standard");
    const ObjectReplicationStatus ObjectReplicationStatus::Complete("complete");
    const ObjectReplicationStatus ObjectReplicationStatus::Failed("failed");
    const BlobImmutabilityPolicyMode BlobImmutabilityPolicyMode::Unlocked("unlocked");
    const BlobImmutabilityPolicyMode BlobImmutabilityPolicyMode::Locked("locked");
    const BlobType BlobType::BlockBlob("BlockBlob");
    const BlobType BlobType::PageBlob("PageBlob");
    const BlobType BlobType::AppendBlob("AppendBlob");
    const DeleteSnapshotsOption DeleteSnapshotsOption::IncludeSnapshots("include");
    const DeleteSnapshotsOption DeleteSnapshotsOption::OnlySnapshots("only");
    const ScheduleBlobExpiryOriginType ScheduleBlobExpiryOriginType::NeverExpire("NeverExpire");
    const ScheduleBlobExpiryOriginType ScheduleBlobExpiryOriginType::RelativeToCreation(
        "RelativeToCreation");
    const ScheduleBlobExpiryOriginType ScheduleBlobExpiryOriginType::RelativeToNow("RelativeToNow");
    const ScheduleBlobExpiryOriginType ScheduleBlobExpiryOriginType::Absolute("Absolute");
    const BlobCopySourceTagsMode BlobCopySourceTagsMode::Replace("REPLACE");
    const BlobCopySourceTagsMode BlobCopySourceTagsMode::Copy("COPY");
    const FileShareTokenIntent FileShareTokenIntent::Backup("backup");
    namespace _detail {
      const QueryRequestQueryType QueryRequestQueryType::SQL("SQL");
      const QueryFormatType QueryFormatType::Delimited("delimited");
      const QueryFormatType QueryFormatType::Json("json");
      const QueryFormatType QueryFormatType::Arrow("arrow");
      const QueryFormatType QueryFormatType::Parquet("parquet");
    } // namespace _detail
    const BlobQueryArrowFieldType BlobQueryArrowFieldType::Int64("int64");
    const BlobQueryArrowFieldType BlobQueryArrowFieldType::Bool("bool");
    const BlobQueryArrowFieldType BlobQueryArrowFieldType::Timestamp("timestamp[ms]");
    const BlobQueryArrowFieldType BlobQueryArrowFieldType::String("string");
    const BlobQueryArrowFieldType BlobQueryArrowFieldType::Double("double");
    const BlobQueryArrowFieldType BlobQueryArrowFieldType::Decimal("decimal");
    const SequenceNumberAction SequenceNumberAction::Max("max");
    const SequenceNumberAction SequenceNumberAction::Update("update");
    const SequenceNumberAction SequenceNumberAction::Increment("increment");
    const BlockListType BlockListType::Committed("committed");
    const BlockListType BlockListType::Uncommitted("uncommitted");
    const BlockListType BlockListType::All("all");
  } // namespace Models
  namespace _detail {
    Response<Models::SetServicePropertiesResult> ServiceClient::SetProperties(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const SetServicePropertiesOptions& options,
        const Core::Context& context)
    {
      std::string xmlBody;
      {
        _internal::XmlWriter writer;
        writer.Write(
            _internal::XmlNode{_internal::XmlNodeType::StartTag, "StorageServiceProperties"});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Logging"});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Version",
            options.BlobServiceProperties.Logging.Version});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Delete",
            options.BlobServiceProperties.Logging.Delete ? "true" : "false"});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Read",
            options.BlobServiceProperties.Logging.Read ? "true" : "false"});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Write",
            options.BlobServiceProperties.Logging.Write ? "true" : "false"});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "RetentionPolicy"});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Enabled",
            options.BlobServiceProperties.Logging.RetentionPolicy.IsEnabled ? "true" : "false"});
        if (options.BlobServiceProperties.Logging.RetentionPolicy.Days.HasValue())
        {
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "Days",
              std::to_string(options.BlobServiceProperties.Logging.RetentionPolicy.Days.Value())});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "HourMetrics"});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Version",
            options.BlobServiceProperties.HourMetrics.Version});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Enabled",
            options.BlobServiceProperties.HourMetrics.IsEnabled ? "true" : "false"});
        if (options.BlobServiceProperties.HourMetrics.IncludeApis.HasValue())
        {
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "IncludeAPIs",
              options.BlobServiceProperties.HourMetrics.IncludeApis.Value() ? "true" : "false"});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "RetentionPolicy"});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Enabled",
            options.BlobServiceProperties.HourMetrics.RetentionPolicy.IsEnabled ? "true"
                                                                                : "false"});
        if (options.BlobServiceProperties.HourMetrics.RetentionPolicy.Days.HasValue())
        {
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "Days",
              std::to_string(
                  options.BlobServiceProperties.HourMetrics.RetentionPolicy.Days.Value())});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "MinuteMetrics"});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Version",
            options.BlobServiceProperties.MinuteMetrics.Version});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Enabled",
            options.BlobServiceProperties.MinuteMetrics.IsEnabled ? "true" : "false"});
        if (options.BlobServiceProperties.MinuteMetrics.IncludeApis.HasValue())
        {
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "IncludeAPIs",
              options.BlobServiceProperties.MinuteMetrics.IncludeApis.Value() ? "true" : "false"});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "RetentionPolicy"});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Enabled",
            options.BlobServiceProperties.MinuteMetrics.RetentionPolicy.IsEnabled ? "true"
                                                                                  : "false"});
        if (options.BlobServiceProperties.MinuteMetrics.RetentionPolicy.Days.HasValue())
        {
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "Days",
              std::to_string(
                  options.BlobServiceProperties.MinuteMetrics.RetentionPolicy.Days.Value())});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Cors"});
        for (const auto& i1 : options.BlobServiceProperties.Cors)
        {
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "CorsRule"});
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag, "AllowedOrigins", i1.AllowedOrigins});
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag, "AllowedMethods", i1.AllowedMethods});
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag, "AllowedHeaders", i1.AllowedHeaders});
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag, "ExposedHeaders", i1.ExposedHeaders});
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "MaxAgeInSeconds",
              std::to_string(i1.MaxAgeInSeconds)});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        if (options.BlobServiceProperties.DefaultServiceVersion.HasValue())
        {
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "DefaultServiceVersion",
              options.BlobServiceProperties.DefaultServiceVersion.Value()});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "DeleteRetentionPolicy"});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Enabled",
            options.BlobServiceProperties.DeleteRetentionPolicy.IsEnabled ? "true" : "false"});
        if (options.BlobServiceProperties.DeleteRetentionPolicy.Days.HasValue())
        {
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "Days",
              std::to_string(options.BlobServiceProperties.DeleteRetentionPolicy.Days.Value())});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "StaticWebsite"});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "Enabled",
            options.BlobServiceProperties.StaticWebsite.IsEnabled ? "true" : "false"});
        if (options.BlobServiceProperties.StaticWebsite.IndexDocument.HasValue())
        {
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "IndexDocument",
              options.BlobServiceProperties.StaticWebsite.IndexDocument.Value()});
        }
        if (options.BlobServiceProperties.StaticWebsite.ErrorDocument404Path.HasValue())
        {
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "ErrorDocument404Path",
              options.BlobServiceProperties.StaticWebsite.ErrorDocument404Path.Value()});
        }
        if (options.BlobServiceProperties.StaticWebsite.DefaultIndexDocumentPath.HasValue())
        {
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "DefaultIndexDocumentPath",
              options.BlobServiceProperties.StaticWebsite.DefaultIndexDocumentPath.Value()});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::End});
        xmlBody = writer.GetDocument();
      }
      Core::IO::MemoryBodyStream requestBody(
          reinterpret_cast<const uint8_t*>(xmlBody.data()), xmlBody.length());
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url, &requestBody);
      request.SetHeader("Content-Type", "application/xml; charset=UTF-8");
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      request.GetUrl().AppendQueryParameter("restype", "service");
      request.GetUrl().AppendQueryParameter("comp", "properties");
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Accepted)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::SetServicePropertiesResult response;
      return Response<Models::SetServicePropertiesResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::BlobServiceProperties> ServiceClient::GetProperties(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetServicePropertiesOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("restype", "service");
      request.GetUrl().AppendQueryParameter("comp", "properties");
      request.SetHeader("x-ms-version", "2026-02-06");
      (void)options;
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::BlobServiceProperties response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kStorageServiceProperties,
          kLogging,
          kVersion,
          kDelete,
          kRead,
          kWrite,
          kRetentionPolicy,
          kEnabled,
          kDays,
          kHourMetrics,
          kIncludeAPIs,
          kMinuteMetrics,
          kCors,
          kCorsRule,
          kAllowedOrigins,
          kAllowedMethods,
          kAllowedHeaders,
          kExposedHeaders,
          kMaxAgeInSeconds,
          kDefaultServiceVersion,
          kDeleteRetentionPolicy,
          kStaticWebsite,
          kIndexDocument,
          kErrorDocument404Path,
          kDefaultIndexDocumentPath,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"StorageServiceProperties", XmlTagEnum::kStorageServiceProperties},
            {"Logging", XmlTagEnum::kLogging},
            {"Version", XmlTagEnum::kVersion},
            {"Delete", XmlTagEnum::kDelete},
            {"Read", XmlTagEnum::kRead},
            {"Write", XmlTagEnum::kWrite},
            {"RetentionPolicy", XmlTagEnum::kRetentionPolicy},
            {"Enabled", XmlTagEnum::kEnabled},
            {"Days", XmlTagEnum::kDays},
            {"HourMetrics", XmlTagEnum::kHourMetrics},
            {"IncludeAPIs", XmlTagEnum::kIncludeAPIs},
            {"MinuteMetrics", XmlTagEnum::kMinuteMetrics},
            {"Cors", XmlTagEnum::kCors},
            {"CorsRule", XmlTagEnum::kCorsRule},
            {"AllowedOrigins", XmlTagEnum::kAllowedOrigins},
            {"AllowedMethods", XmlTagEnum::kAllowedMethods},
            {"AllowedHeaders", XmlTagEnum::kAllowedHeaders},
            {"ExposedHeaders", XmlTagEnum::kExposedHeaders},
            {"MaxAgeInSeconds", XmlTagEnum::kMaxAgeInSeconds},
            {"DefaultServiceVersion", XmlTagEnum::kDefaultServiceVersion},
            {"DeleteRetentionPolicy", XmlTagEnum::kDeleteRetentionPolicy},
            {"StaticWebsite", XmlTagEnum::kStaticWebsite},
            {"IndexDocument", XmlTagEnum::kIndexDocument},
            {"ErrorDocument404Path", XmlTagEnum::kErrorDocument404Path},
            {"DefaultIndexDocumentPath", XmlTagEnum::kDefaultIndexDocumentPath},
        };
        std::vector<XmlTagEnum> xmlPath;
        Models::CorsRule vectorElement1;
        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kLogging && xmlPath[2] == XmlTagEnum::kVersion)
            {
              response.Logging.Version = node.Value;
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kLogging && xmlPath[2] == XmlTagEnum::kDelete)
            {
              response.Logging.Delete = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kLogging && xmlPath[2] == XmlTagEnum::kRead)
            {
              response.Logging.Read = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kLogging && xmlPath[2] == XmlTagEnum::kWrite)
            {
              response.Logging.Write = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kLogging && xmlPath[2] == XmlTagEnum::kRetentionPolicy
                && xmlPath[3] == XmlTagEnum::kEnabled)
            {
              response.Logging.RetentionPolicy.IsEnabled = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kLogging && xmlPath[2] == XmlTagEnum::kRetentionPolicy
                && xmlPath[3] == XmlTagEnum::kDays)
            {
              response.Logging.RetentionPolicy.Days = std::stoi(node.Value);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kHourMetrics && xmlPath[2] == XmlTagEnum::kVersion)
            {
              response.HourMetrics.Version = node.Value;
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kHourMetrics && xmlPath[2] == XmlTagEnum::kEnabled)
            {
              response.HourMetrics.IsEnabled = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kHourMetrics && xmlPath[2] == XmlTagEnum::kIncludeAPIs)
            {
              response.HourMetrics.IncludeApis = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kHourMetrics
                && xmlPath[2] == XmlTagEnum::kRetentionPolicy && xmlPath[3] == XmlTagEnum::kEnabled)
            {
              response.HourMetrics.RetentionPolicy.IsEnabled = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kHourMetrics
                && xmlPath[2] == XmlTagEnum::kRetentionPolicy && xmlPath[3] == XmlTagEnum::kDays)
            {
              response.HourMetrics.RetentionPolicy.Days = std::stoi(node.Value);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kMinuteMetrics && xmlPath[2] == XmlTagEnum::kVersion)
            {
              response.MinuteMetrics.Version = node.Value;
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kMinuteMetrics && xmlPath[2] == XmlTagEnum::kEnabled)
            {
              response.MinuteMetrics.IsEnabled = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kMinuteMetrics
                && xmlPath[2] == XmlTagEnum::kIncludeAPIs)
            {
              response.MinuteMetrics.IncludeApis = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kMinuteMetrics
                && xmlPath[2] == XmlTagEnum::kRetentionPolicy && xmlPath[3] == XmlTagEnum::kEnabled)
            {
              response.MinuteMetrics.RetentionPolicy.IsEnabled = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kMinuteMetrics
                && xmlPath[2] == XmlTagEnum::kRetentionPolicy && xmlPath[3] == XmlTagEnum::kDays)
            {
              response.MinuteMetrics.RetentionPolicy.Days = std::stoi(node.Value);
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kCors && xmlPath[2] == XmlTagEnum::kCorsRule
                && xmlPath[3] == XmlTagEnum::kAllowedOrigins)
            {
              vectorElement1.AllowedOrigins = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kCors && xmlPath[2] == XmlTagEnum::kCorsRule
                && xmlPath[3] == XmlTagEnum::kAllowedMethods)
            {
              vectorElement1.AllowedMethods = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kCors && xmlPath[2] == XmlTagEnum::kCorsRule
                && xmlPath[3] == XmlTagEnum::kAllowedHeaders)
            {
              vectorElement1.AllowedHeaders = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kCors && xmlPath[2] == XmlTagEnum::kCorsRule
                && xmlPath[3] == XmlTagEnum::kExposedHeaders)
            {
              vectorElement1.ExposedHeaders = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kCors && xmlPath[2] == XmlTagEnum::kCorsRule
                && xmlPath[3] == XmlTagEnum::kMaxAgeInSeconds)
            {
              vectorElement1.MaxAgeInSeconds = std::stoi(node.Value);
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kDefaultServiceVersion)
            {
              response.DefaultServiceVersion = node.Value;
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kDeleteRetentionPolicy
                && xmlPath[2] == XmlTagEnum::kEnabled)
            {
              response.DeleteRetentionPolicy.IsEnabled = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kDeleteRetentionPolicy
                && xmlPath[2] == XmlTagEnum::kDays)
            {
              response.DeleteRetentionPolicy.Days = std::stoi(node.Value);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kStaticWebsite && xmlPath[2] == XmlTagEnum::kEnabled)
            {
              response.StaticWebsite.IsEnabled = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kStaticWebsite
                && xmlPath[2] == XmlTagEnum::kIndexDocument)
            {
              response.StaticWebsite.IndexDocument = node.Value;
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kStaticWebsite
                && xmlPath[2] == XmlTagEnum::kErrorDocument404Path)
            {
              response.StaticWebsite.ErrorDocument404Path = node.Value;
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kStaticWebsite
                && xmlPath[2] == XmlTagEnum::kDefaultIndexDocumentPath)
            {
              response.StaticWebsite.DefaultIndexDocumentPath = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {
            if (xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceProperties
                && xmlPath[1] == XmlTagEnum::kCors && xmlPath[2] == XmlTagEnum::kCorsRule)
            {
              response.Cors.push_back(std::move(vectorElement1));
              vectorElement1 = Models::CorsRule();
            }
            xmlPath.pop_back();
          }
        }
      }
      return Response<Models::BlobServiceProperties>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::ServiceStatistics> ServiceClient::GetStatistics(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetServiceStatisticsOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("restype", "service");
      request.GetUrl().AppendQueryParameter("comp", "stats");
      request.SetHeader("x-ms-version", "2026-02-06");
      (void)options;
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::ServiceStatistics response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kStorageServiceStats,
          kGeoReplication,
          kStatus,
          kLastSyncTime,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"StorageServiceStats", XmlTagEnum::kStorageServiceStats},
            {"GeoReplication", XmlTagEnum::kGeoReplication},
            {"Status", XmlTagEnum::kStatus},
            {"LastSyncTime", XmlTagEnum::kLastSyncTime},
        };
        std::vector<XmlTagEnum> xmlPath;

        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceStats
                && xmlPath[1] == XmlTagEnum::kGeoReplication && xmlPath[2] == XmlTagEnum::kStatus)
            {
              response.GeoReplication.Status = Models::GeoReplicationStatus(node.Value);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kStorageServiceStats
                && xmlPath[1] == XmlTagEnum::kGeoReplication
                && xmlPath[2] == XmlTagEnum::kLastSyncTime)
            {
              response.GeoReplication.LastSyncedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {

            xmlPath.pop_back();
          }
        }
      }
      return Response<Models::ServiceStatistics>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::ListBlobContainersResult> ServiceClient::ListBlobContainers(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const ListServiceBlobContainersOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("comp", "list");
      if (options.Prefix.HasValue() && !options.Prefix.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "prefix", _internal::UrlEncodeQueryParameter(options.Prefix.Value()));
      }
      if (options.Marker.HasValue() && !options.Marker.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "marker", _internal::UrlEncodeQueryParameter(options.Marker.Value()));
      }
      if (options.MaxResults.HasValue())
      {
        request.GetUrl().AppendQueryParameter(
            "maxresults", std::to_string(options.MaxResults.Value()));
      }
      if (options.Include.HasValue()
          && !ListBlobContainersIncludeFlagsToString(options.Include.Value()).empty())
      {
        request.GetUrl().AppendQueryParameter(
            "include",
            _internal::UrlEncodeQueryParameter(
                ListBlobContainersIncludeFlagsToString(options.Include.Value())));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::ListBlobContainersResult response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kEnumerationResults,
          kPrefix,
          kNextMarker,
          kContainers,
          kContainer,
          kName,
          kDeleted,
          kVersion,
          kProperties,
          kLastModified,
          kEtag,
          kLeaseStatus,
          kLeaseState,
          kLeaseDuration,
          kPublicAccess,
          kHasImmutabilityPolicy,
          kHasLegalHold,
          kDefaultEncryptionScope,
          kDenyEncryptionScopeOverride,
          kDeletedTime,
          kRemainingRetentionDays,
          kImmutableStorageWithVersioningEnabled,
          kMetadata,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"EnumerationResults", XmlTagEnum::kEnumerationResults},
            {"Prefix", XmlTagEnum::kPrefix},
            {"NextMarker", XmlTagEnum::kNextMarker},
            {"Containers", XmlTagEnum::kContainers},
            {"Container", XmlTagEnum::kContainer},
            {"Name", XmlTagEnum::kName},
            {"Deleted", XmlTagEnum::kDeleted},
            {"Version", XmlTagEnum::kVersion},
            {"Properties", XmlTagEnum::kProperties},
            {"Last-Modified", XmlTagEnum::kLastModified},
            {"Etag", XmlTagEnum::kEtag},
            {"LeaseStatus", XmlTagEnum::kLeaseStatus},
            {"LeaseState", XmlTagEnum::kLeaseState},
            {"LeaseDuration", XmlTagEnum::kLeaseDuration},
            {"PublicAccess", XmlTagEnum::kPublicAccess},
            {"HasImmutabilityPolicy", XmlTagEnum::kHasImmutabilityPolicy},
            {"HasLegalHold", XmlTagEnum::kHasLegalHold},
            {"DefaultEncryptionScope", XmlTagEnum::kDefaultEncryptionScope},
            {"DenyEncryptionScopeOverride", XmlTagEnum::kDenyEncryptionScopeOverride},
            {"DeletedTime", XmlTagEnum::kDeletedTime},
            {"RemainingRetentionDays", XmlTagEnum::kRemainingRetentionDays},
            {"ImmutableStorageWithVersioningEnabled",
             XmlTagEnum::kImmutableStorageWithVersioningEnabled},
            {"Metadata", XmlTagEnum::kMetadata},
        };
        std::vector<XmlTagEnum> xmlPath;
        Models::BlobContainerItem vectorElement1;
        std::string mapKey2;
        std::string mapValue3;
        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
            if (xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kMetadata)
            {
              mapKey2 = node.Name;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kPrefix)
            {
              response.Prefix = node.Value;
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kNextMarker)
            {
              response.ContinuationToken = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kName)
            {
              vectorElement1.Name = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kDeleted)
            {
              vectorElement1.IsDeleted = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kVersion)
            {
              vectorElement1.VersionId = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kLastModified)
            {
              vectorElement1.Details.LastModified
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kEtag)
            {
              vectorElement1.Details.ETag = ETag(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kLeaseStatus)
            {
              vectorElement1.Details.LeaseStatus = Models::LeaseStatus(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kLeaseState)
            {
              vectorElement1.Details.LeaseState = Models::LeaseState(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kLeaseDuration)
            {
              vectorElement1.Details.LeaseDuration = Models::LeaseDurationType(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kPublicAccess)
            {
              vectorElement1.Details.AccessType = Models::PublicAccessType(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kHasImmutabilityPolicy)
            {
              vectorElement1.Details.HasImmutabilityPolicy = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kHasLegalHold)
            {
              vectorElement1.Details.HasLegalHold = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kDefaultEncryptionScope)
            {
              vectorElement1.Details.DefaultEncryptionScope = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kDenyEncryptionScopeOverride)
            {
              vectorElement1.Details.PreventEncryptionScopeOverride
                  = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kDeletedTime)
            {
              vectorElement1.Details.DeletedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kRemainingRetentionDays)
            {
              vectorElement1.Details.RemainingRetentionDays = std::stoi(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kImmutableStorageWithVersioningEnabled)
            {
              vectorElement1.Details.HasImmutableStorageWithVersioning
                  = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kMetadata)
            {
              mapValue3 = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
            if (xmlPath.size() == 1 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && node.Name == "ServiceEndpoint")
            {
              response.ServiceEndpoint = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {
            if (xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer
                && xmlPath[3] == XmlTagEnum::kMetadata)
            {
              vectorElement1.Details.Metadata[std::move(mapKey2)] = std::move(mapValue3);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kContainers && xmlPath[2] == XmlTagEnum::kContainer)
            {
              response.Items.push_back(std::move(vectorElement1));
              vectorElement1 = Models::BlobContainerItem();
            }
            xmlPath.pop_back();
          }
        }
      }
      return Response<Models::_detail::ListBlobContainersResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::UserDelegationKey> ServiceClient::GetUserDelegationKey(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetServiceUserDelegationKeyOptions& options,
        const Core::Context& context)
    {
      std::string xmlBody;
      {
        _internal::XmlWriter writer;
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "KeyInfo"});
        writer.Write(
            _internal::XmlNode{_internal::XmlNodeType::StartTag, "Start", options.KeyInfo.Start});
        writer.Write(
            _internal::XmlNode{_internal::XmlNodeType::StartTag, "Expiry", options.KeyInfo.Expiry});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::End});
        xmlBody = writer.GetDocument();
      }
      Core::IO::MemoryBodyStream requestBody(
          reinterpret_cast<const uint8_t*>(xmlBody.data()), xmlBody.length());
      auto request = Core::Http::Request(Core::Http::HttpMethod::Post, url, &requestBody);
      request.SetHeader("Content-Type", "application/xml; charset=UTF-8");
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      request.GetUrl().AppendQueryParameter("restype", "service");
      request.GetUrl().AppendQueryParameter("comp", "userdelegationkey");
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::UserDelegationKey response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kUserDelegationKey,
          kSignedOid,
          kSignedTid,
          kSignedStart,
          kSignedExpiry,
          kSignedService,
          kSignedVersion,
          kValue,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"UserDelegationKey", XmlTagEnum::kUserDelegationKey},
            {"SignedOid", XmlTagEnum::kSignedOid},
            {"SignedTid", XmlTagEnum::kSignedTid},
            {"SignedStart", XmlTagEnum::kSignedStart},
            {"SignedExpiry", XmlTagEnum::kSignedExpiry},
            {"SignedService", XmlTagEnum::kSignedService},
            {"SignedVersion", XmlTagEnum::kSignedVersion},
            {"Value", XmlTagEnum::kValue},
        };
        std::vector<XmlTagEnum> xmlPath;

        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kUserDelegationKey
                && xmlPath[1] == XmlTagEnum::kSignedOid)
            {
              response.SignedObjectId = node.Value;
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kUserDelegationKey
                && xmlPath[1] == XmlTagEnum::kSignedTid)
            {
              response.SignedTenantId = node.Value;
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kUserDelegationKey
                && xmlPath[1] == XmlTagEnum::kSignedStart)
            {
              response.SignedStartsOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc3339);
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kUserDelegationKey
                && xmlPath[1] == XmlTagEnum::kSignedExpiry)
            {
              response.SignedExpiresOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc3339);
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kUserDelegationKey
                && xmlPath[1] == XmlTagEnum::kSignedService)
            {
              response.SignedService = node.Value;
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kUserDelegationKey
                && xmlPath[1] == XmlTagEnum::kSignedVersion)
            {
              response.SignedVersion = node.Value;
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kUserDelegationKey
                && xmlPath[1] == XmlTagEnum::kValue)
            {
              response.Value = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {

            xmlPath.pop_back();
          }
        }
      }
      return Response<Models::UserDelegationKey>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::AccountInfo> ServiceClient::GetAccountInfo(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetServiceAccountInfoOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("restype", "account");
      request.GetUrl().AppendQueryParameter("comp", "properties");
      request.SetHeader("x-ms-version", "2026-02-06");
      (void)options;
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::AccountInfo response;
      response.SkuName = Models::SkuName(pRawResponse->GetHeaders().at("x-ms-sku-name"));
      response.AccountKind
          = Models::AccountKind(pRawResponse->GetHeaders().at("x-ms-account-kind"));
      response.IsHierarchicalNamespaceEnabled
          = pRawResponse->GetHeaders().at("x-ms-is-hns-enabled") == std::string("true");
      return Response<Models::AccountInfo>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::SubmitBatchResult> ServiceClient::SubmitBatch(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        Core::IO::BodyStream& requestBody,
        const SubmitServiceBatchOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Post, url, &requestBody, false);
      request.GetUrl().AppendQueryParameter("comp", "batch");
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      if (!options.MultipartContentType.empty())
      {
        request.SetHeader("Content-Type", options.MultipartContentType);
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Accepted)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::SubmitBatchResult response;
      response.BodyStream = pRawResponse->ExtractBodyStream();
      response.ContentType = pRawResponse->GetHeaders().at("Content-Type");
      return Response<Models::_detail::SubmitBatchResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::FindBlobsByTagsResult> ServiceClient::FindBlobsByTags(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const FindServiceBlobsByTagsOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("comp", "blobs");
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.Where.HasValue() && !options.Where.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "where", _internal::UrlEncodeQueryParameter(options.Where.Value()));
      }
      if (options.Marker.HasValue() && !options.Marker.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "marker", _internal::UrlEncodeQueryParameter(options.Marker.Value()));
      }
      if (options.MaxResults.HasValue())
      {
        request.GetUrl().AppendQueryParameter(
            "maxresults", std::to_string(options.MaxResults.Value()));
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::FindBlobsByTagsResult response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kEnumerationResults,
          kBlobs,
          kBlob,
          kName,
          kContainerName,
          kTags,
          kTagSet,
          kTag,
          kKey,
          kValue,
          kNextMarker,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"EnumerationResults", XmlTagEnum::kEnumerationResults},
            {"Blobs", XmlTagEnum::kBlobs},
            {"Blob", XmlTagEnum::kBlob},
            {"Name", XmlTagEnum::kName},
            {"ContainerName", XmlTagEnum::kContainerName},
            {"Tags", XmlTagEnum::kTags},
            {"TagSet", XmlTagEnum::kTagSet},
            {"Tag", XmlTagEnum::kTag},
            {"Key", XmlTagEnum::kKey},
            {"Value", XmlTagEnum::kValue},
            {"NextMarker", XmlTagEnum::kNextMarker},
        };
        std::vector<XmlTagEnum> xmlPath;
        Models::TaggedBlobItem vectorElement1;
        std::string mapKey2;
        std::string mapValue3;
        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kName)
            {
              vectorElement1.BlobName = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kContainerName)
            {
              vectorElement1.BlobContainerName = node.Value;
            }
            else if (
                xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kKey)
            {
              mapKey2 = node.Value;
            }
            else if (
                xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kValue)
            {
              mapValue3 = node.Value;
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kNextMarker)
            {
              response.ContinuationToken = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
            if (xmlPath.size() == 1 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && node.Name == "ServiceEndpoint")
            {
              response.ServiceEndpoint = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {
            if (xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kValue)
            {
              vectorElement1.Tags[std::move(mapKey2)] = std::move(mapValue3);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob)
            {
              response.Items.push_back(std::move(vectorElement1));
              vectorElement1 = Models::TaggedBlobItem();
            }
            xmlPath.pop_back();
          }
        }
      }
      return Response<Models::_detail::FindBlobsByTagsResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::CreateBlobContainerResult> BlobContainerClient::Create(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const CreateBlobContainerOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("restype", "container");
      for (const auto& p : options.Metadata)
      {
        request.SetHeader("x-ms-meta-" + p.first, p.second);
      }
      if (!options.Access.ToString().empty())
      {
        request.SetHeader("x-ms-blob-public-access", options.Access.ToString());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.DefaultEncryptionScope.HasValue()
          && !options.DefaultEncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-default-encryption-scope", options.DefaultEncryptionScope.Value());
      }
      if (options.PreventEncryptionScopeOverride.HasValue())
      {
        request.SetHeader(
            "x-ms-deny-encryption-scope-override",
            options.PreventEncryptionScopeOverride.Value() ? "true" : "false");
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::CreateBlobContainerResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      return Response<Models::CreateBlobContainerResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::BlobContainerProperties> BlobContainerClient::GetProperties(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetBlobContainerPropertiesOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("restype", "container");
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::BlobContainerProperties response;
      for (auto i = pRawResponse->GetHeaders().lower_bound("x-ms-meta-");
           i != pRawResponse->GetHeaders().end() && i->first.substr(0, 10) == "x-ms-meta-";
           ++i)
      {
        response.Metadata.emplace(i->first.substr(10), i->second);
      }
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      if (pRawResponse->GetHeaders().count("x-ms-lease-duration") != 0)
      {
        response.LeaseDuration
            = Models::LeaseDurationType(pRawResponse->GetHeaders().at("x-ms-lease-duration"));
      }
      response.LeaseState = Models::LeaseState(pRawResponse->GetHeaders().at("x-ms-lease-state"));
      response.LeaseStatus
          = Models::LeaseStatus(pRawResponse->GetHeaders().at("x-ms-lease-status"));
      if (pRawResponse->GetHeaders().count("x-ms-blob-public-access") != 0)
      {
        response.AccessType
            = Models::PublicAccessType(pRawResponse->GetHeaders().at("x-ms-blob-public-access"));
      }
      response.HasImmutabilityPolicy
          = pRawResponse->GetHeaders().at("x-ms-has-immutability-policy") == std::string("true");
      response.HasLegalHold
          = pRawResponse->GetHeaders().at("x-ms-has-legal-hold") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-default-encryption-scope") != 0)
      {
        response.DefaultEncryptionScope
            = pRawResponse->GetHeaders().at("x-ms-default-encryption-scope");
      }
      if (pRawResponse->GetHeaders().count("x-ms-deny-encryption-scope-override") != 0)
      {
        response.PreventEncryptionScopeOverride
            = pRawResponse->GetHeaders().at("x-ms-deny-encryption-scope-override")
            == std::string("true");
      }
      if (pRawResponse->GetHeaders().count("x-ms-immutable-storage-with-versioning-enabled") != 0)
      {
        response.HasImmutableStorageWithVersioning
            = pRawResponse->GetHeaders().at("x-ms-immutable-storage-with-versioning-enabled")
            == std::string("true");
      }
      return Response<Models::BlobContainerProperties>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::DeleteBlobContainerResult> BlobContainerClient::Delete(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const DeleteBlobContainerOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Delete, url);
      request.GetUrl().AppendQueryParameter("restype", "container");
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Accepted)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::DeleteBlobContainerResult response;
      return Response<Models::DeleteBlobContainerResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::SetBlobContainerMetadataResult> BlobContainerClient::SetMetadata(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const SetBlobContainerMetadataOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.GetUrl().AppendQueryParameter("comp", "metadata");
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      for (const auto& p : options.Metadata)
      {
        request.SetHeader("x-ms-meta-" + p.first, p.second);
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::SetBlobContainerMetadataResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      return Response<Models::SetBlobContainerMetadataResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::BlobContainerAccessPolicy> BlobContainerClient::GetAccessPolicy(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetBlobContainerAccessPolicyOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.GetUrl().AppendQueryParameter("comp", "acl");
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::BlobContainerAccessPolicy response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kSignedIdentifiers,
          kSignedIdentifier,
          kId,
          kAccessPolicy,
          kStart,
          kExpiry,
          kPermission,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"SignedIdentifiers", XmlTagEnum::kSignedIdentifiers},
            {"SignedIdentifier", XmlTagEnum::kSignedIdentifier},
            {"Id", XmlTagEnum::kId},
            {"AccessPolicy", XmlTagEnum::kAccessPolicy},
            {"Start", XmlTagEnum::kStart},
            {"Expiry", XmlTagEnum::kExpiry},
            {"Permission", XmlTagEnum::kPermission},
        };
        std::vector<XmlTagEnum> xmlPath;
        Models::SignedIdentifier vectorElement1;
        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kSignedIdentifiers
                && xmlPath[1] == XmlTagEnum::kSignedIdentifier && xmlPath[2] == XmlTagEnum::kId)
            {
              vectorElement1.Id = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kSignedIdentifiers
                && xmlPath[1] == XmlTagEnum::kSignedIdentifier
                && xmlPath[2] == XmlTagEnum::kAccessPolicy && xmlPath[3] == XmlTagEnum::kStart)
            {
              vectorElement1.StartsOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc3339);
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kSignedIdentifiers
                && xmlPath[1] == XmlTagEnum::kSignedIdentifier
                && xmlPath[2] == XmlTagEnum::kAccessPolicy && xmlPath[3] == XmlTagEnum::kExpiry)
            {
              vectorElement1.ExpiresOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc3339);
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kSignedIdentifiers
                && xmlPath[1] == XmlTagEnum::kSignedIdentifier
                && xmlPath[2] == XmlTagEnum::kAccessPolicy && xmlPath[3] == XmlTagEnum::kPermission)
            {
              vectorElement1.Permissions = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {
            if (xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kSignedIdentifiers
                && xmlPath[1] == XmlTagEnum::kSignedIdentifier)
            {
              response.SignedIdentifiers.push_back(std::move(vectorElement1));
              vectorElement1 = Models::SignedIdentifier();
            }
            xmlPath.pop_back();
          }
        }
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-public-access") != 0)
      {
        response.AccessType
            = Models::PublicAccessType(pRawResponse->GetHeaders().at("x-ms-blob-public-access"));
      }
      return Response<Models::BlobContainerAccessPolicy>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::SetBlobContainerAccessPolicyResult> BlobContainerClient::SetAccessPolicy(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const SetBlobContainerAccessPolicyOptions& options,
        const Core::Context& context)
    {
      std::string xmlBody;
      {
        _internal::XmlWriter writer;
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "SignedIdentifiers"});
        for (const auto& i1 : options.ContainerAcl)
        {
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "SignedIdentifier"});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Id", i1.Id});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "AccessPolicy"});
          if (i1.StartsOn.HasValue())
          {
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "Start",
                i1.StartsOn.Value().ToString(
                    Azure::DateTime::DateFormat::Rfc3339,
                    Azure::DateTime::TimeFractionFormat::AllDigits)});
          }
          if (i1.ExpiresOn.HasValue())
          {
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "Expiry",
                i1.ExpiresOn.Value().ToString(
                    Azure::DateTime::DateFormat::Rfc3339,
                    Azure::DateTime::TimeFractionFormat::AllDigits)});
          }
          writer.Write(
              _internal::XmlNode{_internal::XmlNodeType::StartTag, "Permission", i1.Permissions});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::End});
        xmlBody = writer.GetDocument();
      }
      Core::IO::MemoryBodyStream requestBody(
          reinterpret_cast<const uint8_t*>(xmlBody.data()), xmlBody.length());
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url, &requestBody);
      request.SetHeader("Content-Type", "application/xml; charset=UTF-8");
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.GetUrl().AppendQueryParameter("comp", "acl");
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (!options.Access.ToString().empty())
      {
        request.SetHeader("x-ms-blob-public-access", options.Access.ToString());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::SetBlobContainerAccessPolicyResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      return Response<Models::SetBlobContainerAccessPolicyResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::UndeleteBlobContainerResult> BlobContainerClient::Undelete(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const UndeleteBlobContainerOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.GetUrl().AppendQueryParameter("comp", "undelete");
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.DeletedContainerName.HasValue() && !options.DeletedContainerName.Value().empty())
      {
        request.SetHeader("x-ms-deleted-container-name", options.DeletedContainerName.Value());
      }
      if (options.DeletedContainerVersion.HasValue()
          && !options.DeletedContainerVersion.Value().empty())
      {
        request.SetHeader(
            "x-ms-deleted-container-version", options.DeletedContainerVersion.Value());
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::UndeleteBlobContainerResult response;
      return Response<Models::_detail::UndeleteBlobContainerResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::RenameBlobContainerResult> BlobContainerClient::Rename(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const RenameBlobContainerOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.GetUrl().AppendQueryParameter("comp", "rename");
      request.SetHeader("x-ms-version", "2026-02-06");
      if (!options.SourceContainerName.empty())
      {
        request.SetHeader("x-ms-source-container-name", options.SourceContainerName);
      }
      if (options.SourceLeaseId.HasValue() && !options.SourceLeaseId.Value().empty())
      {
        request.SetHeader("x-ms-source-lease-id", options.SourceLeaseId.Value());
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::RenameBlobContainerResult response;
      return Response<Models::_detail::RenameBlobContainerResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::SubmitBatchResult> BlobContainerClient::SubmitBatch(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        Core::IO::BodyStream& requestBody,
        const SubmitBlobContainerBatchOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Post, url, &requestBody, false);
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.GetUrl().AppendQueryParameter("comp", "batch");
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      if (!options.MultipartContentType.empty())
      {
        request.SetHeader("Content-Type", options.MultipartContentType);
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Accepted)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::SubmitBatchResult response;
      response.BodyStream = pRawResponse->ExtractBodyStream();
      response.ContentType = pRawResponse->GetHeaders().at("Content-Type");
      return Response<Models::_detail::SubmitBatchResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::FindBlobsByTagsResult> BlobContainerClient::FindBlobsByTags(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const FindBlobContainerBlobsByTagsOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.GetUrl().AppendQueryParameter("comp", "blobs");
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.Where.HasValue() && !options.Where.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "where", _internal::UrlEncodeQueryParameter(options.Where.Value()));
      }
      if (options.Marker.HasValue() && !options.Marker.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "marker", _internal::UrlEncodeQueryParameter(options.Marker.Value()));
      }
      if (options.MaxResults.HasValue())
      {
        request.GetUrl().AppendQueryParameter(
            "maxresults", std::to_string(options.MaxResults.Value()));
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::FindBlobsByTagsResult response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kEnumerationResults,
          kBlobs,
          kBlob,
          kName,
          kContainerName,
          kTags,
          kTagSet,
          kTag,
          kKey,
          kValue,
          kNextMarker,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"EnumerationResults", XmlTagEnum::kEnumerationResults},
            {"Blobs", XmlTagEnum::kBlobs},
            {"Blob", XmlTagEnum::kBlob},
            {"Name", XmlTagEnum::kName},
            {"ContainerName", XmlTagEnum::kContainerName},
            {"Tags", XmlTagEnum::kTags},
            {"TagSet", XmlTagEnum::kTagSet},
            {"Tag", XmlTagEnum::kTag},
            {"Key", XmlTagEnum::kKey},
            {"Value", XmlTagEnum::kValue},
            {"NextMarker", XmlTagEnum::kNextMarker},
        };
        std::vector<XmlTagEnum> xmlPath;
        Models::TaggedBlobItem vectorElement1;
        std::string mapKey2;
        std::string mapValue3;
        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kName)
            {
              vectorElement1.BlobName = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kContainerName)
            {
              vectorElement1.BlobContainerName = node.Value;
            }
            else if (
                xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kKey)
            {
              mapKey2 = node.Value;
            }
            else if (
                xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kValue)
            {
              mapValue3 = node.Value;
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kNextMarker)
            {
              response.ContinuationToken = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
            if (xmlPath.size() == 1 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && node.Name == "ServiceEndpoint")
            {
              response.ServiceEndpoint = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {
            if (xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kValue)
            {
              vectorElement1.Tags[std::move(mapKey2)] = std::move(mapValue3);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob)
            {
              response.Items.push_back(std::move(vectorElement1));
              vectorElement1 = Models::TaggedBlobItem();
            }
            xmlPath.pop_back();
          }
        }
      }
      return Response<Models::_detail::FindBlobsByTagsResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::AcquireBlobContainerLeaseResult> BlobContainerClient::AcquireLease(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const AcquireBlobContainerLeaseOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "lease");
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.SetHeader("x-ms-lease-action", "acquire");
      if (options.Duration.HasValue())
      {
        request.SetHeader("x-ms-lease-duration", std::to_string(options.Duration.Value()));
      }
      if (options.ProposedLeaseId.HasValue() && !options.ProposedLeaseId.Value().empty())
      {
        request.SetHeader("x-ms-proposed-lease-id", options.ProposedLeaseId.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::AcquireBlobContainerLeaseResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      response.LeaseId = pRawResponse->GetHeaders().at("x-ms-lease-id");
      return Response<Models::_detail::AcquireBlobContainerLeaseResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::ReleaseBlobContainerLeaseResult> BlobContainerClient::ReleaseLease(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const ReleaseBlobContainerLeaseOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "lease");
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.SetHeader("x-ms-lease-action", "release");
      if (!options.LeaseId.empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId);
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::ReleaseBlobContainerLeaseResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      return Response<Models::_detail::ReleaseBlobContainerLeaseResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::RenewBlobContainerLeaseResult> BlobContainerClient::RenewLease(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const RenewBlobContainerLeaseOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "lease");
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.SetHeader("x-ms-lease-action", "renew");
      if (!options.LeaseId.empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId);
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::RenewBlobContainerLeaseResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      response.LeaseId = pRawResponse->GetHeaders().at("x-ms-lease-id");
      return Response<Models::_detail::RenewBlobContainerLeaseResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::BreakBlobContainerLeaseResult> BlobContainerClient::BreakLease(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const BreakBlobContainerLeaseOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "lease");
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.SetHeader("x-ms-lease-action", "break");
      if (options.BreakPeriod.HasValue())
      {
        request.SetHeader("x-ms-lease-break-period", std::to_string(options.BreakPeriod.Value()));
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Accepted)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::BreakBlobContainerLeaseResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      response.LeaseTime = std::stoi(pRawResponse->GetHeaders().at("x-ms-lease-time"));
      return Response<Models::_detail::BreakBlobContainerLeaseResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::ChangeBlobContainerLeaseResult> BlobContainerClient::ChangeLease(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const ChangeBlobContainerLeaseOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "lease");
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.SetHeader("x-ms-lease-action", "change");
      if (!options.LeaseId.empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId);
      }
      if (!options.ProposedLeaseId.empty())
      {
        request.SetHeader("x-ms-proposed-lease-id", options.ProposedLeaseId);
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::ChangeBlobContainerLeaseResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      response.LeaseId = pRawResponse->GetHeaders().at("x-ms-lease-id");
      return Response<Models::_detail::ChangeBlobContainerLeaseResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::ListBlobsResult> BlobContainerClient::ListBlobs(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const ListBlobContainerBlobsOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.GetUrl().AppendQueryParameter("comp", "list");
      if (options.Prefix.HasValue() && !options.Prefix.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "prefix", _internal::UrlEncodeQueryParameter(options.Prefix.Value()));
      }
      if (options.Marker.HasValue() && !options.Marker.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "marker", _internal::UrlEncodeQueryParameter(options.Marker.Value()));
      }
      if (options.MaxResults.HasValue())
      {
        request.GetUrl().AppendQueryParameter(
            "maxresults", std::to_string(options.MaxResults.Value()));
      }
      if (options.Include.HasValue()
          && !ListBlobsIncludeFlagsToString(options.Include.Value()).empty())
      {
        request.GetUrl().AppendQueryParameter(
            "include",
            _internal::UrlEncodeQueryParameter(
                ListBlobsIncludeFlagsToString(options.Include.Value())));
      }
      if (options.StartFrom.HasValue() && !options.StartFrom.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "startFrom", _internal::UrlEncodeQueryParameter(options.StartFrom.Value()));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::ListBlobsResult response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kEnumerationResults,
          kPrefix,
          kNextMarker,
          kBlobs,
          kBlob,
          kName,
          kDeleted,
          kSnapshot,
          kVersionId,
          kIsCurrentVersion,
          kProperties,
          kCreationTime,
          kLastModified,
          kEtag,
          kXMsBlobSequenceNumber,
          kLeaseStatus,
          kLeaseState,
          kLeaseDuration,
          kCopyId,
          kCopyStatus,
          kCopySource,
          kCopyProgress,
          kCopyCompletionTime,
          kCopyStatusDescription,
          kServerEncrypted,
          kIncrementalCopy,
          kCopyDestinationSnapshot,
          kDeletedTime,
          kRemainingRetentionDays,
          kAccessTier,
          kAccessTierInferred,
          kArchiveStatus,
          kCustomerProvidedKeySha256,
          kEncryptionScope,
          kAccessTierChangeTime,
          kExpiryTime,
          kSealed,
          kRehydratePriority,
          kLastAccessTime,
          kLegalHold,
          kContentType,
          kContentEncoding,
          kContentLanguage,
          kContentMD5,
          kContentDisposition,
          kCacheControl,
          kMetadata,
          kTags,
          kTagSet,
          kTag,
          kKey,
          kValue,
          kOrMetadata,
          kImmutabilityPolicyUntilDate,
          kImmutabilityPolicyMode,
          kHasVersionsOnly,
          kContentLength,
          kBlobType,
          kDeletionId,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"EnumerationResults", XmlTagEnum::kEnumerationResults},
            {"Prefix", XmlTagEnum::kPrefix},
            {"NextMarker", XmlTagEnum::kNextMarker},
            {"Blobs", XmlTagEnum::kBlobs},
            {"Blob", XmlTagEnum::kBlob},
            {"Name", XmlTagEnum::kName},
            {"Deleted", XmlTagEnum::kDeleted},
            {"Snapshot", XmlTagEnum::kSnapshot},
            {"VersionId", XmlTagEnum::kVersionId},
            {"IsCurrentVersion", XmlTagEnum::kIsCurrentVersion},
            {"Properties", XmlTagEnum::kProperties},
            {"Creation-Time", XmlTagEnum::kCreationTime},
            {"Last-Modified", XmlTagEnum::kLastModified},
            {"Etag", XmlTagEnum::kEtag},
            {"x-ms-blob-sequence-number", XmlTagEnum::kXMsBlobSequenceNumber},
            {"LeaseStatus", XmlTagEnum::kLeaseStatus},
            {"LeaseState", XmlTagEnum::kLeaseState},
            {"LeaseDuration", XmlTagEnum::kLeaseDuration},
            {"CopyId", XmlTagEnum::kCopyId},
            {"CopyStatus", XmlTagEnum::kCopyStatus},
            {"CopySource", XmlTagEnum::kCopySource},
            {"CopyProgress", XmlTagEnum::kCopyProgress},
            {"CopyCompletionTime", XmlTagEnum::kCopyCompletionTime},
            {"CopyStatusDescription", XmlTagEnum::kCopyStatusDescription},
            {"ServerEncrypted", XmlTagEnum::kServerEncrypted},
            {"IncrementalCopy", XmlTagEnum::kIncrementalCopy},
            {"CopyDestinationSnapshot", XmlTagEnum::kCopyDestinationSnapshot},
            {"DeletedTime", XmlTagEnum::kDeletedTime},
            {"RemainingRetentionDays", XmlTagEnum::kRemainingRetentionDays},
            {"AccessTier", XmlTagEnum::kAccessTier},
            {"AccessTierInferred", XmlTagEnum::kAccessTierInferred},
            {"ArchiveStatus", XmlTagEnum::kArchiveStatus},
            {"CustomerProvidedKeySha256", XmlTagEnum::kCustomerProvidedKeySha256},
            {"EncryptionScope", XmlTagEnum::kEncryptionScope},
            {"AccessTierChangeTime", XmlTagEnum::kAccessTierChangeTime},
            {"Expiry-Time", XmlTagEnum::kExpiryTime},
            {"Sealed", XmlTagEnum::kSealed},
            {"RehydratePriority", XmlTagEnum::kRehydratePriority},
            {"LastAccessTime", XmlTagEnum::kLastAccessTime},
            {"LegalHold", XmlTagEnum::kLegalHold},
            {"Content-Type", XmlTagEnum::kContentType},
            {"Content-Encoding", XmlTagEnum::kContentEncoding},
            {"Content-Language", XmlTagEnum::kContentLanguage},
            {"Content-MD5", XmlTagEnum::kContentMD5},
            {"Content-Disposition", XmlTagEnum::kContentDisposition},
            {"Cache-Control", XmlTagEnum::kCacheControl},
            {"Metadata", XmlTagEnum::kMetadata},
            {"Tags", XmlTagEnum::kTags},
            {"TagSet", XmlTagEnum::kTagSet},
            {"Tag", XmlTagEnum::kTag},
            {"Key", XmlTagEnum::kKey},
            {"Value", XmlTagEnum::kValue},
            {"OrMetadata", XmlTagEnum::kOrMetadata},
            {"ImmutabilityPolicyUntilDate", XmlTagEnum::kImmutabilityPolicyUntilDate},
            {"ImmutabilityPolicyMode", XmlTagEnum::kImmutabilityPolicyMode},
            {"HasVersionsOnly", XmlTagEnum::kHasVersionsOnly},
            {"Content-Length", XmlTagEnum::kContentLength},
            {"BlobType", XmlTagEnum::kBlobType},
            {"DeletionId", XmlTagEnum::kDeletionId},
        };
        std::vector<XmlTagEnum> xmlPath;
        Models::_detail::BlobItem vectorElement1;
        std::string mapKey2;
        std::string mapValue3;
        std::string mapKey4;
        std::string mapValue5;
        Models::ObjectReplicationPolicy vectorElement6;
        Models::ObjectReplicationRule vectorElement7;
        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
            if (xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kMetadata)
            {
              mapKey2 = node.Name;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kOrMetadata)
            {
              vectorElement6.PolicyId = node.Name;
              vectorElement7.RuleId = node.Name;
            }
            else if (
                ((xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                  && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                  && xmlPath[3] == XmlTagEnum::kProperties
                  && xmlPath[4] == XmlTagEnum::kImmutabilityPolicyUntilDate)
                 || (xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                     && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                     && xmlPath[3] == XmlTagEnum::kProperties
                     && xmlPath[4] == XmlTagEnum::kImmutabilityPolicyMode))
                && !vectorElement1.Details.ImmutabilityPolicy.HasValue())
            {
              vectorElement1.Details.ImmutabilityPolicy = Models::BlobImmutabilityPolicy();
            }
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kPrefix)
            {
              response.Prefix = node.Value;
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kNextMarker)
            {
              response.ContinuationToken = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kName)
            {
              vectorElement1.Name.Content = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kDeleted)
            {
              vectorElement1.IsDeleted = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kSnapshot)
            {
              vectorElement1.Snapshot = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kVersionId)
            {
              vectorElement1.VersionId = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kIsCurrentVersion)
            {
              vectorElement1.IsCurrentVersion = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCreationTime)
            {
              vectorElement1.Details.CreatedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kLastModified)
            {
              vectorElement1.Details.LastModified
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kEtag)
            {
              vectorElement1.Details.ETag = ETag(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kXMsBlobSequenceNumber)
            {
              vectorElement1.Details.SequenceNumber = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kLeaseStatus)
            {
              vectorElement1.Details.LeaseStatus = Models::LeaseStatus(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kLeaseState)
            {
              vectorElement1.Details.LeaseState = Models::LeaseState(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kLeaseDuration)
            {
              vectorElement1.Details.LeaseDuration = Models::LeaseDurationType(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCopyId)
            {
              vectorElement1.Details.CopyId = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCopyStatus)
            {
              vectorElement1.Details.CopyStatus = Models::CopyStatus(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCopySource)
            {
              vectorElement1.Details.CopySource = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCopyProgress)
            {
              vectorElement1.Details.CopyProgress = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kCopyCompletionTime)
            {
              vectorElement1.Details.CopyCompletedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kCopyStatusDescription)
            {
              vectorElement1.Details.CopyStatusDescription = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kServerEncrypted)
            {
              vectorElement1.Details.IsServerEncrypted = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kIncrementalCopy)
            {
              vectorElement1.Details.IsIncrementalCopy = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kCopyDestinationSnapshot)
            {
              vectorElement1.Details.IncrementalCopyDestinationSnapshot = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kDeletedTime)
            {
              vectorElement1.Details.DeletedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kRemainingRetentionDays)
            {
              vectorElement1.Details.RemainingRetentionDays = std::stoi(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kAccessTier)
            {
              vectorElement1.Details.AccessTier = Models::AccessTier(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kAccessTierInferred)
            {
              vectorElement1.Details.IsAccessTierInferred = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kArchiveStatus)
            {
              vectorElement1.Details.ArchiveStatus = Models::ArchiveStatus(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kCustomerProvidedKeySha256)
            {
              vectorElement1.Details.EncryptionKeySha256 = Core::Convert::Base64Decode(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kEncryptionScope)
            {
              vectorElement1.Details.EncryptionScope = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kAccessTierChangeTime)
            {
              vectorElement1.Details.AccessTierChangedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kExpiryTime)
            {
              vectorElement1.Details.ExpiresOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kSealed)
            {
              vectorElement1.Details.IsSealed = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kRehydratePriority)
            {
              vectorElement1.Details.RehydratePriority = Models::RehydratePriority(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kLastAccessTime)
            {
              vectorElement1.Details.LastAccessedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kLegalHold)
            {
              vectorElement1.Details.HasLegalHold = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kContentType)
            {
              vectorElement1.Details.HttpHeaders.ContentType = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kContentEncoding)
            {
              vectorElement1.Details.HttpHeaders.ContentEncoding = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kContentLanguage)
            {
              vectorElement1.Details.HttpHeaders.ContentLanguage = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kContentMD5)
            {
              vectorElement1.Details.HttpHeaders.ContentHash.Value
                  = Core::Convert::Base64Decode(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kContentDisposition)
            {
              vectorElement1.Details.HttpHeaders.ContentDisposition = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCacheControl)
            {
              vectorElement1.Details.HttpHeaders.CacheControl = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kMetadata)
            {
              mapValue3 = node.Value;
            }
            else if (
                xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kKey)
            {
              mapKey4 = node.Value;
            }
            else if (
                xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kValue)
            {
              mapValue5 = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kOrMetadata)
            {
              vectorElement7.ReplicationStatus = Models::ObjectReplicationStatus(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kImmutabilityPolicyUntilDate)
            {
              vectorElement1.Details.ImmutabilityPolicy.Value().ExpiresOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kImmutabilityPolicyMode)
            {
              vectorElement1.Details.ImmutabilityPolicy.Value().PolicyMode
                  = Models::BlobImmutabilityPolicyMode(node.Value);
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kHasVersionsOnly)
            {
              vectorElement1.HasVersionsOnly = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kContentLength)
            {
              vectorElement1.BlobSize = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kBlobType)
            {
              vectorElement1.BlobType = Models::BlobType(node.Value);
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kDeletionId)
            {
              vectorElement1.DeletionId = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
            if (xmlPath.size() == 1 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && node.Name == "ServiceEndpoint")
            {
              response.ServiceEndpoint = node.Value;
            }
            else if (
                xmlPath.size() == 1 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && node.Name == "ContainerName")
            {
              response.BlobContainerName = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kName && node.Name == "Encoded")
            {
              vectorElement1.Name.Encoded = node.Value == std::string("true");
            }
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {
            if (xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kMetadata)
            {
              vectorElement1.Details.Metadata[std::move(mapKey2)] = std::move(mapValue3);
            }
            else if (
                xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kValue)
            {
              vectorElement1.Details.Tags[std::move(mapKey4)] = std::move(mapValue5);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kOrMetadata)
            {
              vectorElement6.Rules.push_back(std::move(vectorElement7));
              vectorElement7 = Models::ObjectReplicationRule();
              vectorElement1.Details.ObjectReplicationSourceProperties.push_back(
                  std::move(vectorElement6));
              vectorElement6 = Models::ObjectReplicationPolicy();
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob)
            {
              response.Items.push_back(std::move(vectorElement1));
              vectorElement1 = Models::_detail::BlobItem();
            }
            xmlPath.pop_back();
          }
        }
      }
      return Response<Models::_detail::ListBlobsResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::ListBlobsByHierarchyResult> BlobContainerClient::ListBlobsByHierarchy(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const ListBlobContainerBlobsByHierarchyOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("restype", "container");
      request.GetUrl().AppendQueryParameter("comp", "list");
      if (options.Prefix.HasValue() && !options.Prefix.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "prefix", _internal::UrlEncodeQueryParameter(options.Prefix.Value()));
      }
      if (!options.Delimiter.empty())
      {
        request.GetUrl().AppendQueryParameter(
            "delimiter", _internal::UrlEncodeQueryParameter(options.Delimiter));
      }
      if (options.Marker.HasValue() && !options.Marker.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "marker", _internal::UrlEncodeQueryParameter(options.Marker.Value()));
      }
      if (options.MaxResults.HasValue())
      {
        request.GetUrl().AppendQueryParameter(
            "maxresults", std::to_string(options.MaxResults.Value()));
      }
      if (options.Include.HasValue()
          && !ListBlobsIncludeFlagsToString(options.Include.Value()).empty())
      {
        request.GetUrl().AppendQueryParameter(
            "include",
            _internal::UrlEncodeQueryParameter(
                ListBlobsIncludeFlagsToString(options.Include.Value())));
      }
      if (options.StartFrom.HasValue() && !options.StartFrom.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "startFrom", _internal::UrlEncodeQueryParameter(options.StartFrom.Value()));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.ShowOnly.HasValue() && !options.ShowOnly.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "showonly", _internal::UrlEncodeQueryParameter(options.ShowOnly.Value()));
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::ListBlobsByHierarchyResult response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kEnumerationResults,
          kPrefix,
          kDelimiter,
          kNextMarker,
          kBlobs,
          kBlob,
          kName,
          kDeleted,
          kSnapshot,
          kVersionId,
          kIsCurrentVersion,
          kProperties,
          kCreationTime,
          kLastModified,
          kEtag,
          kXMsBlobSequenceNumber,
          kLeaseStatus,
          kLeaseState,
          kLeaseDuration,
          kCopyId,
          kCopyStatus,
          kCopySource,
          kCopyProgress,
          kCopyCompletionTime,
          kCopyStatusDescription,
          kServerEncrypted,
          kIncrementalCopy,
          kCopyDestinationSnapshot,
          kDeletedTime,
          kRemainingRetentionDays,
          kAccessTier,
          kAccessTierInferred,
          kArchiveStatus,
          kCustomerProvidedKeySha256,
          kEncryptionScope,
          kAccessTierChangeTime,
          kExpiryTime,
          kSealed,
          kRehydratePriority,
          kLastAccessTime,
          kLegalHold,
          kContentType,
          kContentEncoding,
          kContentLanguage,
          kContentMD5,
          kContentDisposition,
          kCacheControl,
          kMetadata,
          kTags,
          kTagSet,
          kTag,
          kKey,
          kValue,
          kOrMetadata,
          kImmutabilityPolicyUntilDate,
          kImmutabilityPolicyMode,
          kHasVersionsOnly,
          kContentLength,
          kBlobType,
          kDeletionId,
          kBlobPrefix,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"EnumerationResults", XmlTagEnum::kEnumerationResults},
            {"Prefix", XmlTagEnum::kPrefix},
            {"Delimiter", XmlTagEnum::kDelimiter},
            {"NextMarker", XmlTagEnum::kNextMarker},
            {"Blobs", XmlTagEnum::kBlobs},
            {"Blob", XmlTagEnum::kBlob},
            {"Name", XmlTagEnum::kName},
            {"Deleted", XmlTagEnum::kDeleted},
            {"Snapshot", XmlTagEnum::kSnapshot},
            {"VersionId", XmlTagEnum::kVersionId},
            {"IsCurrentVersion", XmlTagEnum::kIsCurrentVersion},
            {"Properties", XmlTagEnum::kProperties},
            {"Creation-Time", XmlTagEnum::kCreationTime},
            {"Last-Modified", XmlTagEnum::kLastModified},
            {"Etag", XmlTagEnum::kEtag},
            {"x-ms-blob-sequence-number", XmlTagEnum::kXMsBlobSequenceNumber},
            {"LeaseStatus", XmlTagEnum::kLeaseStatus},
            {"LeaseState", XmlTagEnum::kLeaseState},
            {"LeaseDuration", XmlTagEnum::kLeaseDuration},
            {"CopyId", XmlTagEnum::kCopyId},
            {"CopyStatus", XmlTagEnum::kCopyStatus},
            {"CopySource", XmlTagEnum::kCopySource},
            {"CopyProgress", XmlTagEnum::kCopyProgress},
            {"CopyCompletionTime", XmlTagEnum::kCopyCompletionTime},
            {"CopyStatusDescription", XmlTagEnum::kCopyStatusDescription},
            {"ServerEncrypted", XmlTagEnum::kServerEncrypted},
            {"IncrementalCopy", XmlTagEnum::kIncrementalCopy},
            {"CopyDestinationSnapshot", XmlTagEnum::kCopyDestinationSnapshot},
            {"DeletedTime", XmlTagEnum::kDeletedTime},
            {"RemainingRetentionDays", XmlTagEnum::kRemainingRetentionDays},
            {"AccessTier", XmlTagEnum::kAccessTier},
            {"AccessTierInferred", XmlTagEnum::kAccessTierInferred},
            {"ArchiveStatus", XmlTagEnum::kArchiveStatus},
            {"CustomerProvidedKeySha256", XmlTagEnum::kCustomerProvidedKeySha256},
            {"EncryptionScope", XmlTagEnum::kEncryptionScope},
            {"AccessTierChangeTime", XmlTagEnum::kAccessTierChangeTime},
            {"Expiry-Time", XmlTagEnum::kExpiryTime},
            {"Sealed", XmlTagEnum::kSealed},
            {"RehydratePriority", XmlTagEnum::kRehydratePriority},
            {"LastAccessTime", XmlTagEnum::kLastAccessTime},
            {"LegalHold", XmlTagEnum::kLegalHold},
            {"Content-Type", XmlTagEnum::kContentType},
            {"Content-Encoding", XmlTagEnum::kContentEncoding},
            {"Content-Language", XmlTagEnum::kContentLanguage},
            {"Content-MD5", XmlTagEnum::kContentMD5},
            {"Content-Disposition", XmlTagEnum::kContentDisposition},
            {"Cache-Control", XmlTagEnum::kCacheControl},
            {"Metadata", XmlTagEnum::kMetadata},
            {"Tags", XmlTagEnum::kTags},
            {"TagSet", XmlTagEnum::kTagSet},
            {"Tag", XmlTagEnum::kTag},
            {"Key", XmlTagEnum::kKey},
            {"Value", XmlTagEnum::kValue},
            {"OrMetadata", XmlTagEnum::kOrMetadata},
            {"ImmutabilityPolicyUntilDate", XmlTagEnum::kImmutabilityPolicyUntilDate},
            {"ImmutabilityPolicyMode", XmlTagEnum::kImmutabilityPolicyMode},
            {"HasVersionsOnly", XmlTagEnum::kHasVersionsOnly},
            {"Content-Length", XmlTagEnum::kContentLength},
            {"BlobType", XmlTagEnum::kBlobType},
            {"DeletionId", XmlTagEnum::kDeletionId},
            {"BlobPrefix", XmlTagEnum::kBlobPrefix},
        };
        std::vector<XmlTagEnum> xmlPath;
        Models::_detail::BlobItem vectorElement1;
        std::string mapKey2;
        std::string mapValue3;
        std::string mapKey4;
        std::string mapValue5;
        Models::ObjectReplicationPolicy vectorElement6;
        Models::ObjectReplicationRule vectorElement7;
        Models::_detail::BlobName vectorElement8;
        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
            if (xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kMetadata)
            {
              mapKey2 = node.Name;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kOrMetadata)
            {
              vectorElement6.PolicyId = node.Name;
              vectorElement7.RuleId = node.Name;
            }
            else if (
                ((xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                  && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                  && xmlPath[3] == XmlTagEnum::kProperties
                  && xmlPath[4] == XmlTagEnum::kImmutabilityPolicyUntilDate)
                 || (xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                     && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                     && xmlPath[3] == XmlTagEnum::kProperties
                     && xmlPath[4] == XmlTagEnum::kImmutabilityPolicyMode))
                && !vectorElement1.Details.ImmutabilityPolicy.HasValue())
            {
              vectorElement1.Details.ImmutabilityPolicy = Models::BlobImmutabilityPolicy();
            }
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kPrefix)
            {
              response.Prefix = node.Value;
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kDelimiter)
            {
              response.Delimiter = node.Value;
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kNextMarker)
            {
              response.ContinuationToken = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kName)
            {
              vectorElement1.Name.Content = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kDeleted)
            {
              vectorElement1.IsDeleted = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kSnapshot)
            {
              vectorElement1.Snapshot = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kVersionId)
            {
              vectorElement1.VersionId = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kIsCurrentVersion)
            {
              vectorElement1.IsCurrentVersion = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCreationTime)
            {
              vectorElement1.Details.CreatedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kLastModified)
            {
              vectorElement1.Details.LastModified
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kEtag)
            {
              vectorElement1.Details.ETag = ETag(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kXMsBlobSequenceNumber)
            {
              vectorElement1.Details.SequenceNumber = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kLeaseStatus)
            {
              vectorElement1.Details.LeaseStatus = Models::LeaseStatus(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kLeaseState)
            {
              vectorElement1.Details.LeaseState = Models::LeaseState(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kLeaseDuration)
            {
              vectorElement1.Details.LeaseDuration = Models::LeaseDurationType(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCopyId)
            {
              vectorElement1.Details.CopyId = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCopyStatus)
            {
              vectorElement1.Details.CopyStatus = Models::CopyStatus(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCopySource)
            {
              vectorElement1.Details.CopySource = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCopyProgress)
            {
              vectorElement1.Details.CopyProgress = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kCopyCompletionTime)
            {
              vectorElement1.Details.CopyCompletedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kCopyStatusDescription)
            {
              vectorElement1.Details.CopyStatusDescription = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kServerEncrypted)
            {
              vectorElement1.Details.IsServerEncrypted = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kIncrementalCopy)
            {
              vectorElement1.Details.IsIncrementalCopy = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kCopyDestinationSnapshot)
            {
              vectorElement1.Details.IncrementalCopyDestinationSnapshot = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kDeletedTime)
            {
              vectorElement1.Details.DeletedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kRemainingRetentionDays)
            {
              vectorElement1.Details.RemainingRetentionDays = std::stoi(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kAccessTier)
            {
              vectorElement1.Details.AccessTier = Models::AccessTier(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kAccessTierInferred)
            {
              vectorElement1.Details.IsAccessTierInferred = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kArchiveStatus)
            {
              vectorElement1.Details.ArchiveStatus = Models::ArchiveStatus(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kCustomerProvidedKeySha256)
            {
              vectorElement1.Details.EncryptionKeySha256 = Core::Convert::Base64Decode(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kEncryptionScope)
            {
              vectorElement1.Details.EncryptionScope = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kAccessTierChangeTime)
            {
              vectorElement1.Details.AccessTierChangedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kExpiryTime)
            {
              vectorElement1.Details.ExpiresOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kSealed)
            {
              vectorElement1.Details.IsSealed = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kRehydratePriority)
            {
              vectorElement1.Details.RehydratePriority = Models::RehydratePriority(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kLastAccessTime)
            {
              vectorElement1.Details.LastAccessedOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kLegalHold)
            {
              vectorElement1.Details.HasLegalHold = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kContentType)
            {
              vectorElement1.Details.HttpHeaders.ContentType = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kContentEncoding)
            {
              vectorElement1.Details.HttpHeaders.ContentEncoding = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kContentLanguage)
            {
              vectorElement1.Details.HttpHeaders.ContentLanguage = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kContentMD5)
            {
              vectorElement1.Details.HttpHeaders.ContentHash.Value
                  = Core::Convert::Base64Decode(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kContentDisposition)
            {
              vectorElement1.Details.HttpHeaders.ContentDisposition = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kCacheControl)
            {
              vectorElement1.Details.HttpHeaders.CacheControl = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kMetadata)
            {
              mapValue3 = node.Value;
            }
            else if (
                xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kKey)
            {
              mapKey4 = node.Value;
            }
            else if (
                xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kValue)
            {
              mapValue5 = node.Value;
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kOrMetadata)
            {
              vectorElement7.ReplicationStatus = Models::ObjectReplicationStatus(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kImmutabilityPolicyUntilDate)
            {
              vectorElement1.Details.ImmutabilityPolicy.Value().ExpiresOn
                  = DateTime::Parse(node.Value, Azure::DateTime::DateFormat::Rfc1123);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kImmutabilityPolicyMode)
            {
              vectorElement1.Details.ImmutabilityPolicy.Value().PolicyMode
                  = Models::BlobImmutabilityPolicyMode(node.Value);
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kHasVersionsOnly)
            {
              vectorElement1.HasVersionsOnly = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties
                && xmlPath[4] == XmlTagEnum::kContentLength)
            {
              vectorElement1.BlobSize = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kProperties && xmlPath[4] == XmlTagEnum::kBlobType)
            {
              vectorElement1.BlobType = Models::BlobType(node.Value);
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kDeletionId)
            {
              vectorElement1.DeletionId = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlobPrefix
                && xmlPath[3] == XmlTagEnum::kName)
            {
              vectorElement8.Content = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
            if (xmlPath.size() == 1 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && node.Name == "ServiceEndpoint")
            {
              response.ServiceEndpoint = node.Value;
            }
            else if (
                xmlPath.size() == 1 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && node.Name == "ContainerName")
            {
              response.BlobContainerName = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kName && node.Name == "Encoded")
            {
              vectorElement1.Name.Encoded = node.Value == std::string("true");
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlobPrefix
                && xmlPath[3] == XmlTagEnum::kName && node.Name == "Encoded")
            {
              vectorElement8.Encoded = node.Value == std::string("true");
            }
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {
            if (xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kMetadata)
            {
              vectorElement1.Details.Metadata[std::move(mapKey2)] = std::move(mapValue3);
            }
            else if (
                xmlPath.size() == 7 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kTags && xmlPath[4] == XmlTagEnum::kTagSet
                && xmlPath[5] == XmlTagEnum::kTag && xmlPath[6] == XmlTagEnum::kValue)
            {
              vectorElement1.Details.Tags[std::move(mapKey4)] = std::move(mapValue5);
            }
            else if (
                xmlPath.size() == 5 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob
                && xmlPath[3] == XmlTagEnum::kOrMetadata)
            {
              vectorElement6.Rules.push_back(std::move(vectorElement7));
              vectorElement7 = Models::ObjectReplicationRule();
              vectorElement1.Details.ObjectReplicationSourceProperties.push_back(
                  std::move(vectorElement6));
              vectorElement6 = Models::ObjectReplicationPolicy();
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlob)
            {
              response.Items.push_back(std::move(vectorElement1));
              vectorElement1 = Models::_detail::BlobItem();
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kEnumerationResults
                && xmlPath[1] == XmlTagEnum::kBlobs && xmlPath[2] == XmlTagEnum::kBlobPrefix
                && xmlPath[3] == XmlTagEnum::kName)
            {
              response.BlobPrefixes.push_back(std::move(vectorElement8));
              vectorElement8 = Models::_detail::BlobName();
            }
            xmlPath.pop_back();
          }
        }
      }
      return Response<Models::_detail::ListBlobsByHierarchyResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::AccountInfo> BlobContainerClient::GetAccountInfo(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetBlobContainerAccountInfoOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("restype", "account");
      request.GetUrl().AppendQueryParameter("comp", "properties");
      request.SetHeader("x-ms-version", "2026-02-06");
      (void)options;
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::AccountInfo response;
      response.SkuName = Models::SkuName(pRawResponse->GetHeaders().at("x-ms-sku-name"));
      response.AccountKind
          = Models::AccountKind(pRawResponse->GetHeaders().at("x-ms-account-kind"));
      response.IsHierarchicalNamespaceEnabled
          = pRawResponse->GetHeaders().at("x-ms-is-hns-enabled") == std::string("true");
      return Response<Models::AccountInfo>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::DownloadBlobResult> BlobClient::Download(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const DownloadBlobOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url, false);
      if (options.Snapshot.HasValue() && !options.Snapshot.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "snapshot", _internal::UrlEncodeQueryParameter(options.Snapshot.Value()));
      }
      if (options.VersionId.HasValue() && !options.VersionId.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "versionid", _internal::UrlEncodeQueryParameter(options.VersionId.Value()));
      }
      if (options.Range.HasValue() && !options.Range.Value().empty())
      {
        request.SetHeader("x-ms-range", options.Range.Value());
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.RangeGetContentMD5.HasValue())
      {
        request.SetHeader(
            "x-ms-range-get-content-md5", options.RangeGetContentMD5.Value() ? "true" : "false");
      }
      if (options.RangeGetContentCRC64.HasValue())
      {
        request.SetHeader(
            "x-ms-range-get-content-crc64",
            options.RangeGetContentCRC64.Value() ? "true" : "false");
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.UserPrincipalName.HasValue())
      {
        request.SetHeader("x-ms-upn", options.UserPrincipalName.Value() ? "true" : "false");
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (!(httpStatusCode == Core::Http::HttpStatusCode::Ok
            || httpStatusCode == Core::Http::HttpStatusCode::PartialContent))
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::DownloadBlobResult response;
      response.BodyStream = pRawResponse->ExtractBodyStream();
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.Details.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      response.Details.CreatedOn = DateTime::Parse(
          pRawResponse->GetHeaders().at("x-ms-creation-time"),
          Azure::DateTime::DateFormat::Rfc1123);
      for (auto i = pRawResponse->GetHeaders().lower_bound("x-ms-meta-");
           i != pRawResponse->GetHeaders().end() && i->first.substr(0, 10) == "x-ms-meta-";
           ++i)
      {
        response.Details.Metadata.emplace(i->first.substr(10), i->second);
      }
      if (pRawResponse->GetHeaders().count("x-ms-or-policy-id") != 0)
      {
        response.Details.ObjectReplicationDestinationPolicyId
            = pRawResponse->GetHeaders().at("x-ms-or-policy-id");
      }
      if (pRawResponse->GetHeaders().count("Content-Type") != 0)
      {
        response.Details.HttpHeaders.ContentType = pRawResponse->GetHeaders().at("Content-Type");
      }
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.Details.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Content-Encoding") != 0)
      {
        response.Details.HttpHeaders.ContentEncoding
            = pRawResponse->GetHeaders().at("Content-Encoding");
      }
      if (pRawResponse->GetHeaders().count("Cache-Control") != 0)
      {
        response.Details.HttpHeaders.CacheControl = pRawResponse->GetHeaders().at("Cache-Control");
      }
      if (pRawResponse->GetHeaders().count("Content-Disposition") != 0)
      {
        response.Details.HttpHeaders.ContentDisposition
            = pRawResponse->GetHeaders().at("Content-Disposition");
      }
      if (pRawResponse->GetHeaders().count("Content-Language") != 0)
      {
        response.Details.HttpHeaders.ContentLanguage
            = pRawResponse->GetHeaders().at("Content-Language");
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-sequence-number") != 0)
      {
        response.Details.SequenceNumber
            = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-sequence-number"));
      }
      response.BlobType = Models::BlobType(pRawResponse->GetHeaders().at("x-ms-blob-type"));
      if (pRawResponse->GetHeaders().count("x-ms-copy-completion-time") != 0)
      {
        response.Details.CopyCompletedOn = DateTime::Parse(
            pRawResponse->GetHeaders().at("x-ms-copy-completion-time"),
            Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-copy-status-description") != 0)
      {
        response.Details.CopyStatusDescription
            = pRawResponse->GetHeaders().at("x-ms-copy-status-description");
      }
      if (pRawResponse->GetHeaders().count("x-ms-copy-id") != 0)
      {
        response.Details.CopyId = pRawResponse->GetHeaders().at("x-ms-copy-id");
      }
      if (pRawResponse->GetHeaders().count("x-ms-copy-progress") != 0)
      {
        response.Details.CopyProgress = pRawResponse->GetHeaders().at("x-ms-copy-progress");
      }
      if (pRawResponse->GetHeaders().count("x-ms-copy-source") != 0)
      {
        response.Details.CopySource = pRawResponse->GetHeaders().at("x-ms-copy-source");
      }
      if (pRawResponse->GetHeaders().count("x-ms-copy-status") != 0)
      {
        response.Details.CopyStatus
            = Models::CopyStatus(pRawResponse->GetHeaders().at("x-ms-copy-status"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-lease-duration") != 0)
      {
        response.Details.LeaseDuration
            = Models::LeaseDurationType(pRawResponse->GetHeaders().at("x-ms-lease-duration"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-lease-state") != 0)
      {
        response.Details.LeaseState
            = Models::LeaseState(pRawResponse->GetHeaders().at("x-ms-lease-state"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-lease-status") != 0)
      {
        response.Details.LeaseStatus
            = Models::LeaseStatus(pRawResponse->GetHeaders().at("x-ms-lease-status"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.Details.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      if (pRawResponse->GetHeaders().count("x-ms-is-current-version") != 0)
      {
        response.Details.IsCurrentVersion
            = pRawResponse->GetHeaders().at("x-ms-is-current-version") == std::string("true");
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-committed-block-count") != 0)
      {
        response.Details.CommittedBlockCount
            = std::stoi(pRawResponse->GetHeaders().at("x-ms-blob-committed-block-count"));
      }
      response.Details.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.Details.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.Details.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      if (pRawResponse->GetHeaders().count("x-ms-tag-count") != 0)
      {
        response.Details.TagCount = std::stoi(pRawResponse->GetHeaders().at("x-ms-tag-count"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-sealed") != 0)
      {
        response.Details.IsSealed
            = pRawResponse->GetHeaders().at("x-ms-blob-sealed") == std::string("true");
      }
      if (pRawResponse->GetHeaders().count("x-ms-last-access-time") != 0)
      {
        response.Details.LastAccessedOn = DateTime::Parse(
            pRawResponse->GetHeaders().at("x-ms-last-access-time"),
            Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-immutability-policy-until-date") != 0)
      {
        if (!response.Details.ImmutabilityPolicy.HasValue())
        {
          response.Details.ImmutabilityPolicy = Models::BlobImmutabilityPolicy();
        }
        response.Details.ImmutabilityPolicy.Value().ExpiresOn = DateTime::Parse(
            pRawResponse->GetHeaders().at("x-ms-immutability-policy-until-date"),
            Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-immutability-policy-mode") != 0)
      {
        if (!response.Details.ImmutabilityPolicy.HasValue())
        {
          response.Details.ImmutabilityPolicy = Models::BlobImmutabilityPolicy();
        }
        response.Details.ImmutabilityPolicy.Value().PolicyMode = Models::BlobImmutabilityPolicyMode(
            pRawResponse->GetHeaders().at("x-ms-immutability-policy-mode"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-legal-hold") != 0)
      {
        response.Details.HasLegalHold
            = pRawResponse->GetHeaders().at("x-ms-legal-hold") == std::string("true");
      }
      if (httpStatusCode == Core::Http::HttpStatusCode::Ok)
      {
        if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
        {
          response.Details.HttpHeaders.ContentHash.Value
              = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
          response.Details.HttpHeaders.ContentHash.Algorithm = HashAlgorithm::Md5;
        }
      }
      if (httpStatusCode == Core::Http::HttpStatusCode::Ok)
      {
        if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
        {
          response.TransactionalContentHash = ContentHash();
          response.TransactionalContentHash.Value().Value
              = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
          response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
        }
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-content-md5") != 0)
      {
        response.Details.HttpHeaders.ContentHash.Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-blob-content-md5"));
        response.Details.HttpHeaders.ContentHash.Algorithm = HashAlgorithm::Md5;
      }
      if (httpStatusCode == Core::Http::HttpStatusCode::PartialContent)
      {
        if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
        {
          response.TransactionalContentHash = ContentHash();
          response.TransactionalContentHash.Value().Value
              = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
          response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
        }
      }
      if (httpStatusCode == Core::Http::HttpStatusCode::PartialContent)
      {
        if (pRawResponse->GetHeaders().count("x-ms-content-crc64") != 0)
        {
          response.TransactionalContentHash = ContentHash();
          response.TransactionalContentHash.Value().Value
              = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-content-crc64"));
          response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Crc64;
        }
      }
      return Response<Models::DownloadBlobResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::BlobProperties> BlobClient::GetProperties(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetBlobPropertiesOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Head, url);
      if (options.Snapshot.HasValue() && !options.Snapshot.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "snapshot", _internal::UrlEncodeQueryParameter(options.Snapshot.Value()));
      }
      if (options.VersionId.HasValue() && !options.VersionId.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "versionid", _internal::UrlEncodeQueryParameter(options.VersionId.Value()));
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.UserPrincipalName.HasValue())
      {
        request.SetHeader("x-ms-upn", options.UserPrincipalName.Value() ? "true" : "false");
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::BlobProperties response;
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      response.CreatedOn = DateTime::Parse(
          pRawResponse->GetHeaders().at("x-ms-creation-time"),
          Azure::DateTime::DateFormat::Rfc1123);
      for (auto i = pRawResponse->GetHeaders().lower_bound("x-ms-meta-");
           i != pRawResponse->GetHeaders().end() && i->first.substr(0, 10) == "x-ms-meta-";
           ++i)
      {
        response.Metadata.emplace(i->first.substr(10), i->second);
      }
      if (pRawResponse->GetHeaders().count("x-ms-or-policy-id") != 0)
      {
        response.ObjectReplicationDestinationPolicyId
            = pRawResponse->GetHeaders().at("x-ms-or-policy-id");
      }
      response.BlobType = Models::BlobType(pRawResponse->GetHeaders().at("x-ms-blob-type"));
      if (pRawResponse->GetHeaders().count("x-ms-copy-completion-time") != 0)
      {
        response.CopyCompletedOn = DateTime::Parse(
            pRawResponse->GetHeaders().at("x-ms-copy-completion-time"),
            Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-copy-status-description") != 0)
      {
        response.CopyStatusDescription
            = pRawResponse->GetHeaders().at("x-ms-copy-status-description");
      }
      if (pRawResponse->GetHeaders().count("x-ms-copy-id") != 0)
      {
        response.CopyId = pRawResponse->GetHeaders().at("x-ms-copy-id");
      }
      if (pRawResponse->GetHeaders().count("x-ms-copy-progress") != 0)
      {
        response.CopyProgress = pRawResponse->GetHeaders().at("x-ms-copy-progress");
      }
      if (pRawResponse->GetHeaders().count("x-ms-copy-source") != 0)
      {
        response.CopySource = pRawResponse->GetHeaders().at("x-ms-copy-source");
      }
      if (pRawResponse->GetHeaders().count("x-ms-copy-status") != 0)
      {
        response.CopyStatus = Models::CopyStatus(pRawResponse->GetHeaders().at("x-ms-copy-status"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-incremental-copy") != 0)
      {
        response.IsIncrementalCopy
            = pRawResponse->GetHeaders().at("x-ms-incremental-copy") == std::string("true");
      }
      if (pRawResponse->GetHeaders().count("x-ms-copy-destination-snapshot") != 0)
      {
        response.IncrementalCopyDestinationSnapshot
            = pRawResponse->GetHeaders().at("x-ms-copy-destination-snapshot");
      }
      if (pRawResponse->GetHeaders().count("x-ms-lease-duration") != 0)
      {
        response.LeaseDuration
            = Models::LeaseDurationType(pRawResponse->GetHeaders().at("x-ms-lease-duration"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-lease-state") != 0)
      {
        response.LeaseState = Models::LeaseState(pRawResponse->GetHeaders().at("x-ms-lease-state"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-lease-status") != 0)
      {
        response.LeaseStatus
            = Models::LeaseStatus(pRawResponse->GetHeaders().at("x-ms-lease-status"));
      }
      response.BlobSize = std::stoll(pRawResponse->GetHeaders().at("Content-Length"));
      if (pRawResponse->GetHeaders().count("Content-Type") != 0)
      {
        response.HttpHeaders.ContentType = pRawResponse->GetHeaders().at("Content-Type");
      }
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
      {
        response.HttpHeaders.ContentHash.Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
        response.HttpHeaders.ContentHash.Algorithm = HashAlgorithm::Md5;
      }
      if (pRawResponse->GetHeaders().count("Content-Encoding") != 0)
      {
        response.HttpHeaders.ContentEncoding = pRawResponse->GetHeaders().at("Content-Encoding");
      }
      if (pRawResponse->GetHeaders().count("Content-Disposition") != 0)
      {
        response.HttpHeaders.ContentDisposition
            = pRawResponse->GetHeaders().at("Content-Disposition");
      }
      if (pRawResponse->GetHeaders().count("Content-Language") != 0)
      {
        response.HttpHeaders.ContentLanguage = pRawResponse->GetHeaders().at("Content-Language");
      }
      if (pRawResponse->GetHeaders().count("Cache-Control") != 0)
      {
        response.HttpHeaders.CacheControl = pRawResponse->GetHeaders().at("Cache-Control");
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-sequence-number") != 0)
      {
        response.SequenceNumber
            = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-sequence-number"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-committed-block-count") != 0)
      {
        response.CommittedBlockCount
            = std::stoi(pRawResponse->GetHeaders().at("x-ms-blob-committed-block-count"));
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      if (pRawResponse->GetHeaders().count("x-ms-access-tier") != 0)
      {
        response.AccessTier = Models::AccessTier(pRawResponse->GetHeaders().at("x-ms-access-tier"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-access-tier-inferred") != 0)
      {
        response.IsAccessTierInferred
            = pRawResponse->GetHeaders().at("x-ms-access-tier-inferred") == std::string("true");
      }
      if (pRawResponse->GetHeaders().count("x-ms-archive-status") != 0)
      {
        response.ArchiveStatus
            = Models::ArchiveStatus(pRawResponse->GetHeaders().at("x-ms-archive-status"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-access-tier-change-time") != 0)
      {
        response.AccessTierChangedOn = DateTime::Parse(
            pRawResponse->GetHeaders().at("x-ms-access-tier-change-time"),
            Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      if (pRawResponse->GetHeaders().count("x-ms-is-current-version") != 0)
      {
        response.IsCurrentVersion
            = pRawResponse->GetHeaders().at("x-ms-is-current-version") == std::string("true");
      }
      if (pRawResponse->GetHeaders().count("x-ms-tag-count") != 0)
      {
        response.TagCount = std::stoi(pRawResponse->GetHeaders().at("x-ms-tag-count"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-expiry-time") != 0)
      {
        response.ExpiresOn = DateTime::Parse(
            pRawResponse->GetHeaders().at("x-ms-expiry-time"),
            Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-sealed") != 0)
      {
        response.IsSealed
            = pRawResponse->GetHeaders().at("x-ms-blob-sealed") == std::string("true");
      }
      if (pRawResponse->GetHeaders().count("x-ms-rehydrate-priority") != 0)
      {
        response.RehydratePriority
            = Models::RehydratePriority(pRawResponse->GetHeaders().at("x-ms-rehydrate-priority"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-last-access-time") != 0)
      {
        response.LastAccessedOn = DateTime::Parse(
            pRawResponse->GetHeaders().at("x-ms-last-access-time"),
            Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-immutability-policy-until-date") != 0)
      {
        if (!response.ImmutabilityPolicy.HasValue())
        {
          response.ImmutabilityPolicy = Models::BlobImmutabilityPolicy();
        }
        response.ImmutabilityPolicy.Value().ExpiresOn = DateTime::Parse(
            pRawResponse->GetHeaders().at("x-ms-immutability-policy-until-date"),
            Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-immutability-policy-mode") != 0)
      {
        if (!response.ImmutabilityPolicy.HasValue())
        {
          response.ImmutabilityPolicy = Models::BlobImmutabilityPolicy();
        }
        response.ImmutabilityPolicy.Value().PolicyMode = Models::BlobImmutabilityPolicyMode(
            pRawResponse->GetHeaders().at("x-ms-immutability-policy-mode"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-legal-hold") != 0)
      {
        response.HasLegalHold
            = pRawResponse->GetHeaders().at("x-ms-legal-hold") == std::string("true");
      }
      return Response<Models::BlobProperties>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::DeleteBlobResult> BlobClient::Delete(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const DeleteBlobOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Delete, url);
      if (options.Snapshot.HasValue() && !options.Snapshot.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "snapshot", _internal::UrlEncodeQueryParameter(options.Snapshot.Value()));
      }
      if (options.VersionId.HasValue() && !options.VersionId.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "versionid", _internal::UrlEncodeQueryParameter(options.VersionId.Value()));
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.DeleteSnapshots.HasValue() && !options.DeleteSnapshots.Value().ToString().empty())
      {
        request.SetHeader("x-ms-delete-snapshots", options.DeleteSnapshots.Value().ToString());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Accepted)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::DeleteBlobResult response;
      return Response<Models::DeleteBlobResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::UndeleteBlobResult> BlobClient::Undelete(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const UndeleteBlobOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "undelete");
      request.SetHeader("x-ms-version", "2026-02-06");
      (void)options;
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::UndeleteBlobResult response;
      return Response<Models::UndeleteBlobResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::SetBlobExpiryResult> BlobClient::SetExpiry(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const SetBlobExpiryOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "expiry");
      request.SetHeader("x-ms-version", "2026-02-06");
      if (!options.ExpiryOptions.ToString().empty())
      {
        request.SetHeader("x-ms-expiry-option", options.ExpiryOptions.ToString());
      }
      if (options.ExpiresOn.HasValue() && !options.ExpiresOn.Value().empty())
      {
        request.SetHeader("x-ms-expiry-time", options.ExpiresOn.Value());
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::SetBlobExpiryResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      return Response<Models::SetBlobExpiryResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::SetBlobHttpHeadersResult> BlobClient::SetHttpHeaders(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const SetBlobHttpHeadersOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "properties");
      if (!options.BlobCacheControl.empty())
      {
        request.SetHeader("x-ms-blob-cache-control", options.BlobCacheControl);
      }
      if (!options.BlobContentType.empty())
      {
        request.SetHeader("x-ms-blob-content-type", options.BlobContentType);
      }
      if (!Core::Convert::Base64Encode(options.BlobContentMD5).empty())
      {
        request.SetHeader(
            "x-ms-blob-content-md5", Core::Convert::Base64Encode(options.BlobContentMD5));
      }
      if (!options.BlobContentEncoding.empty())
      {
        request.SetHeader("x-ms-blob-content-encoding", options.BlobContentEncoding);
      }
      if (!options.BlobContentLanguage.empty())
      {
        request.SetHeader("x-ms-blob-content-language", options.BlobContentLanguage);
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      if (!options.BlobContentDisposition.empty())
      {
        request.SetHeader("x-ms-blob-content-disposition", options.BlobContentDisposition);
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::SetBlobHttpHeadersResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-sequence-number") != 0)
      {
        response.SequenceNumber
            = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-sequence-number"));
      }
      return Response<Models::SetBlobHttpHeadersResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::SetBlobImmutabilityPolicyResult> BlobClient::SetImmutabilityPolicy(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const SetBlobImmutabilityPolicyOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "immutabilityPolicies");
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.ImmutabilityPolicyExpiry.HasValue())
      {
        request.SetHeader(
            "x-ms-immutability-policy-until-date",
            options.ImmutabilityPolicyExpiry.Value().ToString(
                Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.ImmutabilityPolicyMode.HasValue()
          && !options.ImmutabilityPolicyMode.Value().ToString().empty())
      {
        request.SetHeader(
            "x-ms-immutability-policy-mode", options.ImmutabilityPolicyMode.Value().ToString());
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::SetBlobImmutabilityPolicyResult response;
      response.ImmutabilityPolicy.ExpiresOn = DateTime::Parse(
          pRawResponse->GetHeaders().at("x-ms-immutability-policy-until-date"),
          Azure::DateTime::DateFormat::Rfc1123);
      response.ImmutabilityPolicy.PolicyMode = Models::BlobImmutabilityPolicyMode(
          pRawResponse->GetHeaders().at("x-ms-immutability-policy-mode"));
      return Response<Models::SetBlobImmutabilityPolicyResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::DeleteBlobImmutabilityPolicyResult> BlobClient::DeleteImmutabilityPolicy(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const DeleteBlobImmutabilityPolicyOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Delete, url);
      request.GetUrl().AppendQueryParameter("comp", "immutabilityPolicies");
      request.SetHeader("x-ms-version", "2026-02-06");
      (void)options;
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::DeleteBlobImmutabilityPolicyResult response;
      return Response<Models::DeleteBlobImmutabilityPolicyResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::SetBlobLegalHoldResult> BlobClient::SetLegalHold(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const SetBlobLegalHoldOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "legalhold");
      request.SetHeader("x-ms-version", "2026-02-06");
      request.SetHeader("x-ms-legal-hold", options.LegalHold ? "true" : "false");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::SetBlobLegalHoldResult response;
      response.HasLegalHold
          = pRawResponse->GetHeaders().at("x-ms-legal-hold") == std::string("true");
      return Response<Models::SetBlobLegalHoldResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::SetBlobMetadataResult> BlobClient::SetMetadata(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const SetBlobMetadataOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "metadata");
      for (const auto& p : options.Metadata)
      {
        request.SetHeader("x-ms-meta-" + p.first, p.second);
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::SetBlobMetadataResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      return Response<Models::SetBlobMetadataResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::AcquireBlobLeaseResult> BlobClient::AcquireLease(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const AcquireBlobLeaseOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "lease");
      request.SetHeader("x-ms-lease-action", "acquire");
      if (options.Duration.HasValue())
      {
        request.SetHeader("x-ms-lease-duration", std::to_string(options.Duration.Value()));
      }
      if (options.ProposedLeaseId.HasValue() && !options.ProposedLeaseId.Value().empty())
      {
        request.SetHeader("x-ms-proposed-lease-id", options.ProposedLeaseId.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::AcquireBlobLeaseResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      response.LeaseId = pRawResponse->GetHeaders().at("x-ms-lease-id");
      return Response<Models::_detail::AcquireBlobLeaseResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::ReleaseBlobLeaseResult> BlobClient::ReleaseLease(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const ReleaseBlobLeaseOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "lease");
      request.SetHeader("x-ms-lease-action", "release");
      if (!options.LeaseId.empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId);
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::ReleaseBlobLeaseResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      return Response<Models::_detail::ReleaseBlobLeaseResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::RenewBlobLeaseResult> BlobClient::RenewLease(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const RenewBlobLeaseOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "lease");
      request.SetHeader("x-ms-lease-action", "renew");
      if (!options.LeaseId.empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId);
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::RenewBlobLeaseResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      response.LeaseId = pRawResponse->GetHeaders().at("x-ms-lease-id");
      return Response<Models::_detail::RenewBlobLeaseResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::ChangeBlobLeaseResult> BlobClient::ChangeLease(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const ChangeBlobLeaseOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "lease");
      request.SetHeader("x-ms-lease-action", "change");
      if (!options.LeaseId.empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId);
      }
      if (!options.ProposedLeaseId.empty())
      {
        request.SetHeader("x-ms-proposed-lease-id", options.ProposedLeaseId);
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::ChangeBlobLeaseResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      response.LeaseId = pRawResponse->GetHeaders().at("x-ms-lease-id");
      return Response<Models::_detail::ChangeBlobLeaseResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::BreakBlobLeaseResult> BlobClient::BreakLease(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const BreakBlobLeaseOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "lease");
      request.SetHeader("x-ms-lease-action", "break");
      if (options.BreakPeriod.HasValue())
      {
        request.SetHeader("x-ms-lease-break-period", std::to_string(options.BreakPeriod.Value()));
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Accepted)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::BreakBlobLeaseResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      response.LeaseTime = std::stoi(pRawResponse->GetHeaders().at("x-ms-lease-time"));
      return Response<Models::_detail::BreakBlobLeaseResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::CreateBlobSnapshotResult> BlobClient::CreateSnapshot(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const CreateBlobSnapshotOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "snapshot");
      for (const auto& p : options.Metadata)
      {
        request.SetHeader("x-ms-meta-" + p.first, p.second);
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::CreateBlobSnapshotResult response;
      response.Snapshot = pRawResponse->GetHeaders().at("x-ms-snapshot");
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      return Response<Models::CreateBlobSnapshotResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::StartBlobCopyFromUriResult> BlobClient::StartCopyFromUri(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const StartBlobCopyFromUriOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      if (options.SourceLeaseId.HasValue() && !options.SourceLeaseId.Value().empty())
      {
        request.SetHeader("x-ms-source-lease-id", options.SourceLeaseId.Value());
      }
      for (const auto& p : options.Metadata)
      {
        request.SetHeader("x-ms-meta-" + p.first, p.second);
      }
      if (options.Tier.HasValue() && !options.Tier.Value().ToString().empty())
      {
        request.SetHeader("x-ms-access-tier", options.Tier.Value().ToString());
      }
      if (options.RehydratePriority.HasValue()
          && !options.RehydratePriority.Value().ToString().empty())
      {
        request.SetHeader("x-ms-rehydrate-priority", options.RehydratePriority.Value().ToString());
      }
      if (options.SourceIfModifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-modified-since",
            options.SourceIfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-unmodified-since",
            options.SourceIfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfMatch.HasValue() && !options.SourceIfMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-match", options.SourceIfMatch.ToString());
      }
      if (options.SourceIfNoneMatch.HasValue() && !options.SourceIfNoneMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-none-match", options.SourceIfNoneMatch.ToString());
      }
      if (options.SourceIfTags.HasValue() && !options.SourceIfTags.Value().empty())
      {
        request.SetHeader("x-ms-source-if-tags", options.SourceIfTags.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      if (!options.CopySource.empty())
      {
        request.SetHeader("x-ms-copy-source", options.CopySource);
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.BlobTagsString.HasValue() && !options.BlobTagsString.Value().empty())
      {
        request.SetHeader("x-ms-tags", options.BlobTagsString.Value());
      }
      if (options.SealBlob.HasValue())
      {
        request.SetHeader("x-ms-seal-blob", options.SealBlob.Value() ? "true" : "false");
      }
      if (options.ImmutabilityPolicyExpiry.HasValue())
      {
        request.SetHeader(
            "x-ms-immutability-policy-until-date",
            options.ImmutabilityPolicyExpiry.Value().ToString(
                Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.ImmutabilityPolicyMode.HasValue()
          && !options.ImmutabilityPolicyMode.Value().ToString().empty())
      {
        request.SetHeader(
            "x-ms-immutability-policy-mode", options.ImmutabilityPolicyMode.Value().ToString());
      }
      if (options.LegalHold.HasValue())
      {
        request.SetHeader("x-ms-legal-hold", options.LegalHold.Value() ? "true" : "false");
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Accepted)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::StartBlobCopyFromUriResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      response.CopyId = pRawResponse->GetHeaders().at("x-ms-copy-id");
      response.CopyStatus = Models::CopyStatus(pRawResponse->GetHeaders().at("x-ms-copy-status"));
      return Response<Models::_detail::StartBlobCopyFromUriResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::CopyBlobFromUriResult> BlobClient::CopyFromUri(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const CopyBlobFromUriOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.SetHeader("x-ms-requires-sync", "true");
      for (const auto& p : options.Metadata)
      {
        request.SetHeader("x-ms-meta-" + p.first, p.second);
      }
      if (options.Tier.HasValue() && !options.Tier.Value().ToString().empty())
      {
        request.SetHeader("x-ms-access-tier", options.Tier.Value().ToString());
      }
      if (options.SourceIfModifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-modified-since",
            options.SourceIfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-unmodified-since",
            options.SourceIfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfMatch.HasValue() && !options.SourceIfMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-match", options.SourceIfMatch.ToString());
      }
      if (options.SourceIfNoneMatch.HasValue() && !options.SourceIfNoneMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-none-match", options.SourceIfNoneMatch.ToString());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      if (!options.CopySource.empty())
      {
        request.SetHeader("x-ms-copy-source", options.CopySource);
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.SourceContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.SourceContentMD5.Value()).empty())
      {
        request.SetHeader(
            "x-ms-source-content-md5",
            Core::Convert::Base64Encode(options.SourceContentMD5.Value()));
      }
      if (options.BlobTagsString.HasValue() && !options.BlobTagsString.Value().empty())
      {
        request.SetHeader("x-ms-tags", options.BlobTagsString.Value());
      }
      if (options.ImmutabilityPolicyExpiry.HasValue())
      {
        request.SetHeader(
            "x-ms-immutability-policy-until-date",
            options.ImmutabilityPolicyExpiry.Value().ToString(
                Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.ImmutabilityPolicyMode.HasValue()
          && !options.ImmutabilityPolicyMode.Value().ToString().empty())
      {
        request.SetHeader(
            "x-ms-immutability-policy-mode", options.ImmutabilityPolicyMode.Value().ToString());
      }
      if (options.LegalHold.HasValue())
      {
        request.SetHeader("x-ms-legal-hold", options.LegalHold.Value() ? "true" : "false");
      }
      if (options.CopySourceAuthorization.HasValue()
          && !options.CopySourceAuthorization.Value().empty())
      {
        request.SetHeader(
            "x-ms-copy-source-authorization", options.CopySourceAuthorization.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.CopySourceTags.HasValue() && !options.CopySourceTags.Value().ToString().empty())
      {
        request.SetHeader("x-ms-copy-source-tag-option", options.CopySourceTags.Value().ToString());
      }
      if (options.FileRequestIntent.HasValue()
          && !options.FileRequestIntent.Value().ToString().empty())
      {
        request.SetHeader("x-ms-file-request-intent", options.FileRequestIntent.Value().ToString());
      }
      if (options.SourceContentcrc64.HasValue()
          && !Core::Convert::Base64Encode(options.SourceContentcrc64.Value()).empty())
      {
        request.SetHeader(
            "x-ms-source-content-crc64",
            Core::Convert::Base64Encode(options.SourceContentcrc64.Value()));
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Accepted)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::CopyBlobFromUriResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      response.CopyId = pRawResponse->GetHeaders().at("x-ms-copy-id");
      response.CopyStatus = Models::CopyStatus(pRawResponse->GetHeaders().at("x-ms-copy-status"));
      if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
      }
      if (pRawResponse->GetHeaders().count("x-ms-content-crc64") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-content-crc64"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Crc64;
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      return Response<Models::CopyBlobFromUriResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::AbortBlobCopyFromUriResult> BlobClient::AbortCopyFromUri(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const AbortBlobCopyFromUriOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "copy");
      request.SetHeader("x-ms-copy-action", "abort");
      if (!options.CopyId.empty())
      {
        request.GetUrl().AppendQueryParameter(
            "copyid", _internal::UrlEncodeQueryParameter(options.CopyId));
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::NoContent)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::AbortBlobCopyFromUriResult response;
      return Response<Models::AbortBlobCopyFromUriResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::SetBlobAccessTierResult> BlobClient::SetTier(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const SetBlobTierOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "tier");
      if (options.Snapshot.HasValue() && !options.Snapshot.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "snapshot", _internal::UrlEncodeQueryParameter(options.Snapshot.Value()));
      }
      if (options.VersionId.HasValue() && !options.VersionId.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "versionid", _internal::UrlEncodeQueryParameter(options.VersionId.Value()));
      }
      if (!options.Tier.ToString().empty())
      {
        request.SetHeader("x-ms-access-tier", options.Tier.ToString());
      }
      if (options.RehydratePriority.HasValue()
          && !options.RehydratePriority.Value().ToString().empty())
      {
        request.SetHeader("x-ms-rehydrate-priority", options.RehydratePriority.Value().ToString());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (!(httpStatusCode == Core::Http::HttpStatusCode::Ok
            || httpStatusCode == Core::Http::HttpStatusCode::Accepted))
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::SetBlobAccessTierResult response;
      return Response<Models::SetBlobAccessTierResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::AccountInfo> BlobClient::GetAccountInfo(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetBlobAccountInfoOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("restype", "account");
      request.GetUrl().AppendQueryParameter("comp", "properties");
      request.SetHeader("x-ms-version", "2026-02-06");
      (void)options;
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::AccountInfo response;
      response.SkuName = Models::SkuName(pRawResponse->GetHeaders().at("x-ms-sku-name"));
      response.AccountKind
          = Models::AccountKind(pRawResponse->GetHeaders().at("x-ms-account-kind"));
      response.IsHierarchicalNamespaceEnabled
          = pRawResponse->GetHeaders().at("x-ms-is-hns-enabled") == std::string("true");
      return Response<Models::AccountInfo>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::QueryBlobResult> BlobClient::Query(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const QueryBlobOptions& options,
        const Core::Context& context)
    {
      std::string xmlBody;
      {
        _internal::XmlWriter writer;
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "QueryRequest"});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag,
            "QueryType",
            options.QueryRequest.QueryType.ToString()});
        writer.Write(_internal::XmlNode{
            _internal::XmlNodeType::StartTag, "Expression", options.QueryRequest.Expression});
        if (options.QueryRequest.InputSerialization.HasValue())
        {
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "InputSerialization"});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Format"});
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "Type",
              options.QueryRequest.InputSerialization.Value().Format.Type.ToString()});
          if (options.QueryRequest.InputSerialization.Value()
                  .Format.DelimitedTextConfiguration.HasValue())
          {
            writer.Write(
                _internal::XmlNode{_internal::XmlNodeType::StartTag, "DelimitedTextConfiguration"});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "ColumnSeparator",
                options.QueryRequest.InputSerialization.Value()
                    .Format.DelimitedTextConfiguration.Value()
                    .ColumnSeparator});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "FieldQuote",
                options.QueryRequest.InputSerialization.Value()
                    .Format.DelimitedTextConfiguration.Value()
                    .FieldQuote});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "RecordSeparator",
                options.QueryRequest.InputSerialization.Value()
                    .Format.DelimitedTextConfiguration.Value()
                    .RecordSeparator});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "EscapeChar",
                options.QueryRequest.InputSerialization.Value()
                    .Format.DelimitedTextConfiguration.Value()
                    .EscapeChar});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "HasHeaders",
                options.QueryRequest.InputSerialization.Value()
                        .Format.DelimitedTextConfiguration.Value()
                        .HeadersPresent
                    ? "true"
                    : "false"});
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
          }
          if (options.QueryRequest.InputSerialization.Value()
                  .Format.JsonTextConfiguration.HasValue())
          {
            writer.Write(
                _internal::XmlNode{_internal::XmlNodeType::StartTag, "JsonTextConfiguration"});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "RecordSeparator",
                options.QueryRequest.InputSerialization.Value()
                    .Format.JsonTextConfiguration.Value()
                    .RecordSeparator});
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
          }
          if (options.QueryRequest.InputSerialization.Value().Format.ArrowConfiguration.HasValue())
          {
            writer.Write(
                _internal::XmlNode{_internal::XmlNodeType::StartTag, "ArrowConfiguration"});
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Schema"});
            for (const auto& i1 : options.QueryRequest.InputSerialization.Value()
                                      .Format.ArrowConfiguration.Value()
                                      .Schema)
            {
              writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Field"});
              writer.Write(
                  _internal::XmlNode{_internal::XmlNodeType::StartTag, "Type", i1.Type.ToString()});
              if (i1.Name.HasValue())
              {
                writer.Write(
                    _internal::XmlNode{_internal::XmlNodeType::StartTag, "Name", i1.Name.Value()});
              }
              if (i1.Precision.HasValue())
              {
                writer.Write(_internal::XmlNode{
                    _internal::XmlNodeType::StartTag,
                    "Precision",
                    std::to_string(i1.Precision.Value())});
              }
              if (i1.Scale.HasValue())
              {
                writer.Write(_internal::XmlNode{
                    _internal::XmlNodeType::StartTag, "Scale", std::to_string(i1.Scale.Value())});
              }
              writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
            }
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
          }
          if (options.QueryRequest.InputSerialization.Value()
                  .Format.ParquetTextConfiguration.HasValue())
          {
            writer.Write(
                _internal::XmlNode{_internal::XmlNodeType::StartTag, "ParquetTextConfiguration"});
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
          }
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        }
        if (options.QueryRequest.OutputSerialization.HasValue())
        {
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "OutputSerialization"});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Format"});
          writer.Write(_internal::XmlNode{
              _internal::XmlNodeType::StartTag,
              "Type",
              options.QueryRequest.OutputSerialization.Value().Format.Type.ToString()});
          if (options.QueryRequest.OutputSerialization.Value()
                  .Format.DelimitedTextConfiguration.HasValue())
          {
            writer.Write(
                _internal::XmlNode{_internal::XmlNodeType::StartTag, "DelimitedTextConfiguration"});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "ColumnSeparator",
                options.QueryRequest.OutputSerialization.Value()
                    .Format.DelimitedTextConfiguration.Value()
                    .ColumnSeparator});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "FieldQuote",
                options.QueryRequest.OutputSerialization.Value()
                    .Format.DelimitedTextConfiguration.Value()
                    .FieldQuote});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "RecordSeparator",
                options.QueryRequest.OutputSerialization.Value()
                    .Format.DelimitedTextConfiguration.Value()
                    .RecordSeparator});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "EscapeChar",
                options.QueryRequest.OutputSerialization.Value()
                    .Format.DelimitedTextConfiguration.Value()
                    .EscapeChar});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "HasHeaders",
                options.QueryRequest.OutputSerialization.Value()
                        .Format.DelimitedTextConfiguration.Value()
                        .HeadersPresent
                    ? "true"
                    : "false"});
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
          }
          if (options.QueryRequest.OutputSerialization.Value()
                  .Format.JsonTextConfiguration.HasValue())
          {
            writer.Write(
                _internal::XmlNode{_internal::XmlNodeType::StartTag, "JsonTextConfiguration"});
            writer.Write(_internal::XmlNode{
                _internal::XmlNodeType::StartTag,
                "RecordSeparator",
                options.QueryRequest.OutputSerialization.Value()
                    .Format.JsonTextConfiguration.Value()
                    .RecordSeparator});
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
          }
          if (options.QueryRequest.OutputSerialization.Value().Format.ArrowConfiguration.HasValue())
          {
            writer.Write(
                _internal::XmlNode{_internal::XmlNodeType::StartTag, "ArrowConfiguration"});
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Schema"});
            for (const auto& i2 : options.QueryRequest.OutputSerialization.Value()
                                      .Format.ArrowConfiguration.Value()
                                      .Schema)
            {
              writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Field"});
              writer.Write(
                  _internal::XmlNode{_internal::XmlNodeType::StartTag, "Type", i2.Type.ToString()});
              if (i2.Name.HasValue())
              {
                writer.Write(
                    _internal::XmlNode{_internal::XmlNodeType::StartTag, "Name", i2.Name.Value()});
              }
              if (i2.Precision.HasValue())
              {
                writer.Write(_internal::XmlNode{
                    _internal::XmlNodeType::StartTag,
                    "Precision",
                    std::to_string(i2.Precision.Value())});
              }
              if (i2.Scale.HasValue())
              {
                writer.Write(_internal::XmlNode{
                    _internal::XmlNodeType::StartTag, "Scale", std::to_string(i2.Scale.Value())});
              }
              writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
            }
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
          }
          if (options.QueryRequest.OutputSerialization.Value()
                  .Format.ParquetTextConfiguration.HasValue())
          {
            writer.Write(
                _internal::XmlNode{_internal::XmlNodeType::StartTag, "ParquetTextConfiguration"});
            writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
          }
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::End});
        xmlBody = writer.GetDocument();
      }
      Core::IO::MemoryBodyStream requestBody(
          reinterpret_cast<const uint8_t*>(xmlBody.data()), xmlBody.length());
      auto request = Core::Http::Request(Core::Http::HttpMethod::Post, url, &requestBody, false);
      request.SetHeader("Content-Type", "application/xml; charset=UTF-8");
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      request.GetUrl().AppendQueryParameter("comp", "query");
      if (options.Snapshot.HasValue() && !options.Snapshot.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "snapshot", _internal::UrlEncodeQueryParameter(options.Snapshot.Value()));
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (!(httpStatusCode == Core::Http::HttpStatusCode::Ok
            || httpStatusCode == Core::Http::HttpStatusCode::PartialContent))
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::QueryBlobResult response;
      response.BodyStream = pRawResponse->ExtractBodyStream();
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-lease-duration") != 0)
      {
        response.LeaseDuration
            = Models::LeaseDurationType(pRawResponse->GetHeaders().at("x-ms-lease-duration"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-lease-state") != 0)
      {
        response.LeaseState = Models::LeaseState(pRawResponse->GetHeaders().at("x-ms-lease-state"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-lease-status") != 0)
      {
        response.LeaseStatus
            = Models::LeaseStatus(pRawResponse->GetHeaders().at("x-ms-lease-status"));
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-server-encrypted") == std::string("true");
      return Response<Models::QueryBlobResult>(std::move(response), std::move(pRawResponse));
    }
    Response<std::map<std::string, std::string>> BlobClient::GetTags(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetBlobTagsOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("comp", "tags");
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.Snapshot.HasValue() && !options.Snapshot.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "snapshot", _internal::UrlEncodeQueryParameter(options.Snapshot.Value()));
      }
      if (options.VersionId.HasValue() && !options.VersionId.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "versionid", _internal::UrlEncodeQueryParameter(options.VersionId.Value()));
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-blob-if-modified-since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-blob-if-unmodified-since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("x-ms-blob-if-match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("x-ms-blob-if-none-match", options.IfNoneMatch.ToString());
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      std::map<std::string, std::string> response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kTags,
          kTagSet,
          kTag,
          kKey,
          kValue,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"Tags", XmlTagEnum::kTags},
            {"TagSet", XmlTagEnum::kTagSet},
            {"Tag", XmlTagEnum::kTag},
            {"Key", XmlTagEnum::kKey},
            {"Value", XmlTagEnum::kValue},
        };
        std::vector<XmlTagEnum> xmlPath;

        std::string mapKey1;
        std::string mapValue2;
        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kTags
                && xmlPath[1] == XmlTagEnum::kTagSet && xmlPath[2] == XmlTagEnum::kTag
                && xmlPath[3] == XmlTagEnum::kKey)
            {
              mapKey1 = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kTags
                && xmlPath[1] == XmlTagEnum::kTagSet && xmlPath[2] == XmlTagEnum::kTag
                && xmlPath[3] == XmlTagEnum::kValue)
            {
              mapValue2 = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {
            if (xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kTags
                && xmlPath[1] == XmlTagEnum::kTagSet && xmlPath[2] == XmlTagEnum::kTag
                && xmlPath[3] == XmlTagEnum::kValue)
            {
              response[std::move(mapKey1)] = std::move(mapValue2);
            }
            xmlPath.pop_back();
          }
        }
      }
      return Response<std::map<std::string, std::string>>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::SetBlobTagsResult> BlobClient::SetTags(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const SetBlobTagsOptions& options,
        const Core::Context& context)
    {
      std::string xmlBody;
      {
        _internal::XmlWriter writer;
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Tags"});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "TagSet"});
        for (const auto& i1i2 : options.Tags)
        {
          const auto& i1 = i1i2.first;
          const auto& i2 = i1i2.second;
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Tag"});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Key", i1});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Value", i2});
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::End});
        xmlBody = writer.GetDocument();
      }
      Core::IO::MemoryBodyStream requestBody(
          reinterpret_cast<const uint8_t*>(xmlBody.data()), xmlBody.length());
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url, &requestBody);
      request.SetHeader("Content-Type", "application/xml; charset=UTF-8");
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      request.GetUrl().AppendQueryParameter("comp", "tags");
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.VersionId.HasValue() && !options.VersionId.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "versionid", _internal::UrlEncodeQueryParameter(options.VersionId.Value()));
      }
      if (options.TransactionalContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()).empty())
      {
        request.SetHeader(
            "Content-MD5", Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()));
      }
      if (options.TransactionalContentCrc64.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()).empty())
      {
        request.SetHeader(
            "x-ms-content-crc64",
            Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()));
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-blob-if-modified-since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-blob-if-unmodified-since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("x-ms-blob-if-match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("x-ms-blob-if-none-match", options.IfNoneMatch.ToString());
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::NoContent)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::SetBlobTagsResult response;
      return Response<Models::SetBlobTagsResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::CreatePageBlobResult> PageBlobClient::Create(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const CreatePageBlobOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.SetHeader("x-ms-blob-type", "PageBlob");
      request.SetHeader("Content-Length", "0");
      if (options.Tier.HasValue() && !options.Tier.Value().ToString().empty())
      {
        request.SetHeader("x-ms-access-tier", options.Tier.Value().ToString());
      }
      if (!options.BlobContentType.empty())
      {
        request.SetHeader("x-ms-blob-content-type", options.BlobContentType);
      }
      if (!options.BlobContentEncoding.empty())
      {
        request.SetHeader("x-ms-blob-content-encoding", options.BlobContentEncoding);
      }
      if (!options.BlobContentLanguage.empty())
      {
        request.SetHeader("x-ms-blob-content-language", options.BlobContentLanguage);
      }
      if (!Core::Convert::Base64Encode(options.BlobContentMD5).empty())
      {
        request.SetHeader(
            "x-ms-blob-content-md5", Core::Convert::Base64Encode(options.BlobContentMD5));
      }
      if (!options.BlobCacheControl.empty())
      {
        request.SetHeader("x-ms-blob-cache-control", options.BlobCacheControl);
      }
      for (const auto& p : options.Metadata)
      {
        request.SetHeader("x-ms-meta-" + p.first, p.second);
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (!options.BlobContentDisposition.empty())
      {
        request.SetHeader("x-ms-blob-content-disposition", options.BlobContentDisposition);
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-blob-content-length", std::to_string(options.BlobContentLength));
      if (options.BlobSequenceNumber.HasValue())
      {
        request.SetHeader(
            "x-ms-blob-sequence-number", std::to_string(options.BlobSequenceNumber.Value()));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.BlobTagsString.HasValue() && !options.BlobTagsString.Value().empty())
      {
        request.SetHeader("x-ms-tags", options.BlobTagsString.Value());
      }
      if (options.ImmutabilityPolicyExpiry.HasValue())
      {
        request.SetHeader(
            "x-ms-immutability-policy-until-date",
            options.ImmutabilityPolicyExpiry.Value().ToString(
                Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.ImmutabilityPolicyMode.HasValue()
          && !options.ImmutabilityPolicyMode.Value().ToString().empty())
      {
        request.SetHeader(
            "x-ms-immutability-policy-mode", options.ImmutabilityPolicyMode.Value().ToString());
      }
      if (options.LegalHold.HasValue())
      {
        request.SetHeader("x-ms-legal-hold", options.LegalHold.Value() ? "true" : "false");
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::CreatePageBlobResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      return Response<Models::CreatePageBlobResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::UploadPagesResult> PageBlobClient::UploadPages(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        Core::IO::BodyStream& requestBody,
        const UploadPageBlobPagesOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url, &requestBody);
      request.GetUrl().AppendQueryParameter("comp", "page");
      request.SetHeader("x-ms-page-write", "update");
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      if (options.TransactionalContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()).empty())
      {
        request.SetHeader(
            "Content-MD5", Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()));
      }
      if (options.TransactionalContentCrc64.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()).empty())
      {
        request.SetHeader(
            "x-ms-content-crc64",
            Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()));
      }
      if (options.Range.HasValue() && !options.Range.Value().empty())
      {
        request.SetHeader("x-ms-range", options.Range.Value());
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.IfSequenceNumberLessThanOrEqualTo.HasValue())
      {
        request.SetHeader(
            "x-ms-if-sequence-number-le",
            std::to_string(options.IfSequenceNumberLessThanOrEqualTo.Value()));
      }
      if (options.IfSequenceNumberLessThan.HasValue())
      {
        request.SetHeader(
            "x-ms-if-sequence-number-lt", std::to_string(options.IfSequenceNumberLessThan.Value()));
      }
      if (options.IfSequenceNumberEqualTo.HasValue())
      {
        request.SetHeader(
            "x-ms-if-sequence-number-eq", std::to_string(options.IfSequenceNumberEqualTo.Value()));
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::UploadPagesResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
      }
      if (pRawResponse->GetHeaders().count("x-ms-content-crc64") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-content-crc64"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Crc64;
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-sequence-number") != 0)
      {
        response.SequenceNumber
            = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-sequence-number"));
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      return Response<Models::UploadPagesResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::ClearPagesResult> PageBlobClient::ClearPages(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const ClearPageBlobPagesOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "page");
      request.SetHeader("x-ms-page-write", "clear");
      request.SetHeader("Content-Length", "0");
      if (options.Range.HasValue() && !options.Range.Value().empty())
      {
        request.SetHeader("x-ms-range", options.Range.Value());
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.IfSequenceNumberLessThanOrEqualTo.HasValue())
      {
        request.SetHeader(
            "x-ms-if-sequence-number-le",
            std::to_string(options.IfSequenceNumberLessThanOrEqualTo.Value()));
      }
      if (options.IfSequenceNumberLessThan.HasValue())
      {
        request.SetHeader(
            "x-ms-if-sequence-number-lt", std::to_string(options.IfSequenceNumberLessThan.Value()));
      }
      if (options.IfSequenceNumberEqualTo.HasValue())
      {
        request.SetHeader(
            "x-ms-if-sequence-number-eq", std::to_string(options.IfSequenceNumberEqualTo.Value()));
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::ClearPagesResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-sequence-number") != 0)
      {
        response.SequenceNumber
            = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-sequence-number"));
      }
      return Response<Models::ClearPagesResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::UploadPagesFromUriResult> PageBlobClient::UploadPagesFromUri(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const UploadPageBlobPagesFromUriOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "page");
      request.SetHeader("x-ms-page-write", "update");
      if (!options.SourceUrl.empty())
      {
        request.SetHeader("x-ms-copy-source", options.SourceUrl);
      }
      if (!options.SourceRange.empty())
      {
        request.SetHeader("x-ms-source-range", options.SourceRange);
      }
      if (options.SourceContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.SourceContentMD5.Value()).empty())
      {
        request.SetHeader(
            "x-ms-source-content-md5",
            Core::Convert::Base64Encode(options.SourceContentMD5.Value()));
      }
      if (options.SourceContentcrc64.HasValue()
          && !Core::Convert::Base64Encode(options.SourceContentcrc64.Value()).empty())
      {
        request.SetHeader(
            "x-ms-source-content-crc64",
            Core::Convert::Base64Encode(options.SourceContentcrc64.Value()));
      }
      request.SetHeader("Content-Length", "0");
      if (!options.Range.empty())
      {
        request.SetHeader("x-ms-range", options.Range);
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.IfSequenceNumberLessThanOrEqualTo.HasValue())
      {
        request.SetHeader(
            "x-ms-if-sequence-number-le",
            std::to_string(options.IfSequenceNumberLessThanOrEqualTo.Value()));
      }
      if (options.IfSequenceNumberLessThan.HasValue())
      {
        request.SetHeader(
            "x-ms-if-sequence-number-lt", std::to_string(options.IfSequenceNumberLessThan.Value()));
      }
      if (options.IfSequenceNumberEqualTo.HasValue())
      {
        request.SetHeader(
            "x-ms-if-sequence-number-eq", std::to_string(options.IfSequenceNumberEqualTo.Value()));
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      if (options.SourceIfModifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-modified-since",
            options.SourceIfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-unmodified-since",
            options.SourceIfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfMatch.HasValue() && !options.SourceIfMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-match", options.SourceIfMatch.ToString());
      }
      if (options.SourceIfNoneMatch.HasValue() && !options.SourceIfNoneMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-none-match", options.SourceIfNoneMatch.ToString());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.CopySourceAuthorization.HasValue()
          && !options.CopySourceAuthorization.Value().empty())
      {
        request.SetHeader(
            "x-ms-copy-source-authorization", options.CopySourceAuthorization.Value());
      }
      if (options.FileRequestIntent.HasValue()
          && !options.FileRequestIntent.Value().ToString().empty())
      {
        request.SetHeader("x-ms-file-request-intent", options.FileRequestIntent.Value().ToString());
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::UploadPagesFromUriResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
      }
      if (pRawResponse->GetHeaders().count("x-ms-content-crc64") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-content-crc64"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Crc64;
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-sequence-number") != 0)
      {
        response.SequenceNumber
            = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-sequence-number"));
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      return Response<Models::UploadPagesFromUriResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::GetPageRangesResult> PageBlobClient::GetPageRanges(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetPageBlobPageRangesOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("comp", "pagelist");
      if (options.Snapshot.HasValue() && !options.Snapshot.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "snapshot", _internal::UrlEncodeQueryParameter(options.Snapshot.Value()));
      }
      if (options.Range.HasValue() && !options.Range.Value().empty())
      {
        request.SetHeader("x-ms-range", options.Range.Value());
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.Marker.HasValue() && !options.Marker.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "marker", _internal::UrlEncodeQueryParameter(options.Marker.Value()));
      }
      if (options.MaxResults.HasValue())
      {
        request.GetUrl().AppendQueryParameter(
            "maxresults", std::to_string(options.MaxResults.Value()));
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::GetPageRangesResult response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kPageList,
          kPageRange,
          kStart,
          kEnd,
          kClearRange,
          kNextMarker,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"PageList", XmlTagEnum::kPageList},
            {"PageRange", XmlTagEnum::kPageRange},
            {"Start", XmlTagEnum::kStart},
            {"End", XmlTagEnum::kEnd},
            {"ClearRange", XmlTagEnum::kClearRange},
            {"NextMarker", XmlTagEnum::kNextMarker},
        };
        std::vector<XmlTagEnum> xmlPath;
        Core::Http::HttpRange vectorElement1;
        Core::Http::HttpRange vectorElement2;
        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kPageRange && xmlPath[2] == XmlTagEnum::kStart)
            {
              vectorElement1.Offset = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kPageRange && xmlPath[2] == XmlTagEnum::kEnd)
            {
              vectorElement1.Length = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kClearRange && xmlPath[2] == XmlTagEnum::kStart)
            {
              vectorElement2.Offset = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kClearRange && xmlPath[2] == XmlTagEnum::kEnd)
            {
              vectorElement2.Length = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kNextMarker)
            {
              response.ContinuationToken = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {
            if (xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kPageRange)
            {
              vectorElement1.Length = vectorElement1.Length.Value() - vectorElement1.Offset + 1;
              response.PageRanges.push_back(std::move(vectorElement1));
              vectorElement1 = Core::Http::HttpRange();
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kClearRange)
            {
              vectorElement2.Length = vectorElement2.Length.Value() - vectorElement2.Offset + 1;
              response.ClearRanges.push_back(std::move(vectorElement2));
              vectorElement2 = Core::Http::HttpRange();
            }
            xmlPath.pop_back();
          }
        }
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      response.BlobSize = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-content-length"));
      return Response<Models::_detail::GetPageRangesResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::GetPageRangesDiffResult> PageBlobClient::GetPageRangesDiff(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetPageBlobPageRangesDiffOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("comp", "pagelist");
      if (options.Snapshot.HasValue() && !options.Snapshot.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "snapshot", _internal::UrlEncodeQueryParameter(options.Snapshot.Value()));
      }
      if (options.Prevsnapshot.HasValue() && !options.Prevsnapshot.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "prevsnapshot", _internal::UrlEncodeQueryParameter(options.Prevsnapshot.Value()));
      }
      if (options.PrevSnapshotUrl.HasValue() && !options.PrevSnapshotUrl.Value().empty())
      {
        request.SetHeader("x-ms-previous-snapshot-url", options.PrevSnapshotUrl.Value());
      }
      if (options.Range.HasValue() && !options.Range.Value().empty())
      {
        request.SetHeader("x-ms-range", options.Range.Value());
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.Marker.HasValue() && !options.Marker.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "marker", _internal::UrlEncodeQueryParameter(options.Marker.Value()));
      }
      if (options.MaxResults.HasValue())
      {
        request.GetUrl().AppendQueryParameter(
            "maxresults", std::to_string(options.MaxResults.Value()));
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::GetPageRangesDiffResult response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kPageList,
          kPageRange,
          kStart,
          kEnd,
          kClearRange,
          kNextMarker,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"PageList", XmlTagEnum::kPageList},
            {"PageRange", XmlTagEnum::kPageRange},
            {"Start", XmlTagEnum::kStart},
            {"End", XmlTagEnum::kEnd},
            {"ClearRange", XmlTagEnum::kClearRange},
            {"NextMarker", XmlTagEnum::kNextMarker},
        };
        std::vector<XmlTagEnum> xmlPath;
        Core::Http::HttpRange vectorElement1;
        Core::Http::HttpRange vectorElement2;
        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kPageRange && xmlPath[2] == XmlTagEnum::kStart)
            {
              vectorElement1.Offset = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kPageRange && xmlPath[2] == XmlTagEnum::kEnd)
            {
              vectorElement1.Length = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kClearRange && xmlPath[2] == XmlTagEnum::kStart)
            {
              vectorElement2.Offset = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kClearRange && xmlPath[2] == XmlTagEnum::kEnd)
            {
              vectorElement2.Length = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kNextMarker)
            {
              response.ContinuationToken = node.Value;
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {
            if (xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kPageRange)
            {
              vectorElement1.Length = vectorElement1.Length.Value() - vectorElement1.Offset + 1;
              response.PageRanges.push_back(std::move(vectorElement1));
              vectorElement1 = Core::Http::HttpRange();
            }
            else if (
                xmlPath.size() == 2 && xmlPath[0] == XmlTagEnum::kPageList
                && xmlPath[1] == XmlTagEnum::kClearRange)
            {
              vectorElement2.Length = vectorElement2.Length.Value() - vectorElement2.Offset + 1;
              response.ClearRanges.push_back(std::move(vectorElement2));
              vectorElement2 = Core::Http::HttpRange();
            }
            xmlPath.pop_back();
          }
        }
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      response.BlobSize = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-content-length"));
      return Response<Models::_detail::GetPageRangesDiffResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::ResizePageBlobResult> PageBlobClient::Resize(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const ResizePageBlobOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "properties");
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-blob-content-length", std::to_string(options.BlobContentLength));
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::ResizePageBlobResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      response.SequenceNumber
          = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-sequence-number"));
      return Response<Models::ResizePageBlobResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::UpdateSequenceNumberResult> PageBlobClient::UpdateSequenceNumber(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const UpdatePageBlobSequenceNumberOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "properties");
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      if (!options.SequenceNumberAction.ToString().empty())
      {
        request.SetHeader("x-ms-sequence-number-action", options.SequenceNumberAction.ToString());
      }
      if (options.BlobSequenceNumber.HasValue())
      {
        request.SetHeader(
            "x-ms-blob-sequence-number", std::to_string(options.BlobSequenceNumber.Value()));
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::UpdateSequenceNumberResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      response.SequenceNumber
          = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-sequence-number"));
      return Response<Models::UpdateSequenceNumberResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::_detail::StartBlobCopyIncrementalResult> PageBlobClient::StartCopyIncremental(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const StartPageBlobCopyIncrementalOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "incrementalcopy");
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      if (!options.CopySource.empty())
      {
        request.SetHeader("x-ms-copy-source", options.CopySource);
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Accepted)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::_detail::StartBlobCopyIncrementalResult response;
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      response.CopyId = pRawResponse->GetHeaders().at("x-ms-copy-id");
      response.CopyStatus = Models::CopyStatus(pRawResponse->GetHeaders().at("x-ms-copy-status"));
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      return Response<Models::_detail::StartBlobCopyIncrementalResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::CreateAppendBlobResult> AppendBlobClient::Create(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const CreateAppendBlobOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.SetHeader("x-ms-blob-type", "AppendBlob");
      request.SetHeader("Content-Length", "0");
      if (!options.BlobContentType.empty())
      {
        request.SetHeader("x-ms-blob-content-type", options.BlobContentType);
      }
      if (!options.BlobContentEncoding.empty())
      {
        request.SetHeader("x-ms-blob-content-encoding", options.BlobContentEncoding);
      }
      if (!options.BlobContentLanguage.empty())
      {
        request.SetHeader("x-ms-blob-content-language", options.BlobContentLanguage);
      }
      if (!Core::Convert::Base64Encode(options.BlobContentMD5).empty())
      {
        request.SetHeader(
            "x-ms-blob-content-md5", Core::Convert::Base64Encode(options.BlobContentMD5));
      }
      if (!options.BlobCacheControl.empty())
      {
        request.SetHeader("x-ms-blob-cache-control", options.BlobCacheControl);
      }
      for (const auto& p : options.Metadata)
      {
        request.SetHeader("x-ms-meta-" + p.first, p.second);
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (!options.BlobContentDisposition.empty())
      {
        request.SetHeader("x-ms-blob-content-disposition", options.BlobContentDisposition);
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.BlobTagsString.HasValue() && !options.BlobTagsString.Value().empty())
      {
        request.SetHeader("x-ms-tags", options.BlobTagsString.Value());
      }
      if (options.ImmutabilityPolicyExpiry.HasValue())
      {
        request.SetHeader(
            "x-ms-immutability-policy-until-date",
            options.ImmutabilityPolicyExpiry.Value().ToString(
                Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.ImmutabilityPolicyMode.HasValue()
          && !options.ImmutabilityPolicyMode.Value().ToString().empty())
      {
        request.SetHeader(
            "x-ms-immutability-policy-mode", options.ImmutabilityPolicyMode.Value().ToString());
      }
      if (options.LegalHold.HasValue())
      {
        request.SetHeader("x-ms-legal-hold", options.LegalHold.Value() ? "true" : "false");
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::CreateAppendBlobResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      return Response<Models::CreateAppendBlobResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::AppendBlockResult> AppendBlobClient::AppendBlock(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        Core::IO::BodyStream& requestBody,
        const AppendAppendBlobBlockOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url, &requestBody);
      request.GetUrl().AppendQueryParameter("comp", "appendblock");
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      if (options.TransactionalContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()).empty())
      {
        request.SetHeader(
            "Content-MD5", Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()));
      }
      if (options.TransactionalContentCrc64.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()).empty())
      {
        request.SetHeader(
            "x-ms-content-crc64",
            Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()));
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.MaxSize.HasValue())
      {
        request.SetHeader("x-ms-blob-condition-maxsize", std::to_string(options.MaxSize.Value()));
      }
      if (options.AppendPosition.HasValue())
      {
        request.SetHeader(
            "x-ms-blob-condition-appendpos", std::to_string(options.AppendPosition.Value()));
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::AppendBlockResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
      }
      if (pRawResponse->GetHeaders().count("x-ms-content-crc64") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-content-crc64"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Crc64;
      }
      response.AppendOffset = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-append-offset"));
      response.CommittedBlockCount
          = std::stoi(pRawResponse->GetHeaders().at("x-ms-blob-committed-block-count"));
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      return Response<Models::AppendBlockResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::AppendBlockFromUriResult> AppendBlobClient::AppendBlockFromUri(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const AppendAppendBlobBlockFromUriOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "appendblock");
      if (!options.SourceUrl.empty())
      {
        request.SetHeader("x-ms-copy-source", options.SourceUrl);
      }
      if (options.SourceRange.HasValue() && !options.SourceRange.Value().empty())
      {
        request.SetHeader("x-ms-source-range", options.SourceRange.Value());
      }
      if (options.SourceContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.SourceContentMD5.Value()).empty())
      {
        request.SetHeader(
            "x-ms-source-content-md5",
            Core::Convert::Base64Encode(options.SourceContentMD5.Value()));
      }
      if (options.SourceContentcrc64.HasValue()
          && !Core::Convert::Base64Encode(options.SourceContentcrc64.Value()).empty())
      {
        request.SetHeader(
            "x-ms-source-content-crc64",
            Core::Convert::Base64Encode(options.SourceContentcrc64.Value()));
      }
      request.SetHeader("Content-Length", "0");
      if (options.TransactionalContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()).empty())
      {
        request.SetHeader(
            "Content-MD5", Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()));
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.MaxSize.HasValue())
      {
        request.SetHeader("x-ms-blob-condition-maxsize", std::to_string(options.MaxSize.Value()));
      }
      if (options.AppendPosition.HasValue())
      {
        request.SetHeader(
            "x-ms-blob-condition-appendpos", std::to_string(options.AppendPosition.Value()));
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      if (options.SourceIfModifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-modified-since",
            options.SourceIfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-unmodified-since",
            options.SourceIfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfMatch.HasValue() && !options.SourceIfMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-match", options.SourceIfMatch.ToString());
      }
      if (options.SourceIfNoneMatch.HasValue() && !options.SourceIfNoneMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-none-match", options.SourceIfNoneMatch.ToString());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.CopySourceAuthorization.HasValue()
          && !options.CopySourceAuthorization.Value().empty())
      {
        request.SetHeader(
            "x-ms-copy-source-authorization", options.CopySourceAuthorization.Value());
      }
      if (options.FileRequestIntent.HasValue()
          && !options.FileRequestIntent.Value().ToString().empty())
      {
        request.SetHeader("x-ms-file-request-intent", options.FileRequestIntent.Value().ToString());
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::AppendBlockFromUriResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
      }
      if (pRawResponse->GetHeaders().count("x-ms-content-crc64") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-content-crc64"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Crc64;
      }
      response.AppendOffset = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-append-offset"));
      response.CommittedBlockCount
          = std::stoi(pRawResponse->GetHeaders().at("x-ms-blob-committed-block-count"));
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      return Response<Models::AppendBlockFromUriResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::SealAppendBlobResult> AppendBlobClient::Seal(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const SealAppendBlobOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "seal");
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.AppendPosition.HasValue())
      {
        request.SetHeader(
            "x-ms-blob-condition-appendpos", std::to_string(options.AppendPosition.Value()));
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::SealAppendBlobResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      response.IsSealed = pRawResponse->GetHeaders().at("x-ms-blob-sealed") == std::string("true");
      return Response<Models::SealAppendBlobResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::UploadBlockBlobResult> BlockBlobClient::Upload(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        Core::IO::BodyStream& requestBody,
        const UploadBlockBlobOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url, &requestBody);
      request.SetHeader("x-ms-blob-type", "BlockBlob");
      if (options.TransactionalContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()).empty())
      {
        request.SetHeader(
            "Content-MD5", Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()));
      }
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      if (!options.BlobContentType.empty())
      {
        request.SetHeader("x-ms-blob-content-type", options.BlobContentType);
      }
      if (!options.BlobContentEncoding.empty())
      {
        request.SetHeader("x-ms-blob-content-encoding", options.BlobContentEncoding);
      }
      if (!options.BlobContentLanguage.empty())
      {
        request.SetHeader("x-ms-blob-content-language", options.BlobContentLanguage);
      }
      if (!Core::Convert::Base64Encode(options.BlobContentMD5).empty())
      {
        request.SetHeader(
            "x-ms-blob-content-md5", Core::Convert::Base64Encode(options.BlobContentMD5));
      }
      if (!options.BlobCacheControl.empty())
      {
        request.SetHeader("x-ms-blob-cache-control", options.BlobCacheControl);
      }
      for (const auto& p : options.Metadata)
      {
        request.SetHeader("x-ms-meta-" + p.first, p.second);
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (!options.BlobContentDisposition.empty())
      {
        request.SetHeader("x-ms-blob-content-disposition", options.BlobContentDisposition);
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.Tier.HasValue() && !options.Tier.Value().ToString().empty())
      {
        request.SetHeader("x-ms-access-tier", options.Tier.Value().ToString());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.BlobTagsString.HasValue() && !options.BlobTagsString.Value().empty())
      {
        request.SetHeader("x-ms-tags", options.BlobTagsString.Value());
      }
      if (options.ImmutabilityPolicyExpiry.HasValue())
      {
        request.SetHeader(
            "x-ms-immutability-policy-until-date",
            options.ImmutabilityPolicyExpiry.Value().ToString(
                Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.ImmutabilityPolicyMode.HasValue()
          && !options.ImmutabilityPolicyMode.Value().ToString().empty())
      {
        request.SetHeader(
            "x-ms-immutability-policy-mode", options.ImmutabilityPolicyMode.Value().ToString());
      }
      if (options.LegalHold.HasValue())
      {
        request.SetHeader("x-ms-legal-hold", options.LegalHold.Value() ? "true" : "false");
      }
      if (options.TransactionalContentCrc64.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()).empty())
      {
        request.SetHeader(
            "x-ms-content-crc64",
            Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()));
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::UploadBlockBlobResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
      }
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      if (pRawResponse->GetHeaders().count("x-ms-content-crc64") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-content-crc64"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Crc64;
      }
      return Response<Models::UploadBlockBlobResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::UploadBlockBlobFromUriResult> BlockBlobClient::UploadFromUri(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const UploadBlockBlobFromUriOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.SetHeader("x-ms-blob-type", "BlockBlob");
      request.SetHeader("Content-Length", "0");
      if (!options.BlobContentType.empty())
      {
        request.SetHeader("x-ms-blob-content-type", options.BlobContentType);
      }
      if (!options.BlobContentEncoding.empty())
      {
        request.SetHeader("x-ms-blob-content-encoding", options.BlobContentEncoding);
      }
      if (!options.BlobContentLanguage.empty())
      {
        request.SetHeader("x-ms-blob-content-language", options.BlobContentLanguage);
      }
      if (!Core::Convert::Base64Encode(options.BlobContentMD5).empty())
      {
        request.SetHeader(
            "x-ms-blob-content-md5", Core::Convert::Base64Encode(options.BlobContentMD5));
      }
      if (!options.BlobCacheControl.empty())
      {
        request.SetHeader("x-ms-blob-cache-control", options.BlobCacheControl);
      }
      for (const auto& p : options.Metadata)
      {
        request.SetHeader("x-ms-meta-" + p.first, p.second);
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (!options.BlobContentDisposition.empty())
      {
        request.SetHeader("x-ms-blob-content-disposition", options.BlobContentDisposition);
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.Tier.HasValue() && !options.Tier.Value().ToString().empty())
      {
        request.SetHeader("x-ms-access-tier", options.Tier.Value().ToString());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      if (options.SourceIfModifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-modified-since",
            options.SourceIfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-unmodified-since",
            options.SourceIfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfMatch.HasValue() && !options.SourceIfMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-match", options.SourceIfMatch.ToString());
      }
      if (options.SourceIfNoneMatch.HasValue() && !options.SourceIfNoneMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-none-match", options.SourceIfNoneMatch.ToString());
      }
      if (options.SourceIfTags.HasValue() && !options.SourceIfTags.Value().empty())
      {
        request.SetHeader("x-ms-source-if-tags", options.SourceIfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.SourceContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.SourceContentMD5.Value()).empty())
      {
        request.SetHeader(
            "x-ms-source-content-md5",
            Core::Convert::Base64Encode(options.SourceContentMD5.Value()));
      }
      if (options.BlobTagsString.HasValue() && !options.BlobTagsString.Value().empty())
      {
        request.SetHeader("x-ms-tags", options.BlobTagsString.Value());
      }
      if (!options.CopySource.empty())
      {
        request.SetHeader("x-ms-copy-source", options.CopySource);
      }
      if (options.CopySourceBlobProperties.HasValue())
      {
        request.SetHeader(
            "x-ms-copy-source-blob-properties",
            options.CopySourceBlobProperties.Value() ? "true" : "false");
      }
      if (options.CopySourceAuthorization.HasValue()
          && !options.CopySourceAuthorization.Value().empty())
      {
        request.SetHeader(
            "x-ms-copy-source-authorization", options.CopySourceAuthorization.Value());
      }
      if (options.CopySourceTags.HasValue() && !options.CopySourceTags.Value().ToString().empty())
      {
        request.SetHeader("x-ms-copy-source-tag-option", options.CopySourceTags.Value().ToString());
      }
      if (options.FileRequestIntent.HasValue()
          && !options.FileRequestIntent.Value().ToString().empty())
      {
        request.SetHeader("x-ms-file-request-intent", options.FileRequestIntent.Value().ToString());
      }
      if (options.SourceContentcrc64.HasValue()
          && !Core::Convert::Base64Encode(options.SourceContentcrc64.Value()).empty())
      {
        request.SetHeader(
            "x-ms-source-content-crc64",
            Core::Convert::Base64Encode(options.SourceContentcrc64.Value()));
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::UploadBlockBlobFromUriResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
      }
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      if (pRawResponse->GetHeaders().count("x-ms-content-crc64") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-content-crc64"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Crc64;
      }
      return Response<Models::UploadBlockBlobFromUriResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::StageBlockResult> BlockBlobClient::StageBlock(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        Core::IO::BodyStream& requestBody,
        const StageBlockBlobBlockOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url, &requestBody);
      request.GetUrl().AppendQueryParameter("comp", "block");
      if (!options.BlockId.empty())
      {
        request.GetUrl().AppendQueryParameter(
            "blockid", _internal::UrlEncodeQueryParameter(options.BlockId));
      }
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      if (options.TransactionalContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()).empty())
      {
        request.SetHeader(
            "Content-MD5", Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()));
      }
      if (options.TransactionalContentCrc64.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()).empty())
      {
        request.SetHeader(
            "x-ms-content-crc64",
            Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()));
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::StageBlockResult response;
      if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
      }
      if (pRawResponse->GetHeaders().count("x-ms-content-crc64") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-content-crc64"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Crc64;
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      return Response<Models::StageBlockResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::StageBlockFromUriResult> BlockBlobClient::StageBlockFromUri(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const StageBlockBlobBlockFromUriOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url);
      request.GetUrl().AppendQueryParameter("comp", "block");
      if (!options.BlockId.empty())
      {
        request.GetUrl().AppendQueryParameter(
            "blockid", _internal::UrlEncodeQueryParameter(options.BlockId));
      }
      request.SetHeader("Content-Length", "0");
      if (!options.SourceUrl.empty())
      {
        request.SetHeader("x-ms-copy-source", options.SourceUrl);
      }
      if (options.SourceRange.HasValue() && !options.SourceRange.Value().empty())
      {
        request.SetHeader("x-ms-source-range", options.SourceRange.Value());
      }
      if (options.SourceContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.SourceContentMD5.Value()).empty())
      {
        request.SetHeader(
            "x-ms-source-content-md5",
            Core::Convert::Base64Encode(options.SourceContentMD5.Value()));
      }
      if (options.SourceContentcrc64.HasValue()
          && !Core::Convert::Base64Encode(options.SourceContentcrc64.Value()).empty())
      {
        request.SetHeader(
            "x-ms-source-content-crc64",
            Core::Convert::Base64Encode(options.SourceContentcrc64.Value()));
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.SourceIfModifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-modified-since",
            options.SourceIfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "x-ms-source-if-unmodified-since",
            options.SourceIfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.SourceIfMatch.HasValue() && !options.SourceIfMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-match", options.SourceIfMatch.ToString());
      }
      if (options.SourceIfNoneMatch.HasValue() && !options.SourceIfNoneMatch.ToString().empty())
      {
        request.SetHeader("x-ms-source-if-none-match", options.SourceIfNoneMatch.ToString());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.CopySourceAuthorization.HasValue()
          && !options.CopySourceAuthorization.Value().empty())
      {
        request.SetHeader(
            "x-ms-copy-source-authorization", options.CopySourceAuthorization.Value());
      }
      if (options.FileRequestIntent.HasValue()
          && !options.FileRequestIntent.Value().ToString().empty())
      {
        request.SetHeader("x-ms-file-request-intent", options.FileRequestIntent.Value().ToString());
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::StageBlockFromUriResult response;
      if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
      }
      if (pRawResponse->GetHeaders().count("x-ms-content-crc64") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-content-crc64"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Crc64;
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      return Response<Models::StageBlockFromUriResult>(
          std::move(response), std::move(pRawResponse));
    }
    Response<Models::CommitBlockListResult> BlockBlobClient::CommitBlockList(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const CommitBlockBlobBlockListOptions& options,
        const Core::Context& context)
    {
      std::string xmlBody;
      {
        _internal::XmlWriter writer;
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "BlockList"});
        for (const auto& i1 : options.Blocks.Committed)
        {
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Committed", i1});
        }
        for (const auto& i2 : options.Blocks.Uncommitted)
        {
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Uncommitted", i2});
        }
        for (const auto& i3 : options.Blocks.Latest)
        {
          writer.Write(_internal::XmlNode{_internal::XmlNodeType::StartTag, "Latest", i3});
        }
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::EndTag});
        writer.Write(_internal::XmlNode{_internal::XmlNodeType::End});
        xmlBody = writer.GetDocument();
      }
      Core::IO::MemoryBodyStream requestBody(
          reinterpret_cast<const uint8_t*>(xmlBody.data()), xmlBody.length());
      auto request = Core::Http::Request(Core::Http::HttpMethod::Put, url, &requestBody);
      request.SetHeader("Content-Type", "application/xml; charset=UTF-8");
      request.SetHeader("Content-Length", std::to_string(requestBody.Length()));
      request.GetUrl().AppendQueryParameter("comp", "blocklist");
      if (!options.BlobCacheControl.empty())
      {
        request.SetHeader("x-ms-blob-cache-control", options.BlobCacheControl);
      }
      if (!options.BlobContentType.empty())
      {
        request.SetHeader("x-ms-blob-content-type", options.BlobContentType);
      }
      if (!options.BlobContentEncoding.empty())
      {
        request.SetHeader("x-ms-blob-content-encoding", options.BlobContentEncoding);
      }
      if (!options.BlobContentLanguage.empty())
      {
        request.SetHeader("x-ms-blob-content-language", options.BlobContentLanguage);
      }
      if (!Core::Convert::Base64Encode(options.BlobContentMD5).empty())
      {
        request.SetHeader(
            "x-ms-blob-content-md5", Core::Convert::Base64Encode(options.BlobContentMD5));
      }
      if (options.TransactionalContentMD5.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()).empty())
      {
        request.SetHeader(
            "Content-MD5", Core::Convert::Base64Encode(options.TransactionalContentMD5.Value()));
      }
      if (options.TransactionalContentCrc64.HasValue()
          && !Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()).empty())
      {
        request.SetHeader(
            "x-ms-content-crc64",
            Core::Convert::Base64Encode(options.TransactionalContentCrc64.Value()));
      }
      for (const auto& p : options.Metadata)
      {
        request.SetHeader("x-ms-meta-" + p.first, p.second);
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (!options.BlobContentDisposition.empty())
      {
        request.SetHeader("x-ms-blob-content-disposition", options.BlobContentDisposition);
      }
      if (options.EncryptionKey.HasValue() && !options.EncryptionKey.Value().empty())
      {
        request.SetHeader("x-ms-encryption-key", options.EncryptionKey.Value());
      }
      if (options.EncryptionKeySha256.HasValue()
          && !Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()).empty())
      {
        request.SetHeader(
            "x-ms-encryption-key-sha256",
            Core::Convert::Base64Encode(options.EncryptionKeySha256.Value()));
      }
      if (options.EncryptionAlgorithm.HasValue() && !options.EncryptionAlgorithm.Value().empty())
      {
        request.SetHeader("x-ms-encryption-algorithm", options.EncryptionAlgorithm.Value());
      }
      if (options.EncryptionScope.HasValue() && !options.EncryptionScope.Value().empty())
      {
        request.SetHeader("x-ms-encryption-scope", options.EncryptionScope.Value());
      }
      if (options.Tier.HasValue() && !options.Tier.Value().ToString().empty())
      {
        request.SetHeader("x-ms-access-tier", options.Tier.Value().ToString());
      }
      if (options.IfModifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Modified-Since",
            options.IfModifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfUnmodifiedSince.HasValue())
      {
        request.SetHeader(
            "If-Unmodified-Since",
            options.IfUnmodifiedSince.Value().ToString(Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.IfMatch.HasValue() && !options.IfMatch.ToString().empty())
      {
        request.SetHeader("If-Match", options.IfMatch.ToString());
      }
      if (options.IfNoneMatch.HasValue() && !options.IfNoneMatch.ToString().empty())
      {
        request.SetHeader("If-None-Match", options.IfNoneMatch.ToString());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      if (options.BlobTagsString.HasValue() && !options.BlobTagsString.Value().empty())
      {
        request.SetHeader("x-ms-tags", options.BlobTagsString.Value());
      }
      if (options.ImmutabilityPolicyExpiry.HasValue())
      {
        request.SetHeader(
            "x-ms-immutability-policy-until-date",
            options.ImmutabilityPolicyExpiry.Value().ToString(
                Azure::DateTime::DateFormat::Rfc1123));
      }
      if (options.ImmutabilityPolicyMode.HasValue()
          && !options.ImmutabilityPolicyMode.Value().ToString().empty())
      {
        request.SetHeader(
            "x-ms-immutability-policy-mode", options.ImmutabilityPolicyMode.Value().ToString());
      }
      if (options.LegalHold.HasValue())
      {
        request.SetHeader("x-ms-legal-hold", options.LegalHold.Value() ? "true" : "false");
      }
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Created)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::CommitBlockListResult response;
      response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      response.LastModified = DateTime::Parse(
          pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      if (pRawResponse->GetHeaders().count("Content-MD5") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("Content-MD5"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Md5;
      }
      if (pRawResponse->GetHeaders().count("x-ms-content-crc64") != 0)
      {
        response.TransactionalContentHash = ContentHash();
        response.TransactionalContentHash.Value().Value
            = Core::Convert::Base64Decode(pRawResponse->GetHeaders().at("x-ms-content-crc64"));
        response.TransactionalContentHash.Value().Algorithm = HashAlgorithm::Crc64;
      }
      if (pRawResponse->GetHeaders().count("x-ms-version-id") != 0)
      {
        response.VersionId = pRawResponse->GetHeaders().at("x-ms-version-id");
      }
      response.IsServerEncrypted
          = pRawResponse->GetHeaders().at("x-ms-request-server-encrypted") == std::string("true");
      if (pRawResponse->GetHeaders().count("x-ms-encryption-key-sha256") != 0)
      {
        response.EncryptionKeySha256 = Core::Convert::Base64Decode(
            pRawResponse->GetHeaders().at("x-ms-encryption-key-sha256"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-encryption-scope") != 0)
      {
        response.EncryptionScope = pRawResponse->GetHeaders().at("x-ms-encryption-scope");
      }
      return Response<Models::CommitBlockListResult>(std::move(response), std::move(pRawResponse));
    }
    Response<Models::GetBlockListResult> BlockBlobClient::GetBlockList(
        Core::Http::_internal::HttpPipeline& pipeline,
        const Core::Url& url,
        const GetBlockBlobBlockListOptions& options,
        const Core::Context& context)
    {
      auto request = Core::Http::Request(Core::Http::HttpMethod::Get, url);
      request.GetUrl().AppendQueryParameter("comp", "blocklist");
      if (options.Snapshot.HasValue() && !options.Snapshot.Value().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "snapshot", _internal::UrlEncodeQueryParameter(options.Snapshot.Value()));
      }
      if (!options.ListType.ToString().empty())
      {
        request.GetUrl().AppendQueryParameter(
            "blocklisttype", _internal::UrlEncodeQueryParameter(options.ListType.ToString()));
      }
      if (options.LeaseId.HasValue() && !options.LeaseId.Value().empty())
      {
        request.SetHeader("x-ms-lease-id", options.LeaseId.Value());
      }
      if (options.IfTags.HasValue() && !options.IfTags.Value().empty())
      {
        request.SetHeader("x-ms-if-tags", options.IfTags.Value());
      }
      request.SetHeader("x-ms-version", "2026-02-06");
      auto pRawResponse = pipeline.Send(request, context);
      auto httpStatusCode = pRawResponse->GetStatusCode();
      if (httpStatusCode != Core::Http::HttpStatusCode::Ok)
      {
        throw StorageException::CreateFromResponse(std::move(pRawResponse));
      }
      Models::GetBlockListResult response;
      {
        const auto& responseBody = pRawResponse->GetBody();
        _internal::XmlReader reader(
            reinterpret_cast<const char*>(responseBody.data()), responseBody.size());
        enum class XmlTagEnum
        {
          kUnknown,
          kBlockList,
          kCommittedBlocks,
          kBlock,
          kName,
          kSize,
          kUncommittedBlocks,
        };
        const std::unordered_map<std::string, XmlTagEnum> XmlTagEnumMap{
            {"BlockList", XmlTagEnum::kBlockList},
            {"CommittedBlocks", XmlTagEnum::kCommittedBlocks},
            {"Block", XmlTagEnum::kBlock},
            {"Name", XmlTagEnum::kName},
            {"Size", XmlTagEnum::kSize},
            {"UncommittedBlocks", XmlTagEnum::kUncommittedBlocks},
        };
        std::vector<XmlTagEnum> xmlPath;
        Models::BlobBlock vectorElement1;
        Models::BlobBlock vectorElement2;
        while (true)
        {
          auto node = reader.Read();
          if (node.Type == _internal::XmlNodeType::End)
          {
            break;
          }
          else if (node.Type == _internal::XmlNodeType::StartTag)
          {
            auto ite = XmlTagEnumMap.find(node.Name);
            xmlPath.push_back(ite == XmlTagEnumMap.end() ? XmlTagEnum::kUnknown : ite->second);
          }
          else if (node.Type == _internal::XmlNodeType::Text)
          {
            if (xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kBlockList
                && xmlPath[1] == XmlTagEnum::kCommittedBlocks && xmlPath[2] == XmlTagEnum::kBlock
                && xmlPath[3] == XmlTagEnum::kName)
            {
              vectorElement1.Name = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kBlockList
                && xmlPath[1] == XmlTagEnum::kCommittedBlocks && xmlPath[2] == XmlTagEnum::kBlock
                && xmlPath[3] == XmlTagEnum::kSize)
            {
              vectorElement1.Size = std::stoll(node.Value);
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kBlockList
                && xmlPath[1] == XmlTagEnum::kUncommittedBlocks && xmlPath[2] == XmlTagEnum::kBlock
                && xmlPath[3] == XmlTagEnum::kName)
            {
              vectorElement2.Name = node.Value;
            }
            else if (
                xmlPath.size() == 4 && xmlPath[0] == XmlTagEnum::kBlockList
                && xmlPath[1] == XmlTagEnum::kUncommittedBlocks && xmlPath[2] == XmlTagEnum::kBlock
                && xmlPath[3] == XmlTagEnum::kSize)
            {
              vectorElement2.Size = std::stoll(node.Value);
            }
          }
          else if (node.Type == _internal::XmlNodeType::Attribute)
          {
          }
          else if (node.Type == _internal::XmlNodeType::EndTag)
          {
            if (xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kBlockList
                && xmlPath[1] == XmlTagEnum::kCommittedBlocks && xmlPath[2] == XmlTagEnum::kBlock)
            {
              response.CommittedBlocks.push_back(std::move(vectorElement1));
              vectorElement1 = Models::BlobBlock();
            }
            else if (
                xmlPath.size() == 3 && xmlPath[0] == XmlTagEnum::kBlockList
                && xmlPath[1] == XmlTagEnum::kUncommittedBlocks && xmlPath[2] == XmlTagEnum::kBlock)
            {
              response.UncommittedBlocks.push_back(std::move(vectorElement2));
              vectorElement2 = Models::BlobBlock();
            }
            xmlPath.pop_back();
          }
        }
      }
      if (pRawResponse->GetHeaders().count("Last-Modified") != 0)
      {
        response.LastModified = DateTime::Parse(
            pRawResponse->GetHeaders().at("Last-Modified"), Azure::DateTime::DateFormat::Rfc1123);
      }
      if (pRawResponse->GetHeaders().count("ETag") != 0)
      {
        response.ETag = ETag(pRawResponse->GetHeaders().at("ETag"));
      }
      if (pRawResponse->GetHeaders().count("x-ms-blob-content-length") != 0)
      {
        response.BlobSize = std::stoll(pRawResponse->GetHeaders().at("x-ms-blob-content-length"));
      }
      return Response<Models::GetBlockListResult>(std::move(response), std::move(pRawResponse));
    }
  } // namespace _detail
}}} // namespace Azure::Storage::Blobs