// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) TypeSpec Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

#pragma once

#include "dll_import_export.hpp"

#include <azure/core/context.hpp>
#include <azure/core/internal/extendable_enumeration.hpp>
#include <azure/core/nullable.hpp>
#include <azure/core/url.hpp>
#include <azure/core/uuid.hpp>

#include <cstdint>
#include <map>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace Azure { namespace Data { namespace AppConfiguration {

  class GetKeysResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetKeysResponseContentType> {
  public:
    GetKeysResponseContentType() = default;

    explicit GetKeysResponseContentType(std::string getKeysResponseContentType)
        : ExtendableEnumeration(std::move(getKeysResponseContentType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetKeysResponseContentType const
        ApplicationVndMicrosoftAppconfigKeysetJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetKeysResponseContentType const
        ApplicationProblemJson;
  };

  class GetKeyValuesResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetKeyValuesResponseContentType> {
  public:
    GetKeyValuesResponseContentType() = default;

    explicit GetKeyValuesResponseContentType(std::string getKeyValuesResponseContentType)
        : ExtendableEnumeration(std::move(getKeyValuesResponseContentType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetKeyValuesResponseContentType const
        ApplicationVndMicrosoftAppconfigKvsetJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetKeyValuesResponseContentType const
        ApplicationProblemJson;
  };

  class KeyValueFields final : public Core::_internal::ExtendableEnumeration<KeyValueFields> {
  public:
    KeyValueFields() = default;

    explicit KeyValueFields(std::string keyValueFields)
        : ExtendableEnumeration(std::move(keyValueFields))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static KeyValueFields const Key;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static KeyValueFields const Label;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static KeyValueFields const ContentType;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static KeyValueFields const Value;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static KeyValueFields const LastModified;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static KeyValueFields const Tags;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static KeyValueFields const Locked;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static KeyValueFields const Etag;
  };

  class PutKeyValueRequestContentType final
      : public Core::_internal::ExtendableEnumeration<PutKeyValueRequestContentType> {
  public:
    PutKeyValueRequestContentType() = default;

    explicit PutKeyValueRequestContentType(std::string putKeyValueRequestContentType)
        : ExtendableEnumeration(std::move(putKeyValueRequestContentType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static PutKeyValueRequestContentType const
        ApplicationVndMicrosoftAppconfigKvJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static PutKeyValueRequestContentType const
        ApplicationVndMicrosoftAppconfigKvsetJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static PutKeyValueRequestContentType const ApplicationJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static PutKeyValueRequestContentType const TextJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static PutKeyValueRequestContentType const
        ApplicationZeroZeroJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static PutKeyValueRequestContentType const
        ApplicationJsonPatchJson;
  };

  class SnapshotStatus final : public Core::_internal::ExtendableEnumeration<SnapshotStatus> {
  public:
    SnapshotStatus() = default;

    explicit SnapshotStatus(std::string snapshotStatus)
        : ExtendableEnumeration(std::move(snapshotStatus))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotStatus const Provisioning;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotStatus const Ready;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotStatus const Archived;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotStatus const Failed;
  };

  class CompositionType final : public Core::_internal::ExtendableEnumeration<CompositionType> {
  public:
    CompositionType() = default;

    explicit CompositionType(std::string compositionType)
        : ExtendableEnumeration(std::move(compositionType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static CompositionType const Key;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static CompositionType const KeyLabel;
  };

  class GetSnapshotsResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetSnapshotsResponseContentType> {
  public:
    GetSnapshotsResponseContentType() = default;

    explicit GetSnapshotsResponseContentType(std::string getSnapshotsResponseContentType)
        : ExtendableEnumeration(std::move(getSnapshotsResponseContentType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetSnapshotsResponseContentType const
        ApplicationVndMicrosoftAppconfigSnapshotsetJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetSnapshotsResponseContentType const
        ApplicationProblemJson;
  };

  class SnapshotFields final : public Core::_internal::ExtendableEnumeration<SnapshotFields> {
  public:
    SnapshotFields() = default;

    explicit SnapshotFields(std::string snapshotFields)
        : ExtendableEnumeration(std::move(snapshotFields))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotFields const Name;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotFields const Status;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotFields const Filters;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotFields const CompositionType;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotFields const Created;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotFields const Expires;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotFields const RetentionPeriod;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotFields const Size;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotFields const ItemsCount;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotFields const Tags;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static SnapshotFields const Etag;
  };

  class GetSnapshotResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetSnapshotResponseContentType> {
  public:
    GetSnapshotResponseContentType() = default;

    explicit GetSnapshotResponseContentType(std::string getSnapshotResponseContentType)
        : ExtendableEnumeration(std::move(getSnapshotResponseContentType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetSnapshotResponseContentType const
        ApplicationVndMicrosoftAppconfigSnapshotJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetSnapshotResponseContentType const
        ApplicationProblemJson;
  };

  class OperationState final : public Core::_internal::ExtendableEnumeration<OperationState> {
  public:
    OperationState() = default;

    explicit OperationState(std::string operationState)
        : ExtendableEnumeration(std::move(operationState))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static OperationState const NotStarted;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static OperationState const Running;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static OperationState const Succeeded;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static OperationState const Failed;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static OperationState const Canceled;
  };

  class CreateSnapshotResponseContentType final
      : public Core::_internal::ExtendableEnumeration<CreateSnapshotResponseContentType> {
  public:
    CreateSnapshotResponseContentType() = default;

    explicit CreateSnapshotResponseContentType(std::string createSnapshotResponseContentType)
        : ExtendableEnumeration(std::move(createSnapshotResponseContentType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static CreateSnapshotResponseContentType const
        ApplicationVndMicrosoftAppconfigSnapshotJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static CreateSnapshotResponseContentType const
        ApplicationProblemJson;
  };

  class CreateSnapshotRequestContentType final
      : public Core::_internal::ExtendableEnumeration<CreateSnapshotRequestContentType> {
  public:
    CreateSnapshotRequestContentType() = default;

    explicit CreateSnapshotRequestContentType(std::string createSnapshotRequestContentType)
        : ExtendableEnumeration(std::move(createSnapshotRequestContentType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static CreateSnapshotRequestContentType const
        ApplicationVndMicrosoftAppconfigSnapshotJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static CreateSnapshotRequestContentType const
        ApplicationJson;
  };

  class UpdateSnapshotResponseContentType final
      : public Core::_internal::ExtendableEnumeration<UpdateSnapshotResponseContentType> {
  public:
    UpdateSnapshotResponseContentType() = default;

    explicit UpdateSnapshotResponseContentType(std::string updateSnapshotResponseContentType)
        : ExtendableEnumeration(std::move(updateSnapshotResponseContentType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static UpdateSnapshotResponseContentType const
        ApplicationVndMicrosoftAppconfigSnapshotJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static UpdateSnapshotResponseContentType const
        ApplicationProblemJson;
  };

  class UpdateSnapshotRequestContentType final
      : public Core::_internal::ExtendableEnumeration<UpdateSnapshotRequestContentType> {
  public:
    UpdateSnapshotRequestContentType() = default;

    explicit UpdateSnapshotRequestContentType(std::string updateSnapshotRequestContentType)
        : ExtendableEnumeration(std::move(updateSnapshotRequestContentType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static UpdateSnapshotRequestContentType const
        ApplicationMergePatchJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static UpdateSnapshotRequestContentType const
        ApplicationJson;
  };

  class GetLabelsResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetLabelsResponseContentType> {
  public:
    GetLabelsResponseContentType() = default;

    explicit GetLabelsResponseContentType(std::string getLabelsResponseContentType)
        : ExtendableEnumeration(std::move(getLabelsResponseContentType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetLabelsResponseContentType const
        ApplicationVndMicrosoftAppconfigLabelsetJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetLabelsResponseContentType const
        ApplicationProblemJson;
  };

  class LabelFields final : public Core::_internal::ExtendableEnumeration<LabelFields> {
  public:
    LabelFields() = default;

    explicit LabelFields(std::string labelFields) : ExtendableEnumeration(std::move(labelFields)) {}

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static LabelFields const Name;
  };

  class GetRevisionsResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetRevisionsResponseContentType> {
  public:
    GetRevisionsResponseContentType() = default;

    explicit GetRevisionsResponseContentType(std::string getRevisionsResponseContentType)
        : ExtendableEnumeration(std::move(getRevisionsResponseContentType))
    {
    }

    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetRevisionsResponseContentType const
        ApplicationVndMicrosoftAppconfigKvsetJson;
    AZ_DATA_APPCONFIGURATION_DLLEXPORT static GetRevisionsResponseContentType const
        ApplicationProblemJson;
  };

  struct Key final
  {
    std::string Name;
  };

  struct CheckKeysResult final
  {
    std::string SyncToken;
  };

  struct KeyValue final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
  };

  struct CheckKeyValuesResult final
  {
    std::string SyncToken;
    std::string ETag;
  };

  struct GetKeyValueResult final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
    Core::Uuid XMsClientRequestId{};
    std::string SyncToken;
    std::string ETag;
  };

  struct PutKeyValueResult final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
  };

  struct DeleteKeyValueResult final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
  };

  struct CheckKeyValueResult final
  {
    std::string SyncToken;
    std::string ETag;
  };

  struct KeyValueFilter final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::vector<std::string>> Tags;
  };

  struct Snapshot final
  {
    std::string Name;
    Nullable<SnapshotStatus> Status;
    std::vector<KeyValueFilter> Filters;
    Nullable<AppConfiguration::CompositionType> CompositionType;
    Nullable<std::string> Created;
    Nullable<std::string> Expires;
    Nullable<std::int64_t> RetentionPeriod;
    Nullable<std::int64_t> Size;
    Nullable<std::int64_t> ItemsCount;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<std::string> Etag;
  };

  struct CheckSnapshotsResult final
  {
    std::string SyncToken;
  };

  struct GetSnapshotResult final
  {
    std::string Name;
    Nullable<SnapshotStatus> Status;
    std::vector<KeyValueFilter> Filters;
    Nullable<AppConfiguration::CompositionType> CompositionType;
    Nullable<std::string> Created;
    Nullable<std::string> Expires;
    Nullable<std::int64_t> RetentionPeriod;
    Nullable<std::int64_t> Size;
    Nullable<std::int64_t> ItemsCount;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
    std::string Link;
    Core::Uuid XMsClientRequestId{};
    GetSnapshotResponseContentType ContentType;
  };

  struct InnerError final
  {
    Nullable<std::string> Code;
    std::unique_ptr<InnerError> Innererror;
  };

  struct Error final
  {
    std::string Code;
    std::string Message;
    Nullable<std::string> Target;
    Nullable<std::vector<Error>> Details;
    InnerError Innererror;
  };

  struct OperationDetails final
  {
    std::string Id;
    OperationState Status;
    AppConfiguration::Error Error;
  };

  struct CreateSnapshotResult final
  {
    std::string Name;
    Nullable<SnapshotStatus> Status;
    std::vector<KeyValueFilter> Filters;
    Nullable<AppConfiguration::CompositionType> CompositionType;
    Nullable<std::string> Created;
    Nullable<std::string> Expires;
    Nullable<std::int64_t> RetentionPeriod;
    Nullable<std::int64_t> Size;
    Nullable<std::int64_t> ItemsCount;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
    std::string Link;
    Core::Url OperationLocation;
    CreateSnapshotResponseContentType ContentType;
  };

  struct UpdateSnapshotResult final
  {
    std::string Name;
    Nullable<SnapshotStatus> Status;
    std::vector<KeyValueFilter> Filters;
    Nullable<AppConfiguration::CompositionType> CompositionType;
    Nullable<std::string> Created;
    Nullable<std::string> Expires;
    Nullable<std::int64_t> RetentionPeriod;
    Nullable<std::int64_t> Size;
    Nullable<std::int64_t> ItemsCount;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
    std::string Link;
    UpdateSnapshotResponseContentType ContentType;
  };

  struct SnapshotUpdateParameters final
  {
    Nullable<SnapshotStatus> Status;
  };

  struct CheckSnapshotResult final
  {
    std::string SyncToken;
    std::string ETag;
    std::string Link;
  };

  struct Label final
  {
    Nullable<std::string> Name;
  };

  struct CheckLabelsResult final
  {
    std::string SyncToken;
  };

  struct PutLockResult final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
  };

  struct DeleteLockResult final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
  };

  struct CheckRevisionsResult final
  {
    std::string SyncToken;
    std::string ETag;
  };
}}} // namespace Azure::Data::AppConfiguration
