/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.JETAProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LineProperty
extends JETAProperty
implements Externalizable {
    static final long serialVersionUID = -6081805367391562785L;
    public static final int VERSION = 2;
    private ColorProperty m_color_prop = new ColorProperty();
    private int m_thickness = 1;
    private float[] m_dash;
    private Stroke m_stroke;
    public static final String PROPERTY_ID = "lineStyle";

    public LineProperty() {
        super(PROPERTY_ID);
    }

    public Color getColor() {
        return this.m_color_prop.getColor();
    }

    public ColorProperty getColorProperty() {
        return this.m_color_prop;
    }

    public Stroke getStroke(int n) {
        int n2 = Math.min(n, this.getThickness());
        if (this.m_dash != null && this.m_dash.length > 1) {
            return new BasicStroke(n2, 0, 2, 1.0f, this.m_dash, 0.0f);
        }
        return new BasicStroke(n2, 0, 2);
    }

    public Stroke getStroke() {
        if (this.m_stroke == null) {
            this.m_stroke = this.getStroke(this.getThickness());
        }
        return this.m_stroke;
    }

    public int getThickness() {
        return this.m_thickness;
    }

    public float[] getDash() {
        return this.m_dash;
    }

    public void setConstantColor(Color color) {
        this.m_color_prop.setConstantColor(color);
    }

    public void setColorProperty(ColorProperty colorProperty) {
        this.m_color_prop.setValue(colorProperty);
    }

    public void setThickness(int n) {
        this.m_thickness = n;
        this.m_stroke = null;
    }

    public void setDash(float[] fArray) {
        this.m_dash = fArray;
        this.m_stroke = null;
    }

    public void setValue(Object object) {
        if (object instanceof LineProperty) {
            LineProperty lineProperty = (LineProperty)object;
            this.m_color_prop.setValue(lineProperty.m_color_prop);
            this.m_thickness = lineProperty.m_thickness;
            this.m_dash = lineProperty.m_dash;
        }
    }

    public void print() {
        System.out.println("   line component:  thickness: " + this.getThickness() + "   color: " + this.getColor());
    }

    public void updateBean(JETABean jETABean) {
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        if (n == 1) {
            Color color = (Color)objectInput.readObject();
            this.m_color_prop = new ColorProperty(color);
        } else {
            this.m_color_prop = (ColorProperty)objectInput.readObject();
        }
        this.m_thickness = objectInput.readInt();
        this.m_dash = (float[])objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(2);
        objectOutput.writeObject(this.m_color_prop);
        objectOutput.writeInt(this.m_thickness);
        objectOutput.writeObject(this.m_dash);
    }
}

