/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentScriptItemSyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentSyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentSyntaxContextListener;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLCommandModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnConstraintSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryObjectDataModel;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryObjectDropModel;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableAlterActionSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableAlterModel;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableConstraintSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableCreateModel;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableDropModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryCallModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryDeleteModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryInsertModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQuerySelectIntoModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryUpdateModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryUpdateSetClauseModel;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueColumnReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueConstantExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueFlattenedExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueFunctionExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueIndexingExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueMemberExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueSubqueryExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueTupleReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueTypeCastExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueVariableExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCorrelatedSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCrossJoinModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCteModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCteSubqueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsNaturalJoinModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsProjectionModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetCorrespondingOperationModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetOperationModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableProcModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableValueModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultColumnSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultCompleteTupleSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultTupleSpec;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerToggleOutlineView;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.utils.CommonUtils;

public class SQLEditorOutlinePage
extends ContentOutlinePage
implements IContentOutlinePage {
    private static final EnumMap<SQLQuerySymbolClass, String> registryStyleBySymbolClass = new EnumMap<SQLQuerySymbolClass, String>(SQLQuerySymbolClass.class){
        {
            this.put(SQLQuerySymbolClass.RESERVED, "org.jkiss.dbeaver.sql.editor.color.keyword.foreground");
            this.put(SQLQuerySymbolClass.TABLE_ALIAS, "org.jkiss.dbeaver.sql.editor.color.table.alias.foreground");
            this.put(SQLQuerySymbolClass.COLUMN_DERIVED, "org.jkiss.dbeaver.sql.editor.color.column.derived.foreground");
            this.put(SQLQuerySymbolClass.TABLE, "org.jkiss.dbeaver.sql.editor.color.table.foreground");
            this.put(SQLQuerySymbolClass.COLUMN, "org.jkiss.dbeaver.sql.editor.color.column.foreground");
            this.put(SQLQuerySymbolClass.FUNCTION, "org.jkiss.dbeaver.sql.editor.color.function.foreground");
            this.put(SQLQuerySymbolClass.COMPOSITE_FIELD, "org.jkiss.dbeaver.sql.editor.color.composite.field.foreground");
            this.put(SQLQuerySymbolClass.STRING, "org.jkiss.dbeaver.sql.editor.color.string.foreground");
            this.put(SQLQuerySymbolClass.CATALOG, "org.jkiss.dbeaver.sql.editor.color.schema.foreground");
            this.put(SQLQuerySymbolClass.SCHEMA, "org.jkiss.dbeaver.sql.editor.color.schema.foreground");
            this.put(SQLQuerySymbolClass.SQL_BATCH_VARIABLE, "org.jkiss.dbeaver.sql.editor.color.sqlVariable.foreground");
            this.put(SQLQuerySymbolClass.DBEAVER_VARIABLE, "org.jkiss.dbeaver.sql.editor.color.parameter.foreground");
            this.put(SQLQuerySymbolClass.DBEAVER_PARAMETER, "org.jkiss.dbeaver.sql.editor.color.parameter.foreground");
            this.put(SQLQuerySymbolClass.DBEAVER_COMMAND, "org.jkiss.dbeaver.sql.editor.color.command.foreground");
            this.put(SQLQuerySymbolClass.ERROR, "org.jkiss.dbeaver.sql.editor.color.semanticError.foreground");
            this.put(SQLQuerySymbolClass.QUOTED, "org.jkiss.dbeaver.sql.editor.color.datatype.foreground");
        }
    };
    private static final EnumMap<SQLQuerySymbolClass, StyledString.Styler> stylerBySymbolClass = new EnumMap<SQLQuerySymbolClass, StyledString.Styler>(SQLQuerySymbolClass.class){
        {
            registryStyleBySymbolClass.forEach((k, v) -> {
                StyledString.Styler styler = this.put(k, StyledString.createColorRegistryStyler((String)v, null));
            });
        }
    };
    private static final String LABEL_PROPERTY_KEY = "LABEL";
    private static final int SQL_QUERY_ORIGINAL_TEXT_PREVIEW_LENGTH = 100;
    @NotNull
    private final SQLEditorBase editor;
    @Nullable
    private TreeViewer treeViewer;
    private OutlineScriptNode scriptNode;
    @NotNull
    private final List<OutlineNode> rootNodes;
    @NotNull
    private SelectionSyncOperation currentSelectionSyncOp = SelectionSyncOperation.NONE;
    @NotNull
    private final SQLOutlineNodeBuilder currentNodeBuilder = new SQLOutlineNodeFullBuilder();
    @NotNull
    private final OutlineRefreshJob refreshJob = new OutlineRefreshJob();
    @NotNull
    private final CaretListener caretListener = event -> {
        if (this.currentSelectionSyncOp == SelectionSyncOperation.NONE) {
            LinkedList<OutlineNode> path = new LinkedList<OutlineNode>();
            int offset = event.caretOffset;
            OutlineScriptNode node = this.scriptNode;
            OutlineNode nextNode = this.scriptNode;
            path.add(node);
            block0: while (nextNode != null) {
                node = nextNode;
                nextNode = null;
                int i = 0;
                while (i < ((OutlineNode)node).getChildrenCount()) {
                    OutlineNode child = ((OutlineNode)node).getChild(i);
                    IRegion range = child.getTextRange();
                    if (range == null || range.getOffset() > offset) continue block0;
                    nextNode = child;
                    path.add(child);
                    ++i;
                }
            }
            if (node != null) {
                this.currentSelectionSyncOp = SelectionSyncOperation.FROM_EDITOR;
                this.treeViewer.getTree().setRedraw(false);
                this.treeViewer.reveal((Object)new TreePath((Object[])path.toArray(OutlineNode[]::new)));
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
                this.treeViewer.getTree().setRedraw(true);
                this.currentSelectionSyncOp = SelectionSyncOperation.NONE;
            }
        }
    };
    @NotNull
    private final ITextInputListener textInputListener = new ITextInputListener(){

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput != null) {
                SQLEditorOutlinePage.this.treeViewer.setInput((Object)SQLEditorOutlinePage.this.editor.getEditorInput());
            }
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }
    };
    @NotNull
    private final IPropertyListener editorPropertyListener = (source, propId) -> {
        if (propId == 1) {
            this.treeViewer.update((Object)this.scriptNode, new String[]{LABEL_PROPERTY_KEY});
        }
    };

    public SQLEditorOutlinePage(@NotNull SQLEditorBase editor) {
        this.editor = editor;
        this.scriptNode = new OutlineScriptNode();
        this.rootNodes = List.of(this.scriptNode);
    }

    public void refresh() {
        this.scriptNode.updateChildren();
        this.refreshJob.schedule(true);
    }

    @NotNull
    private SQLOutlineNodeBuilder getNodeBuilder() {
        return this.currentNodeBuilder;
    }

    protected int getTreeStyle() {
        return super.getTreeStyle() | 0x10000 | 0x10000000;
    }

    public void createControl(@NotNull Composite parent) {
        super.createControl(parent);
        this.treeViewer = super.getTreeViewer();
        this.treeViewer.setContentProvider((IContentProvider)new ILazyTreeContentProvider(){

            public void updateElement(@NotNull Object parent, int index) {
                if (parent == SQLEditorOutlinePage.this.editor.getEditorInput()) {
                    this.updateChildNode(parent, index, SQLEditorOutlinePage.this.rootNodes.get(index));
                } else if (parent instanceof OutlineNode) {
                    OutlineNode node = (OutlineNode)parent;
                    this.updateChildNode(parent, index, node.getChild(index));
                } else {
                    throw new IllegalStateException();
                }
            }

            private void updateChildNode(@NotNull Object parent, int index, OutlineNode childNode) {
                SQLEditorOutlinePage.this.treeViewer.replace(parent, index, (Object)childNode);
                SQLEditorOutlinePage.this.treeViewer.setChildCount((Object)childNode, childNode.getChildrenCount());
            }

            public void updateChildCount(@NotNull Object element, int currentChildCount) {
                if (element == SQLEditorOutlinePage.this.editor.getEditorInput()) {
                    SQLEditorOutlinePage.this.treeViewer.setChildCount(element, SQLEditorOutlinePage.this.rootNodes.size());
                } else if (element instanceof OutlineNode) {
                    OutlineNode node = (OutlineNode)element;
                    SQLEditorOutlinePage.this.treeViewer.setChildCount(element, node.getChildrenCount());
                } else {
                    throw new IllegalStateException();
                }
            }

            @Nullable
            public Object getParent(@NotNull Object element) {
                OutlineNode outlineNode;
                if (element instanceof OutlineNode) {
                    OutlineNode node = (OutlineNode)element;
                    outlineNode = node.getParent();
                } else {
                    outlineNode = null;
                }
                return outlineNode;
            }
        });
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new SQLOutlineLabelProvider(), null, null));
        this.treeViewer.setInput((Object)this.editor.getEditorInput());
        this.treeViewer.setAutoExpandLevel(3);
        TextViewer textViewer = this.editor.getTextViewer();
        if (textViewer != null) {
            textViewer.getTextWidget().addCaretListener(this.caretListener);
            textViewer.addTextInputListener(this.textInputListener);
        }
        this.editor.addPropertyListener(this.editorPropertyListener);
        SQLEditorHandlerToggleOutlineView.refreshCommandState((IServiceLocator)this.editor.getSite());
        this.refreshJob.schedule(true);
    }

    public void selectionChanged(@NotNull SelectionChangedEvent event) {
        OutlineNode node;
        IRegion textRange;
        IStructuredSelection selection;
        Object object;
        ISelection iSelection;
        if (this.currentSelectionSyncOp == SelectionSyncOperation.NONE && (iSelection = event.getSelection()) instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)iSelection).getFirstElement()) instanceof OutlineNode && (textRange = (node = (OutlineNode)object).getTextRange()) != null) {
            this.currentSelectionSyncOp = SelectionSyncOperation.TO_EDITOR;
            this.editor.selectAndReveal(textRange.getOffset(), textRange.getLength());
            this.currentSelectionSyncOp = SelectionSyncOperation.NONE;
        }
        super.selectionChanged(event);
    }

    @NotNull
    private String prepareQueryPreview(@NotNull SQLDocumentScriptItemSyntaxContext scriptElement) {
        return this.prepareQueryPreview(scriptElement.getOriginalText());
    }

    @NotNull
    private String prepareQueryPreview(@NotNull String queryOriginalText) {
        int queryOriginalLength = queryOriginalText.length();
        int queryPreviewLength = Math.min(queryOriginalLength, 100);
        StringBuilder result = new StringBuilder(queryPreviewLength);
        Throwable throwable = null;
        Object var6_7 = null;
        try (Scanner scanner = new Scanner(queryOriginalText);){
            while (scanner.hasNextLine() && result.length() < queryPreviewLength) {
                String line = scanner.nextLine().trim();
                int fragmentLength = Math.min(line.length(), queryPreviewLength - result.length());
                result.append(line, 0, fragmentLength).append(" ");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (result.length() < queryOriginalLength) {
            result.append(" ...");
        }
        return result.toString();
    }

    public void dispose() {
        this.editor.removePropertyListener(this.editorPropertyListener);
        TextViewer textViewer = this.editor.getTextViewer();
        if (textViewer != null) {
            textViewer.getTextWidget().removeCaretListener(this.caretListener);
            textViewer.removeTextInputListener(this.textInputListener);
        }
        this.scriptNode.dispose();
        super.dispose();
        SQLEditorHandlerToggleOutlineView.refreshCommandState((IServiceLocator)this.editor.getSite());
    }

    @NotNull
    private OutlineScriptElementNode getScriptElementNode(@NotNull OutlineQueryNode node) {
        OutlineNode n = node;
        while (n != null) {
            if (n instanceof OutlineScriptElementNode) {
                OutlineScriptElementNode e = (OutlineScriptElementNode)n;
                return e;
            }
            n = n.getParent();
        }
        throw new IllegalStateException();
    }

    private class OutlineInfoNode
    extends OutlineNode {
        @NotNull
        private final String title;
        @NotNull
        private final DBIcon icon;

        public OutlineInfoNode(@NotNull OutlineNode parentNode, @NotNull String title, DBIcon icon) {
            super(parentNode);
            this.title = title;
            this.icon = icon;
        }

        @Override
        @NotNull
        public String getText() {
            return this.title;
        }

        @NotNull
        public DBIcon getIcon() {
            return this.icon;
        }

        @Override
        @Nullable
        public OutlineNode getChild(int index) {
            return null;
        }

        @Override
        public int getChildrenCount() {
            return 0;
        }

        @Override
        @Nullable
        public IRegion getTextRange() {
            return null;
        }
    }

    private abstract class OutlineNode {
        @Nullable
        private final OutlineNode parentNode;

        public OutlineNode(OutlineNode parentNode) {
            this.parentNode = parentNode;
        }

        public abstract IRegion getTextRange();

        @Nullable
        public final OutlineNode getParent() {
            return this.parentNode;
        }

        public abstract String getText();

        public StyledString.Styler getTextStyler() {
            return null;
        }

        @Nullable
        public String getExtraText() {
            return null;
        }

        @Nullable
        public Image getImage() {
            DBPImage icon = this.getIcon();
            return icon == null ? null : DBeaverIcons.getImage((DBPImage)icon, (boolean)false);
        }

        protected abstract DBPImage getIcon();

        public abstract int getChildrenCount();

        public abstract OutlineNode getChild(int var1);
    }

    private class OutlineQueryNode
    extends OutlineNode {
        @NotNull
        private final SQLQueryNodeModel model;
        @NotNull
        private final OutlineQueryNodeKind kind;
        @NotNull
        private final String text;
        @Nullable
        private final StyledString.Styler textStyler;
        @Nullable
        private final String extraText;
        @NotNull
        private final DBPImage icon;
        @NotNull
        private final SQLQueryNodeModel[] childModels;
        @NotNull
        private final IRegion textRange;
        @Nullable
        private List<OutlineNode> children;

        public OutlineQueryNode(@NotNull OutlineNode parentNode, @NotNull SQLQueryNodeModel model, @NotNull OutlineQueryNodeKind kind, @Nullable String text, @Nullable StyledString.Styler textStyler, @NotNull String extraText, @NotNull DBPImage icon, SQLQueryNodeModel ... childModels) {
            int n;
            super(parentNode);
            this.model = model;
            this.kind = kind;
            this.text = text;
            this.textStyler = textStyler;
            this.extraText = extraText;
            this.icon = icon;
            this.childModels = childModels;
            if (parentNode instanceof OutlineScriptElementNode) {
                OutlineScriptElementNode element = (OutlineScriptElementNode)parentNode;
                n = element.getOffset() + this.model.getInterval().a;
            } else if (parentNode instanceof OutlineQueryNode) {
                OutlineQueryNode queryNode = (OutlineQueryNode)parentNode;
                n = queryNode.getTextRange().getOffset() - queryNode.model.getInterval().a + this.model.getInterval().a;
            } else {
                n = parentNode.getTextRange().getOffset();
            }
            int offset = n;
            this.textRange = new Region(offset, this.model.getInterval().length());
            this.children = null;
        }

        @Override
        @NotNull
        public IRegion getTextRange() {
            return this.textRange;
        }

        @NotNull
        private List<OutlineNode> obtainChildren() {
            if (this.children == null) {
                if (this.childModels.length == 0) {
                    this.children = Collections.emptyList();
                } else {
                    this.children = new ArrayList<OutlineNode>(this.childModels.length);
                    SQLQueryNodeModel[] sQLQueryNodeModelArray = this.childModels;
                    int n = this.childModels.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SQLQueryNodeModel childModel = sQLQueryNodeModelArray[n2];
                        if (childModel != null) {
                            childModel.apply((SQLQueryNodeModelVisitor)SQLEditorOutlinePage.this.getNodeBuilder(), (Object)this);
                        }
                        ++n2;
                    }
                }
            }
            return this.children;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        @Nullable
        public StyledString.Styler getTextStyler() {
            return this.textStyler;
        }

        @Override
        @Nullable
        public String getExtraText() {
            return this.extraText;
        }

        @Override
        @NotNull
        protected DBPImage getIcon() {
            return this.icon;
        }

        @Override
        public int getChildrenCount() {
            return this.obtainChildren().size();
        }

        @Override
        @NotNull
        public OutlineNode getChild(int index) {
            return this.obtainChildren().get(index);
        }
    }

    private static enum OutlineQueryNodeKind {
        DEFAULT,
        NATURAL_JOIN_SUBROOT,
        PROJECTION_SUBROOT,
        DELETE_SUBROOT,
        INSERT_SUBROOT,
        UPDATE_SUBROOT;

    }

    private class OutlineRefreshJob {
        @NotNull
        private final AtomicBoolean updateElements = new AtomicBoolean(false);
        @NotNull
        private final AbstractUIJob job = new AbstractUIJob("SQL editor outline refresh"){

            @NotNull
            protected IStatus runInUIThread(@NotNull DBRProgressMonitor monitor) {
                boolean doUpdateElements = OutlineRefreshJob.this.updateElements.getAndSet(false);
                if (((OutlineRefreshJob)OutlineRefreshJob.this).SQLEditorOutlinePage.this.treeViewer != null && !((OutlineRefreshJob)OutlineRefreshJob.this).SQLEditorOutlinePage.this.treeViewer.getTree().isDisposed()) {
                    if (doUpdateElements) {
                        ((OutlineRefreshJob)OutlineRefreshJob.this).SQLEditorOutlinePage.this.scriptNode.updateElements();
                    }
                    ((OutlineRefreshJob)OutlineRefreshJob.this).SQLEditorOutlinePage.this.scriptNode.updateChildren();
                    ((OutlineRefreshJob)OutlineRefreshJob.this).SQLEditorOutlinePage.this.treeViewer.refresh();
                }
                return Status.OK_STATUS;
            }
        };

        private OutlineRefreshJob() {
        }

        public void schedule(boolean updateElements) {
            this.updateElements.set(updateElements);
            switch (this.job.getState()) {
                case 1: 
                case 2: {
                    this.job.cancel();
                }
            }
            this.job.schedule(500L);
        }
    }

    private class OutlineScriptElementNode
    extends OutlineQueryNode {
        private final int offset;
        @NotNull
        private final SQLDocumentScriptItemSyntaxContext scriptElement;

        public OutlineScriptElementNode(OutlineScriptNode parent, @NotNull int offset, SQLDocumentScriptItemSyntaxContext scriptElement) {
            super(parent, (SQLQueryNodeModel)scriptElement.getQueryModel(), OutlineQueryNodeKind.DEFAULT, SQLEditorOutlinePage.this.prepareQueryPreview(scriptElement), null, null, (DBPImage)UIIcon.SQL_EXECUTE, new SQLQueryNodeModel[]{scriptElement.getQueryModel()});
            this.offset = offset;
            this.scriptElement = scriptElement;
        }

        public int getOffset() {
            return this.offset;
        }

        @Override
        @NotNull
        public IRegion getTextRange() {
            return new Region(this.offset, 0);
        }
    }

    private class OutlineScriptNode
    extends OutlineNode {
        @Nullable
        private SQLDocumentSyntaxContext documentContext;
        @Nullable
        private Image editorImage;
        @Nullable
        private Image outlineImage;
        @NotNull
        private final OutlineNode noElementsNode;
        @NotNull
        private final OutlineNode analysisDisabledNode;
        @NotNull
        private Map<SQLDocumentScriptItemSyntaxContext, OutlineNode> elements;
        @NotNull
        private List<OutlineNode> children;
        @NotNull
        private final SQLDocumentSyntaxContextListener syntaxContextListener;

        public OutlineScriptNode() {
            super(null);
            this.editorImage = null;
            this.outlineImage = null;
            this.noElementsNode = new OutlineInfoNode(this, SQLEditorMessages.sql_editor_outline_no_elements_label, DBIcon.SMALL_INFO);
            this.analysisDisabledNode = new OutlineInfoNode(this, SQLEditorMessages.sql_editor_outline_query_analysis_disabled_label, DBIcon.SMALL_INFO);
            this.elements = new HashMap<SQLDocumentScriptItemSyntaxContext, OutlineNode>();
            this.children = Collections.emptyList();
            this.syntaxContextListener = new SQLDocumentSyntaxContextListener(){

                public void onScriptItemInvalidated(@Nullable SQLDocumentScriptItemSyntaxContext item) {
                    ((OutlineScriptNode)OutlineScriptNode.this).SQLEditorOutlinePage.this.refreshJob.schedule(true);
                }

                public void onScriptItemIntroduced(@Nullable SQLDocumentScriptItemSyntaxContext item) {
                    ((OutlineScriptNode)OutlineScriptNode.this).SQLEditorOutlinePage.this.refreshJob.schedule(true);
                }

                public void onAllScriptItemsInvalidated() {
                    ((OutlineScriptNode)OutlineScriptNode.this).SQLEditorOutlinePage.this.refreshJob.schedule(true);
                }
            };
            if (SQLEditorOutlinePage.this.editor.isAdvancedHighlightingEnabled() && SQLEditorUtils.isSQLSyntaxParserEnabled(SQLEditorOutlinePage.this.editor.getEditorInput())) {
                this.documentContext = SQLEditorOutlinePage.this.editor.getSyntaxContext();
                if (this.documentContext != null) {
                    this.documentContext.addListener(this.syntaxContextListener);
                }
            }
        }

        @Override
        @NotNull
        public IRegion getTextRange() {
            return new Region(0, 0);
        }

        private void updateElements() {
            if (this.documentContext != null) {
                this.elements = this.documentContext.getScriptItems().stream().collect(Collectors.toMap(e -> e.item, e -> new OutlineScriptElementNode(this, e.offset, e.item), (a, b) -> a, LinkedHashMap::new));
            }
        }

        private void updateChildren() {
            if (SQLEditorOutlinePage.this.editor.isAdvancedHighlightingEnabled() && SQLEditorUtils.isSQLSyntaxParserEnabled(SQLEditorOutlinePage.this.editor.getEditorInput())) {
                if (this.documentContext == null || SQLEditorOutlinePage.this.editor.getSyntaxContext() != this.documentContext) {
                    if (this.documentContext != null) {
                        this.documentContext.removeListener(this.syntaxContextListener);
                    }
                    this.documentContext = SQLEditorOutlinePage.this.editor.getSyntaxContext();
                    if (this.documentContext != null) {
                        this.documentContext.addListener(this.syntaxContextListener);
                    }
                }
                this.children = this.elements.isEmpty() ? List.of(this.noElementsNode) : List.copyOf(this.elements.values());
            } else {
                this.children = List.of(this.analysisDisabledNode);
            }
        }

        @Override
        public int getChildrenCount() {
            return this.children.size();
        }

        @Override
        @NotNull
        public OutlineNode getChild(int index) {
            return this.children.get(index);
        }

        @Override
        @NotNull
        public String getText() {
            return SQLEditorOutlinePage.this.editor.getTitle();
        }

        @Override
        @NotNull
        public Image getImage() {
            Image image = SQLEditorOutlinePage.this.editor.getTitleImage();
            if (this.editorImage != image) {
                if (this.outlineImage != null) {
                    this.outlineImage.dispose();
                }
                this.outlineImage = new Image(image.getDevice(), image, 0);
                this.editorImage = image;
            }
            return this.outlineImage;
        }

        @NotNull
        protected DBIcon getIcon() {
            return DBIcon.TREE_SCRIPT;
        }

        public void dispose() {
            if (this.documentContext != null) {
                this.documentContext.removeListener(this.syntaxContextListener);
            }
            if (this.outlineImage != null && !this.outlineImage.isDisposed()) {
                this.outlineImage.dispose();
            }
        }
    }

    private static class SQLOutlineLabelProvider
    implements ILabelProvider,
    IFontProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private SQLOutlineLabelProvider() {
        }

        public void addListener(@Nullable ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(@Nullable Object element, @Nullable String property) {
            return property != null && property.equals(SQLEditorOutlinePage.LABEL_PROPERTY_KEY);
        }

        public void removeListener(@Nullable ILabelProviderListener listener) {
        }

        @Nullable
        public Font getFont(@Nullable Object element) {
            return null;
        }

        @Nullable
        public Image getImage(@NotNull Object element) {
            Image image;
            if (element instanceof OutlineNode) {
                OutlineNode node = (OutlineNode)element;
                image = node.getImage();
            } else {
                image = DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_UNKNOWN, (boolean)false);
            }
            return image;
        }

        @NotNull
        public String getText(@NotNull Object element) {
            String string;
            if (element instanceof OutlineNode) {
                OutlineNode node = (OutlineNode)element;
                string = node.getText();
            } else {
                string = element.toString();
            }
            return string;
        }

        @NotNull
        public StyledString getStyledText(@NotNull Object element) {
            StyledString result = new StyledString();
            if (element instanceof OutlineNode) {
                String extra;
                OutlineNode node = (OutlineNode)element;
                String text = node.getText();
                result.append(text);
                StyledString.Styler styler = node.getTextStyler();
                if (styler != null) {
                    result.setStyle(0, text.length(), styler);
                }
                if ((extra = node.getExtraText()) != null) {
                    result.append(extra);
                    result.setStyle(text.length(), extra.length(), StyledString.DECORATIONS_STYLER);
                }
            } else {
                result.append(element.toString());
            }
            return result;
        }

        public void dispose() {
        }
    }

    private static interface SQLOutlineNodeBuilder
    extends SQLQueryNodeModelVisitor<OutlineQueryNode, Object> {
    }

    private class SQLOutlineNodeFullBuilder
    implements SQLOutlineNodeBuilder {
        @NotNull
        private static final Map<SQLQueryExprType, DBIcon> wellKnownTypeIcons = Map.of(SQLQueryExprType.UNKNOWN, DBIcon.TYPE_UNKNOWN, SQLQueryExprType.STRING, DBIcon.TYPE_STRING, SQLQueryExprType.BOOLEAN, DBIcon.TYPE_BOOLEAN, SQLQueryExprType.NUMERIC, DBIcon.TYPE_NUMBER, SQLQueryExprType.DATETIME, DBIcon.TYPE_DATETIME);

        private SQLOutlineNodeFullBuilder() {
        }

        @Nullable
        public Object visitRowsCte(@NotNull SQLQueryRowsCteModel cte, @NotNull OutlineQueryNode node) {
            this.makeNode(node, (SQLQueryNodeModel)cte, "CTE", (DBPImage)DBIcon.TREE_FOLDER_LINK, (SQLQueryNodeModel[])cte.getAllQueries().toArray(SQLQueryRowsSourceModel[]::new));
            return null;
        }

        @Nullable
        public Object visitRowsCteSubquery(@NotNull SQLQueryRowsCteSubqueryModel cteSubquery, @NotNull OutlineQueryNode node) {
            String text = cteSubquery.subqueryName == null ? "?" : cteSubquery.subqueryName.getRawName();
            SQLQueryRowsSourceModel[] children = (SQLQueryRowsSourceModel[])Stream.of(cteSubquery.source).filter(Objects::nonNull).toArray(SQLQueryRowsSourceModel[]::new);
            this.makeNode(node, (SQLQueryNodeModel)cteSubquery, text, (DBPImage)DBIcon.TREE_TABLE_LINK, (SQLQueryNodeModel[])children);
            return null;
        }

        @Nullable
        public Object visitValueSubqueryExpr(@NotNull SQLQueryValueSubqueryExpression subqueryExpr, @NotNull OutlineQueryNode node) {
            this.makeNode(node, (SQLQueryNodeModel)subqueryExpr, "Scalar subquery", (DBPImage)UIIcon.FILTER_VALUE, new SQLQueryNodeModel[]{subqueryExpr.getSource()});
            return null;
        }

        @Nullable
        public Object visitValueFlatExpr(@NotNull SQLQueryValueFlattenedExpression flattenedExpr, @NotNull OutlineQueryNode node) {
            switch (flattenedExpr.getOperands().size()) {
                case 0: {
                    break;
                }
                case 1: {
                    ((SQLQueryValueExpression)flattenedExpr.getOperands().get(0)).apply((SQLQueryNodeModelVisitor)this, (Object)node);
                    break;
                }
                default: {
                    this.makeNode(node, (SQLQueryNodeModel)flattenedExpr, SQLEditorOutlinePage.this.prepareQueryPreview(flattenedExpr.getExprContent()), (DBPImage)DBIcon.TREE_FUNCTION, (SQLQueryNodeModel[])flattenedExpr.getOperands().toArray(SQLQueryNodeModel[]::new));
                }
            }
            return null;
        }

        @Nullable
        public Object visitValueFunctionExpr(@NotNull SQLQueryValueFunctionExpression funcExpr, OutlineQueryNode node) {
            String nameString = funcExpr.getProcName() == null ? "?" : funcExpr.getProcName().getNameString();
            String argsString = funcExpr.getOperands().isEmpty() ? "()" : "(...)";
            this.makeNode(node, (SQLQueryNodeModel)funcExpr, nameString + argsString, this.obtainExprTypeNameString((SQLQueryValueExpression)funcExpr), (DBPImage)DBIcon.TREE_PROCEDURE, (SQLQueryNodeModel[])funcExpr.getOperands().toArray(SQLQueryNodeModel[]::new));
            return null;
        }

        @Nullable
        public Object visitValueVariableExpr(@NotNull SQLQueryValueVariableExpression varExpr, @NotNull OutlineQueryNode node) {
            DBIcon icon = switch (varExpr.getKind()) {
                case SQLQueryValueVariableExpression.VariableExpressionKind.BATCH_VARIABLE -> UIIcon.SQL_VARIABLE2;
                case SQLQueryValueVariableExpression.VariableExpressionKind.CLIENT_PARAMETER -> UIIcon.SQL_PARAMETER;
                case SQLQueryValueVariableExpression.VariableExpressionKind.CLIENT_VARIABLE -> UIIcon.SQL_PARAMETER;
                default -> throw new MatchException(null, null);
            };
            this.makeNode(node, (SQLQueryNodeModel)varExpr, SQLEditorOutlinePage.this.prepareQueryPreview(varExpr.getRawName()), (DBPImage)icon, new SQLQueryNodeModel[0]);
            return null;
        }

        @Nullable
        public Object visitValueColumnRefExpr(@NotNull SQLQueryValueColumnReferenceExpression columnRefExpr, @NotNull OutlineQueryNode node) {
            DBIcon icon;
            String extraText;
            String text;
            SQLQuerySymbol columnName = columnRefExpr.getColumnNameIfTrivialExpression();
            if (columnName != null) {
                SQLQuerySymbolEntry s;
                SQLQuerySymbolDefinition def = columnName.getDefinition();
                while (def instanceof SQLQuerySymbolEntry && (s = (SQLQuerySymbolEntry)def) != s.getDefinition()) {
                    def = s.getDefinition();
                }
                text = columnRefExpr.getColumnName() != null ? columnRefExpr.getColumnName().getRawName() : "?";
                extraText = this.obtainExprTypeNameString((SQLQueryValueExpression)columnRefExpr);
                icon = this.obtainExprTypeIcon((SQLQueryValueExpression)columnRefExpr);
            } else {
                text = "?";
                extraText = null;
                icon = DBIcon.TYPE_UNKNOWN;
            }
            this.makeNode(node, (SQLQueryNodeModel)columnRefExpr, text, extraText, (DBPImage)icon, new SQLQueryNodeModel[0]);
            return null;
        }

        @Nullable
        public Object visitValueTupleRefExpr(@NotNull SQLQueryValueTupleReferenceExpression tupleRefExpr, @NotNull OutlineQueryNode node) {
            SQLQueryComplexName tableName = tupleRefExpr.getTableName();
            String extraText = this.obtainExprTypeNameString((SQLQueryValueExpression)tupleRefExpr);
            DBPImage icon = this.obtainExprTypeIcon((SQLQueryValueExpression)tupleRefExpr);
            this.makeNode(node, (SQLQueryNodeModel)tupleRefExpr, tableName.getNameString(), extraText, icon, new SQLQueryNodeModel[0]);
            return null;
        }

        @Nullable
        public Object visitValueReferenceExpr(@NotNull SQLQueryValueReferenceExpression valueRefExpr, @NotNull OutlineQueryNode node) {
            DBIcon icon;
            String extraText;
            String text;
            SQLQuerySymbol columnName = valueRefExpr.getColumnNameIfTrivialExpression();
            if (columnName != null) {
                SQLQuerySymbolEntry s;
                SQLQuerySymbolDefinition def = columnName.getDefinition();
                while (def instanceof SQLQuerySymbolEntry && (s = (SQLQuerySymbolEntry)def) != s.getDefinition()) {
                    def = s.getDefinition();
                }
                text = valueRefExpr.getName() != null ? valueRefExpr.getName().getNameString() : "?";
                extraText = this.obtainExprTypeNameString((SQLQueryValueExpression)valueRefExpr);
                icon = this.obtainExprTypeIcon((SQLQueryValueExpression)valueRefExpr);
            } else {
                text = "?";
                extraText = null;
                icon = DBIcon.TYPE_UNKNOWN;
            }
            this.makeNode(node, (SQLQueryNodeModel)valueRefExpr, text, extraText, (DBPImage)icon, new SQLQueryNodeModel[0]);
            return null;
        }

        @Nullable
        public Object visitValueMemberReferenceExpr(@NotNull SQLQueryValueMemberExpression memberRefExpr, @NotNull OutlineQueryNode node) {
            String text = SQLEditorOutlinePage.this.prepareQueryPreview(memberRefExpr.getExprContent());
            String extraText = this.obtainExprTypeNameString((SQLQueryValueExpression)memberRefExpr);
            DBPImage icon = this.obtainExprTypeIcon((SQLQueryValueExpression)memberRefExpr);
            this.makeNode(node, (SQLQueryNodeModel)memberRefExpr, text, extraText, icon, new SQLQueryNodeModel[]{memberRefExpr.getMemberOwner()});
            return null;
        }

        @Nullable
        public Object visitValueIndexingExpr(@NotNull SQLQueryValueIndexingExpression indexingExpr, @NotNull OutlineQueryNode node) {
            String text = SQLEditorOutlinePage.this.prepareQueryPreview(indexingExpr.getExprContent());
            String extraText = this.obtainExprTypeNameString((SQLQueryValueExpression)indexingExpr);
            DBPImage icon = this.obtainExprTypeIcon((SQLQueryValueExpression)indexingExpr);
            this.makeNode(node, (SQLQueryNodeModel)indexingExpr, text, extraText, icon, new SQLQueryNodeModel[]{indexingExpr.getMemberOwner()});
            return null;
        }

        @Nullable
        public Object visitValueTypeCastExpr(@NotNull SQLQueryValueTypeCastExpression typeCastExpr, @NotNull OutlineQueryNode node) {
            typeCastExpr.getValueExpr().apply((SQLQueryNodeModelVisitor)this, (Object)node);
            return null;
        }

        @Nullable
        public Object visitValueConstantExpr(@NotNull SQLQueryValueConstantExpression constExpr, @NotNull OutlineQueryNode node) {
            String extraText = this.obtainExprTypeNameString((SQLQueryValueExpression)constExpr);
            DBPImage icon = this.obtainExprTypeIcon((SQLQueryValueExpression)constExpr);
            this.makeNode(node, (SQLQueryNodeModel)constExpr, constExpr.getValueString(), extraText, icon, new SQLQueryNodeModel[0]);
            return null;
        }

        @Nullable
        private String obtainExprTypeNameString(@NotNull SQLQueryValueExpression expr) {
            return this.obtainExprTypeNameString(expr.getValueType());
        }

        @Nullable
        private String obtainExprTypeNameString(@Nullable SQLQueryExprType type) {
            String typeName = type == null || type == SQLQueryExprType.UNKNOWN ? null : type.getDisplayName();
            return typeName == null ? null : " : " + typeName;
        }

        @NotNull
        private DBPImage obtainExprTypeIcon(@NotNull SQLQueryValueExpression expr) {
            return this.obtainExprTypeIcon(expr.getValueType());
        }

        @NotNull
        private DBPImage obtainExprTypeIcon(@Nullable SQLQueryExprType type) {
            return type == null ? DBIcon.TYPE_UNKNOWN : (type.getTypedDbObject() != null ? DBValueFormatting.getTypeImage((DBSTypedObject)type.getTypedDbObject()) : (DBPImage)wellKnownTypeIcons.getOrDefault(type, DBIcon.TYPE_UNKNOWN));
        }

        @Nullable
        public Object visitSelectionResult(@NotNull SQLQuerySelectionResultModel selectionResult, @NotNull OutlineQueryNode node) {
            selectionResult.getSublists().forEach(s -> {
                Object object = s.apply((SQLQueryNodeModelVisitor)this, (Object)node);
            });
            return null;
        }

        @Nullable
        public Object visitSelectionModel(@NotNull SQLQueryModel selection, @NotNull OutlineQueryNode node) {
            if (selection.getQueryModel() != null) {
                selection.getQueryModel().apply((SQLQueryNodeModelVisitor)this, (Object)node);
            }
            return null;
        }

        @Nullable
        public Object visitRowsTableData(@NotNull SQLQueryRowsTableDataModel tableData, @NotNull OutlineQueryNode node) {
            DBIcon icon;
            DBSEntity table = tableData.getTable();
            Object object = icon = tableData.getReferencedSource() != null ? DBIcon.TREE_TABLE_LINK : DBValueFormatting.getObjectImage((DBPObject)table);
            String text = table == null ? (tableData.getName() == null ? "?" : tableData.getName().getNameString()) : DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DML);
            this.makeNode(node, (SQLQueryNodeModel)tableData, text, (DBPImage)icon, new SQLQueryNodeModel[0]);
            return null;
        }

        @Nullable
        public Object visitRowsTableValue(@NotNull SQLQueryRowsTableValueModel tableValue, @NotNull OutlineQueryNode node) {
            this.makeNode(node, (SQLQueryNodeModel)tableValue, "VALUES", (DBPImage)UIIcon.ROW_COPY, (SQLQueryNodeModel[])tableValue.getValues().toArray(SQLQueryNodeModel[]::new));
            return null;
        }

        @Nullable
        public Object visitRowsTableProc(@NotNull SQLQueryRowsTableProcModel tableProc, @NotNull OutlineQueryNode node) {
            tableProc.getFunctionExpression().apply((SQLQueryNodeModelVisitor)this, (Object)node);
            return null;
        }

        @Nullable
        public Object visitRowsCrossJoin(@NotNull SQLQueryRowsCrossJoinModel crossJoin, @NotNull OutlineQueryNode node) {
            List<SQLQueryNodeModel> children = this.flattenRowSetsCombination(crossJoin, x -> true, (x, l) -> {});
            this.makeNode(node, (SQLQueryNodeModel)crossJoin, "CROSS JOIN", (DBPImage)DBIcon.TREE_TABLE_LINK, (SQLQueryNodeModel[])children.toArray(SQLQueryNodeModel[]::new));
            return null;
        }

        @Nullable
        public Object visitRowsCorrelatedSource(@NotNull SQLQueryRowsCorrelatedSourceModel correlated, @NotNull OutlineQueryNode node) {
            SQLQueryRowsTableDataModel t;
            List columnNames = correlated.getCorrelationColumNames();
            String suffix = columnNames.isEmpty() ? "" : columnNames.stream().map(SQLQuerySymbolEntry::getRawName).collect(Collectors.joining(", ", " (", ")"));
            SQLQueryRowsSourceModel sQLQueryRowsSourceModel = correlated.getSource();
            String prefix = sQLQueryRowsSourceModel instanceof SQLQueryRowsTableDataModel ? ((t = (SQLQueryRowsTableDataModel)sQLQueryRowsSourceModel).getName() == null ? "?" : t.getName().getNameString()) + " AS " : "";
            this.makeNode(node, (SQLQueryNodeModel)correlated, prefix + correlated.getAlias().getRawName() + suffix, (DBPImage)DBIcon.TREE_TABLE_ALIAS, new SQLQueryNodeModel[]{correlated.getSource()});
            return null;
        }

        @Nullable
        public Object visitRowsNaturalJoin(@NotNull SQLQueryRowsNaturalJoinModel naturalJoin, @NotNull OutlineQueryNode node) {
            switch (node.kind) {
                case NATURAL_JOIN_SUBROOT: {
                    if (naturalJoin.getCondition() != null) {
                        this.makeNode(node, (SQLQueryNodeModel)naturalJoin.getCondition(), "ON ", (DBPImage)DBIcon.TREE_UNIQUE_KEY, new SQLQueryNodeModel[]{naturalJoin.getCondition()});
                        break;
                    }
                    if (naturalJoin.getColumnsToJoin() == null || naturalJoin.getColumnsToJoin().isEmpty()) break;
                    String suffix = naturalJoin.getColumnsToJoin().stream().map(SQLQuerySymbolEntry::getRawName).collect(Collectors.joining(", ", "(", ")"));
                    this.makeNode(node, (SQLQueryNodeModel)naturalJoin, "USING " + suffix, (DBPImage)DBIcon.TREE_UNIQUE_KEY, new SQLQueryNodeModel[0]);
                    break;
                }
                default: {
                    List<SQLQueryNodeModel> children = this.flattenRowSetsCombination(naturalJoin, x -> true, (x, l) -> {
                        boolean bl = l.add(x);
                    });
                    this.makeNode(node, (SQLQueryNodeModel)naturalJoin, OutlineQueryNodeKind.NATURAL_JOIN_SUBROOT, "NATURAL JOIN ", (DBPImage)DBIcon.TREE_TABLE_LINK, (SQLQueryNodeModel[])children.toArray(SQLQueryNodeModel[]::new));
                }
            }
            return null;
        }

        @NotNull
        private <T extends SQLQueryRowsSetOperationModel> List<SQLQueryNodeModel> flattenRowSetsCombination(@NotNull T op, @NotNull Predicate<T> predicate, @NotNull BiConsumer<T, List<SQLQueryNodeModel>> action) {
            LinkedList<SQLQueryNodeModel> result = new LinkedList<SQLQueryNodeModel>();
            this.flattenRowSetsCombinationImpl(op.getClass(), op, predicate, result, action);
            return result;
        }

        private <T extends SQLQueryRowsSetOperationModel> void flattenRowSetsCombinationImpl(@NotNull Class<? extends SQLQueryRowsSetOperationModel> type, @NotNull T op, @NotNull Predicate<T> predicate, @NotNull List<SQLQueryNodeModel> result, @NotNull BiConsumer<T, List<SQLQueryNodeModel>> action) {
            SQLQueryRowsSourceModel left = op.getLeft();
            if (type.isInstance(left) && predicate.test((SQLQueryRowsSetOperationModel)left)) {
                this.flattenRowSetsCombinationImpl(type, (SQLQueryRowsSetOperationModel)left, predicate, result, action);
            } else {
                result.add((SQLQueryNodeModel)left);
            }
            if (op.getRight() != null) {
                result.add((SQLQueryNodeModel)op.getRight());
            }
            action.accept(op, result);
        }

        public Object visitRowsProjectionInto(@NotNull SQLQuerySelectIntoModel selectIntoStatement, @NotNull OutlineQueryNode node) {
            return this.visitRowsProjectionImpl((SQLQueryRowsProjectionModel)selectIntoStatement, node, selectIntoStatement.getTargets());
        }

        @Nullable
        public Object visitRowsProjection(@NotNull SQLQueryRowsProjectionModel projection, @NotNull OutlineQueryNode node) {
            return this.visitRowsProjectionImpl(projection, node, null);
        }

        private Object visitRowsProjectionImpl(@NotNull SQLQueryRowsProjectionModel projection, @NotNull OutlineQueryNode node, @Nullable SQLQuerySelectIntoModel.SQLQuerySelectIntoTargetsList targetsList) {
            if (node.kind == OutlineQueryNodeKind.PROJECTION_SUBROOT || node instanceof OutlineScriptElementNode) {
                String suffix = projection.getRowsDataContext().getColumnsList().stream().map(c -> c.symbol.getName()).collect(Collectors.joining(", ", "(", ")"));
                this.makeNode(node, (SQLQueryNodeModel)projection.getResult(), "SELECT " + suffix, (DBPImage)DBIcon.TREE_COLUMNS, new SQLQueryNodeModel[]{projection.getResult()});
                if (targetsList != null) {
                    this.makeNode(node, (SQLQueryNodeModel)targetsList, "INTO", (DBPImage)DBIcon.TREE_FOLDER_TABLE, new SQLQueryNodeModel[]{targetsList});
                }
                this.makeNode(node, (SQLQueryNodeModel)projection.getFromSource(), "FROM", (DBPImage)DBIcon.TREE_FOLDER_TABLE, new SQLQueryNodeModel[]{projection.getFromSource()});
                if (projection.getWhereClause() != null) {
                    this.makeNode(node, (SQLQueryNodeModel)projection.getWhereClause(), "WHERE", (DBPImage)UIIcon.FILTER, new SQLQueryNodeModel[]{projection.getWhereClause()});
                }
                if (projection.getGroupByClause() != null) {
                    this.makeNode(node, (SQLQueryNodeModel)projection.getGroupByClause(), "GROUP BY", (DBPImage)UIIcon.GROUP_BY_ATTR, new SQLQueryNodeModel[]{projection.getGroupByClause()});
                }
                if (projection.getHavingClause() != null) {
                    this.makeNode(node, (SQLQueryNodeModel)projection.getHavingClause(), "HAVING", (DBPImage)UIIcon.FILTER, new SQLQueryNodeModel[]{projection.getHavingClause()});
                }
                if (projection.getOrderByClause() != null) {
                    this.makeNode(node, (SQLQueryNodeModel)projection.getOrderByClause(), "ORDER BY", (DBPImage)UIIcon.SORT, new SQLQueryNodeModel[]{projection.getOrderByClause()});
                }
            } else {
                String text = SQLEditorOutlinePage.this.prepareQueryPreview(projection.getSyntaxNode().getTextContent());
                this.makeNode(node, (SQLQueryNodeModel)projection, OutlineQueryNodeKind.PROJECTION_SUBROOT, text, (DBPImage)DBIcon.TREE_TABLE_LINK, new SQLQueryNodeModel[]{projection});
            }
            return null;
        }

        public Object visitRowsProjectionIntoTargetsList(@NotNull SQLQuerySelectIntoModel.SQLQuerySelectIntoTargetsList targetsList, @NotNull OutlineQueryNode arg) {
            targetsList.getTargetNodes().forEach(t -> {
                Object object = t.apply((SQLQueryNodeModelVisitor)this, (Object)arg);
            });
            return null;
        }

        @Nullable
        public Object visitCallStatement(@NotNull SQLQueryCallModel callStatement, OutlineQueryNode node) {
            SQLQueryObjectDataModel obj = callStatement.getObject();
            if (obj != null) {
                obj.apply((SQLQueryNodeModelVisitor)this, (Object)node);
            }
            return null;
        }

        @Nullable
        public Object visitCommand(@NotNull SQLCommandModel command, OutlineQueryNode arg) {
            this.makeNode(arg, (SQLQueryNodeModel)command, command.getCommandText(), (DBPImage)UIIcon.SQL_CONSOLE, (SQLQueryNodeModel[])command.getVariables());
            return null;
        }

        @Nullable
        public Object visitCommandVariable(@NotNull SQLCommandModel.VariableNode variable, OutlineQueryNode arg) {
            this.makeNode(arg, (SQLQueryNodeModel)variable, variable.name.getName() + " = " + variable.value, (DBPImage)UIIcon.SQL_PARAMETER, new SQLQueryNodeModel[0]);
            return null;
        }

        @Nullable
        public Object visitRowsSetCorrespondingOp(@NotNull SQLQueryRowsSetCorrespondingOperationModel correspondingOp, @NotNull OutlineQueryNode arg) {
            List<SQLQueryNodeModel> children = this.flattenRowSetsCombination(correspondingOp, x -> x.getKind().equals((Object)correspondingOp.getKind()), (x, l) -> {});
            this.makeNode(arg, (SQLQueryNodeModel)correspondingOp, correspondingOp.getKind().toString(), (DBPImage)DBIcon.TREE_TABLE_LINK, (SQLQueryNodeModel[])children.toArray(SQLQueryNodeModel[]::new));
            return null;
        }

        @Nullable
        public Object visitSelectCompleteTupleSpec(@NotNull SQLQuerySelectionResultCompleteTupleSpec completeTupleSpec, @NotNull OutlineQueryNode arg) {
            this.makeNode(arg, (SQLQueryNodeModel)completeTupleSpec, "*", (DBPImage)UIIcon.ASTERISK, new SQLQueryNodeModel[0]);
            return null;
        }

        @Nullable
        public Object visitSelectTupleSpec(@NotNull SQLQuerySelectionResultTupleSpec tupleSpec, @NotNull OutlineQueryNode arg) {
            OutlineQueryNode tupleNode = this.makeNode(arg, (SQLQueryNodeModel)tupleSpec, tupleSpec.getTableName().getNameString() + ".*", (DBPImage)UIIcon.ASTERISK, new SQLQueryNodeModel[0]);
            SQLQueryRowsSourceModel rowsSource = tupleSpec.getTupleSource();
            SQLQueryRowsDataContext rowsData = rowsSource == null ? null : rowsSource.getRowsDataContext();
            List tupleColumns = rowsData != null ? rowsData.getColumnsList() : Collections.emptyList();
            tupleNode.children = new ArrayList<OutlineNode>(tupleColumns.size());
            for (SQLQueryResultColumn column : tupleColumns) {
                StyledString.Styler styler = stylerBySymbolClass.get(column.symbol.getSymbolClass());
                tupleNode.children.add(new OutlineQueryNode(tupleNode, (SQLQueryNodeModel)tupleSpec, OutlineQueryNodeKind.DEFAULT, column.symbol.getName(), styler, this.obtainExprTypeNameString(column.type), this.obtainExprTypeIcon(column.type), new SQLQueryNodeModel[0]));
            }
            return null;
        }

        @Nullable
        public Object visitSelectColumnSpec(@NotNull SQLQuerySelectionResultColumnSpec columnSpec, @NotNull OutlineQueryNode arg) {
            SQLQuerySymbol mayBeColumnName;
            SQLQuerySymbolEntry alias = columnSpec.getAlias();
            SQLQueryValueExpression mayBeExpr = columnSpec.getValueExpression();
            SQLQuerySymbol sQLQuerySymbol = mayBeColumnName = mayBeExpr == null ? null : mayBeExpr.getColumnNameIfTrivialExpression();
            String text = alias != null ? alias.getRawName() : (mayBeColumnName != null ? mayBeColumnName.getName() : SQLEditorOutlinePage.this.getScriptElementNode((OutlineQueryNode)arg).scriptElement.getOriginalText().substring(columnSpec.getInterval().a, columnSpec.getInterval().b + 1));
            String extraText = mayBeExpr == null ? null : this.obtainExprTypeNameString(mayBeExpr);
            SQLQueryNodeModel[] subnodes = (SQLQueryNodeModel[])Stream.of(mayBeExpr).filter(Objects::nonNull).toArray(SQLQueryNodeModel[]::new);
            this.makeNode(arg, (SQLQueryNodeModel)columnSpec, text, extraText, (DBPImage)DBIcon.TREE_COLUMN, subnodes);
            return null;
        }

        @Nullable
        public Object visitTableStatementDelete(@NotNull SQLQueryDeleteModel deleteStatement, @NotNull OutlineQueryNode node) {
            if (node.kind == OutlineQueryNodeKind.DELETE_SUBROOT) {
                if (deleteStatement.getCondition() != null) {
                    this.makeNode(node, (SQLQueryNodeModel)deleteStatement.getCondition(), "WHERE", (DBPImage)UIIcon.FILTER, new SQLQueryNodeModel[]{deleteStatement.getCondition()});
                }
            } else {
                String tableName = deleteStatement.getTableModel() == null || deleteStatement.getTableModel().getName() == null ? "?" : deleteStatement.getTableModel().getName().getNameString();
                String nodeName = "DELETE FROM " + tableName;
                this.makeNode(node, (SQLQueryNodeModel)deleteStatement, OutlineQueryNodeKind.DELETE_SUBROOT, nodeName, (DBPImage)UIIcon.ROW_DELETE, new SQLQueryNodeModel[]{deleteStatement.getAliasedTableModel() != null ? deleteStatement.getAliasedTableModel() : deleteStatement.getTableModel(), deleteStatement});
            }
            return null;
        }

        @Nullable
        public Object visitTableStatementInsert(@NotNull SQLQueryInsertModel insertStatement, @NotNull OutlineQueryNode node) {
            if (node.kind == OutlineQueryNodeKind.INSERT_SUBROOT) {
                if (insertStatement.getValuesRows() != null) {
                    insertStatement.getValuesRows().apply((SQLQueryNodeModelVisitor)this, (Object)node);
                }
            } else {
                String tableName = insertStatement.getTableModel() == null || insertStatement.getTableModel().getName() == null ? "?" : insertStatement.getTableModel().getName().getNameString();
                List columnNames = insertStatement.getColumnNames();
                String columns = columnNames == null ? "" : columnNames.stream().map(SQLQuerySymbolEntry::getName).collect(Collectors.joining(", ", "(", ")"));
                String nodeName = "INSERT INTO " + tableName + columns;
                this.makeNode(node, (SQLQueryNodeModel)insertStatement, OutlineQueryNodeKind.INSERT_SUBROOT, nodeName, (DBPImage)UIIcon.ROW_ADD, new SQLQueryNodeModel[]{insertStatement.getTableModel(), insertStatement});
            }
            return null;
        }

        @Nullable
        public Object visitTableStatementUpdate(@NotNull SQLQueryUpdateModel updateStatement, @NotNull OutlineQueryNode node) {
            switch (node.kind) {
                case UPDATE_SUBROOT: {
                    if (updateStatement.getSetClauseList() != null) {
                        this.makeNode(node, (SQLQueryNodeModel)updateStatement, "SET", (DBPImage)DBIcon.TREE_FOLDER_LINK, (SQLQueryNodeModel[])updateStatement.getSetClauseList().toArray(SQLQueryNodeModel[]::new));
                    }
                    if (updateStatement.getSourceRows() != null) {
                        this.makeNode(node, (SQLQueryNodeModel)updateStatement.getSourceRows(), "FROM", (DBPImage)DBIcon.TREE_FOLDER_TABLE, new SQLQueryNodeModel[]{updateStatement.getSourceRows()});
                    }
                    if (updateStatement.getWhereClause() != null) {
                        this.makeNode(node, (SQLQueryNodeModel)updateStatement.getWhereClause(), "WHERE", (DBPImage)UIIcon.FILTER, new SQLQueryNodeModel[]{updateStatement.getWhereClause()});
                    }
                    if (updateStatement.getOrderByClause() == null) break;
                    this.makeNode(node, (SQLQueryNodeModel)updateStatement.getOrderByClause(), "ORDER BY", (DBPImage)UIIcon.SORT, new SQLQueryNodeModel[]{updateStatement.getOrderByClause()});
                    break;
                }
                default: {
                    SQLQueryRowsTableDataModel table;
                    LinkedList targetNames = new LinkedList();
                    if (updateStatement.getSetClauseList() != null) {
                        for (SQLQueryUpdateSetClauseModel setClause : updateStatement.getSetClauseList()) {
                            setClause.targets.stream().map(SQLQueryValueExpression::getColumnNameIfTrivialExpression).map(s -> s == null ? "..." : s.getName()).forEach(targetNames::add);
                        }
                    }
                    String columns = targetNames.stream().collect(Collectors.joining(", ", "(", ")"));
                    SQLQueryRowsSourceModel sQLQueryRowsSourceModel = updateStatement.getTargetRows();
                    String targetTableName = sQLQueryRowsSourceModel instanceof SQLQueryRowsTableDataModel && (table = (SQLQueryRowsTableDataModel)sQLQueryRowsSourceModel).getName() != null ? table.getName().getNameString() : "...";
                    String nodeName = "UPDATE " + targetTableName + " SET " + columns;
                    this.makeNode(node, (SQLQueryNodeModel)updateStatement, OutlineQueryNodeKind.UPDATE_SUBROOT, nodeName, (DBPImage)UIIcon.ROW_EDIT, new SQLQueryNodeModel[]{updateStatement.getTargetRows(), updateStatement});
                }
            }
            return null;
        }

        @Nullable
        public Object visitTableStatementUpdateSetClause(@NotNull SQLQueryUpdateSetClauseModel setClause, @NotNull OutlineQueryNode node) {
            ArrayList nodes = new ArrayList(setClause.targets.size() + setClause.sources.size());
            nodes.addAll(setClause.targets);
            nodes.addAll(setClause.sources);
            this.makeNode(node, (SQLQueryNodeModel)setClause, setClause.contents, (DBPImage)DBIcon.TYPE_ARRAY, (SQLQueryNodeModel[])nodes.toArray(SQLQueryNodeModel[]::new));
            return null;
        }

        @Nullable
        public Object visitTableStatementDrop(@NotNull SQLQueryTableDropModel dropStatement, OutlineQueryNode node) {
            String tableNames = dropStatement.getTables() == null || dropStatement.getTables().isEmpty() ? "?" : dropStatement.getTables().stream().filter(Objects::nonNull).map(SQLQueryRowsTableDataModel::getName).filter(Objects::nonNull).map(SQLQueryComplexName::getNameString).collect(Collectors.joining(", "));
            String nodeName = "DROP " + (dropStatement.isView() ? "VIEW" : "TABLE") + (dropStatement.getIfExists() ? " IF EXISTS " : " ") + tableNames;
            this.makeNode(node, (SQLQueryNodeModel)dropStatement, nodeName, (DBPImage)UIIcon.REMOVE, (SQLQueryNodeModel[])dropStatement.getTables().toArray(SQLQueryRowsTableDataModel[]::new));
            return null;
        }

        @Nullable
        public Object visitObjectStatementDrop(@NotNull SQLQueryObjectDropModel dropStatement, OutlineQueryNode node) {
            String procName = dropStatement.getObject() == null ? "?" : dropStatement.getObject().getName().getNameString();
            String nodeName = "DROP " + dropStatement.getObject().getObjectType().getTypeName().toUpperCase() + " " + (dropStatement.getIfExists() ? "IF EXISTS " : " ") + procName;
            this.makeNode(node, (SQLQueryNodeModel)dropStatement, nodeName, (DBPImage)UIIcon.REMOVE, new SQLQueryNodeModel[]{dropStatement.getObject()});
            return null;
        }

        @Nullable
        public Object visitObjectReference(@NotNull SQLQueryObjectDataModel objectReference, OutlineQueryNode node) {
            this.makeNode(node, (SQLQueryNodeModel)objectReference, objectReference.getName().getNameString(), objectReference.getObjectType().getImage(), new SQLQueryNodeModel[0]);
            return null;
        }

        @Nullable
        public Object visitCreateTable(@NotNull SQLQueryTableCreateModel createTable, OutlineQueryNode node) {
            SQLQueryComplexName tableName = createTable.getTableName();
            String nodeName = "CREATE TABLE " + (tableName == null ? "?" : tableName.getNameString());
            this.makeNode(node, (SQLQueryNodeModel)createTable, nodeName, (DBPImage)UIIcon.OBJ_ADD, (SQLQueryNodeModel[])Stream.concat(createTable.getColumns().stream(), createTable.getConstraints().stream()).toArray(SQLQueryNodeModel[]::new));
            return null;
        }

        @Nullable
        public Object visitColumnConstraintSpec(@NotNull SQLQueryColumnConstraintSpec columnConstraintSpec, OutlineQueryNode node) {
            String nodeText = SQLEditorOutlinePage.this.prepareQueryPreview(columnConstraintSpec.getSyntaxNode().getTextContent());
            this.makeNode(node, (SQLQueryNodeModel)columnConstraintSpec, nodeText, (DBPImage)DBIcon.TREE_CONSTRAINT, new SQLQueryNodeModel[0]);
            return null;
        }

        @Nullable
        public Object visitColumnSpec(@NotNull SQLQueryColumnSpec columnSpec, OutlineQueryNode node) {
            String nodeText = columnSpec.getColumnName() == null ? "?" : columnSpec.getColumnName().getName();
            this.makeNode(node, (SQLQueryNodeModel)columnSpec, nodeText, " " + (String)CommonUtils.notNull((Object)columnSpec.getTypeName(), (Object)""), (DBPImage)DBIcon.TREE_COLUMN, (SQLQueryNodeModel[])Stream.concat(Stream.of(columnSpec.getDefaultValueExpression()), columnSpec.getConstraints().stream()).toArray(SQLQueryNodeModel[]::new));
            return null;
        }

        @Nullable
        public Object visitTableConstraintSpec(@NotNull SQLQueryTableConstraintSpec tableConstraintSpec, OutlineQueryNode node) {
            String nodeText = SQLEditorOutlinePage.this.prepareQueryPreview(tableConstraintSpec.getSyntaxNode().getTextContent());
            this.makeNode(node, (SQLQueryNodeModel)tableConstraintSpec, nodeText, (DBPImage)DBIcon.TREE_CONSTRAINT, new SQLQueryNodeModel[0]);
            return null;
        }

        @Nullable
        public Object visitAlterTable(@NotNull SQLQueryTableAlterModel alterTable, OutlineQueryNode node) {
            String nodeText = SQLEditorOutlinePage.this.prepareQueryPreview(alterTable.getSyntaxNode().getTextContent());
            this.makeNode(node, (SQLQueryNodeModel)alterTable, nodeText, (DBPImage)DBIcon.TREE_FOLDER_CONSTRAINT, (SQLQueryNodeModel[])Stream.concat(Stream.of(alterTable.getTargetTable()), alterTable.getAlterActions().stream()).toArray(SQLQueryNodeModel[]::new));
            return null;
        }

        @Nullable
        public Object visitAlterTableAction(@NotNull SQLQueryTableAlterActionSpec actionSpec, OutlineQueryNode node) {
            String nodeText = SQLEditorOutlinePage.this.prepareQueryPreview(actionSpec.getSyntaxNode().getTextContent());
            this.makeNode(node, (SQLQueryNodeModel)actionSpec, nodeText, (DBPImage)DBIcon.TREE_CONSTRAINT, new SQLQueryNodeModel[]{actionSpec.getColumnSpec(), actionSpec.getTableConstraintSpec()});
            return null;
        }

        private OutlineQueryNode makeNode(@NotNull OutlineQueryNode parent, @NotNull SQLQueryNodeModel model, @NotNull String text, @NotNull DBPImage icon, SQLQueryNodeModel ... childModels) {
            return this.makeNode(parent, model, text, null, icon, childModels);
        }

        private OutlineQueryNode makeNode(@NotNull OutlineQueryNode parent, @NotNull SQLQueryNodeModel model, @NotNull OutlineQueryNodeKind kind, @NotNull String text, @NotNull DBPImage icon, SQLQueryNodeModel ... childModels) {
            return this.makeNode(parent, model, kind, text, null, icon, childModels);
        }

        private OutlineQueryNode makeNode(@NotNull OutlineQueryNode parent, @NotNull SQLQueryNodeModel model, @NotNull String text, @Nullable String extraText, @NotNull DBPImage icon, SQLQueryNodeModel ... childModels) {
            return this.makeNode(parent, model, OutlineQueryNodeKind.DEFAULT, text, extraText, icon, childModels);
        }

        private OutlineQueryNode makeNode(@NotNull OutlineQueryNode parent, @NotNull SQLQueryNodeModel model, @NotNull OutlineQueryNodeKind kind, @NotNull String text, @Nullable String extraText, @NotNull DBPImage icon, SQLQueryNodeModel ... childModels) {
            SQLQuerySymbolClass symbolClass = model.getAssociatedSymbolClass();
            StyledString.Styler styler = symbolClass == null ? null : stylerBySymbolClass.get(symbolClass);
            OutlineQueryNode node = new OutlineQueryNode(parent, model, kind, text, styler, extraText, icon, childModels);
            parent.children.add(node);
            return node;
        }
    }

    private static enum SelectionSyncOperation {
        NONE,
        FROM_EDITOR,
        TO_EDITOR;

    }
}

