"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _xcss = require("../xcss/xcss");
var _flex = _interopRequireDefault(require("./flex"));
/**
 * @jsxRuntime classic
 * @jsx jsx
 */

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766

var flexGrowMap = {
  hug: (0, _xcss.xcss)({
    flexGrow: 0
  }),
  fill: (0, _xcss.xcss)({
    width: '100%',
    flexGrow: 1
  })
};

/**
 * __Stack__
 *
 * Stack is a primitive component based on flexbox that manages the block layout of direct children.
 *
 * @example
 * ```tsx
 *  <Stack>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Stack>
 * ```
 *
 */
var Stack = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var as = _ref.as,
    alignItems = _ref.alignInline,
    _ref$alignBlock = _ref.alignBlock,
    alignBlock = _ref$alignBlock === void 0 ? 'stretch' : _ref$alignBlock,
    spread = _ref.spread,
    grow = _ref.grow,
    space = _ref.space,
    children = _ref.children,
    testId = _ref.testId,
    xcss = _ref.xcss,
    role = _ref.role;
  var justifyContent = spread || alignBlock;

  // We're type coercing this as Compiled styles in an array isn't supported by the types
  // But the runtime accepts it none-the-wiser. We can remove this entire block and replace
  // it with cx(defaultStyles, focusRingStyles, xcssStyles) when we've moved away from Emotion.
  var styles = grow ? [flexGrowMap[grow]].concat((0, _toConsumableArray2.default)(Array.isArray(xcss) ? xcss : [xcss])) : xcss;
  return (0, _react2.jsx)(_flex.default, {
    as: as,
    role: role,
    gap: space,
    direction: "column",
    alignItems: alignItems,
    justifyContent: justifyContent
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    ,
    xcss: styles,
    testId: testId,
    ref: ref
  }, children);
}));
Stack.displayName = 'Stack';
var _default = exports.default = Stack;