"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RbdInvariant = void 0;
exports.rbdInvariant = rbdInvariant;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _wrapNativeSuper2 = _interopRequireDefault(require("@babel/runtime/helpers/wrapNativeSuper"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var isProduction = process.env.NODE_ENV === 'production';
var prefix = 'Invariant failed';
var RbdInvariant = exports.RbdInvariant = /*#__PURE__*/function (_Error) {
  function RbdInvariant(message) {
    var _this;
    (0, _classCallCheck2.default)(this, RbdInvariant);
    _this = _callSuper(this, RbdInvariant);
    _this.message = message;
    return _this;
  }
  (0, _inherits2.default)(RbdInvariant, _Error);
  return (0, _createClass2.default)(RbdInvariant, [{
    key: "toString",
    value: function toString() {
      return this.message;
    }
  }]);
}( /*#__PURE__*/(0, _wrapNativeSuper2.default)(Error)); // A copy-paste of tiny-invariant but with a custom error type
// Throw an error if the condition fails
function rbdInvariant(condition, message) {
  if (condition) {
    return;
  }
  if (isProduction) {
    // In production we strip the message but still throw
    throw new RbdInvariant(prefix);
  } else {
    // When not in production we allow the message to pass through
    // *This block will be removed in production builds*
    throw new RbdInvariant("".concat(prefix, ": ").concat(message || ''));
  }
}