/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.prompt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;

public abstract class AIPromptAbstract
implements AIPromptGenerator {
    private final List<String> goals = new ArrayList<String>();
    private final List<String> instructions = new ArrayList<String>();
    private final List<String> examples = new ArrayList<String>();
    private final List<String> contexts = new ArrayList<String>();
    private final List<String> outputFormats = new ArrayList<String>();

    protected AIPromptAbstract() {
    }

    public AIPromptAbstract addGoals(String ... goals) {
        this.goals.addAll(Arrays.asList(goals));
        return this;
    }

    public AIPromptAbstract addExamples(String ... examples) {
        this.examples.addAll(Arrays.asList(examples));
        return this;
    }

    public AIPromptAbstract addInstructions(String ... instructions) {
        this.instructions.addAll(Arrays.asList(instructions));
        return this;
    }

    public AIPromptAbstract addContexts(String ... contexts) {
        this.contexts.addAll(Arrays.asList(contexts));
        return this;
    }

    public AIPromptAbstract addOutputFormats(String ... outputFormats) {
        this.outputFormats.addAll(Arrays.asList(outputFormats));
        return this;
    }

    @Override
    @NotNull
    public String build() {
        StringBuilder prompt = new StringBuilder();
        prompt.append("Goals:\n");
        this.goals.forEach(goal -> {
            StringBuilder stringBuilder2 = prompt.append("- ").append((String)goal).append("\n");
        });
        if (!this.instructions.isEmpty()) {
            prompt.append("\nInstructions:\n");
            this.instructions.forEach(instruction -> {
                StringBuilder stringBuilder2 = prompt.append("- ").append((String)instruction).append("\n");
            });
        }
        if (!this.examples.isEmpty()) {
            prompt.append("\nExamples:\n");
            this.examples.forEach(example -> {
                StringBuilder stringBuilder2 = prompt.append("- ").append((String)example).append("\n");
            });
        }
        prompt.append("\nContext:\n");
        this.contexts.forEach(context -> {
            StringBuilder stringBuilder2 = prompt.append("- ").append((String)context).append("\n");
        });
        if (!this.outputFormats.isEmpty()) {
            prompt.append("\nOutput Format:\n");
            this.outputFormats.forEach(outputFormat -> {
                StringBuilder stringBuilder2 = prompt.append("- ").append((String)outputFormat).append("\n");
            });
        }
        return prompt.toString();
    }
}

