/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.actions.HandleAction;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.ReceiveConfig;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.manager.api.UntrustedIdentityException;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.jobs.CleanOldPreKeysJob;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.messageCache.CachedMessage;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.messages.EnvelopeResponse;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.api.websocket.WebSocketConnectionState;
import org.whispersystems.signalservice.api.websocket.WebSocketUnavailableException;

public class ReceiveHelper {
    private static final Logger logger = LoggerFactory.getLogger(ReceiveHelper.class);
    private static final int MAX_BACKOFF_COUNTER = 9;
    private final SignalAccount account;
    private final SignalDependencies dependencies;
    private final Context context;
    private ReceiveConfig receiveConfig = new ReceiveConfig(false, false, false);
    private boolean hasCaughtUpWithOldMessages = false;
    private boolean isWaitingForMessage = false;
    private boolean shouldStop = false;
    private Callable authenticationFailureListener;
    private Callable caughtUpWithOldMessagesListener;

    public ReceiveHelper(Context context) {
        this.account = context.getAccount();
        this.dependencies = context.getDependencies();
        this.context = context;
    }

    public void setReceiveConfig(ReceiveConfig receiveConfig) {
        this.receiveConfig = receiveConfig;
        this.dependencies.setAllowStories(!receiveConfig.ignoreStories());
    }

    public void setAuthenticationFailureListener(Callable authenticationFailureListener) {
        this.authenticationFailureListener = authenticationFailureListener;
    }

    public void setCaughtUpWithOldMessagesListener(Callable caughtUpWithOldMessagesListener) {
        this.caughtUpWithOldMessagesListener = caughtUpWithOldMessagesListener;
    }

    public boolean requestStopReceiveMessages() {
        this.shouldStop = true;
        return this.isWaitingForMessage;
    }

    public void receiveMessagesContinuously(Manager.ReceiveMessageHandler handler) {
        while (!this.shouldStop) {
            try {
                this.receiveMessages(Duration.ofMinutes(1L), false, null, handler);
                break;
            }
            catch (IOException e) {
                logger.warn("Receiving messages failed, retrying", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessages(Duration timeout, boolean returnOnTimeout, Integer maxMessages, Manager.ReceiveMessageHandler handler) throws IOException {
        this.account.setNeedsToRetryFailedMessages(true);
        this.hasCaughtUpWithOldMessages = false;
        HashMap<HandleAction, HandleAction> queuedActions = new HashMap<HandleAction, HandleAction>();
        SignalWebSocket.AuthenticatedWebSocket signalWebSocket = this.dependencies.getAuthenticatedSignalWebSocket();
        Disposable webSocketStateDisposable = signalWebSocket.getState().subscribeOn(Schedulers.computation()).observeOn(Schedulers.computation()).distinctUntilChanged().subscribe(this::onWebSocketStateChange);
        signalWebSocket.connect();
        signalWebSocket.registerKeepAliveToken("receive");
        try {
            this.receiveMessagesInternal(signalWebSocket, timeout, returnOnTimeout, maxMessages, handler, queuedActions);
        }
        finally {
            this.hasCaughtUpWithOldMessages = false;
            this.handleQueuedActions(queuedActions.keySet());
            queuedActions.clear();
            signalWebSocket.removeKeepAliveToken("receive");
            signalWebSocket.disconnect();
            webSocketStateDisposable.dispose();
            this.shouldStop = false;
        }
    }

    private void receiveMessagesInternal(SignalWebSocket.AuthenticatedWebSocket signalWebSocket, Duration timeout, boolean returnOnTimeout, Integer maxMessages, Manager.ReceiveMessageHandler handler, Map<HandleAction, HandleAction> queuedActions) throws IOException {
        int remainingMessages = maxMessages == null ? -1 : maxMessages;
        int backOffCounter = 0;
        this.isWaitingForMessage = false;
        while (!this.shouldStop && remainingMessages != 0) {
            SignalServiceEnvelope envelope;
            CachedMessage[] cachedMessage;
            block21: {
                if (this.account.getNeedsToRetryFailedMessages()) {
                    this.retryFailedReceivedMessages(handler);
                }
                cachedMessage = new CachedMessage[]{null};
                long nowMillis = System.currentTimeMillis();
                if (nowMillis - this.account.getLastReceiveTimestamp() > 14400000L) {
                    this.account.setLastReceiveTimestamp(nowMillis);
                }
                logger.debug("Checking for new message from server");
                try {
                    this.isWaitingForMessage = true;
                    boolean queueNotEmpty = signalWebSocket.readMessageBatch(timeout.toMillis(), 1, batch -> {
                        logger.debug("Retrieved {} envelopes!", (Object)batch.size());
                        this.isWaitingForMessage = false;
                        for (EnvelopeResponse it : batch) {
                            SignalServiceEnvelope envelope1 = new SignalServiceEnvelope(it.getEnvelope(), it.getServerDeliveredTimestamp());
                            RecipientId recipientId = envelope1.getSourceServiceId().map(ServiceId::parseOrNull).map(s -> this.account.getRecipientResolver().resolveRecipient((ServiceId)s)).orElse(null);
                            logger.trace("Storing new message from {}", (Object)recipientId);
                            cachedMessage[0] = this.account.getMessageCache().cacheMessage(envelope1, recipientId);
                            try {
                                signalWebSocket.sendAck(it);
                            }
                            catch (IOException e) {
                                logger.warn("Failed to ack envelope to server after storing it: {}", (Object)e.getMessage());
                            }
                        }
                    });
                    this.isWaitingForMessage = false;
                    backOffCounter = 0;
                    if (queueNotEmpty) {
                        if (remainingMessages > 0) {
                            --remainingMessages;
                        }
                        envelope = cachedMessage[0].loadEnvelope();
                        logger.debug("New message received from server");
                        break block21;
                    }
                    logger.debug("Received indicator that server queue is empty");
                    this.handleQueuedActions(queuedActions.keySet());
                    queuedActions.clear();
                    this.context.getJobExecutor().enqueueJob(new CleanOldPreKeysJob());
                    this.hasCaughtUpWithOldMessages = true;
                    this.caughtUpWithOldMessagesListener.call();
                    continue;
                }
                catch (AssertionError e) {
                    if (((Throwable)((Object)e)).getCause() instanceof InterruptedException) break;
                    throw e;
                }
                catch (IOException e) {
                    logger.debug("Pipe unexpectedly unavailable: {}", (Object)e.getMessage());
                    if (e instanceof WebSocketUnavailableException || "Connection closed!".equals(e.getMessage())) {
                        long sleepMilliseconds = 100L * (long)Math.pow(2.0, backOffCounter);
                        backOffCounter = Math.min(backOffCounter + 1, 9);
                        logger.warn("Connection closed unexpectedly, reconnecting in {} ms", (Object)sleepMilliseconds);
                        try {
                            Thread.sleep(sleepMilliseconds);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        this.hasCaughtUpWithOldMessages = false;
                        signalWebSocket.connect();
                        continue;
                    }
                    throw e;
                }
                catch (TimeoutException e) {
                    backOffCounter = 0;
                    if (!returnOnTimeout) continue;
                    return;
                }
                catch (Exception e) {
                    logger.error("Unknown error when receiving messages", (Throwable)e);
                    continue;
                }
            }
            try {
                Pair<List<HandleAction>, Exception> result = this.context.getIncomingMessageHandler().handleEnvelope(envelope, this.receiveConfig, handler);
                for (HandleAction h : result.first()) {
                    HandleAction existingAction = queuedActions.get(h);
                    if (existingAction == null) {
                        queuedActions.put(h, h);
                        continue;
                    }
                    existingAction.mergeOther(h);
                }
                Exception exception = result.second();
                if (this.hasCaughtUpWithOldMessages) {
                    this.handleQueuedActions(queuedActions.keySet());
                    queuedActions.clear();
                }
                if (cachedMessage[0] == null) continue;
                if (exception instanceof UntrustedIdentityException) {
                    logger.debug("Keeping message with untrusted identity in message cache");
                    RecipientAddress address = ((UntrustedIdentityException)exception).getSender();
                    if (!envelope.getSourceServiceId().isEmpty() || !address.aci().isPresent()) continue;
                    RecipientId recipientId = this.account.getRecipientResolver().resolveRecipient((ServiceId)ServiceId.ACI.parseOrThrow((String)address.aci().get()));
                    try {
                        cachedMessage[0] = this.account.getMessageCache().replaceSender(cachedMessage[0], recipientId);
                    }
                    catch (IOException ioException) {
                        logger.warn("Failed to move cached message to recipient folder: {}", (Object)ioException.getMessage(), (Object)ioException);
                    }
                    continue;
                }
                cachedMessage[0].delete();
            }
            catch (Exception e) {
                logger.error("Unknown error when handling messages", (Throwable)e);
            }
        }
    }

    private void retryFailedReceivedMessages(Manager.ReceiveMessageHandler handler) {
        HashSet<HandleAction> queuedActions = new HashSet<HandleAction>();
        for (CachedMessage cachedMessage : this.account.getMessageCache().getCachedMessages()) {
            List<HandleAction> actions = this.retryFailedReceivedMessage(handler, cachedMessage);
            if (actions == null) continue;
            queuedActions.addAll(actions);
        }
        this.handleQueuedActions(queuedActions);
        this.account.setNeedsToRetryFailedMessages(false);
    }

    private List<HandleAction> retryFailedReceivedMessage(Manager.ReceiveMessageHandler handler, CachedMessage cachedMessage) {
        SignalServiceEnvelope envelope = cachedMessage.loadEnvelope();
        if (envelope == null) {
            cachedMessage.delete();
            return null;
        }
        Pair<List<HandleAction>, Exception> result = this.context.getIncomingMessageHandler().handleRetryEnvelope(envelope, this.receiveConfig, handler);
        List<HandleAction> actions = result.first();
        Exception exception = result.second();
        if (exception instanceof UntrustedIdentityException) {
            if (System.currentTimeMillis() - envelope.getServerDeliveredTimestamp() > 1209600000L) {
                cachedMessage.delete();
                return null;
            }
            if (envelope.getSourceServiceId().isEmpty()) {
                RecipientAddress identifier = ((UntrustedIdentityException)exception).getSender();
                RecipientId recipientId = this.account.getRecipientResolver().resolveRecipient(new org.asamk.signal.manager.storage.recipients.RecipientAddress(identifier));
                try {
                    this.account.getMessageCache().replaceSender(cachedMessage, recipientId);
                }
                catch (IOException ioException) {
                    logger.warn("Failed to move cached message to recipient folder: {}", (Object)ioException.getMessage(), (Object)ioException);
                }
            }
            return null;
        }
        cachedMessage.delete();
        return actions;
    }

    private void handleQueuedActions(Collection<HandleAction> queuedActions) {
        logger.debug("Handling message actions");
        for (HandleAction action : queuedActions) {
            logger.debug("Executing action {}", (Object)action.getClass().getSimpleName());
            try {
                action.execute(this.context);
            }
            catch (Throwable e) {
                logger.warn("Message action failed.", e);
            }
        }
    }

    private void onWebSocketStateChange(WebSocketConnectionState s) {
        if (s.equals((Object)WebSocketConnectionState.AUTHENTICATION_FAILED)) {
            this.account.setRegistered(false);
            this.authenticationFailureListener.call();
        }
    }

    public static interface Callable {
        public void call();
    }
}

