/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import org.whispersystems.signalservice.internal.util.Util;

public record Contact(String givenName, String familyName, String nickName, String nickNameGivenName, String nickNameFamilyName, String note, String color, int messageExpirationTime, int messageExpirationTimeVersion, long muteUntil, boolean hideStory, boolean isBlocked, boolean isArchived, boolean isProfileSharingEnabled, boolean isHidden, Long unregisteredTimestamp) {
    private Contact(Builder builder) {
        this(builder.givenName, builder.familyName, builder.nickName, builder.nickNameGivenName, builder.nickNameFamilyName, builder.note, builder.color, builder.messageExpirationTime, builder.messageExpirationTimeVersion, builder.muteUntil, builder.hideStory, builder.isBlocked, builder.isArchived, builder.isProfileSharingEnabled, builder.isHidden, builder.unregisteredTimestamp);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Contact copy) {
        Builder builder = new Builder();
        builder.givenName = copy.givenName();
        builder.familyName = copy.familyName();
        builder.nickName = copy.nickName();
        builder.nickNameGivenName = copy.nickNameGivenName();
        builder.nickNameFamilyName = copy.nickNameFamilyName();
        builder.note = copy.note();
        builder.color = copy.color();
        builder.messageExpirationTime = copy.messageExpirationTime();
        builder.messageExpirationTimeVersion = copy.messageExpirationTimeVersion();
        builder.muteUntil = copy.muteUntil();
        builder.hideStory = copy.hideStory();
        builder.isBlocked = copy.isBlocked();
        builder.isArchived = copy.isArchived();
        builder.isProfileSharingEnabled = copy.isProfileSharingEnabled();
        builder.isHidden = copy.isHidden();
        builder.unregisteredTimestamp = copy.unregisteredTimestamp();
        return builder;
    }

    public String getName() {
        boolean noGivenName = Util.isEmpty((String)this.givenName);
        boolean noFamilyName = Util.isEmpty((String)this.familyName);
        if (noGivenName && noFamilyName) {
            return "";
        }
        if (noGivenName) {
            return this.familyName;
        }
        if (noFamilyName) {
            return this.givenName;
        }
        return this.givenName + " " + this.familyName;
    }

    public static final class Builder {
        private String givenName;
        private String familyName;
        private String nickName;
        private String nickNameGivenName;
        private String nickNameFamilyName;
        private String note;
        private String color;
        private int messageExpirationTime;
        private int messageExpirationTimeVersion = 1;
        private long muteUntil;
        private boolean hideStory;
        private boolean isBlocked;
        private boolean isArchived;
        private boolean isProfileSharingEnabled;
        private boolean isHidden;
        private Long unregisteredTimestamp;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withGivenName(String val) {
            this.givenName = val;
            return this;
        }

        public Builder withFamilyName(String val) {
            this.familyName = val;
            return this;
        }

        public Builder withNickName(String val) {
            this.nickName = val;
            return this;
        }

        public Builder withNickNameGivenName(String val) {
            this.nickNameGivenName = val;
            return this;
        }

        public Builder withNickNameFamilyName(String val) {
            this.nickNameFamilyName = val;
            return this;
        }

        public Builder withNote(String val) {
            this.note = val;
            return this;
        }

        public Builder withColor(String val) {
            this.color = val;
            return this;
        }

        public Builder withMessageExpirationTime(int val) {
            this.messageExpirationTime = val;
            return this;
        }

        public Builder withMessageExpirationTimeVersion(int val) {
            this.messageExpirationTimeVersion = val;
            return this;
        }

        public Builder withMuteUntil(long val) {
            this.muteUntil = val;
            return this;
        }

        public Builder withHideStory(boolean val) {
            this.hideStory = val;
            return this;
        }

        public Builder withIsBlocked(boolean val) {
            this.isBlocked = val;
            return this;
        }

        public Builder withIsArchived(boolean val) {
            this.isArchived = val;
            return this;
        }

        public Builder withIsProfileSharingEnabled(boolean val) {
            this.isProfileSharingEnabled = val;
            return this;
        }

        public Builder withIsHidden(boolean val) {
            this.isHidden = val;
            return this;
        }

        public Builder withUnregisteredTimestamp(Long val) {
            this.unregisteredTimestamp = val;
            return this;
        }

        public Contact build() {
            return new Contact(this);
        }
    }
}

