/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import java.util.Locale;

public final class Bitmask {
    public static boolean read(long value, int position) {
        return Bitmask.read(value, position, 1) > 0L;
    }

    public static long read(long value, int position, int flagBitSize) {
        Bitmask.checkArgument(flagBitSize >= 0, "Must have a positive bit size! size: " + flagBitSize);
        int bitsToShift = position * flagBitSize;
        Bitmask.checkArgument(bitsToShift + flagBitSize <= 64 && position >= 0, String.format(Locale.US, "Your position is out of bounds! position: %d, flagBitSize: %d", position, flagBitSize));
        long shifted = value >>> bitsToShift;
        long mask = Bitmask.twoToThe(flagBitSize) - 1L;
        return shifted & mask;
    }

    public static long update(long existing, int position, boolean value) {
        return Bitmask.update(existing, position, 1, value ? 1L : 0L);
    }

    public static long update(long existing, int position, int flagBitSize, long value) {
        Bitmask.checkArgument(flagBitSize >= 0, "Must have a positive bit size! size: " + flagBitSize);
        Bitmask.checkArgument(value >= 0L, "Value must be positive! value: " + value);
        Bitmask.checkArgument(value < Bitmask.twoToThe(flagBitSize), String.format(Locale.US, "Value is larger than you can hold for the given bitsize! value: %d, flagBitSize: %d", value, flagBitSize));
        int bitsToShift = position * flagBitSize;
        Bitmask.checkArgument(bitsToShift + flagBitSize <= 64 && position >= 0, String.format(Locale.US, "Your position is out of bounds! position: %d, flagBitSize: %d", position, flagBitSize));
        long clearMask = Bitmask.twoToThe(flagBitSize) - 1L << bitsToShift ^ 0xFFFFFFFFFFFFFFFFL;
        long cleared = existing & clearMask;
        long shiftedValue = value << bitsToShift;
        return cleared | shiftedValue;
    }

    private static long twoToThe(long n) {
        return 1 << (int)n;
    }

    private static void checkArgument(boolean state, String message) {
        if (!state) {
            throw new IllegalArgumentException(message);
        }
    }
}

